/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.threerings.config.ArgumentMap;
import com.threerings.export.Exportable;
import com.threerings.export.ObjectMarshaller;
import com.threerings.math.Matrix3f;
import com.threerings.math.Matrix4f;
import com.threerings.math.Quaternion;
import com.threerings.math.Vector2f;
import com.threerings.math.Vector3f;
import com.threerings.opengl.renderer.Color4f;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Exporter
implements Closeable {
    protected Object _object;
    protected ObjectMarshaller _marshaller;
    protected Replacer _replacer;
    protected Object[] _a1 = new Object[1];
    protected Object[] _a2 = new Object[1];

    public Exporter setReplacer(Replacer replacer) {
        this._replacer = replacer;
        return this;
    }

    public abstract void writeObject(Object var1) throws IOException;

    public void defaultWriteFields() throws IOException {
        if (this._marshaller == null) {
            throw new IllegalStateException("Not invoking a custom writeFields method.");
        }
        this._marshaller.writeFields(this._object, this, false);
    }

    public void write(String name, boolean value, boolean defvalue) throws IOException {
        if (value != defvalue) {
            this.write(name, value);
        }
    }

    public abstract void write(String var1, boolean var2) throws IOException;

    public void write(String name, byte value, byte defvalue) throws IOException {
        if (value != defvalue) {
            this.write(name, value);
        }
    }

    public abstract void write(String var1, byte var2) throws IOException;

    public void write(String name, char value, char defvalue) throws IOException {
        if (value != defvalue) {
            this.write(name, value);
        }
    }

    public abstract void write(String var1, char var2) throws IOException;

    public void write(String name, double value, double defvalue) throws IOException {
        if (value != defvalue) {
            this.write(name, value);
        }
    }

    public abstract void write(String var1, double var2) throws IOException;

    public void write(String name, float value, float defvalue) throws IOException {
        if (value != defvalue) {
            this.write(name, value);
        }
    }

    public abstract void write(String var1, float var2) throws IOException;

    public void write(String name, int value, int defvalue) throws IOException {
        if (value != defvalue) {
            this.write(name, value);
        }
    }

    public abstract void write(String var1, int var2) throws IOException;

    public void write(String name, long value, long defvalue) throws IOException {
        if (value != defvalue) {
            this.write(name, value);
        }
    }

    public abstract void write(String var1, long var2) throws IOException;

    public void write(String name, short value, short defvalue) throws IOException {
        if (value != defvalue) {
            this.write(name, value);
        }
    }

    public abstract void write(String var1, short var2) throws IOException;

    public void write(String name, boolean[] value, boolean[] defvalue) throws IOException {
        this.write(name, value, defvalue, boolean[].class);
    }

    public void write(String name, boolean[] value) throws IOException {
        this.write(name, value, boolean[].class);
    }

    public void write(String name, byte[] value, byte[] defvalue) throws IOException {
        this.write(name, value, defvalue, byte[].class);
    }

    public void write(String name, byte[] value) throws IOException {
        this.write(name, value, byte[].class);
    }

    public void write(String name, char[] value, char[] defvalue) throws IOException {
        this.write(name, value, defvalue, char[].class);
    }

    public void write(String name, char[] value) throws IOException {
        this.write(name, value, char[].class);
    }

    public void write(String name, double[] value, double[] defvalue) throws IOException {
        this.write(name, value, defvalue, double[].class);
    }

    public void write(String name, double[] value) throws IOException {
        this.write(name, value, double[].class);
    }

    public void write(String name, float[] value, float[] defvalue) throws IOException {
        this.write(name, value, defvalue, float[].class);
    }

    public void write(String name, float[] value) throws IOException {
        this.write(name, value, float[].class);
    }

    public void write(String name, int[] value, int[] defvalue) throws IOException {
        this.write(name, value, defvalue, int[].class);
    }

    public void write(String name, int[] value) throws IOException {
        this.write(name, value, int[].class);
    }

    public void write(String name, long[] value, long[] defvalue) throws IOException {
        this.write(name, value, defvalue, long[].class);
    }

    public void write(String name, long[] value) throws IOException {
        this.write(name, value, long[].class);
    }

    public void write(String name, short[] value, short[] defvalue) throws IOException {
        this.write(name, value, defvalue, short[].class);
    }

    public void write(String name, short[] value) throws IOException {
        this.write(name, value, short[].class);
    }

    public void write(String name, String value, String defvalue) throws IOException {
        this.write(name, value, defvalue, String.class);
    }

    public void write(String name, String value) throws IOException {
        this.write(name, value, String.class);
    }

    public void write(String name, ByteBuffer value, ByteBuffer defvalue) throws IOException {
        this.write(name, value, defvalue, ByteBuffer.class);
    }

    public void write(String name, ByteBuffer value) throws IOException {
        this.write(name, value, ByteBuffer.class);
    }

    public void write(String name, CharBuffer value, CharBuffer defvalue) throws IOException {
        this.write(name, value, defvalue, CharBuffer.class);
    }

    public void write(String name, CharBuffer value) throws IOException {
        this.write(name, value, CharBuffer.class);
    }

    public void write(String name, DoubleBuffer value, DoubleBuffer defvalue) throws IOException {
        this.write(name, value, defvalue, DoubleBuffer.class);
    }

    public void write(String name, DoubleBuffer value) throws IOException {
        this.write(name, value, DoubleBuffer.class);
    }

    public void write(String name, FloatBuffer value, FloatBuffer defvalue) throws IOException {
        this.write(name, value, defvalue, FloatBuffer.class);
    }

    public void write(String name, FloatBuffer value) throws IOException {
        this.write(name, value, FloatBuffer.class);
    }

    public void write(String name, IntBuffer value, IntBuffer defvalue) throws IOException {
        this.write(name, value, defvalue, IntBuffer.class);
    }

    public void write(String name, IntBuffer value) throws IOException {
        this.write(name, value, IntBuffer.class);
    }

    public void write(String name, LongBuffer value, LongBuffer defvalue) throws IOException {
        this.write(name, value, defvalue, LongBuffer.class);
    }

    public void write(String name, LongBuffer value) throws IOException {
        this.write(name, value, LongBuffer.class);
    }

    public void write(String name, ShortBuffer value, ShortBuffer defvalue) throws IOException {
        this.write(name, value, defvalue, ShortBuffer.class);
    }

    public void write(String name, ShortBuffer value) throws IOException {
        this.write(name, value, ShortBuffer.class);
    }

    public void write(String name, Color4f value, Color4f defvalue) throws IOException {
        this.write(name, value, defvalue, Color4f.class);
    }

    public void write(String name, Color4f value) throws IOException {
        this.write(name, value, Color4f.class);
    }

    public void write(String name, Matrix3f value, Matrix3f defvalue) throws IOException {
        this.write(name, value, defvalue, Matrix3f.class);
    }

    public void write(String name, Matrix3f value) throws IOException {
        this.write(name, value, Matrix3f.class);
    }

    public void write(String name, Matrix4f value, Matrix4f defvalue) throws IOException {
        this.write(name, value, defvalue, Matrix4f.class);
    }

    public void write(String name, Matrix4f value) throws IOException {
        this.write(name, value, Matrix4f.class);
    }

    public void write(String name, Quaternion value, Quaternion defvalue) throws IOException {
        this.write(name, value, defvalue, Quaternion.class);
    }

    public void write(String name, Quaternion value) throws IOException {
        this.write(name, value, Quaternion.class);
    }

    public void write(String name, Vector2f value, Vector2f defvalue) throws IOException {
        this.write(name, value, defvalue, Vector2f.class);
    }

    public void write(String name, Vector2f value) throws IOException {
        this.write(name, value, Vector2f.class);
    }

    public void write(String name, Vector3f value, Vector3f defvalue) throws IOException {
        this.write(name, value, defvalue, Vector3f.class);
    }

    public void write(String name, Vector3f value) throws IOException {
        this.write(name, value, Vector3f.class);
    }

    public void write(String name, Exportable value, Exportable defvalue) throws IOException {
        this.write(name, value, defvalue, Exportable.class);
    }

    public void write(String name, Exportable value) throws IOException {
        this.write(name, value, Exportable.class);
    }

    public <T> void write(String name, T value, T defvalue, Class<T> clazz) throws IOException {
        this._a1[0] = value;
        this._a2[0] = defvalue;
        if (!Arrays.deepEquals(this._a1, this._a2)) {
            this.write(name, value, clazz);
        }
    }

    public abstract <T> void write(String var1, T var2, Class<T> var3) throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract void finish() throws IOException;

    protected void writeFields(Exportable object) throws IOException {
        Object oobject = this._object;
        ObjectMarshaller omarshaller = this._marshaller;
        try {
            this._object = object;
            this._marshaller = ObjectMarshaller.getObjectMarshaller(object.getClass());
            this._marshaller.writeFields(this._object, this, true);
        }
        finally {
            this._object = oobject;
            this._marshaller = omarshaller;
        }
    }

    protected static Class<?> getClass(Object value) {
        if (value instanceof Enum) {
            return ((Enum)value).getDeclaringClass();
        }
        if (value instanceof Exportable) {
            return value.getClass();
        }
        if (value instanceof Collection) {
            if (value instanceof List) {
                return value instanceof ImmutableList ? ImmutableList.class : ArrayList.class;
            }
            if (value instanceof Set) {
                return value instanceof ImmutableSet ? ImmutableSet.class : (value instanceof EnumSet ? EnumSet.class : HashSet.class);
            }
            if (value instanceof Multiset) {
                return value instanceof ImmutableMultiset ? ImmutableMultiset.class : HashMultiset.class;
            }
            return ArrayList.class;
        }
        if (value instanceof Map) {
            return value instanceof ImmutableMap ? ImmutableMap.class : (value instanceof ArgumentMap ? ArgumentMap.class : HashMap.class);
        }
        if (value instanceof Buffer) {
            if (value instanceof ByteBuffer) {
                return ByteBuffer.class;
            }
            if (value instanceof CharBuffer) {
                return CharBuffer.class;
            }
            if (value instanceof DoubleBuffer) {
                return DoubleBuffer.class;
            }
            if (value instanceof FloatBuffer) {
                return FloatBuffer.class;
            }
            if (value instanceof IntBuffer) {
                return IntBuffer.class;
            }
            if (value instanceof LongBuffer) {
                return LongBuffer.class;
            }
            if (value instanceof ShortBuffer) {
                return ShortBuffer.class;
            }
        } else if (value instanceof File) {
            return File.class;
        }
        return value.getClass();
    }

    protected static enum DummyEnum {

    }

    public static class Replacement {
        public final Object value;
        public final Class<?> clazz;

        public Replacement(Object value, Class<?> clazz) {
            this.value = value;
            this.clazz = clazz;
        }
    }

    public static interface Replacer {
        public Replacement getReplacement(Object var1, Class<?> var2);
    }
}

