/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.tudey.config.HandlerConfig;
import com.threerings.util.DeepObject;

public class ParameterizedHandlerConfig
extends ParameterizedConfig {
    @Editable
    public Implementation implementation = new Original();

    public Original getOriginal(ConfigManager cfgmgr) {
        return this.implementation.getOriginal(cfgmgr);
    }

    @Override
    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    @Override
    protected void getUpdateReferences(ConfigReferenceSet refs) {
        this.implementation.getUpdateReferences(refs);
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<ParameterizedHandlerConfig> ref;

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(ParameterizedHandlerConfig.class, this.ref);
        }

        @Override
        public Original getOriginal(ConfigManager cfgmgr) {
            ParameterizedHandlerConfig config = cfgmgr.getConfig(ParameterizedHandlerConfig.class, this.ref);
            return config == null ? null : config.getOriginal(cfgmgr);
        }
    }

    public static class Original
    extends Implementation {
        @Editable
        public HandlerConfig handler = new HandlerConfig.Startup();

        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            this.handler.getPreloads(cfgmgr, preloads);
        }

        @Override
        public Original getOriginal(ConfigManager cfgmgr) {
            return this;
        }

        @Override
        public void invalidate() {
            this.handler.invalidate();
        }
    }

    @EditorTypes(value={Original.class, Derived.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public abstract Original getOriginal(ConfigManager var1);

        public void invalidate() {
        }
    }
}

