/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.material.config;

import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.expr.Updater;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Matrix4f;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector4f;
import com.threerings.opengl.material.Projection;
import com.threerings.opengl.material.config.MaterialConfig;
import com.threerings.opengl.material.config.TechniqueConfig;
import com.threerings.opengl.renderer.config.ColorStateConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import java.util.ArrayList;

@EditorTypes(value={Perspective.class, Orthographic.class})
public abstract class ProjectionConfig
extends DeepObject
implements Exportable {
    @Editable(nullable=true)
    public ConfigReference<MaterialConfig> material;
    @Editable(nullable=true)
    public ColorStateConfig colorState = new ColorStateConfig();
    @Editable(min=0.0, step=0.01, hgroup="d")
    public float width = 1.0f;
    @Editable(min=0.0, step=0.01, hgroup="d")
    public float height = 1.0f;

    public Projection createProjection(GlContext ctx, Scope scope, ArrayList<Updater> updaters) {
        TechniqueConfig technique;
        MaterialConfig mconfig = ctx.getConfigManager().getConfig(MaterialConfig.class, this.material);
        TechniqueConfig techniqueConfig = technique = mconfig == null ? null : mconfig.getTechnique(ctx, this.getScheme());
        if (technique == null) {
            return null;
        }
        Projection projection = new Projection(technique, this.colorState == null ? null : this.colorState.getState());
        updaters.add(this.createUpdater(ctx, scope, projection));
        return projection;
    }

    protected abstract String getScheme();

    protected abstract Updater createUpdater(GlContext var1, Scope var2, Projection var3);

    public static class Orthographic
    extends ProjectionConfig {
        @Override
        protected String getScheme() {
            return "Projection (ST)";
        }

        @Override
        protected Updater createUpdater(GlContext ctx, Scope scope, final Projection projection) {
            final Transform3D viewTransform = ScopeUtil.resolve(scope, "viewTransform", new Transform3D());
            return new Updater(){
                protected Transform3D _viewTransformInv = new Transform3D();

                @Override
                public void update() {
                    viewTransform.invert(this._viewTransformInv).update(3);
                    Matrix4f mat = this._viewTransformInv.getMatrix();
                    float ss = Orthographic.this.width == 0.0f ? 0.0f : 1.0f / Orthographic.this.width;
                    projection.getGenPlaneS().set(ss * mat.m00, ss * mat.m10, ss * mat.m20, ss * mat.m30 + 0.5f);
                    float ts = Orthographic.this.height == 0.0f ? 0.0f : 1.0f / Orthographic.this.height;
                    projection.getGenPlaneT().set(ts * mat.m01, ts * mat.m11, ts * mat.m21, ts * mat.m31 + 0.5f);
                }
            };
        }
    }

    public static class Perspective
    extends ProjectionConfig {
        @Editable(min=0.0, step=0.01, hgroup="d")
        public float near = 1.0f;

        @Override
        protected String getScheme() {
            return "Projection (STQ)";
        }

        @Override
        protected Updater createUpdater(GlContext ctx, Scope scope, final Projection projection) {
            final Transform3D viewTransform = ScopeUtil.resolve(scope, "viewTransform", new Transform3D());
            return new Updater(){
                protected Transform3D _viewTransformInv = new Transform3D();

                @Override
                public void update() {
                    viewTransform.invert(this._viewTransformInv).update(3);
                    Matrix4f mat = this._viewTransformInv.getMatrix();
                    float ns = Perspective.this.near == 0.0f ? 0.0f : -1.0f / Perspective.this.near;
                    Vector4f gpq = projection.getGenPlaneQ();
                    gpq.set(ns * mat.m02, ns * mat.m12, ns * mat.m22, ns * mat.m32);
                    float ss = Perspective.this.width == 0.0f ? 0.0f : 1.0f / Perspective.this.width;
                    projection.getGenPlaneS().set(ss * mat.m00 + 0.5f * gpq.x, ss * mat.m10 + 0.5f * gpq.y, ss * mat.m20 + 0.5f * gpq.z, ss * mat.m30 + 0.5f * gpq.w);
                    float ts = Perspective.this.height == 0.0f ? 0.0f : 1.0f / Perspective.this.height;
                    projection.getGenPlaneT().set(ts * mat.m01 + 0.5f * gpq.x, ts * mat.m11 + 0.5f * gpq.y, ts * mat.m21 + 0.5f * gpq.z, ts * mat.m31 + 0.5f * gpq.w);
                }
            };
        }
    }
}

