/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.samskivert.util.StringUtil;
import com.threerings.expr.Bound;
import com.threerings.expr.Scope;
import com.threerings.expr.Updater;
import com.threerings.math.Box;
import com.threerings.math.Quaternion;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.compositor.Enqueueable;
import com.threerings.opengl.compositor.RenderQueue;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.config.ComponentBillboardConfig;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.ArticulatedConfig;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.SimpleBatch;
import com.threerings.opengl.renderer.state.RenderState;
import com.threerings.opengl.renderer.state.TransformState;
import com.threerings.opengl.util.DebugBounds;
import com.threerings.opengl.util.GlContext;

public class ComponentBillboard
extends Model.Implementation
implements Enqueueable {
    protected GlContext _ctx;
    protected RenderQueue _queue;
    protected SimpleBatch _batch;
    protected ComponentBillboardConfig _config;
    protected Component _root;
    protected Updater _updater;
    @Bound(value="worldTransform")
    protected Transform3D _parentWorldTransform;
    @Bound(value="viewTransform")
    protected Transform3D _parentViewTransform;
    @Bound
    protected Transform3D _localTransform;
    protected Transform3D _billboardViewTransform = new Transform3D();
    protected Transform3D _billboardLocalTransform = new Transform3D();
    protected Transform3D _worldTransform = new Transform3D();
    protected int _influenceFlags;
    protected Box _bounds = new Box();
    protected Box _nbounds = new Box();

    public ComponentBillboard(GlContext ctx, Scope parentScope, ComponentBillboardConfig config) {
        super(parentScope);
        this._ctx = ctx;
        RenderState[] states = RenderState.createDefaultSet();
        states[1] = null;
        states[2] = null;
        states[9] = null;
        states[14] = null;
        states[15] = new TransformState();
        this._batch = new SimpleBatch(states, new SimpleBatch.DrawCommand(){

            @Override
            public boolean call() {
                ComponentBillboard.this._root.render(ComponentBillboard.this._ctx.getRenderer());
                return true;
            }

            @Override
            public int getPrimitiveCount() {
                return 0;
            }
        });
        this.setConfig(ctx, config);
    }

    public void setConfig(GlContext ctx, ComponentBillboardConfig config) {
        this._ctx = ctx;
        this._config = config;
        this.updateFromConfig();
    }

    @Override
    public void enqueue() {
        this._parentViewTransform.compose(this._localTransform, this._billboardViewTransform);
        if (this._updater != null) {
            this._updater.update();
        } else {
            this._billboardLocalTransform.getRotation().set(Quaternion.IDENTITY);
        }
        TransformState tstate = (TransformState)this._batch.getStates()[15];
        Transform3D modelview = tstate.getModelview();
        this._billboardViewTransform.compose(this._billboardLocalTransform, modelview);
        tstate.setDirty(true);
        this._batch.depth = modelview.transformPointZ(Vector3f.ZERO);
        this._queue.add(this._batch, this._config.priority);
    }

    @Override
    public int getInfluenceFlags() {
        return this._influenceFlags;
    }

    @Override
    public Box getBounds() {
        return this._bounds;
    }

    @Override
    public void updateBounds() {
        if (this._parentWorldTransform == null) {
            return;
        }
        this._parentWorldTransform.compose(this._localTransform, this._worldTransform);
        float extent = (float)Math.max(this._root.getWidth() / 2, this._root.getHeight() / 2) * this._config.scale;
        this._nbounds.getMinimumExtent().set(-extent, -extent, -extent);
        this._nbounds.getMaximumExtent().set(extent, extent, extent);
        this._nbounds.transformLocal(this._worldTransform);
        if (!this._bounds.equals(this._nbounds)) {
            ((Model)this._parentScope).boundsWillChange(this);
            this._bounds.set(this._nbounds);
            ((Model)this._parentScope).boundsDidChange(this);
        }
    }

    @Override
    public void drawBounds() {
        DebugBounds.draw(this._bounds, Color4f.WHITE);
    }

    @Override
    public void composite() {
        this._ctx.getCompositor().addEnqueueable(this);
    }

    protected void updateFromConfig() {
        String bundle = StringUtil.isBlank((String)this._config.bundle) ? "global" : this._config.bundle;
        this._root = this._config.root.getComponent(this._ctx, this, this._ctx.getMessageManager().getBundle(bundle), this._root);
        Dimension size = this._root.getPreferredSize(-1, -1);
        this._root.setBounds(-size.width / 2, -size.height / 2, size.width, size.height);
        this._root.validate();
        this._root.wasAdded();
        this._influenceFlags = this._config.influences.getFlags();
        this._queue = this._ctx.getCompositor().getQueue(this._config.queue);
        RenderState[] states = this._batch.getStates();
        states[0] = this._config.alphaState.getState();
        states[5] = this._config.depthState.getState();
        this._billboardLocalTransform.set(Vector3f.ZERO, Quaternion.IDENTITY, this._config.scale);
        this._updater = this._config.rotationEnabled ? ArticulatedConfig.createBillboardUpdater(this, this._billboardViewTransform, this._billboardLocalTransform, this._config.rotationX, this._config.rotationY) : null;
        this.updateBounds();
    }
}

