/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.google.common.collect.ImmutableList;
import com.samskivert.util.StringUtil;
import com.threerings.editor.swing.PropertyEditor;
import com.threerings.export.ObjectMarshaller;
import com.threerings.util.DeepUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;

public abstract class ArrayListEditor
extends PropertyEditor
implements ActionListener {
    protected int _min;
    protected int _max;
    protected boolean _fixed;
    protected JButton _add;

    public abstract void makeVisible(int var1);

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this._add) {
            this.addValue();
        } else {
            super.actionPerformed(event);
        }
    }

    @Override
    protected void didInit() {
        this._min = this.getMinSize();
        this._max = this.getMaxSize();
        this._fixed = this.isFixedSize();
        this.makeCollapsible(this._ctx, this.getPropertyLabel(), false);
    }

    protected String getActionLabel(String action) {
        return this.getActionLabel(action, null);
    }

    protected String getActionLabel(String action, String units) {
        String bundle = "editor.default";
        if (units == null) {
            units = this._property.getAnnotation().units();
            bundle = this._property.getMessageBundle();
        }
        return this._msgs.get("m." + action + "_entry", new String[]{units.length() > 0 ? this.getLabel(units, bundle) : this.getLabel(this._property.getComponentType())});
    }

    protected int getLength() {
        Object values = this._property.get(this._object);
        return values == null ? 0 : (values.getClass().isArray() ? Array.getLength(values) : ((List)values).size());
    }

    protected Object getValue(int idx) {
        Object value;
        Object values = this._property.get(this._object);
        Object object = value = values.getClass().isArray() ? Array.get(values, idx) : ((List)values).get(idx);
        if (value instanceof String) {
            value = StringUtil.trim((String)((String)value));
        }
        return value;
    }

    protected void setValue(int idx, Object value) {
        Object values = this._property.get(this._object);
        if (value instanceof String) {
            value = StringUtil.trim((String)((String)value));
        }
        if (values.getClass().isArray()) {
            Array.set(values, idx, value);
        } else {
            List<Object> list = this.getListPropertyForModification(this._property.getType());
            list.set(idx, value);
            this._property.set(this._object, list);
        }
    }

    protected final void addValue() {
        Class<?>[] types = this._property.getComponentSubtypes();
        Class<?> type = types[0] == null ? types[1] : types[0];
        this.addValue(ArrayListEditor.getDefaultInstance(type, this._object));
    }

    protected void addValue(Object value) {
        Class<?> type = this._property.getType();
        if (type.isArray()) {
            Object ovalues = this._property.get(this._object);
            int olength = ovalues == null ? 0 : Array.getLength(ovalues);
            Object nvalues = Array.newInstance(type.getComponentType(), olength + 1);
            if (olength > 0) {
                System.arraycopy(ovalues, 0, nvalues, 0, olength);
            }
            Array.set(nvalues, olength, value);
            this._property.set(this._object, nvalues);
        } else {
            List<Object> values = this.getListPropertyForModification(type);
            values.add(value);
            this._property.set(this._object, values);
        }
        this._add.setEnabled(!this._fixed && this.getLength() < this._max);
        this.fireStateChanged();
    }

    protected void copyValue(int idx) {
        Class<?> type = this._property.getType();
        if (type.isArray()) {
            Object ovalues = this._property.get(this._object);
            int olength = Array.getLength(ovalues);
            Object nvalues = Array.newInstance(type.getComponentType(), olength + 1);
            System.arraycopy(ovalues, 0, nvalues, 0, idx + 1);
            Array.set(nvalues, idx + 1, DeepUtil.copy(Array.get(ovalues, idx)));
            System.arraycopy(ovalues, idx + 1, nvalues, idx + 2, olength - idx - 1);
            this._property.set(this._object, nvalues);
        } else {
            List<Object> values = this.getListPropertyForModification(type);
            values.add(idx + 1, DeepUtil.copy(values.get(idx)));
            this._property.set(this._object, values);
        }
        this._add.setEnabled(!this._fixed && this.getLength() < this._max);
        this.fireStateChanged();
    }

    protected void removeValue(int idx) {
        Class<?> type = this._property.getType();
        if (type.isArray()) {
            Object ovalues = this._property.get(this._object);
            int olength = Array.getLength(ovalues);
            Object nvalues = Array.newInstance(type.getComponentType(), olength - 1);
            System.arraycopy(ovalues, 0, nvalues, 0, idx);
            System.arraycopy(ovalues, idx + 1, nvalues, idx, olength - idx - 1);
            this._property.set(this._object, nvalues);
        } else {
            Object proto;
            List<Object> values = this.getListPropertyForModification(type);
            values.remove(idx);
            if (values.isEmpty() && null == this._property.get(proto = ObjectMarshaller.getObjectMarshaller(this._object.getClass()).getPrototype())) {
                values = null;
            }
            this._property.set(this._object, values);
        }
        this._add.setEnabled(!this._fixed && this.getLength() < this._max);
        this.fireStateChanged();
    }

    protected List<Object> getListPropertyForModification(Class<?> type) {
        List values = (ArrayList)this._property.get(this._object);
        if (values == null) {
            if (type == List.class) {
                type = ArrayList.class;
            }
            try {
                List newList = (List)type.newInstance();
                values = newList;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate list [class=" + type + "]", e);
            }
        } else if (values == Collections.EMPTY_LIST || values instanceof ImmutableList) {
            values = new ArrayList(values);
        }
        return values;
    }

    protected void fireStateChanged(boolean reset) {
        if (reset) {
            this._property.set(this._object, this._property.get(this._object));
        }
        this.fireStateChanged();
    }
}

