/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.util;

import com.samskivert.util.StringUtil;
import com.threerings.export.Encodable;
import com.threerings.io.Streamable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Coord
implements Encodable,
Streamable,
Cloneable {
    public static final int EMPTY = Coord.encode(Short.MIN_VALUE, Short.MIN_VALUE);
    public int x;
    public int y;

    public static int encode(int x, int y) {
        return x << 16 | y & 0xFFFF;
    }

    public static int decodeX(int pair) {
        return pair >> 16;
    }

    public static int decodeY(int pair) {
        return pair << 16 >> 16;
    }

    public Coord(int x, int y) {
        this.set(x, y);
    }

    public Coord(int pair) {
        this.set(pair);
    }

    public Coord(int[] values) {
        this.set(values);
    }

    public Coord(Coord other) {
        this.set(other);
    }

    public Coord() {
    }

    public Coord set(Coord other) {
        return this.set(other.x, other.y);
    }

    public Coord set(int[] values) {
        return this.set(values[0], values[1]);
    }

    public Coord set(int pair) {
        return this.set(Coord.decodeX(pair), Coord.decodeY(pair));
    }

    public Coord set(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public int encode() {
        return Coord.encode(this.x, this.y);
    }

    @Override
    public String encodeToString() {
        return String.valueOf(this.x) + ", " + this.y;
    }

    @Override
    public void decodeFromString(String string) throws Exception {
        this.set(StringUtil.parseIntArray((String)string));
    }

    @Override
    public void encodeToStream(DataOutputStream out) throws IOException {
        out.writeInt(this.x);
        out.writeInt(this.y);
    }

    @Override
    public void decodeFromStream(DataInputStream in) throws IOException {
        this.set(in.readInt(), in.readInt());
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + "]";
    }

    public Coord clone() {
        try {
            return (Coord)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int hashCode() {
        return this.x + 31 * this.y;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Coord)) {
            return false;
        }
        Coord ocoord = (Coord)other;
        return this.x == ocoord.x && this.y == ocoord.y;
    }
}

