/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.Strippable;
import com.threerings.export.Exportable;
import com.threerings.io.Streamable;
import com.threerings.math.Vector2f;
import com.threerings.opengl.util.Preloadable;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.probs.FloatVariable;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.client.sprite.ActorSprite;
import com.threerings.tudey.config.ActorConfig;
import com.threerings.tudey.config.ClientActionConfig;
import com.threerings.tudey.config.ConditionConfig;
import com.threerings.tudey.config.EffectConfig;
import com.threerings.tudey.config.ExpressionConfig;
import com.threerings.tudey.config.TargetConfig;
import com.threerings.tudey.util.Coord;
import com.threerings.util.DeepObject;
import com.threerings.whirled.zone.util.ZoneUtil;

@EditorTypes(value={SpawnActor.class, SpawnRotatedActor.class, SpawnTransformedActor.class, SpawnRandomTranslatedActor.class, DestroyActor.class, RotateActor.class, WarpActor.class, WarpTransformedActor.class, FireEffect.class, Signal.class, MoveBody.class, MoveAll.class, Conditional.class, Switch.class, ExpressionSwitch.class, Compound.class, Random.class, Delayed.class, StepLimitMobile.class, SetVariable.class, SetFlag.class, ForceClientAction.class, TargetedAction.class, ZoneMove.class, ServerLog.class, RemoveEntry.class, SpawnLimitedActor.class, SpawnFacingActor.class, Loop.class, None.class, LoopWithDelayed.class, Cascading.class, ModifySpeed.class, Fail.class, ClearSpeed.class, IntervalAction.class})
public abstract class ActionConfig
extends DeepObject
implements Exportable,
Streamable {
    public abstract String getLogicClassName();

    public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
    }

    public void invalidate() {
    }

    public ActionConfig[] getSubActions() {
        return null;
    }

    @Strippable
    public static abstract class AbstractMove
    extends ActionConfig {
        @Editable(min=0.0)
        public int sceneId;
    }

    public static class Cascading
    extends Compound
    implements PreExecutable {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$Cascading";
        }
    }

    public static class Case
    extends DeepObject
    implements Streamable,
    Exportable {
        @Editable
        public ConditionConfig condition = new ConditionConfig.Tagged();
        @Editable
        public ActionConfig action = new SpawnActor();
    }

    public static class ClearSpeed
    extends ActionConfig {
        @Editable
        public TargetConfig target = new TargetConfig.Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$ClearSpeed";
        }
    }

    public static class Compound
    extends ActionConfig
    implements PreExecutable {
        @Editable
        public ActionConfig[] actions = new ActionConfig[0];
        @Editable
        public boolean stopOnFailure = false;

        @Override
        public boolean shouldPreExecute() {
            ActionConfig[] actionConfigArray = this.actions;
            int n = this.actions.length;
            int n2 = 0;
            while (n2 < n) {
                ActionConfig action = actionConfigArray[n2];
                if (action instanceof PreExecutable && ((PreExecutable)((Object)action)).shouldPreExecute()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public void preExecute(TudeySceneView view, ActorSprite sprite, int timestamp) {
            ActionConfig[] actionConfigArray = this.actions;
            int n = this.actions.length;
            int n2 = 0;
            while (n2 < n) {
                PreExecutable preex;
                ActionConfig action = actionConfigArray[n2];
                if (action instanceof PreExecutable && (preex = (PreExecutable)((Object)action)).shouldPreExecute()) {
                    preex.preExecute(view, sprite, timestamp);
                }
                ++n2;
            }
        }

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$Compound";
        }

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            ActionConfig[] actionConfigArray = this.actions;
            int n = this.actions.length;
            int n2 = 0;
            while (n2 < n) {
                ActionConfig action = actionConfigArray[n2];
                action.getPreloads(cfgmgr, preloads);
                ++n2;
            }
        }

        @Override
        public void invalidate() {
            ActionConfig[] actionConfigArray = this.actions;
            int n = this.actions.length;
            int n2 = 0;
            while (n2 < n) {
                ActionConfig action = actionConfigArray[n2];
                action.invalidate();
                ++n2;
            }
        }

        @Override
        public ActionConfig[] getSubActions() {
            return this.actions;
        }
    }

    public static class Conditional
    extends ActionConfig {
        @Editable
        public ConditionConfig condition = new ConditionConfig.Tagged();
        @Editable
        public ActionConfig action = new SpawnActor();
        @Editable(nullable=true)
        public ActionConfig elseAction;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$Conditional";
        }

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            this.action.getPreloads(cfgmgr, preloads);
            this.condition.getPreloads(cfgmgr, preloads);
            if (this.elseAction != null) {
                this.elseAction.getPreloads(cfgmgr, preloads);
            }
        }

        @Override
        public void invalidate() {
            this.condition.invalidate();
            this.action.invalidate();
            if (this.elseAction != null) {
                this.elseAction.invalidate();
            }
        }

        @Override
        public ActionConfig[] getSubActions() {
            ActionConfig[] actions = new ActionConfig[this.elseAction == null ? 1 : 2];
            actions[0] = this.action;
            if (this.elseAction != null) {
                actions[1] = this.elseAction;
            }
            return actions;
        }
    }

    public static class DefaultZone
    extends Zone {
        @Override
        public int getQualifyZoneId() {
            return -1;
        }
    }

    public static class Delayed
    extends ActionConfig {
        @Editable(min=0.0, hgroup="d")
        @Strippable
        public int delay;
        @Editable(min=0.0, hgroup="d")
        @Strippable
        public int variance;
        @Editable
        public ActionConfig action = new SpawnActor();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$Delayed";
        }

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            this.action.getPreloads(cfgmgr, preloads);
        }

        @Override
        public void invalidate() {
            this.action.invalidate();
        }

        @Override
        public ActionConfig[] getSubActions() {
            ActionConfig[] subActions = new ActionConfig[]{this.action};
            return subActions;
        }
    }

    @Strippable
    public static class DestroyActor
    extends ActionConfig {
        @Editable
        public TargetConfig target = new TargetConfig.Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$DestroyActor";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class EntryPortal
    extends Portal {
        @Editable(min=0.0)
        public int id;

        @Override
        public Object getKey() {
            return this.id;
        }
    }

    public static class ExpressionCase
    extends DeepObject
    implements Streamable,
    Exportable {
        @Editable
        public ExpressionConfig value = new ExpressionConfig.Constant();
        @Editable
        public ActionConfig action = new SpawnActor();
    }

    public static class ExpressionSwitch
    extends ActionConfig {
        @Editable
        public ExpressionConfig value = new ExpressionConfig.Constant();
        @Editable
        public ExpressionCase[] cases = new ExpressionCase[0];
        @Editable(nullable=true)
        public ActionConfig defaultAction;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$ExpressionSwitch";
        }

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            ExpressionCase[] expressionCaseArray = this.cases;
            int n = this.cases.length;
            int n2 = 0;
            while (n2 < n) {
                ExpressionCase c = expressionCaseArray[n2];
                c.action.getPreloads(cfgmgr, preloads);
                ++n2;
            }
            if (this.defaultAction != null) {
                this.defaultAction.getPreloads(cfgmgr, preloads);
            }
        }

        @Override
        public void invalidate() {
            ExpressionCase[] expressionCaseArray = this.cases;
            int n = this.cases.length;
            int n2 = 0;
            while (n2 < n) {
                ExpressionCase c = expressionCaseArray[n2];
                c.action.invalidate();
                ++n2;
            }
            if (this.defaultAction != null) {
                this.defaultAction.invalidate();
            }
        }

        @Override
        public ActionConfig[] getSubActions() {
            ActionConfig[] actions = new ActionConfig[this.cases.length + (this.defaultAction == null ? 0 : 1)];
            int ii = 0;
            while (ii < this.cases.length) {
                actions[ii] = this.cases[ii].action;
                ++ii;
            }
            if (this.defaultAction != null) {
                actions[this.cases.length] = this.defaultAction;
            }
            return actions;
        }
    }

    public static class Fail
    extends ActionConfig
    implements PreExecutable {
        @Editable
        public ActionConfig action = new SpawnActor();

        @Override
        public boolean shouldPreExecute() {
            return this.action instanceof PreExecutable && ((PreExecutable)((Object)this.action)).shouldPreExecute();
        }

        @Override
        public void preExecute(TudeySceneView view, ActorSprite sprite, int timestamp) {
            PreExecutable preex;
            if (this.action instanceof PreExecutable && (preex = (PreExecutable)((Object)this.action)).shouldPreExecute()) {
                preex.preExecute(view, sprite, timestamp);
            }
        }

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$Fail";
        }

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            this.action.getPreloads(cfgmgr, preloads);
        }

        @Override
        public void invalidate() {
            this.action.invalidate();
        }
    }

    public static class FireEffect
    extends ActionConfig {
        @Editable(nullable=true)
        public ConfigReference<EffectConfig> effect;
        @Editable
        public TargetConfig location = new TargetConfig.Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$FireEffect";
        }

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            EffectConfig.Original original;
            EffectConfig config = cfgmgr.getConfig(EffectConfig.class, this.effect);
            EffectConfig.Original original2 = original = config == null ? null : config.getOriginal(cfgmgr);
            if (original != null) {
                original.getPreloads(cfgmgr, preloads);
            }
        }

        @Override
        public void invalidate() {
            this.location.invalidate();
        }
    }

    @Strippable
    public static class ForceClientAction
    extends ActionConfig {
        @Editable
        public TargetConfig target = new TargetConfig.Source();
        @Editable
        public ClientActionConfig action = new ClientActionConfig.ControllerAction();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$ForceClientAction";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class IntervalAction
    extends ActionConfig {
        @Editable(hgroup="i", min=-1.0)
        public int delay = -1;
        @Editable(hgroup="i")
        public float interval;
        @Editable(hgroup="i")
        public boolean onServerStart;
        @Editable(nullable=true)
        public ActionConfig action;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$IntervalAction";
        }
    }

    public static enum LogLevel {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }

    public static class Loop
    extends Compound {
        @Editable
        public int times = 1;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$Loop";
        }
    }

    public static enum LoopType {
        COMPOUND,
        CASCADING;

    }

    public static class LoopWithDelayed
    extends Compound {
        @Editable(min=0.0, step=1.0, hgroup="i")
        public int deplay = 0;
        @Editable(min=0.0, step=1.0, hgroup="i")
        @Strippable
        public int interval = 10;
        @Editable(min=0.0, step=1.0, hgroup="i")
        public int limit = 1;
        @Editable(hgroup="i")
        public LoopType type = LoopType.COMPOUND;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$LoopWithDelayed";
        }
    }

    public static class ModifySpeed
    extends ActionConfig {
        @Editable(hgroup="r")
        @Strippable
        public float speed = 1.0f;
        @Editable
        public TargetConfig target = new TargetConfig.Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$ModifySpeed";
        }
    }

    public static class MoveAll
    extends PortalMove {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$MoveAll";
        }
    }

    public static class MoveBody
    extends PortalMove {
        @Editable
        public TargetConfig target = new TargetConfig.Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$MoveBody";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class None
    extends ActionConfig {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$None";
        }
    }

    @EditorTypes(value={TaggedPortal.class, TilePortal.class, EntryPortal.class})
    public static abstract class Portal
    extends DeepObject
    implements Exportable {
        public abstract Object getKey();
    }

    public static abstract class PortalMove
    extends AbstractMove {
        @Editable
        public Portal portal = new TaggedPortal();
    }

    public static interface PreExecutable {
        public boolean shouldPreExecute();

        public void preExecute(TudeySceneView var1, ActorSprite var2, int var3);
    }

    public static class QualifyZone
    extends Zone {
        @Editable
        public byte zoneType;
        @Editable
        public int zoneId;

        @Override
        public int getQualifyZoneId() {
            return ZoneUtil.qualifyZoneId((byte)this.zoneType, (int)this.zoneId);
        }
    }

    public static class Random
    extends ActionConfig {
        @Editable
        public WeightedAction[] actions = new WeightedAction[0];

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$Random";
        }

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            WeightedAction[] weightedActionArray = this.actions;
            int n = this.actions.length;
            int n2 = 0;
            while (n2 < n) {
                WeightedAction waction = weightedActionArray[n2];
                waction.action.getPreloads(cfgmgr, preloads);
                ++n2;
            }
        }

        @Override
        public void invalidate() {
            WeightedAction[] weightedActionArray = this.actions;
            int n = this.actions.length;
            int n2 = 0;
            while (n2 < n) {
                WeightedAction waction = weightedActionArray[n2];
                waction.action.invalidate();
                ++n2;
            }
        }

        @Override
        public ActionConfig[] getSubActions() {
            ActionConfig[] subActions = new ActionConfig[this.actions.length];
            int ii = 0;
            while (ii < this.actions.length) {
                subActions[ii] = this.actions[ii].action;
                ++ii;
            }
            return subActions;
        }
    }

    @Strippable
    public static class RemoveEntry
    extends ActionConfig {
        @Editable
        public TargetConfig target = new TargetConfig.Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$RemoveEntry";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class RotateActor
    extends ActionConfig {
        @Editable
        public TargetConfig target = new TargetConfig.Source();
        @Editable(min=-180.0, max=180.0, scale=0.017453292519943295)
        public FloatVariable rotation = new FloatVariable.Uniform((float)(-Math.PI), (float)Math.PI);

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$RotateActor";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class ServerLog
    extends ActionConfig {
        @Editable
        public LogLevel level = LogLevel.INFO;
        @Editable
        public String message = "";

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$ServerLog";
        }
    }

    @Strippable
    public static class SetFlag
    extends ActionConfig {
        @Editable(hgroup="d")
        public String flag = "";
        @Editable(hgroup="d")
        public boolean on = true;
        @Editable
        public TargetConfig target = new TargetConfig.Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$SetFlag";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    @Strippable
    public static class SetVariable
    extends ActionConfig {
        @Editable
        public String name = "";
        @Editable
        public TargetConfig target = new TargetConfig.Source();
        @Editable
        public ExpressionConfig value = new ExpressionConfig.Constant();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$SetVariable";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    @Strippable
    public static class Signal
    extends ActionConfig {
        @Editable(nullable=true)
        public String name = "";
        @Editable
        public TargetConfig target = new TargetConfig.Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$Signal";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class SpawnActor
    extends ActionConfig {
        @Editable(nullable=true)
        public ConfigReference<ActorConfig> actor;
        @Editable
        public TargetConfig location = new TargetConfig.Source();
        @Editable(nullable=true)
        public String tag;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$SpawnActor";
        }

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            ActorConfig.Original original;
            if (preloads.add(new Preloadable.Config(ActorConfig.class, this.actor)) && (original = this.getOriginal(cfgmgr)) != null) {
                original.getPreloads(cfgmgr, preloads);
            }
        }

        @Override
        public void invalidate() {
            this.location.invalidate();
        }

        public ActorConfig.Original getOriginal(ConfigManager cfgmgr) {
            ActorConfig config = cfgmgr.getConfig(ActorConfig.class, this.actor);
            return config == null ? null : config.getOriginal(cfgmgr);
        }
    }

    public static class SpawnFacingActor
    extends SpawnActor {
        @Editable
        public TargetConfig facing = new TargetConfig.Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$SpawnFacingActor";
        }

        @Override
        public void invalidate() {
            this.facing.invalidate();
        }
    }

    public static class SpawnLimitedActor
    extends SpawnRandomTranslatedActor {
        @Editable
        public int limit;
        @Editable
        public boolean activate;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$SpawnLimitedActor";
        }
    }

    public static class SpawnRandomTranslatedActor
    extends SpawnActor {
        @Editable
        @Strippable
        public int count = 1;
        @Editable(min=0.01, step=0.01, hgroup="s")
        @Strippable
        public float stepSize = 1.0f;
        @Editable(hgroup="s")
        @Strippable
        public int steps = 1;
        @Editable(editor="mask", mode="collision", hgroup="c")
        @Strippable
        public int collisionMask = 0;
        @Editable(hgroup="c")
        @Strippable
        public TargetConfig collisionSource = new TargetConfig.Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$SpawnRandomTranslatedActor";
        }

        @Override
        public void invalidate() {
            super.invalidate();
            this.collisionSource.invalidate();
        }
    }

    public static class SpawnRotatedActor
    extends SpawnActor {
        @Editable(min=-180.0, max=180.0, scale=0.017453292519943295, hgroup="r")
        @Strippable
        public float rotation = 0.0f;
        @Editable(hgroup="r")
        @Strippable
        public boolean relative = false;
        @Editable(min=0.0, max=360.0, scale=0.017453292519943295)
        @Strippable
        public float rotationVariance = 0.0f;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$SpawnRotatedActor";
        }
    }

    public static class SpawnTransformedActor
    extends SpawnRotatedActor {
        @Editable
        @Strippable
        public Vector2f translation = new Vector2f();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$SpawnTransformedActor";
        }
    }

    @Strippable
    public static class StepLimitMobile
    extends ActionConfig {
        @Editable
        public boolean remove = false;
        @Editable(min=-180.0, max=180.0, scale=0.017453292519943295, hgroup="m")
        public float minDirection;
        @Editable(min=-180.0, max=180.0, scale=0.017453292519943295, hgroup="m")
        public float maxDirection;
        @Editable
        public TargetConfig target = new TargetConfig.Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$StepLimitMobile";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class Switch
    extends ActionConfig {
        @Editable
        public Case[] cases = new Case[0];
        @Editable(nullable=true)
        public ActionConfig defaultAction;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$Switch";
        }

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            Case[] caseArray = this.cases;
            int n = this.cases.length;
            int n2 = 0;
            while (n2 < n) {
                Case c = caseArray[n2];
                c.action.getPreloads(cfgmgr, preloads);
                ++n2;
            }
            if (this.defaultAction != null) {
                this.defaultAction.getPreloads(cfgmgr, preloads);
            }
        }

        @Override
        public void invalidate() {
            Case[] caseArray = this.cases;
            int n = this.cases.length;
            int n2 = 0;
            while (n2 < n) {
                Case c = caseArray[n2];
                c.condition.invalidate();
                c.action.invalidate();
                ++n2;
            }
            if (this.defaultAction != null) {
                this.defaultAction.invalidate();
            }
        }

        @Override
        public ActionConfig[] getSubActions() {
            ActionConfig[] actions = new ActionConfig[this.cases.length + (this.defaultAction == null ? 0 : 1)];
            int ii = 0;
            while (ii < this.cases.length) {
                actions[ii] = this.cases[ii].action;
                ++ii;
            }
            if (this.defaultAction != null) {
                actions[this.cases.length] = this.defaultAction;
            }
            return actions;
        }
    }

    public static class TaggedPortal
    extends Portal {
        @Editable
        public String tag = "";

        @Override
        public Object getKey() {
            return this.tag;
        }
    }

    public static class TargetedAction
    extends ActionConfig {
        @Editable
        public TargetConfig target = new TargetConfig.Source();
        @Editable
        public ActionConfig action = new SpawnActor();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$TargetedAction";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
            this.action.invalidate();
        }
    }

    public static class TilePortal
    extends Portal {
        @Editable(hgroup="c")
        public int x;
        @Editable(hgroup="c")
        public int y;

        @Override
        public Object getKey() {
            return new Coord(this.x, this.y);
        }
    }

    @Strippable
    public static class WarpActor
    extends ActionConfig {
        @Editable
        public TargetConfig target = new TargetConfig.Source();
        @Editable
        public TargetConfig location = new TargetConfig.Tagged();
        @Editable(min=0.0)
        public int maxWarpPath = 0;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$WarpActor";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
            this.location.invalidate();
        }
    }

    @Strippable
    public static class WarpTransformedActor
    extends WarpActor {
        @Editable(min=-180.0, max=180.0, scale=0.017453292519943295, hgroup="t")
        public float rotation = 0.0f;
        @Editable(hgroup="t")
        public Vector2f translation = new Vector2f();
        @Editable(hgroup="r")
        public boolean rotatedTranslation = true;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$WarpTransformedActor";
        }
    }

    public static class WeightedAction
    extends DeepObject
    implements Exportable {
        @Editable(min=0.0, step=0.01)
        @Strippable
        public float weight = 1.0f;
        @Editable
        public ActionConfig action = new SpawnActor();
    }

    @EditorTypes(value={DefaultZone.class, QualifyZone.class})
    public static abstract class Zone
    extends DeepObject
    implements Exportable {
        public abstract int getQualifyZoneId();
    }

    public static class ZoneMove
    extends MoveBody {
        @Editable
        public Zone zone = new DefaultZone();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActionLogic$ZoneMove";
        }
    }
}

