/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.opengl.gui.BoundedRangeModel;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.UIConstants;
import com.threerings.opengl.gui.config.StyleConfig;
import com.threerings.opengl.gui.event.Event;
import com.threerings.opengl.gui.event.MouseEvent;
import com.threerings.opengl.gui.icon.Icon;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.gui.util.Insets;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.util.GlContext;

public class Slider
extends Component
implements UIConstants {
    protected int _orient;
    protected BoundedRangeModel _model;
    protected Icon[] _frobs = new Icon[this.getStateCount()];

    public Slider(GlContext ctx, int orient, int min, int max, int value) {
        this(ctx, orient, new BoundedRangeModel(min, value, 0, max));
    }

    public Slider(GlContext ctx, int orient, BoundedRangeModel model) {
        super(ctx);
        this._orient = orient;
        this._model = model;
    }

    public BoundedRangeModel getModel() {
        return this._model;
    }

    @Override
    protected String getDefaultStyleConfig() {
        return String.valueOf(this._orient == 0 ? "Default/H" : "Default/V") + "Slider";
    }

    @Override
    protected void updateFromStyleConfig(int state, StyleConfig.Original config) {
        super.updateFromStyleConfig(state, config);
        this._frobs[state] = config.icon == null ? null : config.icon.getIcon(this._ctx);
    }

    @Override
    protected Dimension computePreferredSize(int whint, int hhint) {
        Dimension psize = new Dimension(this.getFrob().getWidth(), this.getFrob().getHeight());
        if (this._orient == 0) {
            psize.width *= 2;
        } else {
            psize.height *= 2;
        }
        return psize;
    }

    @Override
    public boolean dispatchEvent(Event event) {
        if (this.isEnabled() && event instanceof MouseEvent) {
            MouseEvent mev = (MouseEvent)event;
            int mx = mev.getX() - this.getAbsoluteX();
            int my = mev.getY() - this.getAbsoluteY();
            switch (mev.getType()) {
                case 0: {
                    if (mev.getButton() != 0) break;
                    this.updateValue(mx, my);
                    break;
                }
                case 6: {
                    this.updateValue(mx, my);
                    break;
                }
                case 7: {
                    int delta = this._model.getRange() / 10;
                    int value = this._model.getValue();
                    this._model.setValue(mev.getDelta() > 0 ? value + delta : value - delta);
                    break;
                }
                default: {
                    return super.dispatchEvent(event);
                }
            }
            return true;
        }
        return super.dispatchEvent(event);
    }

    @Override
    protected void renderComponent(Renderer renderer) {
        int x;
        int y;
        super.renderComponent(renderer);
        Insets insets = this.getInsets();
        Icon frob = this.getFrob();
        int range = this._model.getRange();
        int offset = this._model.getValue() - this._model.getMinimum();
        if (this._orient == 0) {
            y = (this.getHeight() - frob.getHeight()) / 2;
            x = insets.left + (this.getWidth() - insets.getHorizontal() - frob.getWidth()) * offset / range;
        } else {
            x = (this.getWidth() - frob.getWidth()) / 2;
            y = insets.bottom + (this.getHeight() - insets.getVertical() - frob.getHeight()) * offset / range;
        }
        frob.render(renderer, x, y, this._alpha);
    }

    protected void updateValue(int mx, int my) {
        Insets insets = this.getInsets();
        Icon frob = this.getFrob();
        if (this._orient == 0) {
            int fwid = frob.getWidth();
            this._model.setValue(this._model.getMinimum() + Math.round(((float)mx - (float)fwid * 0.5f) * (float)this._model.getRange() / (float)(this.getWidth() - insets.getHorizontal() - fwid)));
        } else {
            int fhei = frob.getHeight();
            this._model.setValue(this._model.getMinimum() + Math.round(((float)my - (float)fhei * 0.5f) * (float)this._model.getRange() / (float)(this.getHeight() - insets.getVertical() - fhei)));
        }
    }

    protected Icon getFrob() {
        Icon frob = this._frobs[this.getState()];
        return frob != null ? frob : this._frobs[0];
    }
}

