/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.shape;

import com.threerings.math.FloatMath;
import com.threerings.math.Ray2D;
import com.threerings.math.Rect;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.tudey.shape.Capsule;
import com.threerings.tudey.shape.Circle;
import com.threerings.tudey.shape.Compound;
import com.threerings.tudey.shape.None;
import com.threerings.tudey.shape.Point;
import com.threerings.tudey.shape.Polygon;
import com.threerings.tudey.shape.Segment;
import com.threerings.tudey.shape.config.ShapeConfig;
import com.threerings.tudey.space.SpaceElement;

public abstract class Shape {
    protected Rect _bounds = new Rect();
    protected static final int CIRCLE_SEGMENTS = 16;
    protected static final float CIRCLE_INCREMENT = 0.3926991f;

    public Rect getBounds() {
        return this._bounds;
    }

    public abstract void updateBounds();

    public Vector2f getCenter() {
        return this.getCenter(new Vector2f());
    }

    public abstract Vector2f getCenter(Vector2f var1);

    public Shape transformLocal(Transform2D transform) {
        return this.transform(transform, this);
    }

    public Shape transform(Transform2D transform) {
        return this.transform(transform, null);
    }

    public abstract Shape transform(Transform2D var1, Shape var2);

    public Shape expandLocal(float amount) {
        return this.expand(amount, this);
    }

    public Shape expand(float amount) {
        return this.expand(amount, null);
    }

    public abstract Shape expand(float var1, Shape var2);

    public Shape sweep(Vector2f translation) {
        return this.sweep(translation, null);
    }

    public abstract Shape sweep(Vector2f var1, Shape var2);

    public Vector2f[] getPerimeterPath() {
        return this._bounds.getPerimeterPath();
    }

    public abstract boolean getIntersection(Ray2D var1, Vector2f var2);

    public abstract void getNearestPoint(Vector2f var1, Vector2f var2);

    public abstract IntersectionType getIntersectionType(Rect var1);

    public abstract boolean intersects(SpaceElement var1);

    public abstract boolean intersects(Shape var1);

    public abstract boolean intersects(Point var1);

    public abstract boolean intersects(Segment var1);

    public abstract boolean intersects(Circle var1);

    public abstract boolean intersects(Capsule var1);

    public abstract boolean intersects(Polygon var1);

    public abstract boolean intersects(Compound var1);

    public boolean intersects(None none) {
        return false;
    }

    public abstract Vector2f getPenetration(Shape var1, Vector2f var2);

    public abstract Vector2f getPenetration(Point var1, Vector2f var2);

    public abstract Vector2f getPenetration(Segment var1, Vector2f var2);

    public abstract Vector2f getPenetration(Circle var1, Vector2f var2);

    public abstract Vector2f getPenetration(Capsule var1, Vector2f var2);

    public abstract Vector2f getPenetration(Polygon var1, Vector2f var2);

    public abstract Vector2f getPenetration(Compound var1, Vector2f var2);

    public Vector2f getPenetration(None none, Vector2f result) {
        return result.set(Vector2f.ZERO);
    }

    public abstract void draw(boolean var1);

    public abstract ShapeConfig createConfig();

    protected static Vector2f updateClosest(Vector2f origin, Vector2f result, Vector2f closest) {
        if (result == closest) {
            return new Vector2f();
        }
        if (origin.distanceSquared(result) < origin.distanceSquared(closest)) {
            closest.set(result);
        }
        return result;
    }

    protected static boolean intersects(Vector2f start, Vector2f end, float radius, Vector2f origin, Vector2f terminus) {
        float y;
        float x;
        boolean below;
        float c;
        float dist;
        float a = start.y - end.y;
        float b = end.x - start.x;
        float len = FloatMath.hypot(a, b);
        if (len < 1.0E-6f) {
            return Shape.intersects(start, radius, origin, terminus);
        }
        float rlen = 1.0f / len;
        boolean above = (dist = (a *= rlen) * origin.x + (b *= rlen) * origin.y + (c = -a * start.x - b * start.y)) > radius;
        boolean bl = below = dist < -radius;
        if (above || below) {
            float dx = terminus.x - origin.x;
            float dy = terminus.y - origin.y;
            float divisor = a * dx + b * dy;
            if (Math.abs(divisor) < 1.0E-6f) {
                return false;
            }
            float t = (-a * origin.x - b * origin.y - (c += above ? -radius : radius)) / divisor;
            if (t < 0.0f || t > 1.0f) {
                return false;
            }
            x = origin.x + t * dx;
            y = origin.y + t * dy;
        } else {
            x = origin.x;
            y = origin.y;
        }
        float tmp = a;
        a = b;
        b = -tmp;
        c = -a * start.x - b * start.y;
        dist = a * x + b * y + c;
        if (dist < 0.0f) {
            return Shape.intersects(start, radius, origin, terminus);
        }
        if (dist > len) {
            return Shape.intersects(end, radius, origin, terminus);
        }
        return true;
    }

    protected static boolean intersects(Vector2f center, float radius, Vector2f start, Vector2f end) {
        float r2 = radius * radius;
        if (center.distanceSquared(start) <= r2 || center.distanceSquared(end) <= r2) {
            return true;
        }
        float ax = start.x - center.x;
        float ay = start.y - center.y;
        float dx = end.x - start.x;
        float dy = end.y - start.y;
        float a = dx * dx + dy * dy;
        if (a < 1.0E-6f) {
            return false;
        }
        float b = 2.0f * (dx * ax + dy * ay);
        float c = ax * ax + ay * ay - r2;
        float radicand = b * b - 4.0f * a * c;
        if (radicand < 0.0f) {
            return false;
        }
        float t = (-b - FloatMath.sqrt(radicand)) / (2.0f * a);
        return t >= 0.0f && t <= 1.0f;
    }

    protected static void nearestPointOnSegment(Vector2f start, Vector2f end, Vector2f point, Vector2f result) {
        float r = point.subtract(start).dot(end.subtract(start)) / start.distanceSquared(end);
        if (r <= 0.0f) {
            result.set(start);
        } else if (r >= 1.0f) {
            result.set(end);
        } else {
            result.set(start.add(end.subtract(start).mult(r)));
        }
    }

    protected static void getOutsideLinePenetration(Vector2f start, Vector2f end, float radius, Vector2f point, Vector2f result) {
        Shape.nearestPointOnSegment(start, end, point, result);
        if (radius > 0.0f) {
            Vector2f perp = new Vector2f(start.y - end.y, end.x - start.x);
            Vector2f line = result.subtract(point);
            float sign = Math.signum(perp.dot(line));
            if (sign > 0.0f && result.lengthSquared() > radius * radius) {
                result.set(Vector2f.ZERO);
            } else {
                result.addLocal(line.normalizeLocal().multLocal(sign * -radius));
            }
        }
    }

    protected static Vector2f getMinMinkowskyDifference(Vector2f[] A, Vector2f[] B, float radius, Vector2f minDistance) {
        if (Vector2f.ZERO.equals(minDistance)) {
            return minDistance;
        }
        boolean flip = minDistance != null;
        int nn = A.length;
        for (int ii = 0; ii < nn; ++ii) {
            Vector2f start = A[ii];
            Vector2f end = A[(ii + 1) % nn];
            Vector2f sprime = Vector2f.ZERO;
            Vector2f eprime = Vector2f.ZERO;
            Vector2f perp = new Vector2f(start.y - end.y, end.x - start.x);
            float dot = Float.NEGATIVE_INFINITY;
            int dj = 0;
            int mm = B.length;
            for (int jj = 0; jj < mm; ++jj) {
                float odot = perp.dot(B[jj]);
                if (odot > dot) {
                    dot = odot;
                    eprime = sprime = B[jj];
                    dj = jj;
                    continue;
                }
                if (!FloatMath.epsilonEquals(odot, dot)) continue;
                Vector2f perp2 = new Vector2f(B[jj].y - sprime.y, sprime.x - B[jj].x);
                if (perp.dot(perp2) < 0.0f) {
                    sprime = B[jj];
                    continue;
                }
                eprime = B[jj];
            }
            if (flip) {
                sprime = sprime.subtract(start);
                eprime = eprime.subtract(end);
            } else {
                sprime = start.subtract(sprime);
                eprime = end.subtract(eprime);
            }
            Vector2f distance = new Vector2f();
            Shape.getOutsideLinePenetration(sprime, eprime, radius, Vector2f.ZERO, distance);
            if ((minDistance == null || minDistance.distanceSquared(Vector2f.ZERO) > distance.distanceSquared(Vector2f.ZERO)) && (minDistance = distance).equals(Vector2f.ZERO)) break;
        }
        return minDistance;
    }

    public static enum IntersectionType {
        NONE,
        INTERSECTS,
        CONTAINS;

    }
}

