/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.threerings.editor.FileConstraints;
import com.threerings.editor.swing.PropertyEditor;
import com.threerings.util.MessageBundle;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.filechooser.FileFilter;

public class FileEditor
extends PropertyEditor
implements ActionListener {
    protected JButton _file;
    protected JButton _clear;
    protected JFileChooser _chooser;
    protected static Preferences _prefs = Preferences.userNodeForPackage(FileEditor.class);

    @Override
    public void actionPerformed(ActionEvent event) {
        File value;
        Object source = event.getSource();
        if (source == this._file) {
            String key;
            final FileConstraints constraints = this._property.getAnnotation(FileConstraints.class);
            String string = key = constraints == null || constraints.directory().length() == 0 ? null : constraints.directory();
            if (this._chooser == null) {
                String ddir = this.getDefaultDirectory();
                this._chooser = new JFileChooser((String)(ddir == null ? (key == null ? null : _prefs.get(key, ddir)) : ddir));
                if (this.getMode().equals("directory")) {
                    this._chooser.setFileSelectionMode(1);
                } else if (constraints != null) {
                    final MessageBundle msgs = this._msgmgr.getBundle(this._property.getMessageBundle());
                    this._chooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            String name = file.getName();
                            for (String extension : constraints.extensions()) {
                                if (!name.endsWith(extension)) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public String getDescription() {
                            return msgs.get(constraints.description());
                        }
                    });
                }
            }
            this._chooser.setSelectedFile(this.getPropertyFile());
            int result = this._chooser.showOpenDialog((Component)((Object)this));
            if (key != null) {
                _prefs.put(key, this._chooser.getCurrentDirectory().toString());
            }
            if (result != 0) {
                return;
            }
            value = this._chooser.getSelectedFile();
        } else {
            value = null;
        }
        this.setPropertyFile(value);
        this.updateButtons(value);
        this.fireStateChanged();
    }

    @Override
    public void update() {
        this.updateButtons(this.getPropertyFile());
    }

    @Override
    protected void didInit() {
        this.add(new JLabel(this.getPropertyLabel() + ":"));
        this._file = new JButton(" ");
        this.add(this._file);
        this._file.addActionListener(this);
        if (this._property.getAnnotation().nullable()) {
            this._clear = new JButton(this._msgs.get("m.clear"));
            this.add(this._clear);
            this._clear.addActionListener(this);
        }
    }

    protected void updateButtons(File value) {
        boolean enable = value != null;
        this._file.setText(enable ? value.getName() : this._msgs.get("m.null_value"));
        if (this._clear != null) {
            this._clear.setEnabled(enable);
        }
    }

    protected String getDefaultDirectory() {
        File file = (File)this._property.get(this._object);
        if (file != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    protected File getPropertyFile() {
        return (File)this._property.get(this._object);
    }

    protected void setPropertyFile(File file) {
        this._property.set(this._object, file);
    }
}

