//
// $Id$
//
// Clyde library - tools for developing networked games
// Copyright (C) 2005-2012 Three Rings Design, Inc.
// http://code.google.com/p/clyde/
//
// Redistribution and use in source and binary forms, with or without modification, are permitted
// provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice, this list of
//    conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright notice, this list of
//    conditions and the following disclaimer in the documentation and/or other materials provided
//    with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
// INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
// PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
// TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

package com.threerings.tudey.tools;

import com.samskivert.io.PersistenceException;
import com.threerings.whirled.data.SceneModel;
import com.threerings.whirled.server.persist.DummySceneRepository;
import com.threerings.whirled.util.NoSuchSceneException;
import com.google.inject.Singleton;

/**
 * Returns a single scene model for all scene requests.
 */
@Singleton
public class ToolSceneRepository extends DummySceneRepository
{
	
	public void setSourceId(int sceneId){
		this._sourceId = sceneId;
	}
    /**
     * Sets the scene model to return.
     */
    public void setSceneModel (SceneModel model)
    {
        _sceneModel = model;
    }

    @Override // documentation inherited
    public SceneModel loadSceneModel (int sceneId) throws  PersistenceException, NoSuchSceneException
    {
        return _sceneModel;
    }

    /** The scene model to return. */
    protected SceneModel _sceneModel;
    protected int _sourceId;
}
