/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.scene.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.io.Streamable;
import com.threerings.math.Box;
import com.threerings.math.Transform3D;
import com.threerings.util.DeepObject;

@EditorTypes(value={Limited.class, Unlimited.class})
public abstract class Extent
extends DeepObject
implements Exportable,
Streamable {
    public abstract void transformBounds(Transform3D var1, Box var2);

    public static class Limited
    extends Extent {
        @Editable(min=0.0, step=0.01, hgroup="s")
        public float sizeX = 1.0f;
        @Editable(min=0.0, step=0.01, hgroup="s")
        public float sizeY = 1.0f;
        @Editable(min=0.0, step=0.01, hgroup="s")
        public float sizeZ = 1.0f;

        @Override
        public void transformBounds(Transform3D transform, Box result) {
            float hx = this.sizeX * 0.5f;
            float hy = this.sizeY * 0.5f;
            float hz = this.sizeZ * 0.5f;
            result.getMinimumExtent().set(-hx, -hy, -hz);
            result.getMaximumExtent().set(hx, hy, hz);
            result.transformLocal(transform);
        }
    }

    public static class Unlimited
    extends Extent {
        @Override
        public void transformBounds(Transform3D transform, Box result) {
            result.set(Box.MAX_VALUE);
        }
    }
}

