/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.samskivert.util.ListUtil;
import com.samskivert.util.QuickSort;
import com.threerings.media.image.ColorPository;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Selectable;
import com.threerings.opengl.gui.event.ActionEvent;
import com.threerings.opengl.gui.event.Event;
import com.threerings.opengl.gui.event.MouseEvent;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.gui.util.Insets;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.util.GlContext;
import java.util.Collection;
import java.util.Comparator;
import org.lwjgl.opengl.GL11;

public class ColorPicker
extends Component
implements Selectable<ColorPository.ColorRecord> {
    protected ColorPository.ColorRecord[] _colors;
    protected Color4f[] _colorizedRoots;
    protected int _swatchWidth;
    protected int _swatchHeight;
    protected int _sidx;

    public ColorPicker(GlContext ctx, String colorClass, int swatchWidth, int swatchHeight) {
        super(ctx);
        this.setColorClass(colorClass);
        this._swatchWidth = swatchWidth;
        this._swatchHeight = swatchHeight;
    }

    public ColorPicker(GlContext ctx) {
        super(ctx);
    }

    public void setColorClass(String colorClass) {
        this.setColorClass(colorClass, false);
    }

    public void setColorClass(String colorClass, boolean starters) {
        ColorPository.ClassRecord crec = this._ctx.getColorPository().getClassRecord(colorClass);
        if (crec == null) {
            this._colors = new ColorPository.ColorRecord[0];
        } else {
            Collection colors = crec.colors.values();
            if (starters) {
                colors = Collections2.filter((Collection)colors, (Predicate)new Predicate<ColorPository.ColorRecord>(){

                    public boolean apply(ColorPository.ColorRecord color) {
                        return color.starter;
                    }
                });
            }
            this._colors = colors.toArray(new ColorPository.ColorRecord[colors.size()]);
            QuickSort.sort((Object[])this._colors, (Comparator)new Comparator<ColorPository.ColorRecord>(){

                @Override
                public int compare(ColorPository.ColorRecord c1, ColorPository.ColorRecord c2) {
                    return c1.colorId - c2.colorId;
                }
            });
        }
        this._colorizedRoots = new Color4f[this._colors.length];
        int ii = 0;
        while (ii < this._colors.length) {
            this._colorizedRoots[ii] = new Color4f(this._colors[ii].getColorization().getColorizedRoot());
            ++ii;
        }
    }

    public void setSwatchSize(int swatchWidth, int swatchHeight) {
        this._swatchWidth = swatchWidth;
        this._swatchHeight = swatchHeight;
    }

    @Override
    public ColorPository.ColorRecord getSelected() {
        return this._colors[this._sidx];
    }

    @Override
    public void setSelected(ColorPository.ColorRecord color) {
        this.setSelectedIndex(ListUtil.indexOf((Object[])this._colors, (Object)color));
    }

    @Override
    public void setSelectedIndex(int sidx) {
        this._sidx = Math.min(Math.max(sidx, 0), this._colors.length - 1);
    }

    @Override
    public int getSelectedIndex() {
        return this._sidx;
    }

    @Override
    public boolean dispatchEvent(Event event) {
        if (this.isEnabled() && event instanceof MouseEvent) {
            MouseEvent mev = (MouseEvent)event;
            int oidx = this._sidx;
            int midx = (mev.getX() - this.getAbsoluteX()) / this._swatchWidth;
            switch (mev.getType()) {
                case 0: {
                    if (mev.getButton() != 0) break;
                    this.setSelectedIndex(midx);
                    break;
                }
                case 6: {
                    this.setSelectedIndex(midx);
                    break;
                }
                default: {
                    return super.dispatchEvent(event);
                }
            }
            if (this._sidx != oidx) {
                this.emitEvent(new ActionEvent(this, mev.getWhen(), mev.getModifiers(), "select", this.getSelected()));
            }
            return true;
        }
        return super.dispatchEvent(event);
    }

    @Override
    protected String getDefaultStyleConfig() {
        return "Default/ColorPicker";
    }

    @Override
    protected Dimension computePreferredSize(int whint, int hhint) {
        return new Dimension(this._swatchWidth * this._colors.length, this._swatchHeight);
    }

    @Override
    protected void renderComponent(Renderer renderer) {
        renderer.setTextureState(null);
        Insets insets = this.getInsets();
        int x = insets.left;
        int y = insets.bottom;
        GL11.glBegin((int)7);
        int ii = 0;
        while (ii < this._colors.length) {
            Color4f color = this._colorizedRoots[ii];
            GL11.glColor4f((float)(color.r * this._alpha), (float)(color.g * this._alpha), (float)(color.b * this._alpha), (float)(color.a * this._alpha));
            GL11.glVertex2f((float)x, (float)y);
            GL11.glVertex2f((float)(x + this._swatchWidth), (float)y);
            GL11.glVertex2f((float)(x + this._swatchWidth), (float)(y + this._swatchHeight));
            GL11.glVertex2f((float)x, (float)(y + this._swatchHeight));
            x += this._swatchWidth;
            ++ii;
        }
        GL11.glEnd();
        x = insets.left + this._sidx * this._swatchWidth;
        GL11.glLineWidth((float)2.0f);
        GL11.glBegin((int)2);
        GL11.glColor4f((float)this._alpha, (float)this._alpha, (float)this._alpha, (float)this._alpha);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glVertex2f((float)(x + this._swatchWidth), (float)y);
        GL11.glVertex2f((float)(x + this._swatchWidth), (float)(y + this._swatchHeight));
        GL11.glVertex2f((float)x, (float)(y + this._swatchHeight));
        GL11.glEnd();
        GL11.glLineWidth((float)1.0f);
        renderer.invalidateColorState();
    }
}

