/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.samskivert.util.Interval;
import com.samskivert.util.RandomUtil;
import com.samskivert.util.Randoms;
import com.samskivert.util.RunQueue;
import com.samskivert.util.StringUtil;
import com.threerings.config.ConfigReference;
import com.threerings.crowd.data.BodyObject;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector2f;
import com.threerings.presents.dobj.OidList;
import com.threerings.presents.server.PresentsDObjectMgr;
import com.threerings.tudey.Log;
import com.threerings.tudey.config.ActionConfig;
import com.threerings.tudey.config.ActorConfig;
import com.threerings.tudey.config.ClientActionConfig;
import com.threerings.tudey.config.EffectConfig;
import com.threerings.tudey.data.EntityKey;
import com.threerings.tudey.data.TudeyOccupantInfo;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.data.TudeySceneObject;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.data.actor.Mobile;
import com.threerings.tudey.server.TudeySceneManager;
import com.threerings.tudey.server.TudeySceneRegistry;
import com.threerings.tudey.server.TudeyZoneRegistry;
import com.threerings.tudey.server.logic.ActiveLogic;
import com.threerings.tudey.server.logic.ActorLogic;
import com.threerings.tudey.server.logic.AgentLogic;
import com.threerings.tudey.server.logic.ConditionLogic;
import com.threerings.tudey.server.logic.EntryLogic;
import com.threerings.tudey.server.logic.ExpressionLogic;
import com.threerings.tudey.server.logic.HandlerLogic;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.server.logic.PawnLogic;
import com.threerings.tudey.server.logic.TargetLogic;
import com.threerings.tudey.shape.Segment;
import com.threerings.tudey.shape.Shape;
import com.threerings.whirled.server.SceneManager;
import com.threerings.whirled.zone.data.ZonedBodyObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ActionLogic
extends Logic {
    protected ActionConfig _config;
    protected Logic _source;
    protected ArrayList<Logic> _targets = Lists.newArrayList();

    public void init(TudeySceneManager scenemgr, ActionConfig config, Logic source) {
        super.init(scenemgr);
        this._config = config;
        this._source = source;
        this.didInit();
    }

    public void removed() {
        this.wasRemoved();
    }

    public boolean shouldExecute(Logic activator) {
        return true;
    }

    public abstract boolean execute(int var1, Logic var2);

    @Override
    public boolean isActive() {
        return this._source.isActive();
    }

    @Override
    public EntityKey getEntityKey() {
        return this._source.getEntityKey();
    }

    @Override
    public Vector2f getTranslation() {
        return this._source.getTranslation();
    }

    @Override
    public float getRotation() {
        return this._source.getRotation();
    }

    protected void didInit() {
    }

    protected void wasRemoved() {
    }

    public static abstract class AbstractMove
    extends ActionLogic {
        @Inject
        protected PresentsDObjectMgr _omgr;
        @Inject
        protected TudeySceneRegistry _screg;

        protected void moveBody(int bodyOid) {
            BodyObject body = (BodyObject)this._omgr.getObject(bodyOid);
            ActionConfig.MoveBody mconfig = (ActionConfig.MoveBody)this._config;
            SceneManager manager = this._screg.getSceneManager(mconfig.sceneId);
            if (manager == null || body.getPlaceOid() != manager.getPlaceObject().getOid()) {
                this._screg.moveBody(body, mconfig.sceneId, mconfig.portal.getKey());
            }
        }
    }

    public static class Cascading
    extends Compound {
        private int _current;
        private boolean _success = true;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            if (this._current >= this._actions.length || ((ActionConfig.Compound)this._config).stopOnFailure && !this._success) {
                return false;
            }
            this._success = this._actions[this._current++].execute(timestamp, activator) | this._success;
            return this._success;
        }
    }

    public static class ClearSpeed
    extends Targeted {
        @Override
        public boolean execute(int timestamp, Logic activator) {
            boolean success = false;
            this._target.resolve(activator, this._targets);
            int ii = 0;
            int nn = this._targets.size();
            while (ii < nn) {
                Logic target = (Logic)this._targets.get(ii);
                if (target instanceof AgentLogic) {
                    ((AgentLogic)target).clearSpeed();
                    success = true;
                }
                ++ii;
            }
            this._targets.clear();
            return success;
        }

        @Override
        protected void didInit() {
            ActionConfig.ClearSpeed config = (ActionConfig.ClearSpeed)this._config;
            this._target = this.createTarget(config.target, this._source);
        }
    }

    public static class Compound
    extends ActionLogic {
        protected ActionLogic[] _actions;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            boolean success = false;
            ActionLogic[] actionLogicArray = this._actions;
            int n = this._actions.length;
            int n2 = 0;
            while (n2 < n) {
                ActionLogic action = actionLogicArray[n2];
                success = action.execute(timestamp, activator) | success;
                if (((ActionConfig.Compound)this._config).stopOnFailure && !success) {
                    return false;
                }
                ++n2;
            }
            return success;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            ActionLogic[] sactions = ((Compound)source)._actions;
            int ii = 0;
            while (ii < this._actions.length) {
                this._actions[ii].transfer(sactions[ii], refs);
                ++ii;
            }
        }

        @Override
        protected void didInit() {
            ArrayList<ActionLogic> actions = new ArrayList<ActionLogic>();
            ActionConfig[] actionConfigArray = ((ActionConfig.Compound)this._config).actions;
            int n = ((ActionConfig.Compound)this._config).actions.length;
            int n2 = 0;
            while (n2 < n) {
                ActionLogic action;
                ActionConfig config = actionConfigArray[n2];
                if (config != null && (action = this.createAction(config, this._source)) != null) {
                    actions.add(action);
                }
                ++n2;
            }
            this._actions = actions.toArray(new ActionLogic[actions.size()]);
        }

        @Override
        protected void wasRemoved() {
            ActionLogic[] actionLogicArray = this._actions;
            int n = this._actions.length;
            int n2 = 0;
            while (n2 < n) {
                ActionLogic action = actionLogicArray[n2];
                action.removed();
                ++n2;
            }
        }
    }

    public static class Conditional
    extends ActionLogic {
        protected ConditionLogic _condition;
        protected ActionLogic _action;
        protected ActionLogic _elseAction;

        @Override
        public boolean shouldExecute(Logic activator) {
            return this._elseAction != null || this._condition.isSatisfied(activator);
        }

        @Override
        public boolean execute(int timestamp, Logic activator) {
            if (this._condition.isSatisfied(activator)) {
                return this._action.execute(timestamp, activator);
            }
            if (this._elseAction != null) {
                return this._elseAction.execute(timestamp, activator);
            }
            return true;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            Conditional csource = (Conditional)source;
            this._condition.transfer(csource._condition, refs);
            this._action.transfer(csource._action, refs);
            if (this._elseAction != null) {
                this._elseAction.transfer(csource._elseAction, refs);
            }
        }

        @Override
        protected void didInit() {
            ActionConfig.Conditional config = (ActionConfig.Conditional)this._config;
            this._condition = this.createCondition(config.condition, this._source);
            this._action = this.createAction(config.action, this._source);
            if (config.elseAction != null) {
                this._elseAction = this.createAction(config.elseAction, this._source);
            }
        }

        @Override
        protected void wasRemoved() {
            if (this._action != null) {
                this._action.removed();
            }
            if (this._elseAction != null) {
                this._elseAction.removed();
            }
        }
    }

    public static class Delayed
    extends ActionLogic {
        protected ActionLogic _action;
        protected Set<ActionInterval> _intervals = Sets.newIdentityHashSet();

        @Override
        public boolean execute(int timestamp, Logic activator) {
            if (!this._scenemgr.isRunning()) {
                Log.log.warning((Object)"Delayed action executing on shutdown SceneManager.", new Object[]{new Exception()});
                return false;
            }
            ActionConfig.Delayed config = (ActionConfig.Delayed)this._config;
            int delay = config.variance == 0 ? config.delay : Math.max(0, config.delay + Randoms.threadLocal().getInt(config.variance * 2) - config.variance);
            new ActionInterval(this._scenemgr.getTimestamp() + delay, activator);
            return true;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            Delayed src = (Delayed)source;
            this._action.transfer(src._action, refs);
            for (ActionInterval ai : src._intervals) {
                new ActionInterval(ai.executionStamp, (Logic)refs.get(ai.activator));
            }
        }

        @Override
        protected void didInit() {
            super.didInit();
            this._action = this.createAction(((ActionConfig.Delayed)this._config).action, this._source);
        }

        @Override
        protected void wasRemoved() {
            this._action.removed();
            for (ActionInterval ai : this._intervals) {
                ai.cancel();
            }
            this._intervals.clear();
        }

        protected class ActionInterval
        extends Interval {
            public final int executionStamp;
            public final Logic activator;

            public ActionInterval(int executionStamp, Logic activator) {
                super((RunQueue)Delayed.this._scenemgr);
                this.executionStamp = executionStamp;
                this.activator = activator;
                Delayed.this._intervals.add(this);
                this.schedule(Math.max(0, executionStamp - Delayed.this._scenemgr.getTimestamp()));
            }

            public void expired() {
                Delayed.this._intervals.remove((Object)this);
                Delayed.this._action.execute(Delayed.this._scenemgr.getTimestamp(), this.activator);
            }

            protected void noteRejected() {
                Delayed.this._intervals.remove((Object)this);
            }
        }
    }

    public static class DestroyActor
    extends Targeted {
        @Override
        public boolean execute(int timestamp, Logic activator) {
            boolean success = false;
            this._target.resolve(activator, this._targets);
            int ii = 0;
            int nn = this._targets.size();
            while (ii < nn) {
                Logic target = (Logic)this._targets.get(ii);
                if (target instanceof ActorLogic) {
                    ((ActorLogic)target).destroy(timestamp, activator);
                    success = true;
                }
                ++ii;
            }
            this._targets.clear();
            return success;
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ActionConfig.DestroyActor)this._config).target, this._source);
        }
    }

    public static class ExpressionSwitch
    extends ActionLogic {
        protected ExpressionLogic _value;
        protected ExpressionLogic[] _caseValues;
        protected ActionLogic[] _actions;
        protected ActionLogic _defaultAction;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            Object value = this._value.evaluate(activator, null);
            int ii = 0;
            while (ii < this._caseValues.length) {
                if (Objects.equal((Object)value, (Object)this._caseValues[ii].evaluate(activator, null))) {
                    return this._actions[ii].execute(timestamp, activator);
                }
                ++ii;
            }
            if (this._defaultAction != null) {
                return this._defaultAction.execute(timestamp, activator);
            }
            return true;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            ExpressionSwitch esource = (ExpressionSwitch)source;
            int ii = 0;
            while (ii < this._actions.length) {
                this._actions[ii].transfer(esource._actions[ii], refs);
                ++ii;
            }
            if (this._defaultAction != null) {
                this._defaultAction.transfer(esource._defaultAction, refs);
            }
        }

        @Override
        protected void didInit() {
            ActionConfig.ExpressionSwitch config = (ActionConfig.ExpressionSwitch)this._config;
            this._value = this.createExpression(config.value, this._source);
            this._caseValues = new ExpressionLogic[config.cases.length];
            this._actions = new ActionLogic[config.cases.length];
            int ii = 0;
            while (ii < config.cases.length) {
                this._caseValues[ii] = this.createExpression(config.cases[ii].value, this._source);
                this._actions[ii] = this.createAction(config.cases[ii].action, this._source);
                ++ii;
            }
            if (config.defaultAction != null) {
                this._defaultAction = this.createAction(config.defaultAction, this._source);
            }
        }

        @Override
        protected void wasRemoved() {
            ActionLogic[] actionLogicArray = this._actions;
            int n = this._actions.length;
            int n2 = 0;
            while (n2 < n) {
                ActionLogic action = actionLogicArray[n2];
                action.removed();
                ++n2;
            }
            if (this._defaultAction != null) {
                this._defaultAction.removed();
            }
        }
    }

    public static class Fail
    extends ActionLogic {
        protected ActionLogic _action;

        @Override
        public boolean shouldExecute(Logic activator) {
            return this._action != null && this._action.shouldExecute(activator);
        }

        @Override
        public boolean execute(int timestamp, Logic activator) {
            if (this._action != null) {
                this._action.execute(timestamp, activator);
            }
            return false;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            if (this._action != null) {
                this._action.transfer(((Fail)source)._action, refs);
            }
        }

        @Override
        protected void didInit() {
            this._action = this.createAction(((ActionConfig.Fail)this._config).action, this._source);
        }

        @Override
        protected void wasRemoved() {
            if (this._action != null) {
                this._action.removed();
            }
        }
    }

    public static class FireEffect
    extends ActionLogic {
        protected TargetLogic _location;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            ConfigReference<EffectConfig> effect = ((ActionConfig.FireEffect)this._config).effect;
            if (effect == null) {
                return true;
            }
            this._location.resolve(activator, this._targets);
            int ii = 0;
            int nn = this._targets.size();
            while (ii < nn) {
                Logic target = (Logic)this._targets.get(ii);
                this._scenemgr.fireEffect(this._scenemgr.getNextTimestamp(), target, null, 0.0f, effect);
                ++ii;
            }
            this._targets.clear();
            return true;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._location.transfer(((FireEffect)source)._location, refs);
        }

        @Override
        protected void didInit() {
            this._location = this.createTarget(((ActionConfig.FireEffect)this._config).location, this._source);
        }
    }

    public static class ForceClientAction
    extends Targeted {
        @Inject
        protected PresentsDObjectMgr _omgr;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            ClientActionConfig action = ((ActionConfig.ForceClientAction)this._config).action;
            this._target.resolve(activator, this._targets);
            boolean success = false;
            int ii = 0;
            int nn = this._targets.size();
            while (ii < nn) {
                Logic target = (Logic)this._targets.get(ii);
                if (target instanceof PawnLogic) {
                    int pawnId = ((PawnLogic)target).getActor().getId();
                    TudeyOccupantInfo info = ((TudeySceneObject)this._scenemgr.getPlaceObject()).getOccupantInfo(pawnId);
                    if (info != null) {
                        this._omgr.getObject(info.getBodyOid()).postMessage("forceClientAction", new Object[]{action, this._source.getEntityKey()});
                        success = true;
                    }
                }
                ++ii;
            }
            this._targets.clear();
            return success;
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ActionConfig.ForceClientAction)this._config).target, this._source);
        }
    }

    public static class IntervalAction
    extends ActionLogic {
        protected ActionLogic _action;
        protected int _nextTime;
        protected int _delay;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            ActionConfig.IntervalAction cf = (ActionConfig.IntervalAction)this._config;
            if (cf.interval >= 0.0f && timestamp >= this._nextTime) {
                this._nextTime = timestamp + (int)cf.interval * 1000;
                if (this._action != null) {
                    return this._action.execute(timestamp, activator);
                }
            }
            return true;
        }

        @Override
        protected void didInit() {
            ActionConfig.IntervalAction cf = (ActionConfig.IntervalAction)this._config;
            this._action = this.createAction(cf.action, this._source);
            this._nextTime = (cf.onServerStart ? 0 : this._scenemgr.getTimestamp()) + (cf.delay == -1 ? (int)cf.interval * 1000 : cf.delay * 1000);
        }

        @Override
        protected void wasRemoved() {
            if (this._action != null) {
                this._action.wasRemoved();
            }
            super.wasRemoved();
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._action = ((IntervalAction)source)._action;
        }
    }

    public static class Loop
    extends Compound {
        @Override
        public boolean execute(int timestamp, Logic activator) {
            boolean success = false;
            int i = 0;
            while (i < ((ActionConfig.Loop)this._config).times) {
                success = super.execute(timestamp, activator);
                if (((ActionConfig.Loop)this._config).stopOnFailure && !success) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    public static class LoopWithDelayed
    extends Compound {
        protected List<Interval> _intervals = Lists.newArrayList();
        private boolean _cascadingSuccess = true;

        @Override
        public boolean execute(int timestamp, final Logic activator) {
            final ActionConfig.LoopWithDelayed config = (ActionConfig.LoopWithDelayed)this._config;
            Interval interval = new Interval(this._scenemgr){
                int _limit;
                private int _current;
                {
                    super($anonymous0);
                    this._limit = loopWithDelayed2.limit == 0 ? Integer.MAX_VALUE : loopWithDelayed2.limit;
                    this._current = 0;
                }

                public void expired() {
                    boolean success = true;
                    success = config.type == ActionConfig.LoopType.COMPOUND ? LoopWithDelayed.super.execute(LoopWithDelayed.this._scenemgr.getTimestamp(), activator) : LoopWithDelayed.this.executeCascading(LoopWithDelayed.this._scenemgr.getTimestamp(), activator, this._current++);
                    if (--this._limit > 0 && LoopWithDelayed.this._intervals != null && (!config.stopOnFailure || success)) {
                        this.schedule(config.interval);
                    }
                }
            };
            this._intervals.add(interval);
            interval.schedule((long)config.deplay);
            return true;
        }

        @Override
        protected void wasRemoved() {
            int ii = 0;
            int nn = this._intervals.size();
            while (ii < nn) {
                this._intervals.get(ii).cancel();
                ++ii;
            }
            this._intervals.clear();
            super.wasRemoved();
        }

        public boolean executeCascading(int timestamp, Logic activator, int current) {
            if (current >= this._actions.length || ((ActionConfig.Compound)this._config).stopOnFailure && !this._cascadingSuccess) {
                return false;
            }
            this._cascadingSuccess = this._actions[current].execute(timestamp, activator) | this._cascadingSuccess;
            return this._cascadingSuccess;
        }
    }

    public static class ModifySpeed
    extends Targeted {
        @Override
        public boolean execute(int timestamp, Logic activator) {
            ActionConfig.ModifySpeed config = (ActionConfig.ModifySpeed)this._config;
            boolean success = false;
            this._target.resolve(activator, this._targets);
            int ii = 0;
            int nn = this._targets.size();
            while (ii < nn) {
                Logic target = (Logic)this._targets.get(ii);
                if (target instanceof AgentLogic) {
                    ((AgentLogic)target).setSpeed(config.speed);
                    success = true;
                }
                ++ii;
            }
            return success;
        }

        @Override
        protected void wasRemoved() {
            super.wasRemoved();
            int ii = 0;
            int nn = this._targets.size();
            while (ii < nn) {
                Logic target = (Logic)this._targets.get(ii);
                if (target instanceof AgentLogic) {
                    ((AgentLogic)target).clearSpeed();
                }
                ++ii;
            }
            this._targets.clear();
        }

        @Override
        protected void didInit() {
            ActionConfig.ModifySpeed config = (ActionConfig.ModifySpeed)this._config;
            this._target = this.createTarget(config.target, this._source);
        }
    }

    public static class MoveAll
    extends AbstractMove {
        @Override
        public boolean execute(int timestamp, Logic activator) {
            OidList occupants = this._scenemgr.getPlaceObject().occupants;
            int ii = 0;
            int nn = occupants.size();
            while (ii < nn) {
                this.moveBody(occupants.get(ii));
                ++ii;
            }
            return true;
        }
    }

    public static class MoveBody
    extends AbstractMove {
        protected TargetLogic _target;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            boolean success = false;
            this._target.resolve(activator, this._targets);
            int ii = 0;
            int nn = this._targets.size();
            while (ii < nn) {
                Logic target = (Logic)this._targets.get(ii);
                if (target instanceof PawnLogic) {
                    int pawnId = ((PawnLogic)target).getActor().getId();
                    TudeyOccupantInfo info = ((TudeySceneObject)this._scenemgr.getPlaceObject()).getOccupantInfo(pawnId);
                    if (info != null) {
                        this.moveBody(info.getBodyOid());
                        success = true;
                    }
                }
                ++ii;
            }
            if (!success && activator instanceof PawnLogic) {
                int pawnId = ((PawnLogic)activator).getActor().getId();
                TudeyOccupantInfo info = ((TudeySceneObject)this._scenemgr.getPlaceObject()).getOccupantInfo(pawnId);
                if (info != null) {
                    this.moveBody(info.getBodyOid());
                    success = true;
                }
            }
            this._targets.clear();
            return success;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._target.transfer(((MoveBody)source)._target, refs);
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ActionConfig.MoveBody)this._config).target, this._source);
        }
    }

    public static class None
    extends ActionLogic {
        @Override
        public boolean execute(int timestamp, Logic activator) {
            return true;
        }
    }

    public static class Random
    extends ActionLogic {
        protected float[] _weights;
        protected ActionLogic[] _actions;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            int idx = RandomUtil.getWeightedIndex((float[])this._weights);
            if (idx >= 0) {
                return this._actions[idx].execute(timestamp, activator);
            }
            return true;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            ActionLogic[] sactions = ((Random)source)._actions;
            int ii = 0;
            while (ii < this._actions.length) {
                this._actions[ii].transfer(sactions[ii], refs);
                ++ii;
            }
        }

        @Override
        protected void didInit() {
            ActionConfig.WeightedAction[] wactions = ((ActionConfig.Random)this._config).actions;
            this._weights = new float[wactions.length];
            this._actions = new ActionLogic[wactions.length];
            int ii = 0;
            while (ii < this._actions.length) {
                ActionConfig.WeightedAction waction = wactions[ii];
                this._weights[ii] = waction.weight;
                this._actions[ii] = this.createAction(waction.action, this._source);
                ++ii;
            }
        }

        @Override
        protected void wasRemoved() {
            ActionLogic[] actionLogicArray = this._actions;
            int n = this._actions.length;
            int n2 = 0;
            while (n2 < n) {
                ActionLogic action = actionLogicArray[n2];
                action.removed();
                ++n2;
            }
        }
    }

    public static class RemoveEntry
    extends Targeted {
        @Override
        public boolean execute(int timestamp, Logic activator) {
            boolean success = false;
            this._target.resolve(activator, this._targets);
            int ii = 0;
            int nn = this._targets.size();
            while (ii < nn) {
                Logic target = (Logic)this._targets.get(ii);
                if (target instanceof EntryLogic) {
                    EntryLogic logic = (EntryLogic)target;
                    logic.getSceneManager().entryRemoved(logic.getEntry());
                    success = true;
                }
                ++ii;
            }
            this._targets.clear();
            return success;
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ActionConfig.RemoveEntry)this._config).target, this._source);
        }
    }

    public static class RotateActor
    extends Targeted {
        @Override
        public boolean execute(int timestamp, Logic activator) {
            boolean success = false;
            this._target.resolve(activator, this._targets);
            int ii = 0;
            int nn = this._targets.size();
            while (ii < nn) {
                Logic target = (Logic)this._targets.get(ii);
                if (target instanceof ActorLogic) {
                    ActorLogic logic = (ActorLogic)target;
                    Actor actor = logic.getActor();
                    Vector2f translation = actor.getTranslation();
                    float rotation = ((ActionConfig.RotateActor)this._config).rotation.getValue();
                    logic.move(translation.x, translation.y, FloatMath.normalizeAngle(actor.getRotation() + rotation));
                    if (actor instanceof Mobile) {
                        Mobile mobile = (Mobile)actor;
                        mobile.setDirection(FloatMath.normalizeAngle(mobile.getDirection() + rotation));
                    }
                    success = true;
                }
                ++ii;
            }
            this._targets.clear();
            return success;
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ActionConfig.RotateActor)this._config).target, this._source);
        }
    }

    public static class ServerLog
    extends ActionLogic {
        @Override
        public boolean execute(int timestamp, Logic activator) {
            ActionConfig.ServerLog config = (ActionConfig.ServerLog)this._config;
            switch (config.level) {
                case DEBUG: {
                    Log.log.debug((Object)config.message, new Object[0]);
                    break;
                }
                case INFO: {
                    Log.log.info((Object)config.message, new Object[0]);
                    break;
                }
                case WARN: {
                    Log.log.warning((Object)config.message, new Object[0]);
                    break;
                }
                case ERROR: {
                    Log.log.error((Object)config.message, new Object[0]);
                }
            }
            return true;
        }
    }

    public static class SetFlag
    extends Targeted {
        @Override
        public boolean execute(int timestamp, Logic activator) {
            ActionConfig.SetFlag config = (ActionConfig.SetFlag)this._config;
            this._target.resolve(activator, this._targets);
            boolean ret = false;
            int ii = 0;
            int nn = this._targets.size();
            while (ii < nn) {
                Logic target = (Logic)this._targets.get(ii);
                try {
                    Field flag2;
                    if (target instanceof ActorLogic) {
                        Actor actor = ((ActorLogic)target).getActor();
                        try {
                            flag2 = actor.getClass().getField(config.flag);
                            actor.set(flag2.getInt(actor), config.on);
                            ret = true;
                        }
                        catch (NoSuchFieldException flag2) {
                        }
                        catch (IllegalAccessException e) {
                            Log.log.warning((Object)"Cannot access flag field for Set Flag Action.", new Object[]{e});
                        }
                    } else if (target instanceof EntryLogic) {
                        TudeySceneModel.Entry entry = ((EntryLogic)target)._entry;
                        try {
                            flag2 = entry.getClass().getField(config.flag);
                            entry.set(flag2.getInt(entry), config.on);
                            ret = true;
                        }
                        catch (NoSuchFieldException flag3) {
                        }
                        catch (IllegalAccessException e) {
                            Log.log.warning((Object)"Cannot access flag field for Set Flag Action.", new Object[]{e});
                        }
                    }
                }
                finally {
                    if (ret) {
                        target.signal(timestamp, target, "set_flag");
                    }
                }
                ++ii;
            }
            this._targets.clear();
            return ret;
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ActionConfig.SetFlag)this._config).target, this._source);
        }
    }

    public static class SetVariable
    extends Targeted {
        protected ExpressionLogic _value;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            String name = ((ActionConfig.SetVariable)this._config).name;
            this._target.resolve(activator, this._targets);
            int ii = 0;
            int nn = this._targets.size();
            while (ii < nn) {
                Logic target = (Logic)this._targets.get(ii);
                target.setVariable(timestamp, this._source, name, this._value.evaluate(activator, target.getVariable(name)));
                ++ii;
            }
            this._targets.clear();
            return true;
        }

        @Override
        protected void didInit() {
            ActionConfig.SetVariable config = (ActionConfig.SetVariable)this._config;
            this._target = this.createTarget(config.target, this._source);
            this._value = this.createExpression(config.value, this._source);
        }
    }

    public static class Signal
    extends Targeted {
        @Override
        public boolean execute(int timestamp, Logic activator) {
            String name = ((ActionConfig.Signal)this._config).name;
            if (StringUtil.isBlank((String)name)) {
                return true;
            }
            this._target.resolve(activator, this._targets);
            int ii = 0;
            int nn = this._targets.size();
            while (ii < nn) {
                ((Logic)this._targets.get(ii)).signal(timestamp, this._source, name);
                ++ii;
            }
            this._targets.clear();
            return true;
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ActionConfig.Signal)this._config).target, this._source);
        }
    }

    public static class SpawnActor
    extends ActionLogic {
        protected TargetLogic _location;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            ConfigReference<ActorConfig> actor = this.getActorConfig(activator);
            if (actor == null) {
                return true;
            }
            this._location.resolve(activator, this._targets);
            boolean success = false;
            int ii = 0;
            int nn = this._targets.size();
            while (ii < nn) {
                Logic target = (Logic)this._targets.get(ii);
                success = this.spawnActor(timestamp, actor, this.getTranslation(target), this.getRotation(target), activator) | success;
                ++ii;
            }
            this._targets.clear();
            return success;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._location.transfer(((SpawnActor)source)._location, refs);
        }

        @Override
        protected void didInit() {
            this._location = this.createTarget(((ActionConfig.SpawnActor)this._config).location, this._source);
        }

        public ConfigReference<ActorConfig> getActorConfig(Logic activator) {
            return ((ActionConfig.SpawnActor)this._config).actor;
        }

        protected boolean spawnActor(int timestamp, ConfigReference<ActorConfig> actor, Vector2f translation, float rotation, Logic activator) {
            ActorLogic logic = this._scenemgr.spawnActor(timestamp, translation, rotation, actor, this._source, activator);
            this.initLogic(logic, activator);
            return true;
        }

        protected void initLogic(ActorLogic logic, Logic activator) {
            if (logic != null) {
                logic.setSource(this._source);
                logic.setActivator(activator);
                logic.afterInit();
            }
        }

        protected float getRotation(Logic target) {
            return target.getRotation();
        }

        protected Vector2f getTranslation(Logic target) {
            return target.getTranslation();
        }
    }

    public static class SpawnFacingActor
    extends SpawnActor {
        protected ArrayList<Logic> _faces = Lists.newArrayList();
        protected TargetLogic _facing;

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._facing.transfer(((SpawnFacingActor)source)._facing, refs);
        }

        @Override
        protected boolean spawnActor(int timestamp, ConfigReference<ActorConfig> actor, Vector2f translation, float rotation, Logic activator) {
            this._facing.resolve(activator, this._faces);
            boolean result = super.spawnActor(timestamp, actor, translation, rotation, activator);
            this._faces.clear();
            return result;
        }

        @Override
        protected void didInit() {
            super.didInit();
            this._facing = this.createTarget(((ActionConfig.SpawnFacingActor)this._config).facing, this._source);
        }

        @Override
        protected float getRotation(Logic target) {
            if (this._faces.size() > 0) {
                Logic face = this._faces.get(0);
                return target.getTranslation().direction(face.getTranslation());
            }
            return super.getRotation(target);
        }
    }

    public static class SpawnLimitedActor
    extends SpawnRandomTranslatedActor {
        HandlerLogic handler = new HandlerLogic(){

            @Override
            protected void wasRemoved() {
                SpawnLimitedActor spawnLimitedActor = SpawnLimitedActor.this;
                spawnLimitedActor.current = spawnLimitedActor.current - 1;
            }
        };
        private int current = 0;

        @Override
        protected void initLogic(ActorLogic logic, Logic activator) {
            super.initLogic(logic, activator);
            if (logic != null) {
                logic._handlers = Arrays.copyOf(logic._handlers, logic._handlers.length + 1);
                logic._handlers[logic._handlers.length - 1] = this.handler;
                ++this.current;
                if (logic instanceof ActiveLogic) {
                    ActionConfig.SpawnLimitedActor config = (ActionConfig.SpawnLimitedActor)this._config;
                    if (config.activate && logic instanceof ActiveLogic) {
                        ((ActiveLogic)logic).activate(this._scenemgr.getTimestamp());
                    }
                }
            }
        }

        @Override
        public boolean execute(int timestamp, Logic activator) {
            ActionConfig.SpawnLimitedActor config = (ActionConfig.SpawnLimitedActor)this._config;
            if (this.current >= config.limit) {
                return true;
            }
            ConfigReference<ActorConfig> actor = this.getActorConfig(activator);
            if (actor == null) {
                return true;
            }
            this._location.resolve(activator, this._targets);
            boolean success = false;
            int ii = 0;
            int nn = this._targets.size();
            while (ii < nn) {
                Logic target = (Logic)this._targets.get(ii);
                success = this.spawnActor(timestamp, actor, target.getTranslation(), target.getRotation(), activator) | success;
                if (this.current >= config.limit) break;
                ++ii;
            }
            this._targets.clear();
            return success;
        }
    }

    public static class SpawnRandomTranslatedActor
    extends SpawnActor {
        protected TargetLogic _cs;
        protected static final int COLLISION_ATTEMPTS = 3;

        @Override
        protected boolean spawnActor(int timestamp, ConfigReference<ActorConfig> actor, Vector2f targetTranslation, float rotation, Logic activator) {
            ActionConfig.SpawnRandomTranslatedActor config = (ActionConfig.SpawnRandomTranslatedActor)this._config;
            HashSet locations = Sets.newHashSet();
            int steps = config.steps;
            boolean success = false;
            Vector2f translation = null;
            if (config.collisionMask != 0) {
                ArrayList cTargets = Lists.newArrayList();
                this._cs.resolve(activator, cTargets);
                if (cTargets.size() > 0) {
                    translation = this.getTranslation((Logic)cTargets.get(0));
                }
            }
            int ii = 0;
            while (ii < config.count) {
                int jj = 0;
                while (jj < 3) {
                    Vector2f location = targetTranslation.add((float)RandomUtil.getInRange((int)(-steps), (int)(steps + 1)) * config.stepSize, (float)RandomUtil.getInRange((int)(-steps), (int)(steps + 1)) * config.stepSize);
                    if (locations.add(location) && (translation == null || !this._scenemgr.collides(config.collisionMask, (Shape)new Segment(translation, location)))) {
                        super.spawnActor(timestamp, actor, location, rotation, activator);
                        success = true;
                        break;
                    }
                    ++jj;
                }
                ++ii;
            }
            return success;
        }

        @Override
        protected void didInit() {
            super.didInit();
            this._cs = this.createTarget(((ActionConfig.SpawnRandomTranslatedActor)this._config).collisionSource, this._source);
        }
    }

    public static class SpawnRotatedActor
    extends SpawnActor {
        @Override
        protected float getRotation(Logic target) {
            ActionConfig.SpawnRotatedActor config = (ActionConfig.SpawnRotatedActor)this._config;
            float rotation = config.rotation;
            if (config.rotationVariance > 0.0f) {
                rotation += config.rotationVariance * (FloatMath.random() - 0.5f);
            }
            return FloatMath.normalizeAngle((config.relative ? target.getRotation() : 0.0f) + rotation);
        }
    }

    public static class SpawnTransformedActor
    extends SpawnRotatedActor {
        @Override
        protected Vector2f getTranslation(Logic target) {
            return ((ActionConfig.SpawnTransformedActor)this._config).translation.rotateAndAdd(target.getRotation(), target.getTranslation(), new Vector2f());
        }
    }

    public static class Switch
    extends ActionLogic {
        protected ConditionLogic[] _conditions;
        protected ActionLogic[] _actions;
        protected ActionLogic _defaultAction;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            int ii = 0;
            while (ii < this._conditions.length) {
                if (this._conditions[ii].isSatisfied(activator)) {
                    return this._actions[ii].execute(timestamp, activator);
                }
                ++ii;
            }
            if (this._defaultAction != null) {
                return this._defaultAction.execute(timestamp, activator);
            }
            return true;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            Switch ssource = (Switch)source;
            int ii = 0;
            while (ii < this._conditions.length) {
                this._conditions[ii].transfer(ssource._conditions[ii], refs);
                this._actions[ii].transfer(ssource._actions[ii], refs);
                ++ii;
            }
            if (this._defaultAction != null) {
                this._defaultAction.transfer(ssource._defaultAction, refs);
            }
        }

        @Override
        protected void didInit() {
            ActionConfig.Switch config = (ActionConfig.Switch)this._config;
            this._conditions = new ConditionLogic[config.cases.length];
            this._actions = new ActionLogic[config.cases.length];
            int ii = 0;
            while (ii < config.cases.length) {
                this._conditions[ii] = this.createCondition(config.cases[ii].condition, this._source);
                this._actions[ii] = this.createAction(config.cases[ii].action, this._source);
                ++ii;
            }
            if (config.defaultAction != null) {
                this._defaultAction = this.createAction(config.defaultAction, this._source);
            }
        }

        @Override
        protected void wasRemoved() {
            ActionLogic[] actionLogicArray = this._actions;
            int n = this._actions.length;
            int n2 = 0;
            while (n2 < n) {
                ActionLogic action = actionLogicArray[n2];
                action.removed();
                ++n2;
            }
            if (this._defaultAction != null) {
                this._defaultAction.removed();
            }
        }
    }

    public static abstract class Targeted
    extends ActionLogic {
        protected TargetLogic _target;

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._target.transfer(((Targeted)source)._target, refs);
        }
    }

    public static class TargetedAction
    extends Targeted {
        protected ActionLogic _action;

        @Override
        public boolean execute(int timestamp, Logic activator) {
            this._target.resolve(activator, this._targets);
            int ii = 0;
            int nn = this._targets.size();
            while (ii < nn) {
                this._action.execute(timestamp, (Logic)this._targets.get(ii));
                ++ii;
            }
            this._targets.clear();
            return true;
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ActionConfig.TargetedAction)this._config).target, this._source);
            this._action = this.createAction(((ActionConfig.TargetedAction)this._config).action, this._source);
        }

        @Override
        protected void wasRemoved() {
            this._action.removed();
        }
    }

    public static class WarpActor
    extends Targeted {
        protected TargetLogic _location;
        protected ArrayList<Logic> _locations = Lists.newArrayList();

        @Override
        public boolean execute(int timestamp, Logic activator) {
            boolean success = false;
            this._target.resolve(activator, this._targets);
            int ii = 0;
            int nn = this._targets.size();
            while (ii < nn) {
                Logic target = (Logic)this._targets.get(ii);
                if (target instanceof ActorLogic) {
                    this._location.resolve(activator, this._locations);
                    if (!this._locations.isEmpty()) {
                        Logic location = (Logic)RandomUtil.pickRandom(this._locations);
                        this._locations.clear();
                        this.warp((ActorLogic)target, location);
                        success = true;
                    }
                }
                ++ii;
            }
            this._targets.clear();
            return success;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._location.transfer(((WarpActor)source)._location, refs);
        }

        protected void warp(ActorLogic target, Logic location) {
            Vector2f translation = location.getTranslation();
            target.warp(translation.x, translation.y, location.getRotation(), translation.x, translation.y, true, ((ActionConfig.WarpActor)this._config).maxWarpPath);
        }

        @Override
        protected void didInit() {
            ActionConfig.WarpActor config = (ActionConfig.WarpActor)this._config;
            this._target = this.createTarget(config.target, this._source);
            this._location = this.createTarget(config.location, this._source);
        }
    }

    public static class WarpTransformedActor
    extends WarpActor {
        @Override
        protected void warp(ActorLogic target, Logic location) {
            ActionConfig.WarpTransformedActor config = (ActionConfig.WarpTransformedActor)this._config;
            float rotation = config.rotation + location.getRotation();
            Vector2f translation = new Vector2f();
            Vector2f ltrans = location.getTranslation();
            if (config.rotatedTranslation) {
                config.translation.rotateAndAdd(rotation, ltrans, translation);
            } else {
                translation.addLocal(ltrans);
            }
            target.warp(translation.x, translation.y, rotation, ltrans.x, ltrans.y, true, config.maxWarpPath);
        }
    }

    public static class ZoneMove
    extends MoveBody {
        @Inject
        protected TudeyZoneRegistry _zonereg;
        protected TargetLogic _target;

        @Override
        protected void moveBody(int bodyOid) {
            ZonedBodyObject body = (ZonedBodyObject)this._omgr.getObject(bodyOid);
            ActionConfig.ZoneMove mconfig = (ActionConfig.ZoneMove)this._config;
            if (mconfig.sceneId == 0 || mconfig.zone.getQualifyZoneId() == 0) {
                return;
            }
            if (mconfig.zone.getQualifyZoneId() < 0) {
                this._zonereg.moveBody(body, body.getZoneId(), mconfig.sceneId, mconfig.portal.getKey());
            } else {
                this._zonereg.moveBody(body, mconfig.zone.getQualifyZoneId(), mconfig.sceneId, mconfig.portal.getKey());
            }
        }
    }
}

