/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.samskivert.util.RunAnywhere;
import com.threerings.opengl.gui.Cursor;
import com.threerings.opengl.gui.Log;
import com.threerings.opengl.gui.Root;
import com.threerings.opengl.gui.event.ControllerEvent;
import com.threerings.opengl.gui.event.KeyEvent;
import com.threerings.opengl.util.GlContext;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.Iterator;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Controller;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

public class DisplayRoot
extends Root {
    protected Point _forcedMouse;
    protected boolean _wasActive;
    protected boolean _imeComposingEnabled;
    protected static final int MAC_OS_MENUBAR_HEIGHT = 22;
    private static final boolean NAIVE_FOCUS = false;

    public DisplayRoot(GlContext ctx) {
        super(ctx);
        this._clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public void poll() {
        boolean isActive = Display.isActive();
        boolean newActive = !this._wasActive && isActive;
        this._wasActive = isActive;
        if (newActive && RunAnywhere.isMacOS()) {
            Point p = MouseInfo.getPointerInfo().getLocation();
            p.x -= Display.getX();
            p.y = 22 + Display.getHeight() - (p.y - Display.getY());
            this.mouseMoved(this._tickStamp, p.x, p.y, false);
            this._forcedMouse = p;
        }
        while (Mouse.next()) {
            int button = Mouse.getEventButton();
            int delta = Mouse.getEventDWheel();
            int eventX = Mouse.getEventX();
            int eventY = Mouse.getEventY();
            if (button != -1 || delta != 0) {
                if (this._forcedMouse != null) {
                    eventX = this._forcedMouse.x;
                    eventY = this._forcedMouse.y;
                }
                if (button != -1) {
                    boolean pressed = Mouse.getEventButtonState();
                    if (pressed && !newActive) {
                        this.mousePressed(this._tickStamp, button, eventX, eventY, false);
                    } else {
                        this.mouseReleased(this._tickStamp, button, eventX, eventY, false);
                    }
                    this.updateButtonModifier(button, pressed);
                }
                if (delta == 0) continue;
                this.mouseWheeled(this._tickStamp, eventX, eventY, delta > 0 ? 1 : -1, false);
                continue;
            }
            if (!isActive) continue;
            this.mouseMoved(this._tickStamp, eventX, eventY, false);
            this._forcedMouse = null;
        }
        while (Keyboard.next()) {
            int key = Keyboard.getEventKey();
            boolean pressed = Keyboard.getEventKeyState();
            if (pressed) {
                this.keyPressed(this._tickStamp, Keyboard.getEventCharacter(), key, false);
            } else {
                this.keyReleased(this._tickStamp, Keyboard.getEventCharacter(), key, false);
            }
            this.updateKeyModifier(key, pressed);
        }
        if (isActive) {
            if (!this._pressedKeys.isEmpty()) {
                Iterator it = this._pressedKeys.values().iterator();
                while (it.hasNext()) {
                    Root.KeyRecord record = (Root.KeyRecord)it.next();
                    KeyEvent press = record.getPress();
                    int key = press.getKeyCode();
                    if (Keyboard.isKeyDown((int)key)) continue;
                    this.dispatchEvent(this.getFocus(), new KeyEvent(this, this._tickStamp, this._modifiers, 1, press.getKeyChar(), key, false));
                    this.updateKeyModifier(key, false);
                    it.remove();
                }
            }
        } else {
            if (!this._pressedKeys.isEmpty()) {
                for (Root.KeyRecord record : this._pressedKeys.values()) {
                    KeyEvent press = record.getPress();
                    this.dispatchEvent(this.getFocus(), new KeyEvent(this, this._tickStamp, this._modifiers, 1, press.getKeyChar(), press.getKeyCode(), false));
                }
                this._pressedKeys.clear();
            }
            this._modifiers = 0;
        }
        while (Controllers.next()) {
            if (!isActive) continue;
            Controller controller = Controllers.getEventSource();
            if (Controllers.isEventButton()) {
                int index = Controllers.getEventControlIndex();
                if (controller.isButtonPressed(index)) {
                    this.controllerPressed(controller, this._tickStamp, index);
                    continue;
                }
                this.controllerReleased(controller, this._tickStamp, index);
                continue;
            }
            if (Controllers.isEventAxis()) {
                int index = Controllers.getEventControlIndex();
                this.controllerMoved(controller, this._tickStamp, index, Controllers.isEventXAxis(), Controllers.isEventYAxis(), controller.getAxisValue(index));
                continue;
            }
            if (Controllers.isEventPovX()) {
                this.controllerPovXMoved(controller, this._tickStamp, controller.getPovX());
                continue;
            }
            if (!Controllers.isEventPovY()) continue;
            this.controllerPovYMoved(controller, this._tickStamp, controller.getPovY());
        }
    }

    @Override
    public int getDisplayWidth() {
        return this._ctx.getRenderer().getWidth();
    }

    @Override
    public int getDisplayHeight() {
        return this._ctx.getRenderer().getHeight();
    }

    @Override
    public void setMousePosition(int x, int y) {
        Mouse.setCursorPosition((int)x, (int)y);
        super.setMousePosition(x, y);
    }

    @Override
    protected void updateCursor(Cursor cursor) {
        if (cursor == null) {
            cursor = this.getDefaultCursor();
        }
        try {
            Mouse.setNativeCursor((org.lwjgl.input.Cursor)(cursor == null ? null : cursor.getLWJGLCursor()));
        }
        catch (LWJGLException e) {
            Log.log.warning((Object)"Failed to set cursor.", new Object[]{"cursor", cursor, e});
        }
    }

    protected void updateButtonModifier(int button, boolean pressed) {
        int mask;
        switch (button) {
            case 0: {
                mask = 1;
                break;
            }
            case 1: {
                mask = 2;
                break;
            }
            case 2: {
                mask = 4;
                break;
            }
            default: {
                return;
            }
        }
        this._modifiers = pressed ? (this._modifiers |= mask) : (this._modifiers &= ~mask);
    }

    protected void updateKeyModifier(int key, boolean pressed) {
        int okey;
        int mask;
        switch (key) {
            case 42: 
            case 54: {
                mask = 8;
                okey = key == 42 ? 54 : 42;
                break;
            }
            case 29: 
            case 157: {
                mask = 16;
                okey = key == 29 ? 157 : 29;
                break;
            }
            case 56: 
            case 184: {
                mask = 32;
                okey = key == 56 ? 184 : 56;
                break;
            }
            case 219: 
            case 220: {
                mask = 64;
                okey = key == 219 ? 220 : 219;
                break;
            }
            default: {
                return;
            }
        }
        this._modifiers = pressed || this._pressedKeys.containsKey(okey) ? (this._modifiers |= mask) : (this._modifiers &= ~mask);
    }

    protected void controllerPressed(Controller controller, long when, int index) {
        ControllerEvent event = new ControllerEvent(controller, when, this._modifiers, 0, index);
        this.dispatchEvent(this.getFocus(), event);
    }

    protected void controllerReleased(Controller controller, long when, int index) {
        ControllerEvent event = new ControllerEvent(controller, when, this._modifiers, 1, index);
        this.dispatchEvent(this.getFocus(), event);
    }

    protected void controllerMoved(Controller controller, long when, int index, boolean xAxis, boolean yAxis, float value) {
        ControllerEvent event = new ControllerEvent(controller, when, this._modifiers, 2, index, xAxis, yAxis, value);
        this.dispatchEvent(this.getFocus(), event);
    }

    protected void controllerPovXMoved(Controller controller, long when, float value) {
        ControllerEvent event = new ControllerEvent(controller, when, this._modifiers, 3, value);
        this.dispatchEvent(this.getFocus(), event);
    }

    protected void controllerPovYMoved(Controller controller, long when, float value) {
        ControllerEvent event = new ControllerEvent(controller, when, this._modifiers, 4, value);
        this.dispatchEvent(this.getFocus(), event);
    }
}

