/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.geometry.config;

import com.samskivert.util.ListUtil;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.math.Matrix4f;
import com.threerings.math.Vector3f;
import com.threerings.opengl.geometry.DynamicGeometry;
import com.threerings.opengl.geometry.Geometry;
import com.threerings.opengl.geometry.config.GeometryConfig;
import com.threerings.opengl.geometry.config.PassDescriptor;
import com.threerings.opengl.geometry.config.PassSummary;
import com.threerings.opengl.renderer.BufferObject;
import com.threerings.opengl.renderer.ClientArray;
import com.threerings.opengl.renderer.SimpleBatch;
import com.threerings.opengl.renderer.config.ClientArrayConfig;
import com.threerings.opengl.renderer.config.CoordSpace;
import com.threerings.opengl.renderer.state.ArrayState;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GLContext;

@EditorTypes(value={Skin.class})
public abstract class DeformerConfig
extends DeepObject
implements Exportable {
    public abstract Geometry createGeometry(GlContext var1, Scope var2, GeometryConfig.Stored var3, PassDescriptor[] var4);

    protected static void skinVertices(float[] source, float[] dest, Matrix4f[] boneMatrices, int[] boneIndices, float[] boneWeights, int tidx, int nidx, int vidx, int dinc) {
        int sidx = 0;
        int bidx = 0;
        while (sidx < source.length) {
            float stx = source[sidx++];
            float sty = source[sidx++];
            float stz = source[sidx++];
            float snx = source[sidx++];
            float sny = source[sidx++];
            float snz = source[sidx++];
            float svx = source[sidx++];
            float svy = source[sidx++];
            float svz = source[sidx++];
            float dtx = 0.0f;
            float dty = 0.0f;
            float dtz = 0.0f;
            float dnx = 0.0f;
            float dny = 0.0f;
            float dnz = 0.0f;
            float dvx = 0.0f;
            float dvy = 0.0f;
            float dvz = 0.0f;
            int ii = 0;
            while (ii < 4) {
                Matrix4f m = boneMatrices[boneIndices[bidx]];
                float weight = boneWeights[bidx++];
                float m00 = m.m00;
                float m10 = m.m10;
                float m20 = m.m20;
                float m01 = m.m01;
                float m11 = m.m11;
                float m21 = m.m21;
                float m02 = m.m02;
                float m12 = m.m12;
                float m22 = m.m22;
                dtx += (m00 * stx + m10 * sty + m20 * stz) * weight;
                dty += (m01 * stx + m11 * sty + m21 * stz) * weight;
                dtz += (m02 * stx + m12 * sty + m22 * stz) * weight;
                dnx += (m00 * snx + m10 * sny + m20 * snz) * weight;
                dny += (m01 * snx + m11 * sny + m21 * snz) * weight;
                dnz += (m02 * snx + m12 * sny + m22 * snz) * weight;
                dvx += (m00 * svx + m10 * svy + m20 * svz + m.m30) * weight;
                dvy += (m01 * svx + m11 * svy + m21 * svz + m.m31) * weight;
                dvz += (m02 * svx + m12 * svy + m22 * svz + m.m32) * weight;
                ++ii;
            }
            dest[tidx] = dtx;
            dest[tidx + 1] = dty;
            dest[tidx + 2] = dtz;
            tidx += dinc;
            dest[nidx] = dnx;
            dest[nidx + 1] = dny;
            dest[nidx + 2] = dnz;
            nidx += dinc;
            dest[vidx] = dvx;
            dest[vidx + 1] = dvy;
            dest[vidx + 2] = dvz;
            vidx += dinc;
        }
    }

    protected static void skinVertices(float[] source, float[] dest, Matrix4f[] boneMatrices, int[] boneIndices, float[] boneWeights, int nidx, int vidx, int dinc) {
        int sidx = 0;
        int bidx = 0;
        while (sidx < source.length) {
            float snx = source[sidx++];
            float sny = source[sidx++];
            float snz = source[sidx++];
            float svx = source[sidx++];
            float svy = source[sidx++];
            float svz = source[sidx++];
            float dnx = 0.0f;
            float dny = 0.0f;
            float dnz = 0.0f;
            float dvx = 0.0f;
            float dvy = 0.0f;
            float dvz = 0.0f;
            int ii = 0;
            while (ii < 4) {
                Matrix4f m = boneMatrices[boneIndices[bidx]];
                float weight = boneWeights[bidx++];
                float m00 = m.m00;
                float m10 = m.m10;
                float m20 = m.m20;
                float m01 = m.m01;
                float m11 = m.m11;
                float m21 = m.m21;
                float m02 = m.m02;
                float m12 = m.m12;
                float m22 = m.m22;
                dnx += (m00 * snx + m10 * sny + m20 * snz) * weight;
                dny += (m01 * snx + m11 * sny + m21 * snz) * weight;
                dnz += (m02 * snx + m12 * sny + m22 * snz) * weight;
                dvx += (m00 * svx + m10 * svy + m20 * svz + m.m30) * weight;
                dvy += (m01 * svx + m11 * svy + m21 * svz + m.m31) * weight;
                dvz += (m02 * svx + m12 * svy + m22 * svz + m.m32) * weight;
                ++ii;
            }
            dest[nidx] = dnx;
            dest[nidx + 1] = dny;
            dest[nidx + 2] = dnz;
            nidx += dinc;
            dest[vidx] = dvx;
            dest[vidx + 1] = dvy;
            dest[vidx + 2] = dvz;
            vidx += dinc;
        }
    }

    protected static void skinVertices(float[] source, float[] dest, Matrix4f[] boneMatrices, int[] boneIndices, float[] boneWeights, int vidx, int dinc) {
        int sidx = 0;
        int bidx = 0;
        while (sidx < source.length) {
            float svx = source[sidx++];
            float svy = source[sidx++];
            float svz = source[sidx++];
            float dvx = 0.0f;
            float dvy = 0.0f;
            float dvz = 0.0f;
            int ii = 0;
            while (ii < 4) {
                Matrix4f m = boneMatrices[boneIndices[bidx]];
                float weight = boneWeights[bidx++];
                dvx += (m.m00 * svx + m.m10 * svy + m.m20 * svz + m.m30) * weight;
                dvy += (m.m01 * svx + m.m11 * svy + m.m21 * svz + m.m31) * weight;
                dvz += (m.m02 * svx + m.m12 * svy + m.m22 * svz + m.m32) * weight;
                ++ii;
            }
            dest[vidx] = dvx;
            dest[vidx + 1] = dvy;
            dest[vidx + 2] = dvz;
            vidx += dinc;
        }
    }

    public static class Skin
    extends DeformerConfig {
        @Override
        public Geometry createGeometry(GlContext ctx, Scope scope, GeometryConfig.Stored config, PassDescriptor[] passes) {
            boolean normals;
            boolean tangents;
            final Matrix4f[] boneMatrices = config.getBoneMatrices(scope);
            GeometryConfig.AttributeArrayConfig boneIndexArray = config.getVertexAttribArray("boneIndices");
            GeometryConfig.AttributeArrayConfig boneWeightArray = config.getVertexAttribArray("boneWeights");
            if (boneMatrices == null || boneIndexArray == null || boneWeightArray == null) {
                return config.createStaticGeometry(ctx, scope, passes);
            }
            final int[] boneIndices = config.getIntArray(false, boneIndexArray);
            final float[] boneWeights = config.getFloatArray(false, boneWeightArray);
            PassSummary summary = new PassSummary(passes);
            ArrayList<ClientArrayConfig> sourceArrays = new ArrayList<ClientArrayConfig>();
            GeometryConfig.AttributeArrayConfig tangentArray = summary.vertexAttribs.contains("tangents") ? config.getVertexAttribArray("tangents") : null;
            boolean bl = tangents = tangentArray != null;
            if (tangents) {
                sourceArrays.add(tangentArray);
            }
            boolean bl2 = normals = summary.normals && config.normalArray != null;
            if (normals) {
                sourceArrays.add(config.normalArray);
            }
            sourceArrays.add(config.vertexArray);
            final float[] source = config.getFloatArray(false, sourceArrays.toArray(new ClientArrayConfig[sourceArrays.size()]));
            ArrayList<ClientArrayConfig> destArrays = new ArrayList<ClientArrayConfig>();
            for (String attrib : summary.vertexAttribs) {
                GeometryConfig.AttributeArrayConfig vertexAttribArray = config.getVertexAttribArray(attrib);
                if (vertexAttribArray == null) continue;
                destArrays.add(vertexAttribArray);
            }
            Iterator iterator = summary.texCoordSets.iterator();
            while (iterator.hasNext()) {
                int set = (Integer)iterator.next();
                ClientArrayConfig texCoordArray = config.getTexCoordArray(set);
                if (texCoordArray == null) continue;
                destArrays.add(texCoordArray);
            }
            if (summary.colors && config.colorArray != null) {
                destArrays.add(config.colorArray);
            }
            if (summary.normals && config.normalArray != null) {
                destArrays.add(config.normalArray);
            }
            destArrays.add(config.vertexArray);
            float[] dest = config.getFloatArray(true, destArrays.toArray(new ClientArrayConfig[destArrays.size()]));
            BufferObject arrayBuffer = null;
            FloatBuffer floatArray = null;
            boolean vbos = GLContext.getCapabilities().GL_ARB_vertex_buffer_object;
            if (vbos) {
                arrayBuffer = new BufferObject(ctx.getRenderer());
            } else {
                floatArray = BufferUtils.createFloatBuffer((int)dest.length);
            }
            final ArrayState[] arrayStates = config.createArrayStates(ctx, passes, summary, false, vbos, arrayBuffer, floatArray);
            final int tangentOffset = tangents ? this.getTangentOffset(passes, arrayStates) : 0;
            final int normalOffset = normals ? this.getNormalOffset(arrayStates) : 0;
            ClientArray vertexArray = arrayStates[0].getVertexArray();
            final int vertexOffset = (int)(vertexArray.offset / 4L);
            final int vertexStride = vertexArray.stride / 4;
            final Vector3f center = config.bounds.getCenter();
            final SimpleBatch.DrawCommand drawCommand = config.createDrawCommand(vbos);
            return new DynamicGeometry(dest, arrayBuffer, floatArray){

                @Override
                public CoordSpace getCoordSpace(int pass) {
                    return CoordSpace.EYE;
                }

                @Override
                public Vector3f getCenter() {
                    return center;
                }

                @Override
                public ArrayState getArrayState(int pass) {
                    return arrayStates[pass];
                }

                @Override
                public SimpleBatch.DrawCommand getDrawCommand(int pass) {
                    return drawCommand;
                }

                @Override
                protected void updateData() {
                    if (tangents && normals) {
                        Skin.skinVertices(source, this._data, boneMatrices, boneIndices, boneWeights, tangentOffset, normalOffset, vertexOffset, vertexStride);
                    } else if (normals) {
                        Skin.skinVertices(source, this._data, boneMatrices, boneIndices, boneWeights, normalOffset, vertexOffset, vertexStride);
                    } else {
                        Skin.skinVertices(source, this._data, boneMatrices, boneIndices, boneWeights, vertexOffset, vertexStride);
                    }
                }
            };
        }

        protected int getTangentOffset(PassDescriptor[] passes, ArrayState[] arrayStates) {
            int ii = 0;
            while (ii < passes.length) {
                int idx = ListUtil.indexOf((Object[])passes[ii].vertexAttribs, (Object)"tangents");
                if (idx != -1) {
                    return (int)(arrayStates[ii].getVertexAttribArrays()[idx].offset / 4L);
                }
                ++ii;
            }
            return 0;
        }

        protected int getNormalOffset(ArrayState[] arrayStates) {
            ArrayState[] arrayStateArray = arrayStates;
            int n = arrayStates.length;
            int n2 = 0;
            while (n2 < n) {
                ArrayState state = arrayStateArray[n2];
                ClientArray normalArray = state.getNormalArray();
                if (normalArray != null) {
                    return (int)(normalArray.offset / 4L);
                }
                ++n2;
            }
            return 0;
        }
    }
}

