/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.compositor.config;

import com.google.common.base.Objects;
import com.threerings.config.BoundConfig;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.opengl.compositor.config.RenderSchemeConfig;
import com.threerings.opengl.compositor.config.TargetConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.util.ArrayList;

public class RenderEffectConfig
extends BoundConfig {
    @Editable
    public Implementation implementation = new Original();

    public int getPriority(GlContext ctx) {
        return this.implementation.getPriority(ctx);
    }

    public Technique getTechnique(GlContext ctx, String scheme) {
        return this.implementation.getTechnique(ctx, scheme);
    }

    @Override
    public void wasUpdated() {
        this.implementation.invalidate();
        super.wasUpdated();
    }

    @Override
    protected void getUpdateReferences(ConfigReferenceSet refs) {
        this.implementation.getUpdateReferences(refs);
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<RenderEffectConfig> renderEffect;

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(RenderEffectConfig.class, this.renderEffect);
        }

        @Override
        public int getPriority(GlContext ctx) {
            RenderEffectConfig config = ctx.getConfigManager().getConfig(RenderEffectConfig.class, this.renderEffect);
            return config == null ? 0 : config.getPriority(ctx);
        }

        @Override
        public Technique getTechnique(GlContext ctx, String scheme) {
            RenderEffectConfig config = ctx.getConfigManager().getConfig(RenderEffectConfig.class, this.renderEffect);
            return config == null ? null : config.getTechnique(ctx, scheme);
        }
    }

    @EditorTypes(value={Original.class, Derived.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public abstract void getUpdateReferences(ConfigReferenceSet var1);

        public abstract int getPriority(GlContext var1);

        public abstract Technique getTechnique(GlContext var1, String var2);

        public void invalidate() {
        }
    }

    public static class Original
    extends Implementation {
        @Editable
        public int priority;
        @Editable
        public Technique[] techniques = new Technique[0];
        @DeepOmit
        protected transient Technique[] _processedTechniques;

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            Technique[] techniqueArray = this.techniques;
            int n = this.techniques.length;
            int n2 = 0;
            while (n2 < n) {
                Technique technique = techniqueArray[n2];
                technique.getUpdateReferences(refs);
                ++n2;
            }
        }

        @Override
        public int getPriority(GlContext ctx) {
            return this.priority;
        }

        @Override
        public Technique getTechnique(GlContext ctx, String scheme) {
            Technique[] processed;
            Technique[] techniqueArray = processed = this.getProcessedTechniques(ctx);
            int n = processed.length;
            int n2 = 0;
            while (n2 < n) {
                Technique technique = techniqueArray[n2];
                if (Objects.equal((Object)technique.scheme, (Object)scheme)) {
                    return technique;
                }
                ++n2;
            }
            RenderSchemeConfig sconfig = scheme == null ? null : ctx.getConfigManager().getConfig(RenderSchemeConfig.class, scheme);
            Technique[] techniqueArray2 = processed;
            int n3 = processed.length;
            n = 0;
            while (n < n3) {
                Technique technique = techniqueArray2[n];
                RenderSchemeConfig tconfig = technique.getSchemeConfig(ctx);
                if (sconfig == null ? tconfig == null || tconfig.isCompatibleWith(sconfig) : sconfig.isCompatibleWith(tconfig)) {
                    return technique;
                }
                ++n;
            }
            return null;
        }

        @Override
        public void invalidate() {
            this._processedTechniques = null;
            Technique[] techniqueArray = this.techniques;
            int n = this.techniques.length;
            int n2 = 0;
            while (n2 < n) {
                Technique technique = techniqueArray[n2];
                technique.invalidate();
                ++n2;
            }
        }

        protected Technique[] getProcessedTechniques(GlContext ctx) {
            if (this._processedTechniques == null) {
                ArrayList<Technique> list = new ArrayList<Technique>(this.techniques.length);
                ArrayList<Technique> fallbacks = new ArrayList<Technique>(0);
                Technique[] techniqueArray = this.techniques;
                int n = this.techniques.length;
                int n2 = 0;
                while (n2 < n) {
                    Technique technique = techniqueArray[n2];
                    Technique processed = technique.process(ctx, false);
                    if (processed == null) {
                        Technique fallback = technique.process(ctx, true);
                        if (fallback != null) {
                            fallbacks.add(fallback);
                        }
                    } else {
                        list.add(processed);
                    }
                    ++n2;
                }
                list.addAll(fallbacks);
                this._processedTechniques = list.toArray(new Technique[list.size()]);
            }
            return this._processedTechniques;
        }
    }

    public static class Technique
    extends DeepObject
    implements Exportable {
        @Editable(editor="config", mode="render_scheme", nullable=true)
        public String scheme;
        @Editable
        public TargetConfig[] targets = new TargetConfig[0];
        @Editable
        public TargetConfig.Output output = new TargetConfig.Output();
        @DeepOmit
        protected transient RenderSchemeConfig _schemeConfig = RenderSchemeConfig.INVALID;

        public void getUpdateReferences(ConfigReferenceSet refs) {
            TargetConfig[] targetConfigArray = this.targets;
            int n = this.targets.length;
            int n2 = 0;
            while (n2 < n) {
                TargetConfig target = targetConfigArray[n2];
                target.getUpdateReferences(refs);
                ++n2;
            }
            this.output.getUpdateReferences(refs);
        }

        public Technique process(GlContext ctx, boolean fallback) {
            return this.isSupported(ctx, fallback) ? this : null;
        }

        public boolean isSupported(GlContext ctx, boolean fallback) {
            TargetConfig[] targetConfigArray = this.targets;
            int n = this.targets.length;
            int n2 = 0;
            while (n2 < n) {
                TargetConfig target = targetConfigArray[n2];
                if (!target.isSupported(ctx, fallback)) {
                    return false;
                }
                ++n2;
            }
            return this.output.isSupported(ctx, fallback);
        }

        public RenderSchemeConfig getSchemeConfig(GlContext ctx) {
            if (this._schemeConfig == RenderSchemeConfig.INVALID) {
                return this.scheme == null ? null : ctx.getConfigManager().getConfig(RenderSchemeConfig.class, this.scheme);
            }
            return this._schemeConfig;
        }

        public void invalidate() {
            this._schemeConfig = RenderSchemeConfig.INVALID;
        }
    }
}

