/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.tools;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.util.SwingUtil;
import com.threerings.editor.Log;
import com.threerings.editor.util.EditorContext;
import com.threerings.expr.MutableBoolean;
import com.threerings.expr.MutableInteger;
import com.threerings.util.MessageBundle;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

public abstract class BatchValidateDialog
extends JDialog
implements ActionListener {
    protected EditorContext _ctx;
    protected Preferences _prefs;
    protected JTextField _includes;
    protected JTextField _excludes;
    protected JButton _start;
    protected JTextArea _results;

    public BatchValidateDialog(EditorContext ctx, JFrame parent, Preferences prefs) {
        super((Frame)parent, true);
        this._ctx = ctx;
        this._prefs = prefs;
        this.setDefaultCloseOperation(2);
        this.setSize(400, 500);
        SwingUtil.centerWindow((Window)this);
        JPanel cont = GroupLayout.makeVStretchBox((int)5);
        this.setContentPane(cont);
        MessageBundle msgs = ctx.getMessageManager().getBundle("editor.default");
        this.setTitle(msgs.get("m.batch_validate"));
        JPanel ipanel = GroupLayout.makeHStretchBox((int)5);
        cont.add((Component)ipanel, GroupLayout.FIXED);
        ipanel.add((Component)new JLabel(msgs.get("m.includes")), GroupLayout.FIXED);
        this._includes = new JTextField(prefs.get("validate_includes", ""));
        ipanel.add(this._includes);
        JPanel epanel = GroupLayout.makeHStretchBox((int)5);
        cont.add((Component)epanel, GroupLayout.FIXED);
        epanel.add((Component)new JLabel(msgs.get("m.excludes")), GroupLayout.FIXED);
        this._excludes = new JTextField(prefs.get("validate_excludes", ""));
        epanel.add(this._excludes);
        JPanel bpanel = new JPanel();
        cont.add((Component)bpanel, GroupLayout.FIXED);
        this._start = new JButton(msgs.get("m.start"));
        bpanel.add(this._start);
        this._start.addActionListener(this);
        this._results = new JTextArea();
        cont.add(new JScrollPane(this._results));
        this._results.setEditable(false);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this._start.setEnabled(false);
        String includes = this._includes.getText();
        this._prefs.put("validate_includes", includes);
        String excludes = this._excludes.getText();
        this._prefs.put("validate_excludes", excludes);
        this._results.setText("");
        final PrintStream out = new PrintStream(new ByteArrayOutputStream(){

            @Override
            public void flush() throws IOException {
                super.flush();
                BatchValidateDialog.this._results.append(this.toString());
                this.reset();
            }
        }, true);
        FileSet fs = new FileSet();
        File dir = this._ctx.getResourceManager().getResourceFile("");
        fs.setDir(dir);
        fs.setIncludes(includes);
        fs.setExcludes(excludes);
        DirectoryScanner ds = fs.getDirectoryScanner(new Project());
        final String[] files = ds.getIncludedFiles();
        final MutableInteger idx = new MutableInteger();
        final MutableBoolean valid = new MutableBoolean(true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (idx.value < files.length && BatchValidateDialog.this.isVisible()) {
                    String file = files[idx.value++];
                    try {
                        valid.value = BatchValidateDialog.this.validate(file, out) && valid.value;
                    }
                    catch (Exception e) {
                        Log.log.warning((Object)"Error in validation.", new Object[]{"file", file, e});
                    }
                    EventQueue.invokeLater(this);
                } else {
                    BatchValidateDialog.this._start.setEnabled(true);
                }
            }
        };
        EventQueue.invokeLater(runnable);
    }

    protected abstract boolean validate(String var1, PrintStream var2) throws Exception;
}

