/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor;

import com.samskivert.util.ClassUtil;
import com.samskivert.util.StringUtil;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ManagedConfig;
import com.threerings.config.Parameter;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.FieldProperty;
import com.threerings.editor.Introspector;
import com.threerings.editor.InvalidPathsException;
import com.threerings.editor.Log;
import com.threerings.editor.MethodProperty;
import com.threerings.editor.Property;
import com.threerings.editor.util.PropertyUtil;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class PathProperty
extends Property {
    protected Property[][] _paths;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Property[] createPath(ConfigManager cfgmgr, Object object, String path) {
        StreamTokenizer tok = new StreamTokenizer(new StringReader(path));
        tok.ordinaryChar(47);
        tok.ordinaryChar(46);
        tok.ordinaryChar(39);
        tok.wordChars(95, 95);
        ArrayList<Property> props = new ArrayList<Property>();
        try {
            while (tok.nextToken() != -1) {
                if (tok.ttype != -3) {
                    Log.log.warning((Object)("Unexpected token [path=" + path + ", token=" + tok + "]."), new Object[0]);
                    return null;
                }
                String name = tok.sval;
                Property prop = PathProperty.getProperty(cfgmgr, object, tok);
                if (prop == null) {
                    Log.log.warning((Object)"Failed to find property.", new Object[]{"path", path, "name", name, "object", object, "class", object == null ? null : object.getClass().getName()});
                    return null;
                }
                props.add(prop);
                object = prop.get(object);
            }
        }
        catch (IOException e) {
            Log.log.warning((Object)("Error parsing path [path=" + path + "]."), new Object[]{e});
            return null;
        }
        int size = props.size();
        if (size == 0) {
            return null;
        }
        Property[] propertyArray = props.toArray(new Property[size]);
        return propertyArray;
    }

    public PathProperty(ConfigManager cfgmgr, String name, Object reference, String ... paths) throws InvalidPathsException {
        this._name = name;
        ArrayList<Property[]> list = new ArrayList<Property[]>(paths.length);
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            Property[] props = PathProperty.createPath(cfgmgr, reference, path);
            if (props != null && props[props.length - 1].getAnnotation() != null) {
                list.add(props);
            }
            ++n2;
        }
        if (list.isEmpty()) {
            throw new InvalidPathsException(StringUtil.toString((Object)paths));
        }
        this._paths = (Property[][])list.toArray((T[])new Property[list.size()][]);
    }

    @Override
    public boolean shouldTranslateName() {
        return false;
    }

    @Override
    public String getColorName() {
        Property[] path = this._paths[0];
        return path[path.length - 1].getColorName();
    }

    @Override
    public Member getMember() {
        Property[] path = this._paths[0];
        return path[path.length - 1].getMember();
    }

    @Override
    public Object getMemberObject(Object object) {
        Property[] path = this._paths[0];
        int last = path.length - 1;
        int ii = 0;
        while (ii < last) {
            object = path[ii].get(object);
            ++ii;
        }
        return path[last].getMemberObject(object);
    }

    @Override
    public Class<?> getType() {
        Property[] path = this._paths[0];
        return path[path.length - 1].getType();
    }

    @Override
    public Type getGenericType() {
        Property[] path = this._paths[0];
        return path[path.length - 1].getGenericType();
    }

    @Override
    public String getMode() {
        return PropertyUtil.getMode(this._paths[0]);
    }

    @Override
    public String getUnits() {
        return PropertyUtil.getUnits(this._paths[0]);
    }

    @Override
    public double getMinimum() {
        return PropertyUtil.getMinimum(this._paths[0]);
    }

    @Override
    public double getMaximum() {
        return PropertyUtil.getMaximum(this._paths[0]);
    }

    @Override
    public double getStep() {
        return PropertyUtil.getStep(this._paths[0]);
    }

    @Override
    public double getScale() {
        return PropertyUtil.getScale(this._paths[0]);
    }

    @Override
    public int getMinSize() {
        return PropertyUtil.getMinSize(this._paths[0]);
    }

    @Override
    public int getMaxSize() {
        return PropertyUtil.getMaxSize(this._paths[0]);
    }

    @Override
    public Object get(Object object) {
        Property[] propertyArray = this._paths[0];
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property property = propertyArray[n2];
            object = property.get(object);
            ++n2;
        }
        return object;
    }

    @Override
    public void set(Object object, Object value) {
        int ii = 0;
        while (ii < this._paths.length) {
            Property[] path = this._paths[ii];
            Object obj = object;
            int last = path.length - 1;
            int jj = 0;
            while (jj < last) {
                obj = path[jj].get(obj);
                ++jj;
            }
            Property plast = path[last];
            this.setProperty(obj, value, path[last], ii == 0);
            ++ii;
        }
    }

    protected void setProperty(Object obj, Object value, Property prop, boolean coerce) {
        prop.set(obj, coerce ? value : PathProperty.coerce(value, prop.getType()));
    }

    protected static Property getProperty(ConfigManager cfgmgr, Object object, StreamTokenizer tok) throws IOException {
        Property[] props;
        if (object == null) {
            return null;
        }
        String name = tok.sval;
        Class<?> clazz = object.getClass();
        Property[] propertyArray = props = Introspector.getProperties(clazz);
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            Property prop = propertyArray[n2];
            if (prop.getName().equals(name)) {
                return PathProperty.getProperty(cfgmgr, object, prop, tok);
            }
            ++n2;
        }
        Class<?> sclazz = clazz;
        while (sclazz != null) {
            try {
                Field field = sclazz.getDeclaredField(name);
                field.setAccessible(true);
                return PathProperty.getProperty(cfgmgr, object, new FieldProperty(field), tok);
            }
            catch (NoSuchFieldException field) {
                try {
                    Method method = sclazz.getDeclaredMethod(name, new Class[0]);
                    method.setAccessible(true);
                    return PathProperty.getProperty(cfgmgr, object, new MethodProperty(method, method), tok);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    sclazz = sclazz.getSuperclass();
                }
            }
        }
        return null;
    }

    protected static Property getProperty(final ConfigManager cfgmgr, Object object, final Property base, StreamTokenizer tok) throws IOException {
        if (tok.nextToken() != 91) {
            return base;
        }
        Object value = base.get(object);
        if (value == null) {
            return null;
        }
        Property prop = null;
        if (tok.nextToken() == -2) {
            final int idx = (int)tok.nval;
            if (value instanceof List) {
                if (idx >= 0 && idx < ((List)value).size()) {
                    prop = new IndexProperty(base, idx){

                        @Override
                        public Object get(Object object) {
                            return ((List)base.get(object)).get(idx);
                        }

                        @Override
                        public void set(Object object, Object value) {
                            List list = (List)base.get(object);
                            list.set(idx, value);
                        }
                    };
                }
            } else if (value.getClass().isArray() && idx >= 0 && idx < Array.getLength(value)) {
                prop = new IndexProperty(base, idx){

                    @Override
                    public Object get(Object object) {
                        return Array.get(base.get(object), idx);
                    }

                    @Override
                    public void set(Object object, Object value) {
                        Array.set(base.get(object), idx, value);
                    }
                };
            }
        } else if (tok.ttype == 34 && value instanceof ConfigReference) {
            Object config;
            final String arg = tok.sval;
            final Class<?> clazz = base.getArgumentType(ConfigReference.class);
            if (clazz == null) {
                Log.log.warning((Object)"Couldn't determine config reference type.", new Object[]{"ref", value});
                return null;
            }
            ConfigReference ref = (ConfigReference)value;
            if (cfgmgr == null) {
                Log.log.warning((Object)"No config manager available.", new Object[]{"ref", value});
                return null;
            }
            Object v0 = config = ref == null ? null : cfgmgr.getConfig(clazz, ref.getName());
            if (!(config instanceof ParameterizedConfig)) {
                return null;
            }
            ParameterizedConfig pconfig = config;
            Parameter parameter = pconfig.getParameter(arg);
            if (parameter == null) {
                return null;
            }
            final Property aprop = parameter.getArgumentProperty(pconfig);
            if (aprop == null) {
                return null;
            }
            prop = new Property(){
                {
                    this._name = String.valueOf(property.getName()) + "[\"" + string.replace("\"", "\\\"") + "\"]";
                }

                @Override
                public Member getMember() {
                    return aprop.getMember();
                }

                @Override
                public Object getMemberObject(Object object) {
                    ConfigReference<ManagedConfig> ref = this.getReference(object);
                    Property prop = this.getArgumentProperty(ref);
                    return prop == null ? null : prop.getMemberObject(ref.getArguments());
                }

                @Override
                public Class<?> getType() {
                    return aprop.getType();
                }

                @Override
                public Type getGenericType() {
                    return aprop.getGenericType();
                }

                @Override
                public Object get(Object object) {
                    ConfigReference<ManagedConfig> ref = this.getReference(object);
                    Property prop = this.getArgumentProperty(ref);
                    return prop == null ? null : prop.get(ref.getArguments());
                }

                @Override
                public void set(Object object, Object value) {
                    ConfigReference<ManagedConfig> ref = this.getReference(object);
                    Property prop = this.getArgumentProperty(ref);
                    if (prop != null) {
                        prop.set(ref.getArguments(), value);
                    }
                }

                protected ConfigReference<ManagedConfig> getReference(Object object) {
                    return (ConfigReference)base.get(object);
                }

                protected Property getArgumentProperty(ConfigReference<ManagedConfig> ref) {
                    Object config;
                    Object v0 = config = ref == null ? null : cfgmgr.getConfig(clazz, ref.getName());
                    if (!(config instanceof ParameterizedConfig)) {
                        return null;
                    }
                    ParameterizedConfig pconfig = config;
                    Parameter parameter = pconfig.getParameter(arg);
                    if (parameter == null) {
                        return null;
                    }
                    return parameter.getArgumentProperty(pconfig);
                }
            };
        }
        if (tok.nextToken() != 93) {
            Log.log.warning((Object)("Missing matching bracket [token=" + tok + "]."), new Object[0]);
            return null;
        }
        return prop == null ? null : PathProperty.getProperty(cfgmgr, object, prop, tok);
    }

    protected static Object coerce(Object value, Class<?> type) {
        if (type.isPrimitive()) {
            type = ClassUtil.objectEquivalentOf(type);
        }
        if (value == null || type.isInstance(value)) {
            return value;
        }
        if (value instanceof String) {
            if (type == Byte.class) {
                try {
                    return Byte.valueOf((String)value);
                }
                catch (NumberFormatException e) {
                    return (byte)0;
                }
            }
            if (type == Double.class) {
                try {
                    return Double.valueOf((String)value);
                }
                catch (NumberFormatException e) {
                    return 0.0;
                }
            }
            if (type == Float.class) {
                try {
                    return Float.valueOf((String)value);
                }
                catch (NumberFormatException e) {
                    return Float.valueOf(0.0f);
                }
            }
            if (type == Integer.class) {
                try {
                    return Integer.valueOf((String)value);
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
            if (type == Long.class) {
                try {
                    return Long.valueOf((String)value);
                }
                catch (NumberFormatException e) {
                    return 0L;
                }
            }
            if (type == Short.class) {
                try {
                    return Short.valueOf((String)value);
                }
                catch (NumberFormatException e) {
                    return (short)0;
                }
            }
        } else if (value instanceof Number) {
            if (type == Byte.class) {
                return ((Number)value).byteValue();
            }
            if (type == Double.class) {
                return ((Number)value).doubleValue();
            }
            if (type == Float.class) {
                return Float.valueOf(((Number)value).floatValue());
            }
            if (type == Integer.class) {
                return ((Number)value).intValue();
            }
            if (type == Long.class) {
                return ((Number)value).longValue();
            }
            if (type == Short.class) {
                return ((Number)value).shortValue();
            }
            if (type == String.class) {
                return value.toString();
            }
        }
        throw new IllegalArgumentException("Can't coerce " + value + " to " + type);
    }

    protected static abstract class IndexProperty
    extends Property {
        protected Property _base;

        public IndexProperty(Property base, int idx) {
            this._base = base;
            this._name = String.valueOf(this._base.getName()) + "[" + idx + "]";
        }

        @Override
        public boolean shouldTranslateName() {
            return false;
        }

        @Override
        public Member getMember() {
            return this._base.getMember();
        }

        @Override
        public Class<?> getType() {
            return this._base.getComponentType();
        }

        @Override
        public Type getGenericType() {
            return this._base.getGenericComponentType();
        }
    }
}

