/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.Randoms;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector2f;
import com.threerings.tudey.config.BehaviorConfig;
import com.threerings.tudey.data.EntityKey;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.data.actor.Mobile;
import com.threerings.tudey.server.TudeySceneManager;
import com.threerings.tudey.server.logic.ActionLogic;
import com.threerings.tudey.server.logic.AgentLogic;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.server.logic.ScriptLogic;
import com.threerings.tudey.server.logic.TargetLogic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public abstract class BehaviorLogic
extends Logic {
    public static final float MAX_FOLLOW_PATH_LENGTH = 8.0f;
    protected BehaviorConfig.Original _config;
    protected AgentLogic _agent;

    public void init(TudeySceneManager scenemgr, BehaviorConfig.Original config, AgentLogic agent) {
        super.init(scenemgr);
        this._config = config;
        this._agent = agent;
        this.didInit();
    }

    public void startup() {
    }

    public void suspend() {
    }

    public void shutdown() {
    }

    public void tick(int timestamp) {
    }

    public void reachedTargetRotation() {
    }

    public void penetratedEnvironment(Vector2f penetration) {
    }

    public Logic getCurrentTarget() {
        return null;
    }

    @Override
    public boolean isActive() {
        return this._agent.isActive();
    }

    @Override
    public EntityKey getEntityKey() {
        return this._agent.getEntityKey();
    }

    @Override
    public Vector2f getTranslation() {
        return this._agent.getTranslation();
    }

    @Override
    public float getRotation() {
        return this._agent.getRotation();
    }

    protected void didInit() {
    }

    public static class BaseWander
    extends Evaluating {
        protected int _startRotating = Integer.MAX_VALUE;
        protected float _rotation;
        protected int _startMoving = Integer.MAX_VALUE;

        @Override
        public void startup() {
            super.startup();
            this._startRotating = Integer.MAX_VALUE;
            this._startMoving = Integer.MAX_VALUE;
        }

        @Override
        public void tick(int timestamp) {
            super.tick(timestamp);
            if (this._agent.canRotate() && timestamp >= this._startRotating) {
                this._startMoving = Integer.MAX_VALUE;
                this._startRotating = Integer.MAX_VALUE;
                this._agent.setTargetRotation(this._rotation);
            }
            if (this._agent.canMove() && timestamp >= this._startMoving) {
                this.scheduleNextEvaluation();
                this._agent.startMoving();
                this._startMoving = Integer.MAX_VALUE;
            }
        }

        @Override
        public void reachedTargetRotation() {
            BehaviorConfig.BaseWander config = (BehaviorConfig.BaseWander)this._config;
            int pause = (int)(config.postRotationPause.getValue() * 1000.0f);
            if (pause == 0) {
                this.scheduleNextEvaluation();
                this._agent.startMoving();
                this._startMoving = Integer.MAX_VALUE;
                this._startRotating = Integer.MAX_VALUE;
            } else {
                this._startMoving = this._scenemgr.getTimestamp() + pause;
                this._startRotating = Integer.MAX_VALUE;
            }
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            BaseWander wsource = (BaseWander)source;
            this._startRotating = wsource._startRotating;
            this._rotation = wsource._rotation;
            this._startMoving = wsource._startMoving;
        }

        protected void setDirectionChange(float rotation) {
            int pause = (int)(((BehaviorConfig.BaseWander)this._config).preRotationPause.getValue() * 1000.0f);
            this.postponeNextEvaluation();
            this._rotation = rotation;
            if (pause == 0) {
                this._startMoving = Integer.MAX_VALUE;
                this._startRotating = Integer.MAX_VALUE;
                this._agent.setTargetRotation(this._rotation);
            } else {
                this._startRotating = this._scenemgr.getTimestamp() + pause;
                this._startMoving = Integer.MAX_VALUE;
            }
        }
    }

    public static class Combined
    extends BehaviorLogic {
        protected BehaviorLogic _first;
        protected BehaviorLogic _second;

        @Override
        public void startup() {
            if (this._first != null) {
                this._first.startup();
            }
            if (this._second != null) {
                this._second.startup();
            }
        }

        @Override
        public void shutdown() {
            if (this._first != null) {
                this._first.shutdown();
            }
            if (this._second != null) {
                this._second.shutdown();
            }
        }

        @Override
        public void tick(int timestamp) {
            if (this._first != null) {
                this._first.tick(timestamp);
            }
            if (this._second != null) {
                this._second.tick(timestamp);
            }
        }

        @Override
        public void reachedTargetRotation() {
            if (this._first != null) {
                this._first.reachedTargetRotation();
            }
            if (this._second != null) {
                this._second.reachedTargetRotation();
            }
        }

        @Override
        public void penetratedEnvironment(Vector2f penetration) {
            if (this._first != null) {
                this._first.penetratedEnvironment(penetration);
            }
            if (this._second != null) {
                this._second.penetratedEnvironment(penetration);
            }
        }

        @Override
        public Logic getCurrentTarget() {
            Logic target = null;
            if (this._first != null) {
                target = this._first.getCurrentTarget();
            }
            if (this._second != null && target == null) {
                target = this._second.getCurrentTarget();
            }
            return target;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            Combined csource = (Combined)source;
            if (this._first != null) {
                this._first.transfer(csource._first, refs);
            }
            if (this._second != null) {
                this._second.transfer(csource._second, refs);
            }
        }

        @Override
        protected void didInit() {
            super.didInit();
            BehaviorConfig.Combined config = (BehaviorConfig.Combined)this._config;
            this._first = this._agent.createBehavior(config.first);
            if (this._first != null) {
                this._first.didInit();
            }
            this._second = this._agent.createBehavior(config.second);
            if (this._second != null) {
                this._second.didInit();
            }
        }
    }

    public static abstract class Evaluating
    extends BehaviorLogic {
        protected int _nextEvaluation;

        @Override
        public void startup() {
            this.advanceEvaluation();
        }

        @Override
        public void tick(int timestamp) {
            if (this._agent.canThink() && timestamp >= this._nextEvaluation) {
                this.evaluate();
            }
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._nextEvaluation = ((Evaluating)source)._nextEvaluation;
        }

        protected void evaluate() {
            this.scheduleNextEvaluation();
        }

        protected void scheduleNextEvaluation() {
            this._nextEvaluation = this._scenemgr.getTimestamp() + (int)(((BehaviorConfig.Evaluating)this._config).evaluationInterval.getValue() * 1000.0f);
        }

        protected void postponeNextEvaluation() {
            this._nextEvaluation = Integer.MAX_VALUE;
        }

        protected void advanceEvaluation() {
            this._nextEvaluation = this._scenemgr.getTimestamp();
        }
    }

    public static class Follow
    extends Pathing {
        protected TargetLogic _target;
        protected ArrayList<Logic> _targets = Lists.newArrayList();
        protected Logic _currentTarget;

        @Override
        public Logic getCurrentTarget() {
            return this._currentTarget;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._target.transfer(((Follow)source)._target, refs);
        }

        @Override
        protected void didInit() {
            super.didInit();
            this._target = this.createTarget(((BehaviorConfig.Follow)this._config).target, this._agent);
        }

        @Override
        protected void evaluate() {
            super.evaluate();
            this._target.resolve(this._agent, this._targets);
            Vector2f trans = this._agent.getTranslation();
            this._currentTarget = null;
            float cdist = Float.MAX_VALUE;
            int ii = 0;
            int nn = this._targets.size();
            while (ii < nn) {
                Logic target = this._targets.get(ii);
                float dist = target.getTranslation().distanceSquared(trans);
                if (dist < cdist) {
                    this._currentTarget = target;
                    cdist = dist;
                }
                ++ii;
            }
            this._targets.clear();
            if (this._currentTarget == null) {
                return;
            }
            BehaviorConfig.Follow config = (BehaviorConfig.Follow)this._config;
            float min2 = config.minimumDistance * config.minimumDistance;
            float max2 = config.maximumDistance * config.maximumDistance;
            if (FloatMath.isWithin(cdist, min2, max2)) {
                this.clearPath();
                this._agent.face(this._currentTarget);
                return;
            }
            Vector2f loc = this._currentTarget.getTranslation();
            Vector2f[] path = this._scenemgr.getPathfinder().getPath(this._agent, 8.0f, loc.x, loc.y, true, true);
            if (path == null) {
                this.clearPath();
                this._agent.face(this._currentTarget);
                return;
            }
            this.setPath(path);
        }
    }

    public static class GridWander
    extends BaseWander {
        @Override
        public void startup() {
            super.startup();
            if (!((BehaviorConfig.GridWander)this._config).evaluationRotate) {
                this.setDirectionChange(this._rotation);
            }
        }

        @Override
        public void penetratedEnvironment(Vector2f penetration) {
            BehaviorConfig.GridWander config = (BehaviorConfig.GridWander)this._config;
            this.changeDirection();
        }

        @Override
        protected void evaluate() {
            super.evaluate();
            if (((BehaviorConfig.GridWander)this._config).evaluationRotate) {
                this.changeDirection();
            }
        }

        @Override
        protected void didInit() {
            super.didInit();
            this._rotation = this._agent.getActor().getRotation();
        }

        protected void changeDirection() {
            this._agent.stopMoving();
            float rotation = this._rotation;
            switch (((BehaviorConfig.GridWander)this._config).gridTurn) {
                case REVERSE: {
                    rotation += (float)Math.PI;
                    break;
                }
                case LEFT: {
                    rotation += 1.5707964f;
                    break;
                }
                case RIGHT: {
                    rotation -= 1.5707964f;
                    break;
                }
                case RANDOM: {
                    rotation += Randoms.threadLocal().getBoolean() ? 1.5707964f : -1.5707964f;
                }
            }
            rotation = FloatMath.normalizeAnglePositive(rotation);
            rotation = rotation > 5.4977875f ? 0.0f : (rotation > 3.926991f ? -1.5707964f : (rotation > 2.3561945f ? (float)Math.PI : (rotation > 0.7853982f ? 1.5707964f : 0.0f)));
            this.setDirectionChange(rotation);
        }
    }

    public static class Idle
    extends BehaviorLogic {
        @Override
        public void startup() {
            this._agent.stopMoving();
            this._agent.clearTargetRotation();
        }
    }

    protected static class PathCandidate {
        protected Logic _target;
        protected Vector2f[] _path;
        protected int _cidx;

        public PathCandidate(Logic target, Vector2f[] path, int cidx) {
            this._target = target;
            this._path = path;
            this._cidx = cidx;
        }

        public Logic getTarget() {
            return this._target;
        }

        public Vector2f[] getRemainingPath(float angle) {
            if (this._cidx == this._path.length - 1) {
                ArrayUtil.reverse((Object[])this._path);
            } else if (this._cidx != 0) {
                Vector2f prev = this._path[this._cidx - 1];
                Vector2f node = this._path[this._cidx];
                Vector2f next = this._path[this._cidx + 1];
                float df = FloatMath.atan2(next.y - node.y, next.x - node.x);
                float dr = FloatMath.atan2(prev.y - node.y, prev.x - node.x);
                if (FloatMath.getAngularDistance(angle, dr) < FloatMath.getAngularDistance(angle, df)) {
                    this._path = (Vector2f[])ArrayUtil.splice((Object[])this._path, (int)(this._cidx + 1));
                    ArrayUtil.reverse((Object[])this._path);
                } else {
                    this._path = (Vector2f[])ArrayUtil.splice((Object[])this._path, (int)0, (int)this._cidx);
                }
            }
            return this._path;
        }
    }

    public static abstract class Pathing
    extends Evaluating {
        protected Vector2f[] _path;
        protected int _pidx;
        protected float _moveFaceRange;

        @Override
        public void tick(int timestamp) {
            super.tick(timestamp);
            if (this._path == null) {
                return;
            }
            Vector2f trans = this._agent.getTranslation();
            boolean completedPath = false;
            while (this._path[this._pidx].distance(trans) <= this.getReachRadius()) {
                if (++this._pidx == this._path.length) {
                    this._agent.stopMoving();
                    this._path = null;
                    if (completedPath) {
                        return;
                    }
                    this.completedPath();
                    completedPath = true;
                } else {
                    this.reachedPathIndex(this._pidx - 1);
                }
                if (this._path != null) continue;
                return;
            }
            Vector2f node = this._path[this._pidx];
            float rot = FloatMath.atan2(node.y - trans.y, node.x - trans.x);
            float dist = FloatMath.getAngularDistance(this._agent.getRotation(), rot);
            if (dist > 1.0E-4f) {
                this._agent.setTargetRotation(rot);
            }
            if (dist > this._moveFaceRange) {
                this._agent.stopMoving();
            } else {
                this._agent.startMoving();
            }
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            Pathing psource = (Pathing)source;
            this._path = psource._path;
            this._pidx = psource._pidx;
        }

        protected void setPath(Vector2f[] path) {
            if (this._path != path && !Arrays.equals(this._path, path)) {
                this._path = path;
                this._pidx = 0;
            }
        }

        protected void clearPath() {
            if (this._path != null) {
                this._agent.stopMoving();
                this._path = null;
            }
        }

        protected float getReachRadius() {
            float speed = ((Mobile)this._agent.getActor()).getSpeed();
            return speed / (float)this._scenemgr.getTicksPerSecond();
        }

        protected void reachedPathIndex(int idx) {
        }

        protected void completedPath() {
        }

        @Override
        protected void didInit() {
            super.didInit();
            this._moveFaceRange = ((BehaviorConfig.Pathing)this._config).moveFaceRange;
            if (this._moveFaceRange == 0.0f) {
                this._moveFaceRange = 0.001f;
            }
        }
    }

    public static class Patrol
    extends Pathing {
        protected TargetLogic _target;
        protected ArrayList<Logic> _targets = Lists.newArrayList();
        protected ArrayList<PathCandidate> _candidates = Lists.newArrayList();
        protected Logic _currentTarget;

        @Override
        public Logic getCurrentTarget() {
            return this._currentTarget;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            Patrol psource = (Patrol)source;
            this._target.transfer(psource._target, refs);
            this._currentTarget = (Logic)refs.get(psource._currentTarget);
        }

        @Override
        protected void didInit() {
            super.didInit();
            this._target = this.createTarget(((BehaviorConfig.Patrol)this._config).target, this._agent);
        }

        @Override
        protected void evaluate() {
            float br2;
            super.evaluate();
            if (this._path == null) {
                br2 = Float.MAX_VALUE;
            } else {
                float radius = ((BehaviorConfig.Patrol)this._config).branchRadius;
                if (radius < 0.0f) {
                    return;
                }
                br2 = radius * radius;
            }
            this._target.resolve(this._agent, this._targets);
            Vector2f trans = this._agent.getTranslation();
            int ii = 0;
            int nn = this._targets.size();
            while (ii < nn) {
                Vector2f[] path;
                Logic target = this._targets.get(ii);
                if (target != this._currentTarget && (path = this._targets.get(ii).getPatrolPath()) != null) {
                    float cdist = Float.MAX_VALUE;
                    int cidx = -1;
                    int jj = 0;
                    int mm = path.length;
                    while (jj < mm) {
                        float dist = path[jj].distanceSquared(trans);
                        if (dist < cdist) {
                            cidx = jj;
                            cdist = dist;
                        }
                        ++jj;
                    }
                    if (cdist <= br2) {
                        this._candidates.add(new PathCandidate(target, path, cidx));
                    }
                }
                ++ii;
            }
            this._targets.clear();
            if (this._candidates.isEmpty()) {
                return;
            }
            if (this._path != null) {
                this._candidates.add(null);
            }
            PathCandidate candidate = (PathCandidate)Randoms.threadLocal().pick(this._candidates, null);
            this._candidates.clear();
            if (candidate != null) {
                this.setPath(candidate.getRemainingPath(this._agent.getRotation()), candidate.getTarget());
            }
        }

        @Override
        protected void reachedPathIndex(int idx) {
            this.evaluate();
        }

        @Override
        protected void completedPath() {
            this._currentTarget = null;
            this.evaluate();
        }

        protected void setPath(Vector2f[] path, Logic currentTarget) {
            super.setPath(path);
            this._currentTarget = currentTarget;
        }
    }

    public static class Random
    extends Evaluating {
        protected BehaviorLogic[] _behaviors;
        protected BehaviorLogic _active;
        protected Map<BehaviorLogic, Float> _behaviorWeights;

        @Override
        public void tick(int timestamp) {
            super.tick(timestamp);
            if (this._active != null) {
                this._active.tick(timestamp);
            }
        }

        @Override
        public void reachedTargetRotation() {
            if (this._active != null) {
                this._active.reachedTargetRotation();
            }
        }

        @Override
        public void penetratedEnvironment(Vector2f penetration) {
            if (this._active != null) {
                this._active.penetratedEnvironment(penetration);
            }
        }

        @Override
        public Logic getCurrentTarget() {
            return this._active == null ? null : this._active.getCurrentTarget();
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            BehaviorLogic[] sbehaviors = ((Random)source)._behaviors;
            int ii = 0;
            while (ii < this._behaviors.length) {
                if (this._behaviors[ii] != null) {
                    this._behaviors[ii].transfer(sbehaviors[ii], refs);
                }
                ++ii;
            }
        }

        @Override
        protected void didInit() {
            super.didInit();
            BehaviorConfig.WeightedBehavior[] wbehaviors = ((BehaviorConfig.Random)this._config).behaviors;
            this._behaviors = new BehaviorLogic[wbehaviors.length];
            this._behaviorWeights = Maps.newHashMap();
            int ii = 0;
            while (ii < wbehaviors.length) {
                BehaviorConfig.WeightedBehavior wbehavior = wbehaviors[ii];
                this._behaviors[ii] = this._agent.createBehavior(wbehavior.behavior);
                this._behaviorWeights.put(this._behaviors[ii], Float.valueOf(wbehavior.weight));
                ++ii;
            }
        }

        @Override
        protected void evaluate() {
            super.evaluate();
            BehaviorLogic nactive = (BehaviorLogic)Randoms.threadLocal().pick(this._behaviorWeights, null);
            if (nactive == this._active) {
                return;
            }
            this._active = nactive;
            if (this._active != null) {
                this._active.startup();
            }
        }
    }

    public static class Scripted
    extends BehaviorLogic {
        protected ScriptLogic[] _steps;
        protected int _currentStep;
        protected boolean _start = true;

        public void setCurrentStep(int step, int timestamp) {
            this._currentStep = Math.min(this._steps.length, step);
            this._steps[this._currentStep].start(timestamp);
        }

        @Override
        public void tick(int timestamp) {
            if (this._currentStep < this._steps.length) {
                if (this._start) {
                    this._steps[this._currentStep].start(timestamp);
                }
                if (this._start = this._steps[this._currentStep].tick(timestamp)) {
                    ++this._currentStep;
                }
            }
        }

        @Override
        public void reachedTargetRotation() {
            if (this._currentStep < this._steps.length) {
                this._steps[this._currentStep].reachedTargetRotation();
            }
        }

        @Override
        public void startup() {
            this._currentStep = 0;
            this._start = true;
        }

        @Override
        public void suspend() {
            if (this._currentStep < this._steps.length && !this._start) {
                this._steps[this._currentStep].suspend();
            }
        }

        @Override
        public void shutdown() {
            ScriptLogic[] scriptLogicArray = this._steps;
            int n = this._steps.length;
            int n2 = 0;
            while (n2 < n) {
                ScriptLogic logic = scriptLogicArray[n2];
                logic.shutdown();
                ++n2;
            }
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            Scripted ssource = (Scripted)source;
            int ii = 0;
            while (ii < this._steps.length) {
                this._steps[ii].transfer(ssource._steps[ii], refs);
                ++ii;
            }
            this._currentStep = ssource._currentStep;
            this._start = ssource._start;
        }

        @Override
        protected void didInit() {
            super.didInit();
            BehaviorConfig.Scripted config = (BehaviorConfig.Scripted)this._config;
            this._steps = new ScriptLogic[config.steps.length];
            int ii = 0;
            while (ii < this._steps.length) {
                this._steps[ii] = ScriptLogic.createScriptLogic(this._scenemgr, config.steps[ii], this._agent, this);
                ++ii;
            }
        }
    }

    public static class Wander
    extends BaseWander {
        protected Vector2f _origin = new Vector2f();

        @Override
        public void tick(int timestamp) {
            float rotation;
            float angle;
            super.tick(timestamp);
            Actor actor = this._agent.getActor();
            Vector2f trans = this._agent.getTranslation();
            if (actor.isSet(2) && trans.distance(this._origin) > ((BehaviorConfig.Wander)this._config).radius && FloatMath.getAngularDistance(angle = FloatMath.atan2(this._origin.y - trans.y, this._origin.x - trans.x), rotation = this._agent.getActor().getRotation()) > 1.5707964f) {
                this.changeDirection(angle);
            }
        }

        @Override
        public void penetratedEnvironment(Vector2f penetration) {
            float rotation = FloatMath.normalizeAngle(this._agent.getActor().getRotation() + (float)Math.PI);
            if (penetration.length() > 1.0E-6f) {
                float angle = FloatMath.atan2(penetration.y, penetration.x);
                rotation = FloatMath.normalizeAngle(angle - FloatMath.getAngularDifference(rotation, angle));
            }
            this.changeDirection(rotation);
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            Wander wsource = (Wander)source;
            this._origin.set(wsource._origin);
        }

        @Override
        protected void didInit() {
            super.didInit();
            this._origin.set(this._agent.getTranslation());
        }

        @Override
        protected void evaluate() {
            super.evaluate();
            this.changeDirection();
        }

        protected void changeDirection() {
            this.changeDirection(this._agent.getActor().getRotation());
        }

        protected void changeDirection(float rotation) {
            this._agent.stopMoving();
            BehaviorConfig.Wander config = (BehaviorConfig.Wander)this._config;
            this.setDirectionChange(FloatMath.normalizeAngle(rotation + config.directionChange.getValue()));
        }
    }

    public static class WanderCollision
    extends BaseWander {
        protected ActionLogic _action;

        @Override
        public void penetratedEnvironment(Vector2f penetration) {
            this._action.execute(this._scenemgr.getTimestamp(), this._agent);
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            WanderCollision wsource = (WanderCollision)source;
            this._action = (ActionLogic)refs.get(wsource._action);
        }

        @Override
        protected void didInit() {
            super.didInit();
            this._action = this.createAction(((BehaviorConfig.WanderCollision)this._config).action, this._agent);
        }
    }
}

