/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.opengl.gui.EditableTextComponent;
import com.threerings.opengl.gui.background.Background;
import com.threerings.opengl.gui.text.Text;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.gui.util.Insets;
import com.threerings.opengl.gui.util.Point;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.util.GlContext;

public class TextEditor
extends EditableTextComponent {
    protected Text[] _glyphs;
    protected int _lines = 1;
    protected Point _curs = new Point();
    protected Point _sel = new Point();

    public TextEditor(GlContext ctx) {
        this(ctx, "");
    }

    public TextEditor(GlContext ctx, String text) {
        super(ctx, text, 0);
    }

    @Override
    protected String getDefaultStyleConfig() {
        return "Default/TextEditor";
    }

    @Override
    protected void renderComponent(Renderer renderer) {
        Background bkg;
        super.renderComponent(renderer);
        Insets insets = this.getInsets();
        int lineHeight = this.getTextFactory().getHeight();
        if (this.showCursor() && this._cursp != this._selp && (bkg = this.getSelectionBackground()) != null) {
            Point endLoc;
            int startP = Math.min(this._cursp, this._selp);
            int endP = Math.max(this._cursp, this._selp);
            Point startLoc = startP == this._cursp ? this._curs : this._sel;
            Point point = endLoc = startP == this._cursp ? this._sel : this._curs;
            if (startLoc.y == endLoc.y) {
                bkg.render(renderer, insets.left + startLoc.x, insets.bottom + startLoc.y, endLoc.x - startLoc.x + 1, lineHeight, this._alpha);
            } else {
                int idx = (this._height - insets.getVertical() - startLoc.y) / lineHeight - 1;
                bkg.render(renderer, insets.left + startLoc.x, insets.bottom + startLoc.y, this._glyphs[idx].getSize().width - startLoc.x + 1, lineHeight, this._alpha);
                int y = startLoc.y - lineHeight;
                while (y > endLoc.y) {
                    bkg.render(renderer, insets.left, insets.bottom + y, this._glyphs[++idx].getSize().width + 1, lineHeight, this._alpha);
                    y -= lineHeight;
                }
                bkg.render(renderer, insets.left, insets.bottom + endLoc.y, endLoc.x + 1, lineHeight, this._alpha);
            }
        }
        if (this._glyphs != null) {
            Rectangle oscissor = TextEditor.intersectScissor(renderer, this._srect, this.getAbsoluteX() + insets.left, this.getAbsoluteY() + insets.bottom, this._width - insets.getHorizontal(), this._height - insets.getVertical());
            try {
                int x = insets.left;
                int y = this._height - insets.top - lineHeight;
                Text[] textArray = this._glyphs;
                int n = this._glyphs.length;
                int n2 = 0;
                while (n2 < n) {
                    Text text = textArray[n2];
                    text.render(renderer, x, y, this._alpha);
                    y -= lineHeight;
                    ++n2;
                }
            }
            finally {
                renderer.setScissor(oscissor);
            }
        }
        if (this.showCursor() && this._cursp == this._selp) {
            this.renderCursor(renderer, insets.left + this._curs.x, insets.bottom + this._curs.y, lineHeight);
        }
    }

    @Override
    protected Dimension computePreferredSize(int whint, int hhint) {
        Insets insets = this.getInsets();
        int lineHeight = this.getTextFactory().getHeight();
        int width = this._prefWidth == -1 ? insets.getHorizontal() : this._prefWidth;
        return new Dimension(width, this._lines * lineHeight + insets.getVertical());
    }

    @Override
    protected boolean processCommand(int cmd) {
        switch (cmd) {
            default: {
                return super.processCommand(cmd);
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
        }
        int lineHeight = this.getTextFactory().getHeight();
        int x = this._curs.x;
        int y = this._curs.y + lineHeight / 2;
        switch (cmd) {
            case 5: {
                y += lineHeight;
                break;
            }
            case 6: {
                y -= lineHeight;
                break;
            }
            case 9: {
                x = 0;
                break;
            }
            case 10: {
                x = Integer.MAX_VALUE;
            }
        }
        this.setCursorPos(this.getPosition(x, y));
        return true;
    }

    @Override
    protected void recreateGlyphs() {
        int lines;
        super.recreateGlyphs();
        int n = lines = this._glyphs == null ? 1 : this._glyphs.length;
        if (this._lines != lines) {
            this._lines = lines;
            this.invalidate();
        }
    }

    @Override
    protected boolean hasGlyphs() {
        return this._glyphs != null;
    }

    @Override
    protected void createGlyphs() {
        this._glyphs = this.getTextFactory().wrapText(this.getDisplayText(), this.getColor(), 3, 1, null, this._width - this.getInsets().getHorizontal());
    }

    @Override
    protected void clearGlyphs() {
        this._glyphs = null;
    }

    @Override
    protected int getPosition(int mouseX, int mouseY) {
        int y = this._height - this.getInsets().getVertical();
        if (mouseY > y) {
            return 0;
        }
        int lineHeight = this.getTextFactory().getHeight();
        int pos = 0;
        String docText = this._text.getText();
        Text[] textArray = this._glyphs;
        int n = this._glyphs.length;
        int n2 = 0;
        while (n2 < n) {
            Text text = textArray[n2];
            if (mouseY > (y -= lineHeight)) {
                return pos + text.getHitPos(mouseX, mouseY - y);
            }
            if ((pos += text.getLength()) < docText.length() && Character.isWhitespace(docText.charAt(pos))) {
                ++pos;
            }
            ++n2;
        }
        return Math.min(pos, this._text.getText().length());
    }

    @Override
    protected void selectionWasSet() {
        this.calculatePosition(this._cursp, this._curs);
        if (this._selp == this._cursp) {
            this._sel.set(this._curs);
        } else {
            this.calculatePosition(this._selp, this._sel);
        }
        if (this.showCursor()) {
            Insets insets = this.getInsets();
            int lineHeight = this.getTextFactory().getHeight();
            this.scrollRectToVisible(this._curs.x, this._curs.y, insets.getHorizontal() + 1, lineHeight + insets.getVertical() + 1);
        }
    }

    protected void calculatePosition(int pos, Point loc) {
        int lineHeight = this.getTextFactory().getHeight();
        int y = this._height - this.getInsets().getVertical() - lineHeight;
        if (this._glyphs != null) {
            String docText = this._text.getText();
            int docPos = 0;
            Text[] textArray = this._glyphs;
            int n = this._glyphs.length;
            int n2 = 0;
            while (n2 < n) {
                Text text = textArray[n2];
                int len = text.getLength();
                if (pos <= len) {
                    loc.set(text.getCursorPos(pos), y);
                    return;
                }
                pos -= len;
                if ((docPos += len) < docText.length() && Character.isWhitespace(docText.charAt(docPos))) {
                    ++docPos;
                    --pos;
                }
                y -= lineHeight;
                ++n2;
            }
        }
        loc.set(0, y);
    }
}

