/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.opengl.gui.BoundedRangeModel;
import com.threerings.opengl.gui.Button;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.UIConstants;
import com.threerings.opengl.gui.event.ActionEvent;
import com.threerings.opengl.gui.event.ActionListener;
import com.threerings.opengl.gui.layout.BorderLayout;
import com.threerings.opengl.util.GlContext;

public class ScrollButton
extends Container
implements UIConstants {
    protected ActionListener _buttoner = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            int delta = ScrollButton.this._model.getScrollIncrement();
            if (event.getAction().equals("less")) {
                ScrollButton.this._model.setValue(ScrollButton.this._model.getValue() - delta);
            } else {
                ScrollButton.this._model.setValue(ScrollButton.this._model.getValue() + delta);
            }
        }
    };
    protected BoundedRangeModel _model;
    protected int _orient;
    protected boolean _less;
    protected Button _btn;

    public ScrollButton(GlContext ctx, boolean less) {
        this(ctx, less, 1);
    }

    public ScrollButton(GlContext ctx, boolean less, int orientation) {
        this(ctx, less, orientation, 0, 100, 0, 10);
    }

    public ScrollButton(GlContext ctx, boolean less, int orientation, int min, int value, int extent, int max) {
        this(ctx, less, orientation, new BoundedRangeModel(min, value, extent, max));
    }

    public ScrollButton(GlContext ctx, boolean less, int orientation, BoundedRangeModel model) {
        super(ctx, new BorderLayout());
        this._orient = orientation;
        this._model = model;
        this._less = less;
    }

    public BoundedRangeModel getModel() {
        return this._model;
    }

    @Override
    public void wasAdded() {
        super.wasAdded();
        String oprefix = "Default/ScrollBar" + (this._orient == 0 ? "H" : "V");
        this._btn = new Button(this._ctx, "");
        this._btn.setStyleConfig(String.valueOf(oprefix) + (this._less ? "Less" : "More"));
        this.add(this._btn, BorderLayout.CENTER);
        this._btn.addListener(this._buttoner);
        this._btn.setAction(this._less ? "less" : "more");
    }

    @Override
    public void wasRemoved() {
        super.wasRemoved();
        if (this._btn != null) {
            this.remove(this._btn);
            this._btn = null;
        }
    }

    @Override
    protected String getDefaultStyleConfig() {
        return "Default/ScrollBar";
    }
}

