/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.effect;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.io.Streamable;
import com.threerings.opengl.effect.Easing;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.util.DeepObject;

@EditorTypes(value={Constant.class, Linear.class, InAndOut.class, ThreePoint.class, Multipoint.class})
public abstract class ColorFunction
extends DeepObject
implements Exportable,
Streamable {
    public abstract Color4f getValue(float var1, Color4f var2);

    public abstract ColorFunction copy(ColorFunction var1);

    public static class Constant
    extends ColorFunction {
        @Editable(mode="%INHERIT%")
        public Color4f value = new Color4f(1.0f, 1.0f, 1.0f, 1.0f);

        public Constant(ColorFunction function) {
            function.getValue(0.5f, this.value);
        }

        public Constant() {
        }

        @Override
        public Color4f getValue(float t, Color4f result) {
            return result.set(this.value);
        }

        @Override
        public ColorFunction copy(ColorFunction result) {
            Constant cresult = result instanceof Constant ? (Constant)result : new Constant();
            cresult.value.set(this.value);
            return cresult;
        }
    }

    public static class InAndOut
    extends ColorFunction {
        @Editable(mode="%INHERIT%")
        public Color4f start = new Color4f(1.0f, 1.0f, 1.0f, 0.0f);
        @Editable(mode="%INHERIT%")
        public Color4f end = new Color4f(1.0f, 1.0f, 1.0f, 1.0f);
        @Editable(min=0.0, max=1.0, step=0.01)
        public float in = 0.25f;
        @Editable(min=0.0, max=1.0, step=0.01)
        public float out = 0.25f;

        public InAndOut(ColorFunction function) {
            function.getValue(0.0f, this.start);
            function.getValue(1.0f, this.end);
        }

        public InAndOut(ThreePoint function) {
            this.start.set(function.start);
            this.end.set(function.middle);
            this.in = function.in;
            this.out = function.out;
        }

        public InAndOut() {
        }

        @Override
        public Color4f getValue(float t, Color4f result) {
            if (t < this.in) {
                return this.start.lerp(this.end, t / this.in, result);
            }
            if (t <= 1.0f - this.out) {
                return result.set(this.end);
            }
            return this.start.lerp(this.end, (1.0f - t) / this.out, result);
        }

        @Override
        public ColorFunction copy(ColorFunction result) {
            InAndOut iresult = result instanceof InAndOut ? (InAndOut)result : new InAndOut();
            iresult.start.set(this.start);
            iresult.end.set(this.end);
            iresult.in = this.in;
            iresult.out = this.out;
            return iresult;
        }
    }

    public static class Linear
    extends ColorFunction {
        @Editable(mode="%INHERIT%")
        public Color4f start = new Color4f(1.0f, 1.0f, 1.0f, 1.0f);
        @Editable(mode="%INHERIT%")
        public Color4f end = new Color4f(1.0f, 1.0f, 1.0f, 0.0f);
        @Editable
        public Easing easing = new Easing.None();

        public Linear(ColorFunction function) {
            function.getValue(0.0f, this.start);
            function.getValue(1.0f, this.end);
        }

        public Linear() {
        }

        @Override
        public Color4f getValue(float t, Color4f result) {
            return this.start.lerp(this.end, this.easing.getTime(t), result);
        }

        @Override
        public ColorFunction copy(ColorFunction result) {
            Linear lresult = result instanceof Linear ? (Linear)result : new Linear();
            lresult.start.set(this.start);
            lresult.end.set(this.end);
            lresult.easing = this.easing.copy(lresult.easing);
            return lresult;
        }
    }

    public static class Multipoint
    extends ColorFunction {
        @Editable(mode="%INHERIT%")
        public Color4f start = new Color4f(1.0f, 1.0f, 1.0f, 1.0f);
        @Editable(mode="%INHERIT%")
        public Point[] middle = new Point[0];
        @Editable(mode="%INHERIT%")
        public Color4f end = new Color4f(1.0f, 1.0f, 1.0f, 0.0f);

        public Multipoint(ColorFunction function) {
            function.getValue(0.0f, this.start);
            function.getValue(1.0f, this.end);
        }

        public Multipoint(InAndOut function) {
            this.start.set(function.start);
            this.middle = new Point[]{new Point(function.end, function.in), new Point(function.end, 1.0f - function.in - function.out)};
            this.end.set(function.start);
        }

        public Multipoint(ThreePoint function) {
            this.start.set(function.start);
            this.middle = new Point[]{new Point(function.middle, function.in), new Point(function.middle, 1.0f - function.in - function.out)};
            this.end.set(function.end);
        }

        public Multipoint() {
        }

        @Override
        public Color4f getValue(float t, Color4f result) {
            Color4f last = this.start;
            float remaining = 1.0f;
            Point[] pointArray = this.middle;
            int n = this.middle.length;
            int n2 = 0;
            while (n2 < n) {
                Point point = pointArray[n2];
                if (t < point.offset) {
                    return last.lerp(point.color, t / point.offset, result);
                }
                t -= point.offset;
                remaining -= point.offset;
                last = point.color;
                ++n2;
            }
            return last.lerp(this.end, t / remaining, result);
        }

        @Override
        public ColorFunction copy(ColorFunction result) {
            Multipoint mresult = result instanceof Multipoint ? (Multipoint)result : new Multipoint();
            mresult.start.set(this.start);
            if (mresult.middle.length != this.middle.length) {
                Point[] oarray = mresult.middle;
                mresult.middle = new Point[this.middle.length];
                int len = Math.min(oarray.length, this.middle.length);
                System.arraycopy(oarray, 0, mresult.middle, 0, len);
                int ii = len;
                while (ii < this.middle.length) {
                    mresult.middle[ii] = new Point();
                    ++ii;
                }
            }
            int ii = 0;
            while (ii < this.middle.length) {
                mresult.middle[ii].set(this.middle[ii]);
                ++ii;
            }
            mresult.end.set(this.end);
            return mresult;
        }

        public static class Point
        implements Exportable,
        Streamable {
            @Editable(mode="%INHERIT%")
            public Color4f color = new Color4f(1.0f, 1.0f, 1.0f, 1.0f);
            @Editable(min=0.0, max=1.0, step=0.01)
            public float offset = 0.25f;

            public Point(Color4f color, float offset) {
                this.color.set(color);
                this.offset = offset;
            }

            public Point() {
            }

            public void set(Point other) {
                this.color.set(other.color);
                this.offset = other.offset;
            }
        }
    }

    public static class ThreePoint
    extends ColorFunction {
        @Editable(mode="%INHERIT%")
        public Color4f start = new Color4f(1.0f, 1.0f, 1.0f, 0.0f);
        @Editable(mode="%INHERIT%")
        public Color4f middle = new Color4f(1.0f, 1.0f, 1.0f, 1.0f);
        @Editable(mode="%INHERIT%")
        public Color4f end = new Color4f(1.0f, 1.0f, 1.0f, 0.0f);
        @Editable(min=0.0, max=1.0, step=0.01)
        public float in = 0.25f;
        @Editable(min=0.0, max=1.0, step=0.01)
        public float out = 0.25f;

        public ThreePoint(ColorFunction function) {
            function.getValue(0.0f, this.start);
            function.getValue(0.5f, this.middle);
            function.getValue(1.0f, this.end);
        }

        public ThreePoint(InAndOut function) {
            this.start.set(function.start);
            this.middle.set(function.end);
            this.end.set(function.start);
            this.in = function.in;
            this.out = function.out;
        }

        public ThreePoint() {
        }

        @Override
        public Color4f getValue(float t, Color4f result) {
            if (t < this.in) {
                return this.start.lerp(this.middle, t / this.in, result);
            }
            if (t <= 1.0f - this.out) {
                return result.set(this.middle);
            }
            return this.end.lerp(this.middle, (1.0f - t) / this.out, result);
        }

        @Override
        public ColorFunction copy(ColorFunction result) {
            ThreePoint tresult = result instanceof ThreePoint ? (ThreePoint)result : new ThreePoint();
            tresult.start.set(this.start);
            tresult.middle.set(this.middle);
            tresult.end.set(this.end);
            tresult.in = this.in;
            tresult.out = this.out;
            return tresult;
        }
    }
}

