/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export;

import com.samskivert.util.StringUtil;
import com.threerings.export.Encodable;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.lwjgl.BufferUtils;

public abstract class Stringifier<T> {
    protected static HashMap<Class<?>, Stringifier<?>> _stringifiers = new HashMap();

    static {
        _stringifiers.put(Boolean.class, new Stringifier<Boolean>(){

            @Override
            public String toString(Boolean value) {
                return value.toString();
            }

            @Override
            public Boolean fromString(String string) {
                return Boolean.valueOf(string);
            }
        });
        _stringifiers.put(Byte.class, new Stringifier<Byte>(){

            @Override
            public String toString(Byte value) {
                return value.toString();
            }

            @Override
            public Byte fromString(String string) {
                return Byte.valueOf(string);
            }
        });
        _stringifiers.put(Character.class, new Stringifier<Character>(){

            @Override
            public String toString(Character value) {
                return value.toString();
            }

            @Override
            public Character fromString(String string) {
                return Character.valueOf(string.charAt(0));
            }
        });
        _stringifiers.put(Class.class, new Stringifier<Class<?>>(){

            @Override
            public String toString(Class<?> value) {
                return value.getName();
            }

            @Override
            public Class<?> fromString(String string) throws Exception {
                return Class.forName(string);
            }
        });
        _stringifiers.put(Double.class, new Stringifier<Double>(){

            @Override
            public String toString(Double value) {
                return value.toString();
            }

            @Override
            public Double fromString(String string) {
                return Double.valueOf(string);
            }
        });
        _stringifiers.put(Float.class, new Stringifier<Float>(){

            @Override
            public String toString(Float value) {
                return value.toString();
            }

            @Override
            public Float fromString(String string) {
                return Float.valueOf(string);
            }
        });
        _stringifiers.put(Integer.class, new Stringifier<Integer>(){

            @Override
            public String toString(Integer value) {
                return value.toString();
            }

            @Override
            public Integer fromString(String string) {
                return Integer.valueOf(string);
            }
        });
        _stringifiers.put(Long.class, new Stringifier<Long>(){

            @Override
            public String toString(Long value) {
                return value.toString();
            }

            @Override
            public Long fromString(String string) {
                return Long.valueOf(string);
            }
        });
        _stringifiers.put(Short.class, new Stringifier<Short>(){

            @Override
            public String toString(Short value) {
                return value.toString();
            }

            @Override
            public Short fromString(String string) {
                return Short.valueOf(string);
            }
        });
        _stringifiers.put(String.class, new Stringifier<String>(){

            @Override
            public String toString(String value) {
                return value;
            }

            @Override
            public String fromString(String string) {
                return string;
            }
        });
        _stringifiers.put(boolean[].class, new Stringifier<boolean[]>(){

            @Override
            public String toString(boolean[] value) {
                return StringUtil.toString((Object)value, (String)"", (String)"");
            }

            @Override
            public boolean[] fromString(String string) {
                return StringUtil.parseBooleanArray((String)string);
            }
        });
        _stringifiers.put(byte[].class, new Stringifier<byte[]>(){

            @Override
            public String toString(byte[] value) {
                return StringUtil.toString((Object)value, (String)"", (String)"");
            }

            @Override
            public byte[] fromString(String string) {
                return StringUtil.parseByteArray((String)string);
            }
        });
        _stringifiers.put(char[].class, new Stringifier<char[]>(){

            @Override
            public String toString(char[] value) {
                return String.valueOf(value);
            }

            @Override
            public char[] fromString(String string) {
                return string.toCharArray();
            }
        });
        _stringifiers.put(double[].class, new Stringifier<double[]>(){

            @Override
            public String toString(double[] value) {
                return StringUtil.toString((Object)value, (String)"", (String)"");
            }

            @Override
            public double[] fromString(String string) {
                return StringUtil.parseDoubleArray((String)string);
            }
        });
        _stringifiers.put(float[].class, new Stringifier<float[]>(){

            @Override
            public String toString(float[] value) {
                return StringUtil.toString((Object)value, (String)"", (String)"");
            }

            @Override
            public float[] fromString(String string) {
                return StringUtil.parseFloatArray((String)string);
            }
        });
        _stringifiers.put(int[].class, new Stringifier<int[]>(){

            @Override
            public String toString(int[] value) {
                return StringUtil.toString((Object)value, (String)"", (String)"");
            }

            @Override
            public int[] fromString(String string) {
                return StringUtil.parseIntArray((String)string);
            }
        });
        _stringifiers.put(long[].class, new Stringifier<long[]>(){

            @Override
            public String toString(long[] value) {
                return StringUtil.toString((Object)value, (String)"", (String)"");
            }

            @Override
            public long[] fromString(String string) {
                return StringUtil.parseLongArray((String)string);
            }
        });
        _stringifiers.put(short[].class, new Stringifier<short[]>(){

            @Override
            public String toString(short[] value) {
                return StringUtil.toString((Object)value, (String)"", (String)"");
            }

            @Override
            public short[] fromString(String string) {
                return StringUtil.parseShortArray((String)string);
            }
        });
        _stringifiers.put(String[].class, new Stringifier<String[]>(){

            @Override
            public String toString(String[] value) {
                return StringUtil.joinEscaped((String[])value);
            }

            @Override
            public String[] fromString(String string) {
                return StringUtil.parseStringArray((String)string);
            }
        });
        _stringifiers.put(File.class, new Stringifier<File>(){

            @Override
            public String toString(File value) {
                return value.toString();
            }

            @Override
            public File fromString(String string) {
                return new File(string);
            }
        });
        _stringifiers.put(ByteBuffer.class, new Stringifier<ByteBuffer>(){

            @Override
            public String toString(ByteBuffer value) {
                StringBuilder sb = new StringBuilder();
                int ii = 0;
                int nn = value.limit();
                while (ii < nn) {
                    if (ii > 0) {
                        sb.append(", ");
                    }
                    sb.append(value.get(ii));
                    ++ii;
                }
                return sb.toString();
            }

            @Override
            public ByteBuffer fromString(String string) {
                StringTokenizer tok = new StringTokenizer(string, ",");
                ByteBuffer buf = BufferUtils.createByteBuffer((int)tok.countTokens());
                int ii = 0;
                while (tok.hasMoreTokens()) {
                    buf.put(ii, Byte.parseByte(tok.nextToken().trim()));
                    ++ii;
                }
                return buf;
            }
        });
        _stringifiers.put(CharBuffer.class, new Stringifier<CharBuffer>(){

            @Override
            public String toString(CharBuffer value) {
                return value.toString();
            }

            @Override
            public CharBuffer fromString(String string) {
                CharBuffer buf = BufferUtils.createCharBuffer((int)string.length());
                buf.put(string).rewind();
                return buf;
            }
        });
        _stringifiers.put(DoubleBuffer.class, new Stringifier<DoubleBuffer>(){

            @Override
            public String toString(DoubleBuffer value) {
                StringBuilder sb = new StringBuilder();
                int ii = 0;
                int nn = value.limit();
                while (ii < nn) {
                    if (ii > 0) {
                        sb.append(", ");
                    }
                    sb.append(value.get(ii));
                    ++ii;
                }
                return sb.toString();
            }

            @Override
            public DoubleBuffer fromString(String string) {
                StringTokenizer tok = new StringTokenizer(string, ",");
                DoubleBuffer buf = BufferUtils.createDoubleBuffer((int)tok.countTokens());
                int ii = 0;
                while (tok.hasMoreTokens()) {
                    buf.put(ii, Double.parseDouble(tok.nextToken().trim()));
                    ++ii;
                }
                return buf;
            }
        });
        _stringifiers.put(FloatBuffer.class, new Stringifier<FloatBuffer>(){

            @Override
            public String toString(FloatBuffer value) {
                StringBuilder sb = new StringBuilder();
                int ii = 0;
                int nn = value.limit();
                while (ii < nn) {
                    if (ii > 0) {
                        sb.append(", ");
                    }
                    sb.append(value.get(ii));
                    ++ii;
                }
                return sb.toString();
            }

            @Override
            public FloatBuffer fromString(String string) {
                StringTokenizer tok = new StringTokenizer(string, ",");
                FloatBuffer buf = BufferUtils.createFloatBuffer((int)tok.countTokens());
                int ii = 0;
                while (tok.hasMoreTokens()) {
                    buf.put(ii, Float.parseFloat(tok.nextToken().trim()));
                    ++ii;
                }
                return buf;
            }
        });
        _stringifiers.put(IntBuffer.class, new Stringifier<IntBuffer>(){

            @Override
            public String toString(IntBuffer value) {
                StringBuilder sb = new StringBuilder();
                int ii = 0;
                int nn = value.limit();
                while (ii < nn) {
                    if (ii > 0) {
                        sb.append(", ");
                    }
                    sb.append(value.get(ii));
                    ++ii;
                }
                return sb.toString();
            }

            @Override
            public IntBuffer fromString(String string) {
                StringTokenizer tok = new StringTokenizer(string, ",");
                IntBuffer buf = BufferUtils.createIntBuffer((int)tok.countTokens());
                int ii = 0;
                while (tok.hasMoreTokens()) {
                    buf.put(ii, Integer.parseInt(tok.nextToken().trim()));
                    ++ii;
                }
                return buf;
            }
        });
        _stringifiers.put(LongBuffer.class, new Stringifier<LongBuffer>(){

            @Override
            public String toString(LongBuffer value) {
                StringBuilder sb = new StringBuilder();
                int ii = 0;
                int nn = value.limit();
                while (ii < nn) {
                    if (ii > 0) {
                        sb.append(", ");
                    }
                    sb.append(value.get(ii));
                    ++ii;
                }
                return sb.toString();
            }

            @Override
            public LongBuffer fromString(String string) {
                StringTokenizer tok = new StringTokenizer(string, ",");
                LongBuffer buf = BufferUtils.createLongBuffer((int)tok.countTokens());
                int ii = 0;
                while (tok.hasMoreTokens()) {
                    buf.put(ii, Long.parseLong(tok.nextToken().trim()));
                    ++ii;
                }
                return buf;
            }
        });
        _stringifiers.put(ShortBuffer.class, new Stringifier<ShortBuffer>(){

            @Override
            public String toString(ShortBuffer value) {
                StringBuilder sb = new StringBuilder();
                int ii = 0;
                int nn = value.limit();
                while (ii < nn) {
                    if (ii > 0) {
                        sb.append(", ");
                    }
                    sb.append(value.get(ii));
                    ++ii;
                }
                return sb.toString();
            }

            @Override
            public ShortBuffer fromString(String string) {
                StringTokenizer tok = new StringTokenizer(string, ",");
                ShortBuffer buf = BufferUtils.createShortBuffer((int)tok.countTokens());
                int ii = 0;
                while (tok.hasMoreTokens()) {
                    buf.put(ii, Short.parseShort(tok.nextToken().trim()));
                    ++ii;
                }
                return buf;
            }
        });
    }

    public static Stringifier<?> getStringifier(final Class<?> clazz) {
        Stringifier<Object> stringifier = _stringifiers.get(clazz);
        if (stringifier == null) {
            if (clazz.isEnum()) {
                stringifier = new Stringifier<Enum<?>>(){

                    @Override
                    public String toString(Enum<?> value) {
                        return value.name();
                    }

                    @Override
                    public Enum<?> fromString(String string) {
                        Class eclazz = clazz;
                        return Enum.valueOf(eclazz, string);
                    }
                };
                _stringifiers.put(clazz, stringifier);
            } else if (Encodable.class.isAssignableFrom(clazz)) {
                stringifier = new Stringifier<Encodable>(){

                    @Override
                    public String toString(Encodable value) {
                        return value.encodeToString();
                    }

                    @Override
                    public Encodable fromString(String string) throws Exception {
                        Encodable value = (Encodable)clazz.newInstance();
                        value.decodeFromString(string);
                        return value;
                    }
                };
                _stringifiers.put(clazz, stringifier);
            }
        }
        return stringifier;
    }

    public abstract String toString(T var1);

    public abstract T fromString(String var1) throws Exception;
}

