/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.swing;

import com.google.common.base.Objects;
import com.samskivert.util.QuickSort;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigGroupListener;
import com.threerings.config.ManagedConfig;
import com.threerings.util.MessageBundle;
import java.util.HashSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class ConfigBox
extends JComboBox
implements ConfigGroupListener<ManagedConfig> {
    protected MessageBundle _msgs;
    protected ConfigGroup<ManagedConfig>[] _groups;
    protected boolean _nullable;

    public ConfigBox(MessageBundle msgs, ConfigGroup[] groups, boolean nullable) {
        this(msgs, groups, nullable, null);
    }

    public ConfigBox(MessageBundle msgs, ConfigGroup[] groups, boolean nullable, String config) {
        this._msgs = msgs;
        ConfigGroup[] mgroups = groups;
        this._groups = mgroups;
        this._nullable = nullable;
        this.updateModel();
        this.setSelectedConfig(config);
    }

    public void setSelectedConfig(String config) {
        this.setSelectedItem(new ConfigItem(config));
    }

    public String getSelectedConfig() {
        ConfigItem item = (ConfigItem)this.getSelectedItem();
        return item == null ? null : item.name;
    }

    @Override
    public void configAdded(ConfigEvent<ManagedConfig> event) {
        this.updateModel();
    }

    @Override
    public void configRemoved(ConfigEvent<ManagedConfig> event) {
        this.updateModel();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateModel();
        ConfigGroup<ManagedConfig>[] configGroupArray = this._groups;
        int n = this._groups.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigGroup<ManagedConfig> group = configGroupArray[n2];
            group.addListener(this);
            ++n2;
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ConfigGroup<ManagedConfig>[] configGroupArray = this._groups;
        int n = this._groups.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigGroup<ManagedConfig> group = configGroupArray[n2];
            group.removeListener(this);
            ++n2;
        }
    }

    protected void updateModel() {
        HashSet<String> names = new HashSet<String>();
        ConfigGroup<ManagedConfig>[] configGroupArray = this._groups;
        int n = this._groups.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigGroup<ManagedConfig> group = configGroupArray[n2];
            for (ManagedConfig config : group.getConfigs()) {
                names.add(config.getName());
            }
            ++n2;
        }
        int offset = this._nullable ? 1 : 0;
        Comparable[] items = new ConfigItem[offset + names.size()];
        int idx = 0;
        if (this._nullable) {
            items[idx++] = new ConfigItem(null);
        }
        for (String name : names) {
            items[idx++] = new ConfigItem(name);
        }
        QuickSort.sort((Comparable[])items, (int)offset, (int)(items.length - 1));
        String config = this.getSelectedConfig();
        this.setModel(new DefaultComboBoxModel<Comparable>(items));
        this.setSelectedConfig(config);
    }

    protected class ConfigItem
    implements Comparable<ConfigItem> {
        public String name;

        public ConfigItem(String name) {
            this.name = name;
        }

        @Override
        public int compareTo(ConfigItem other) {
            return this.name.compareTo(other.name);
        }

        public String toString() {
            return this.name == null ? ConfigBox.this._msgs.get("m.null_value") : this.name;
        }

        public boolean equals(Object other) {
            return Objects.equal((Object)this.name, (Object)((ConfigItem)other).name);
        }
    }
}

