/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.dist.client;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.samskivert.util.Interval;
import com.threerings.ClydeLog;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigGroupListener;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.config.ManagedConfig;
import com.threerings.config.dist.data.ConfigEntry;
import com.threerings.config.dist.data.ConfigKey;
import com.threerings.config.dist.data.DConfigBootstrapData;
import com.threerings.config.dist.data.DConfigObject;
import com.threerings.config.dist.util.ConfigUpdater;
import com.threerings.crowd.data.BodyObject;
import com.threerings.presents.client.BasicDirector;
import com.threerings.presents.client.Client;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.dobj.EntryAddedEvent;
import com.threerings.presents.dobj.EntryRemovedEvent;
import com.threerings.presents.dobj.EntryUpdatedEvent;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.Subscriber;
import com.threerings.presents.util.PresentsContext;
import com.threerings.util.ChangeBlock;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DConfigDirector
extends BasicDirector
implements Subscriber<DConfigObject>,
ConfigGroupListener<ManagedConfig>,
ConfigUpdateListener<ManagedConfig> {
    protected ConfigManager _cfgmgr;
    protected DConfigObject _cfgobj;
    protected ChangeBlock _block = new ChangeBlock();
    protected Map<ConfigKey, ConfigEntry> _added = Maps.newTreeMap();
    protected Map<ConfigKey, ConfigEntry> _updated = Maps.newTreeMap();
    protected Set<ConfigKey> _removed = Sets.newTreeSet();
    protected long _lastTransmit;
    protected Interval _transmitInterval;
    protected static final long MIN_TRANSMIT_INTERVAL = 200L;

    public DConfigDirector(PresentsContext ctx, ConfigManager cfgmgr) {
        super(ctx);
        this._cfgmgr = cfgmgr;
        Iterator<ConfigGroup> iterator = cfgmgr.getGroups().iterator();
        while (iterator.hasNext()) {
            ConfigGroup group;
            ConfigGroup mgroup = group = iterator.next();
            mgroup.addListener(this);
        }
        this._cfgmgr.addUpdateListener(this);
        this._transmitInterval = new Interval(ctx.getClient().getRunQueue()){

            public void expired() {
                DConfigDirector.this.maybeTransmitUpdate();
            }
        };
    }

    public void objectAvailable(DConfigObject cfgobj) {
        this._cfgobj = cfgobj;
        new ConfigUpdater(this._cfgmgr){

            @Override
            public void entryAdded(EntryAddedEvent event) {
                int clientOid = ((DConfigObject.ClientEntryAddedEvent)event).getClientOid();
                if (clientOid != DConfigDirector.this._ctx.getClient().getClientOid() && DConfigDirector.this._block.enter()) {
                    try {
                        super.entryAdded(event);
                    }
                    finally {
                        DConfigDirector.this._block.leave();
                    }
                }
            }

            @Override
            public void entryUpdated(EntryUpdatedEvent event) {
                int clientOid = ((DConfigObject.ClientEntryUpdatedEvent)event).getClientOid();
                if (clientOid != DConfigDirector.this._ctx.getClient().getClientOid() && DConfigDirector.this._block.enter()) {
                    try {
                        super.entryUpdated(event);
                    }
                    finally {
                        DConfigDirector.this._block.leave();
                    }
                }
            }

            @Override
            public void entryRemoved(EntryRemovedEvent event) {
                int clientOid = ((DConfigObject.ClientEntryRemovedEvent)event).getClientOid();
                if (clientOid != DConfigDirector.this._ctx.getClient().getClientOid() && DConfigDirector.this._block.enter()) {
                    try {
                        super.entryRemoved(event);
                    }
                    finally {
                        DConfigDirector.this._block.leave();
                    }
                }
            }
        }.init(this._cfgobj);
    }

    public void requestFailed(int oid, ObjectAccessException cause) {
        ClydeLog.log.warning((Object)"Failed to subscribe to config object.", new Object[]{"oid", oid, cause});
    }

    @Override
    public void configAdded(ConfigEvent<ManagedConfig> event) {
        if (this._cfgobj == null || !this.clientIsAdmin() || !this._block.enter()) {
            return;
        }
        try {
            ConfigEntry entry = new ConfigEntry(event.getConfig());
            ConfigKey key = (ConfigKey)entry.getKey();
            if (this._removed.remove(key)) {
                this._updated.put(key, entry);
            } else {
                this._added.put(key, entry);
            }
            this.maybeTransmitUpdate();
        }
        finally {
            this._block.leave();
        }
    }

    @Override
    public void configRemoved(ConfigEvent<ManagedConfig> event) {
        if (this._cfgobj == null || !this.clientIsAdmin() || !this._block.enter()) {
            return;
        }
        try {
            ManagedConfig config = event.getConfig();
            ConfigKey key = new ConfigKey(config.getClass(), config.getName());
            if (this._added.remove(key) == null) {
                this._updated.remove(key);
                this._removed.add(key);
            }
            this.maybeTransmitUpdate();
        }
        finally {
            this._block.leave();
        }
    }

    @Override
    public void configUpdated(ConfigEvent<ManagedConfig> event) {
        if (this._cfgobj == null || !this.clientIsAdmin() || !this._block.enter()) {
            return;
        }
        try {
            ConfigEntry entry = new ConfigEntry(event.getConfig());
            ConfigKey key = (ConfigKey)entry.getKey();
            if (this._added.containsKey(key)) {
                this._added.put(key, entry);
            } else {
                this._updated.put(key, entry);
            }
            this.maybeTransmitUpdate();
        }
        finally {
            this._block.leave();
        }
    }

    public void clientDidLogoff(Client client) {
        super.clientDidLogoff(client);
        this._cfgobj = null;
    }

    protected void fetchServices(Client client) {
        int oid = ((DConfigBootstrapData)client.getBootstrapData()).dconfigOid;
        this._ctx.getDObjectManager().subscribeToObject(oid, (Subscriber)this);
    }

    protected void maybeTransmitUpdate() {
        if (this._added.isEmpty() && this._updated.isEmpty() && this._removed.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        long delay = this._lastTransmit + 200L - now;
        if (delay > 0L) {
            this._transmitInterval.schedule(delay);
            return;
        }
        this._lastTransmit = now;
        this._cfgobj.dconfigService.updateConfigs(this._added.values().toArray(new ConfigEntry[this._added.size()]), this._updated.values().toArray(new ConfigEntry[this._updated.size()]), this._removed.toArray(new ConfigKey[this._removed.size()]));
        this._added.clear();
        this._updated.clear();
        this._removed.clear();
    }

    protected boolean clientIsAdmin() {
        ClientObject clobj = this._ctx.getClient().getClientObject();
        return clobj instanceof BodyObject && ((BodyObject)clobj).getTokens().isAdmin();
    }
}

