/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Label;
import com.threerings.opengl.gui.Log;
import com.threerings.opengl.gui.TextComponent;
import com.threerings.opengl.gui.UIConstants;
import com.threerings.opengl.gui.icon.Icon;
import com.threerings.opengl.gui.text.Text;
import com.threerings.opengl.gui.text.TextFactory;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.gui.util.Insets;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import org.lwjgl.opengl.GL11;

public class LabelRenderer
implements UIConstants {
    protected TextComponent _container;
    protected String _value;
    protected int _textRotation;
    protected int _orient = 0;
    protected int _gap = 3;
    protected Label.Fit _fit = Label.Fit.WRAP;
    protected Icon _icon;
    protected int _ix;
    protected int _iy;
    protected Config _config;
    protected int _tx;
    protected int _ty;
    protected float _alpha = 1.0f;
    protected Config _prefconfig;
    protected Dimension _prefsize;
    protected int _prefWidth = -1;
    protected Fade _fade = new Fade();
    protected Rectangle _srect = new Rectangle();

    public LabelRenderer(TextComponent container) {
        this._container = container;
    }

    public void setText(String text) {
        if (this._value != null && this._value.equals(text)) {
            return;
        }
        this._value = text;
        this._container.invalidate();
    }

    public String getText() {
        return this._value;
    }

    public void setIcon(Icon icon) {
        if (this._icon == icon) {
            return;
        }
        int owidth = 0;
        int oheight = 0;
        int nwidth = 0;
        int nheight = 0;
        if (this._icon != null) {
            owidth = this._icon.getWidth();
            oheight = this._icon.getHeight();
        }
        this._icon = icon;
        if (this._icon != null) {
            nwidth = this._icon.getWidth();
            nheight = this._icon.getHeight();
        }
        if (owidth != nwidth || oheight != nheight) {
            this._container.invalidate();
        } else if (this._container.isValid()) {
            this._container.layout();
        }
    }

    public Icon getIcon() {
        return this._icon;
    }

    public void setIconTextGap(int gap) {
        this._gap = gap;
    }

    public int getIconTextGap() {
        return this._gap;
    }

    public void setTextRotation(int rotation) {
        this._textRotation = rotation;
    }

    public void setOrientation(int orient) {
        this._orient = orient;
    }

    public void setFit(Label.Fit mode) {
        this._fit = mode;
    }

    public void setPreferredWidth(int width) {
        this._prefWidth = width;
    }

    public void setLineFadeTime(int lineFadeTime) {
        this._fade.lineFadeTime = lineFadeTime;
        this._fade.elapsed = 0;
    }

    public void tick(int elapsed) {
        this._fade.elapsed += elapsed;
    }

    public Dimension computePreferredSize(int whint, int hhint) {
        Config prefconfig;
        int hint = LabelRenderer.getWidth(whint, hhint, this._textRotation);
        if (this._prefWidth > 0) {
            hint = this._prefWidth;
        } else if (hint <= 0) {
            hint = 32766;
        }
        this._prefconfig = prefconfig = this.layoutConfig(this._prefconfig, hint);
        this._prefsize = this.computeSize(this._prefconfig);
        prefconfig.glyphs = null;
        return new Dimension(this._prefsize);
    }

    public void layout(Insets insets, int contWidth, int contHeight) {
        Config config = this.layoutConfig(this._config, LabelRenderer.getWidth(contWidth - insets.getHorizontal(), contHeight - insets.getVertical(), this._textRotation));
        Dimension size = this.computeSize(config);
        int xoff = 0;
        int yoff = 0;
        switch (this._orient) {
            case 0: {
                if (this._icon != null) {
                    this._ix = this.getXOffset(insets, contWidth, size.width);
                    this._iy = this.getYOffset(insets, contHeight, this._icon.getHeight());
                    xoff = this._icon.getWidth() + this._gap;
                }
                if (config.glyphs == null) break;
                this._tx = this.getXOffset(insets, contWidth, size.width) + xoff;
                this._ty = this.getYOffset(insets, contHeight, config.glyphs.getHeight(this._textRotation));
                break;
            }
            case 1: {
                if (config.glyphs != null) {
                    this._tx = this.getXOffset(insets, contWidth, config.glyphs.getWidth(this._textRotation));
                    this._ty = this.getYOffset(insets, contHeight, size.height);
                    yoff = config.glyphs.getHeight(this._textRotation) + this._gap;
                }
                if (this._icon == null) break;
                this._ix = this.getXOffset(insets, contWidth, this._icon.getWidth());
                this._iy = this.getYOffset(insets, contHeight, size.height) + yoff;
                break;
            }
            case 2: {
                if (this._icon != null) {
                    this._ix = this.getXOffset(insets, contWidth, this._icon.getWidth());
                    this._iy = this.getYOffset(insets, contHeight, this._icon.getHeight());
                }
                if (config.glyphs == null) break;
                this._tx = this.getXOffset(insets, contWidth, config.glyphs.getWidth(this._textRotation));
                this._ty = this.getYOffset(insets, contHeight, config.glyphs.getHeight(this._textRotation));
            }
        }
        this.useConfig(config);
    }

    public int getIconX() {
        return this._ix;
    }

    public int getIconY() {
        return this._iy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Renderer renderer, int x, int y, int contWidth, int contHeight, float alpha) {
        block7: {
            GL11.glTranslatef((float)x, (float)y, (float)0.0f);
            try {
                if (this._icon != null) {
                    this._icon.render(renderer, this._ix, this._iy, alpha);
                }
                if (this._config == null || this._config.glyphs == null) break block7;
                Dimension size = this._config.glyphs.size;
                int ox = LabelRenderer.getOffsetX(size.width, size.height, this._textRotation) + this._tx;
                int oy = LabelRenderer.getOffsetY(size.width, size.height, this._textRotation) + this._ty;
                GL11.glTranslatef((float)ox, (float)oy, (float)0.0f);
                GL11.glRotatef((float)(this._textRotation * 90), (float)0.0f, (float)0.0f, (float)1.0f);
                try {
                    this.renderText(renderer, contWidth, contHeight, alpha);
                }
                finally {
                    GL11.glRotatef((float)(this._textRotation * -90), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)(-ox), (float)(-oy), (float)0.0f);
                }
            }
            finally {
                GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderText(Renderer renderer, int contWidth, int contHeight, float alpha) {
        if (this._fit == Label.Fit.WRAP) {
            this._config.glyphs.render(renderer, 0, 0, this._container.getHorizontalAlignment(), alpha, this._config.spacing);
            return;
        }
        Insets insets = this._container.getInsets();
        int width = contWidth - insets.getHorizontal();
        int height = contHeight - insets.getVertical();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (this._fit == Label.Fit.SCALE) {
            this._config.glyphs.render(renderer, 0, 0, LabelRenderer.getWidth(width, height, this._textRotation), LabelRenderer.getHeight(width, height, this._textRotation), this._container.getHorizontalAlignment(), alpha);
            return;
        }
        Rectangle oscissor = Component.intersectScissor(renderer, this._srect, this._container.getAbsoluteX() + insets.left, this._container.getAbsoluteY() + insets.bottom, width, height);
        try {
            this._config.glyphs.render(renderer, 0, 0, this._container.getHorizontalAlignment(), alpha, this._config.spacing);
        }
        finally {
            renderer.setScissor(oscissor);
        }
    }

    protected Dimension computeSize(Config config) {
        int height;
        int width;
        int iwidth = 0;
        int iheight = 0;
        int twidth = 0;
        int theight = 0;
        int gap = 0;
        if (this._icon != null) {
            iwidth = this._icon.getWidth();
            iheight = this._icon.getHeight();
        }
        if (config.glyphs != null) {
            if (this._icon != null) {
                gap = this._gap;
            }
            twidth = config.glyphs.getWidth(this._textRotation);
            theight = config.glyphs.getHeight(this._textRotation);
        }
        switch (this._orient) {
            default: {
                width = iwidth + gap + twidth;
                height = Math.max(iheight, theight);
                break;
            }
            case 1: {
                width = Math.max(iwidth, twidth);
                height = iheight + gap + theight;
                break;
            }
            case 2: {
                width = Math.max(iwidth, twidth);
                height = Math.max(iheight, theight);
            }
        }
        return new Dimension(width, height);
    }

    protected int getXOffset(Insets insets, int contWidth, int width) {
        switch (this._container.getHorizontalAlignment()) {
            default: {
                return insets.left;
            }
            case 1: {
                return contWidth - width - insets.right;
            }
            case 2: 
        }
        return (contWidth - insets.getHorizontal() - width) / 2 + insets.left;
    }

    protected int getYOffset(Insets insets, int contHeight, int height) {
        switch (this._container.getVerticalAlignment()) {
            default: {
                return contHeight - height - insets.top;
            }
            case 1: {
                return insets.bottom;
            }
            case 2: 
        }
        return (contHeight - insets.getVertical() - height) / 2 + insets.bottom;
    }

    protected Config layoutConfig(Config oconfig, int twidth) {
        if (this._fit != Label.Fit.WRAP) {
            twidth = 32766;
        }
        if (this._value != null && this._icon != null) {
            if ((this._textRotation & 1) == 0) {
                if (this._orient == 0) {
                    twidth -= this._gap;
                    twidth -= this._icon.getWidth();
                }
            } else if (this._orient == 1) {
                twidth -= this._gap;
                twidth -= this._icon.getHeight();
            }
        }
        Config config = this._container.getLabelRendererConfig(this, twidth);
        if (oconfig != null && oconfig.glyphs != null && oconfig.matches(config, twidth)) {
            return oconfig;
        }
        if (this._value == null || this._value.equals("")) {
            return config;
        }
        if (twidth < 0) {
            Log.log.warning((Object)("Requested to layout with negative target width [text=" + this._value + ", twidth=" + twidth + "]."), new Object[]{new Exception()});
            return config;
        }
        TextFactory tfact = this._container.getTextFactory(this);
        Glyphs glyphs = new Glyphs();
        glyphs.fade = this._fade;
        glyphs.lines = tfact.wrapText(this._value, config.color, config.effect, config.effectSize, config.effectColor, twidth);
        for (int ii = 0; ii < glyphs.lines.length; ++ii) {
            glyphs.size.width = Math.max(glyphs.size.width, glyphs.lines[ii].getSize().width);
            glyphs.size.height = glyphs.size.height + (glyphs.lines[ii].getSize().height + (ii > 0 ? config.spacing : 0));
        }
        config.glyphs = glyphs;
        if (oconfig != null && oconfig.glyphs != null && oconfig.glyphs.lines.length == config.glyphs.lines.length) {
            config.minwidth = Math.min(config.minwidth, oconfig.minwidth);
            config.maxwidth = Math.max(config.maxwidth, oconfig.maxwidth);
        }
        return config;
    }

    protected void useConfig(Config config) {
        if (this._config == config) {
            return;
        }
        this._config = config;
    }

    protected static int getWidth(int width, int height, int rotation) {
        return (rotation & 1) == 0 ? width : height;
    }

    protected static int getHeight(int width, int height, int rotation) {
        return (rotation & 1) == 0 ? height : width;
    }

    protected static int getOffsetX(int width, int height, int rotation) {
        switch (rotation & 3) {
            default: {
                return 0;
            }
            case 1: {
                return height;
            }
            case 2: {
                return width;
            }
            case 3: 
        }
        return 0;
    }

    protected static int getOffsetY(int width, int height, int rotation) {
        switch (rotation & 3) {
            default: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return height;
            }
            case 3: 
        }
        return width;
    }

    protected static class Fade {
        public int lineFadeTime;
        public int elapsed;

        protected Fade() {
        }
    }

    protected static class Glyphs {
        public Text[] lines;
        public Dimension size = new Dimension();
        public Fade fade;

        protected Glyphs() {
        }

        public int getWidth(int rotation) {
            return LabelRenderer.getWidth(this.size.width, this.size.height, rotation);
        }

        public int getHeight(int rotation) {
            return LabelRenderer.getHeight(this.size.width, this.size.height, rotation);
        }

        public void render(Renderer renderer, int tx, int ty, int halign, float alpha, int spacing) {
            for (int ii = this.lines.length - 1; ii >= 0; --ii) {
                int lx = tx;
                if (halign == 1) {
                    lx += this.size.width - this.lines[ii].getSize().width;
                } else if (halign == 2) {
                    lx += (this.size.width - this.lines[ii].getSize().width) / 2;
                }
                float a = alpha;
                if (this.fade.lineFadeTime > 0) {
                    int start = ii * this.fade.lineFadeTime / 2;
                    a = start < this.fade.elapsed ? (a *= Math.min(1.0f, (float)(this.fade.elapsed - start) / (float)this.fade.lineFadeTime)) : 0.0f;
                }
                this.lines[ii].render(renderer, lx, ty, a);
                ty += this.lines[ii].getSize().height + (ii > 0 ? spacing : 0);
            }
        }

        public void render(Renderer renderer, int tx, int ty, int width, int height, int halign, float alpha) {
            float scale = 1.0f;
            if (this.size.width > width) {
                scale = (float)width / (float)this.size.width;
            }
            if (this.size.height > height) {
                scale = Math.min(scale, (float)height / (float)this.size.height);
            }
            width = (int)((float)this.size.width * scale);
            height = (int)((float)this.size.height * scale);
            if (height < this.size.height) {
                ty += (this.size.height - height) / 2;
            }
            if (halign == 1) {
                tx += this.size.width - width;
            } else if (halign == 2) {
                tx += (this.size.width - width) / 2;
            }
            this.lines[0].render(renderer, tx, ty, width, height, alpha);
        }
    }

    protected static class Config {
        public String text;
        public Color4f color;
        public int effect;
        public int effectSize;
        public Color4f effectColor;
        public int minwidth;
        public int maxwidth;
        public Glyphs glyphs;
        public int spacing;

        protected Config() {
        }

        public boolean matches(Config other, int twidth) {
            if (other == null) {
                return false;
            }
            if (this.effect != other.effect) {
                return false;
            }
            if (!(this.text == other.text || this.text != null && this.text.equals(other.text))) {
                return false;
            }
            if (!this.color.equals(other.color)) {
                return false;
            }
            if (!(this.effectColor == other.effectColor || this.effectColor != null && this.effectColor.equals(other.effectColor))) {
                return false;
            }
            if (this.effectSize != other.effectSize || this.spacing != other.spacing) {
                return false;
            }
            if (this.glyphs != null && this.glyphs.lines.length == 1 && this.minwidth <= twidth) {
                return true;
            }
            return this.minwidth <= twidth && twidth <= this.maxwidth;
        }

        public String toString() {
            return this.text + "(" + this.toString(this.color) + "," + this.effect + "," + this.toString(this.effectColor) + "," + this.minwidth + "<>" + this.maxwidth + ")";
        }

        protected String toString(Color4f color) {
            return color == null ? "null" : Integer.toHexString(color.hashCode());
        }
    }
}

