/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.threerings.editor.swing.DraggableSpinner;
import com.threerings.editor.swing.PropertyEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NumberEditor
extends PropertyEditor
implements ChangeListener {
    protected JSlider _slider;
    protected DraggableSpinner _spinner;
    protected double _step;
    protected double _scale;

    @Override
    public void stateChanged(ChangeEvent event) {
        double value;
        if (event.getSource() == this._slider) {
            value = (double)this._slider.getValue() * this._step;
            this._spinner.setValue(value);
        } else {
            value = (Double)this._spinner.getValue();
            if (this._slider != null) {
                this._slider.setValue((int)Math.round(value / this._step));
            }
        }
        Number nvalue = this.fromDouble(value * this._scale);
        if (!this._property.get(this._object).equals(nvalue)) {
            this._property.set(this._object, nvalue);
            this.fireStateChanged();
        }
    }

    @Override
    public void update() {
        double value = ((Number)this._property.get(this._object)).doubleValue() / this._scale;
        this._spinner.setValue(value);
        if (this._slider != null) {
            this._slider.setValue((int)Math.round(value / this._step));
        }
    }

    @Override
    protected void didInit() {
        this.add(new JLabel(this.getPropertyLabel() + ":"));
        double min = this.getMinimum();
        double max = this.getMaximum();
        this._step = this.getStep();
        this._scale = this.getScale();
        if (this.getMode().equals("wide") && min != -1.7976931348623157E308 && max != Double.MAX_VALUE) {
            this._slider = new JSlider((int)Math.round(min / this._step), (int)Math.round(max / this._step));
            this.add(this._slider);
            this._slider.setBackground(null);
            this._slider.addChangeListener(this);
        }
        this._spinner = new DraggableSpinner(min, min, max, this._step);
        this.add(this._spinner);
        if (this.getMode().equals("sized")) {
            ((JSpinner.NumberEditor)this._spinner.getEditor()).getTextField().setColumns(this._property.getAnnotation().width());
            this._spinner.setPreferredSize(null);
        }
        this._spinner.addChangeListener(this);
        this.addUnits((JPanel)((Object)this));
    }

    protected Number fromDouble(double value) {
        Class<?> type = this._property.getType();
        if (type == Byte.TYPE || type == Byte.class) {
            return (byte)value;
        }
        if (type == Double.TYPE || type == Double.class) {
            return value;
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf((float)value);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return (int)value;
        }
        if (type == Long.TYPE || type == Long.class) {
            return (long)value;
        }
        return (short)value;
    }
}

