package com.threerings.opengl.gui;

import java.awt.image.BufferedImage;

import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.Texture2D;

public class ScaledImage extends Image {
	
	private int _scaleWidth,_scaleHeight;
	
	public ScaledImage(BufferedImage image,int scaleWidth,int scaleHeight) {
		super(image);
		this._scaleWidth = scaleHeight;
		this._scaleHeight = scaleHeight;
	}


    public ScaledImage (Texture2D texture,int scaleWidth,int scaleHeight)
    {
        super(texture);
        this._scaleWidth = scaleHeight;
		this._scaleHeight = scaleHeight;
    }
    
    public void render (
            Renderer renderer, int sx, int sy, int swidth, int sheight,
            int tx, int ty, int twidth, int theight, Color4f color, float alpha){
    	super.render(renderer, sx, sy, swidth, sheight, tx, ty, _scaleWidth, _scaleHeight, color, alpha);
    }
}
