/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.util;

import com.samskivert.util.IntTuple;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.tudey.config.GroundConfig;
import com.threerings.tudey.config.TileConfig;
import com.threerings.tudey.config.WallConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.util.Coord;
import com.threerings.tudey.util.CoordSet;
import com.threerings.tudey.util.Direction;
import com.threerings.tudey.util.EntryManipulator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TilePainter {
    protected ConfigManager _cfgmgr;
    protected TudeySceneModel _scene;
    protected EntryManipulator _manipulator;

    public TilePainter(ConfigManager cfgmgr, TudeySceneModel scene, EntryManipulator manipulator) {
        this._cfgmgr = cfgmgr;
        this._scene = scene;
        this._manipulator = manipulator;
    }

    public void paintGround(CoordSet coords, ConfigReference<GroundConfig> ground, int elevation) {
        this.paintGround(coords, ground, elevation, false, false);
    }

    public void paintGround(CoordSet coords, ConfigReference<GroundConfig> ground, int elevation, boolean erase, boolean revise) {
        GroundConfig.Original original;
        GroundConfig config = this._cfgmgr.getConfig(GroundConfig.class, ground);
        GroundConfig.Original original2 = original = config == null ? null : config.getOriginal(this._cfgmgr);
        if (original == null) {
            this.removeEntries(coords);
            return;
        }
        if (erase) {
            this.removeEntries(coords);
            CoordSet border = coords.getBorder();
            this.removeEntries(border);
            this.updateGroundEdges(border, coords, ground, elevation, revise);
            return;
        }
        if (original.extendEdge) {
            coords.addAll(coords.getCardinalBorder());
        }
        Iterator<Coord> it = coords.iterator();
        while (it.hasNext()) {
            GroundConfig oconfig;
            GroundConfig.Original ooriginal;
            Coord coord = it.next();
            TudeySceneModel.Paint paint = this._scene.getPaint(coord.x, coord.y);
            if (paint == null || paint.type == TudeySceneModel.Paint.Type.WALL || (ooriginal = (oconfig = paint.getConfig(this._cfgmgr, GroundConfig.class)) == null ? null : oconfig.getOriginal(this._cfgmgr)) == null || ooriginal.priority <= original.priority) continue;
            it.remove();
        }
        CoordSet inner = new CoordSet(coords);
        CoordSet border = inner.getBorder();
        coords.removeAll(border);
        if (!revise) {
            Iterator<Coord> it2 = coords.iterator();
            while (it2.hasNext()) {
                Coord coord = it2.next();
                if (!original.isFloor(this._scene, ground, coord.x, coord.y, elevation)) continue;
                it2.remove();
            }
        }
        this.paintFloor(coords, ground, elevation);
        this.updateGroundEdges(inner.getBorder(), inner, ground, elevation, revise);
    }

    public void paintWall(CoordSet coords, ConfigReference<WallConfig> wall, int elevation) {
        this.paintWall(coords, wall, elevation, false, false);
    }

    public void paintWall(CoordSet coords, ConfigReference<WallConfig> wall, int elevation, boolean erase, boolean revise) {
        IntTuple tuple;
        WallConfig.Original original;
        WallConfig config = this._cfgmgr.getConfig(WallConfig.class, wall);
        WallConfig.Original original2 = original = config == null ? null : config.getOriginal(this._cfgmgr);
        if (original == null) {
            this.removeEntries(coords);
            return;
        }
        CoordSet ocoords = new CoordSet(coords);
        coords.addAll(coords.getBorder());
        CoordSet wcoords = new CoordSet();
        if (erase) {
            Iterator<Coord> it = ocoords.iterator();
            while (it.hasNext()) {
                Coord coord = it.next();
                if (original.isWall(this._scene.getTileEntry(coord.x, coord.y), elevation)) continue;
                it.remove();
            }
            this.paintFloor(ocoords, original.ground, elevation);
        } else {
            wcoords.addAll(ocoords);
        }
        HashMap<IntTuple, CoordSet> sets = new HashMap<IntTuple, CoordSet>();
        for (Coord coord : coords) {
            TudeySceneModel.TileEntry entry = this._scene.getTileEntry(coord.x, coord.y);
            if (!wcoords.contains(coord) && !original.isWall(entry, elevation)) continue;
            int pattern = 0;
            for (Direction dir : Direction.CARDINAL_VALUES) {
                int y;
                int x = coord.x + dir.getX();
                if (!wcoords.contains(x, y = coord.y + dir.getY()) && !original.isWall(this._scene.getTileEntry(x, y), elevation)) continue;
                pattern |= 1 << dir.ordinal();
            }
            tuple = original.getWallCaseRotations(pattern);
            if (tuple == null || !revise && original.isWall(entry, tuple, elevation)) continue;
            CoordSet set = (CoordSet)sets.get(tuple);
            if (set == null) {
                set = new CoordSet();
                sets.put(tuple, set);
            }
            set.add(coord);
        }
        Rectangle region = new Rectangle();
        TudeySceneModel.Paint paint = new TudeySceneModel.Paint(TudeySceneModel.Paint.Type.WALL, wall, elevation);
        block3: for (Map.Entry entry : sets.entrySet()) {
            tuple = (IntTuple)entry.getKey();
            CoordSet set = (CoordSet)entry.getValue();
            while (!set.isEmpty()) {
                set.getLargestRegion(region);
                TudeySceneModel.TileEntry tentry = original.createWall(this._cfgmgr, tuple, region.width, region.height, elevation);
                if (tentry == null) continue block3;
                Coord coord = tentry.getLocation();
                set.pickRandom(region.width, region.height, coord);
                TileConfig.Original tconfig = tentry.getConfig(this._cfgmgr);
                int twidth = tentry.getWidth(tconfig);
                int theight = tentry.getHeight(tconfig);
                this.addEntry(tentry, region.set(coord.x, coord.y, twidth, theight), paint);
                set.removeAll(region);
            }
        }
    }

    protected void paintFloor(CoordSet coords, ConfigReference<GroundConfig> ground, int elevation) {
        GroundConfig.Original original;
        GroundConfig config = this._cfgmgr.getConfig(GroundConfig.class, ground);
        GroundConfig.Original original2 = original = config == null ? null : config.getOriginal(this._cfgmgr);
        if (original == null) {
            this.removeEntries(coords);
            return;
        }
        Rectangle region = new Rectangle();
        TudeySceneModel.Paint paint = new TudeySceneModel.Paint(TudeySceneModel.Paint.Type.FLOOR, ground, elevation);
        while (!coords.isEmpty()) {
            coords.getLargestRegion(region);
            TudeySceneModel.TileEntry entry = original.createFloor(this._cfgmgr, region.width, region.height, elevation);
            if (entry == null) break;
            Coord coord = entry.getLocation();
            coords.pickRandom(region.width, region.height, coord);
            TileConfig.Original tconfig = entry.getConfig(this._cfgmgr);
            int twidth = entry.getWidth(tconfig);
            int theight = entry.getHeight(tconfig);
            this.addEntry(entry, region.set(coord.x, coord.y, twidth, theight), paint);
            coords.removeAll(region);
        }
    }

    protected void updateGroundEdges(CoordSet coords, CoordSet inner, ConfigReference<GroundConfig> ground, int elevation, boolean revise) {
        GroundConfig.Original original;
        GroundConfig config = this._cfgmgr.getConfig(GroundConfig.class, ground);
        GroundConfig.Original original2 = original = config == null ? null : config.getOriginal(this._cfgmgr);
        if (original == null) {
            this.removeEntries(coords);
            return;
        }
        HashMap<IntTuple, CoordSet> sets = new HashMap<IntTuple, CoordSet>();
        for (Coord coord : coords) {
            IntTuple tuple;
            GroundConfig oconfig;
            GroundConfig.Original ooriginal;
            TudeySceneModel.Paint paint;
            TudeySceneModel.TileEntry entry = this._scene.getTileEntry(coord.x, coord.y);
            if (entry != null && !original.isEdge(entry, elevation) && ((paint = this._scene.getPaint(coord.x, coord.y)) == null || paint.type == TudeySceneModel.Paint.Type.WALL || (ooriginal = (oconfig = paint.getConfig(this._cfgmgr, GroundConfig.class)) == null ? null : oconfig.getOriginal(this._cfgmgr)) == null || ooriginal.priority >= original.priority) || (tuple = original.getEdgeCaseRotations(this._scene, ground, coord.x, coord.y, elevation)) == null || !revise && original.isEdge(entry, tuple, elevation)) continue;
            CoordSet set = (CoordSet)sets.get(tuple);
            if (set == null) {
                set = new CoordSet();
                sets.put(tuple, set);
            }
            set.add(coord);
        }
        Rectangle region = new Rectangle();
        TudeySceneModel.Paint paint = new TudeySceneModel.Paint(TudeySceneModel.Paint.Type.EDGE, ground, elevation);
        block1: for (Map.Entry entry : sets.entrySet()) {
            IntTuple tuple = (IntTuple)entry.getKey();
            CoordSet set = (CoordSet)entry.getValue();
            while (!set.isEmpty()) {
                set.getLargestRegion(region);
                TudeySceneModel.TileEntry tentry = original.createEdge(this._cfgmgr, tuple, region.width, region.height, elevation);
                if (tentry == null) continue block1;
                Coord coord = tentry.getLocation();
                set.pickRandom(region.width, region.height, coord);
                TileConfig.Original tconfig = tentry.getConfig(this._cfgmgr);
                int twidth = tentry.getWidth(tconfig);
                int theight = tentry.getHeight(tconfig);
                this.addEntry(tentry, region.set(coord.x, coord.y, twidth, theight), paint);
                set.removeAll(region);
            }
        }
        if (original.base != null) {
            CoordSet combined = new CoordSet(inner);
            combined.addAll(coords);
            this.updateGroundEdges(combined.getBorder(), combined, original.base, elevation, revise);
        }
    }

    protected void addEntry(TudeySceneModel.TileEntry entry, Rectangle region, TudeySceneModel.Paint paint) {
        this.removeEntries(region);
        this._manipulator.addEntries(entry);
        this._manipulator.setPaint(region, paint);
    }

    protected void removeEntries(Rectangle region) {
        ArrayList<TudeySceneModel.TileEntry> results = new ArrayList<TudeySceneModel.TileEntry>();
        this._scene.getTileEntries(region, results);
        this._manipulator.removeEntries(results);
    }

    protected void removeEntries(CoordSet coords) {
        ArrayList<TudeySceneModel.TileEntry> list = new ArrayList<TudeySceneModel.TileEntry>();
        for (Coord coord : coords) {
            TudeySceneModel.TileEntry entry = this._scene.getTileEntry(coord.x, coord.y);
            if (entry == null) continue;
            list.add(entry);
        }
        this._manipulator.removeEntries(list);
    }
}

