/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.util.Interval;
import com.threerings.config.ConfigManager;
import com.threerings.crowd.data.OccupantInfo;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.presents.dobj.EntryAddedEvent;
import com.threerings.presents.dobj.EntryRemovedEvent;
import com.threerings.presents.dobj.NamedSetAdapter;
import com.threerings.tudey.Log;
import com.threerings.tudey.config.HandlerConfig;
import com.threerings.tudey.config.ParameterizedHandlerConfig;
import com.threerings.tudey.data.EntityKey;
import com.threerings.tudey.data.TudeyOccupantInfo;
import com.threerings.tudey.server.TudeySceneManager;
import com.threerings.tudey.server.logic.ActionLogic;
import com.threerings.tudey.server.logic.ActorLogic;
import com.threerings.tudey.server.logic.ConditionLogic;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.server.logic.PawnLogic;
import com.threerings.tudey.server.logic.TargetLogic;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.shape.ShapeElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public abstract class HandlerLogic
extends Logic {
    protected HandlerConfig _config;
    protected Logic _source;

    public void init(TudeySceneManager scenemgr, HandlerConfig config, Logic source) {
        super.init(scenemgr);
        this._config = config;
        this._source = source;
        this.didInit();
    }

    public void startup(int timestamp) {
    }

    public void shutdown(int timestamp, Logic activator) {
    }

    public void variableChanged(int timestamp, Logic activator, String name) {
    }

    public void removed() {
        this.wasRemoved();
    }

    @Override
    public boolean isActive() {
        return this._source.isActive();
    }

    @Override
    public EntityKey getEntityKey() {
        return this._source.getEntityKey();
    }

    @Override
    public Vector2f getTranslation() {
        return this._source.getTranslation();
    }

    @Override
    public float getRotation() {
        return this._source.getRotation();
    }

    protected void didInit() {
    }

    protected void wasRemoved() {
    }

    protected static class ActionHandlerLogic
    extends HandlerLogic {
        protected ActionLogic _action;

        protected ActionHandlerLogic() {
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._action.transfer(((ActionHandlerLogic)source)._action, refs);
        }

        @Override
        protected void didInit() {
            super.didInit();
            this._action = this.createAction(((HandlerConfig.ActionHandlerConfig)this._config).action, this._source);
            if (this._action == null) {
                Log.log.warning((Object)("action is null,source=" + this._source + ", handler class=" + this._config.getLogicClassName()), new Object[0]);
            }
        }

        protected void execute(int timestamp) {
            this.execute(timestamp, this._source);
        }

        protected void execute(int timestamp, Logic activator) {
            if (this._action != null) {
                this._action.execute(timestamp, activator);
            } else {
                Log.log.warning((Object)("action is null,source=" + this._source + ", handler class=" + this._config.getLogicClassName()), new Object[0]);
            }
        }

        @Override
        protected void wasRemoved() {
            if (this._action != null) {
                this._action.removed();
            }
        }
    }

    public static class VariableChanged
    extends ActionHandlerLogic {
        @Override
        public void variableChanged(int timestamp, Logic activator, String name) {
            this.execute(timestamp, activator);
        }
    }

    public static class BodyLeft
    extends BaseBodyObserver {
        @Override
        protected void bodyLeft(int pawnId) {
            ActorLogic logic = this._scenemgr.getActorLogic(pawnId);
            if (logic != null) {
                this.execute(this._scenemgr.getTimestamp(), logic);
            }
        }
    }

    public static class BodyEntered
    extends BaseBodyObserver {
        @Override
        protected void bodyEntered(int pawnId) {
            ActorLogic logic = this._scenemgr.getActorLogic(pawnId);
            if (logic != null) {
                this.execute(this._scenemgr.getTimestamp(), logic);
            }
        }
    }

    public static abstract class BaseBodyObserver
    extends ActionHandlerLogic {
        protected NamedSetAdapter<OccupantInfo> _placelist = new NamedSetAdapter<OccupantInfo>("occupantInfo"){

            public void namedEntryAdded(EntryAddedEvent<OccupantInfo> event) {
                BaseBodyObserver.this.bodyEntered(((TudeyOccupantInfo)event.getEntry()).pawnId);
            }

            public void namedEntryRemoved(EntryRemovedEvent<OccupantInfo> event) {
                BaseBodyObserver.this.bodyLeft(((TudeyOccupantInfo)event.getOldEntry()).pawnId);
            }
        };

        @Override
        public void startup(int timestamp) {
            this._scenemgr.getPlaceObject().addListener(this._placelist);
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this.startup(0);
        }

        @Override
        public void shutdown(int timestamp, Logic activator) {
            this._scenemgr.getPlaceObject().removeListener(this._placelist);
        }

        protected void bodyEntered(int pawnId) {
        }

        protected void bodyLeft(int pawnId) {
        }
    }

    public static class ActorRemoved
    extends BaseActorObserver {
        @Override
        protected void targetActorRemoved(ActorLogic logic) {
            if (this._lastCount == 1 || !((HandlerConfig.ActorRemoved)this._config).all) {
                this.execute(this._scenemgr.getTimestamp(), logic);
            }
        }
    }

    public static class ActorAdded
    extends BaseActorObserver {
        @Override
        protected void targetActorAdded(ActorLogic logic) {
            this.execute(this._scenemgr.getTimestamp(), logic);
        }
    }

    public static abstract class BaseActorObserver
    extends ActionHandlerLogic
    implements TudeySceneManager.ActorObserver {
        protected TargetLogic _target;
        protected ArrayList<Logic> _targets = Lists.newArrayList();
        protected int _lastCount;

        @Override
        public void actorAdded(ActorLogic logic) {
            this._target.resolve(logic, this._targets);
            int count = this._targets.size();
            if (count > this._lastCount) {
                this.targetActorAdded(logic);
                this._lastCount = count;
            }
            this._targets.clear();
        }

        @Override
        public void actorRemoved(ActorLogic logic) {
            if (this._lastCount > 0) {
                this._target.resolve(logic, this._targets);
                int count = this._targets.size();
                if (count < this._lastCount) {
                    this.targetActorRemoved(logic);
                    this._lastCount = count;
                }
                this._targets.clear();
            }
        }

        @Override
        public void startup(int timestamp) {
            this._target.resolve(this._source, this._targets);
            this._lastCount = this._targets.size();
            this._targets.clear();
            this._scenemgr.addActorObserver(this);
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._target.transfer(((BaseActorObserver)source)._target, refs);
            this.startup(0);
        }

        @Override
        public void shutdown(int timestamp, Logic activator) {
            this._scenemgr.removeActorObserver(this);
        }

        @Override
        protected void didInit() {
            super.didInit();
            this._target = this.createTarget(((HandlerConfig.BaseActorObserver)this._config).target, this._source);
        }

        protected void targetActorAdded(ActorLogic logic) {
        }

        protected void targetActorRemoved(ActorLogic logic) {
        }
    }

    public static class Request
    extends ActionHandlerLogic {
        @Override
        public void request(int timestamp, PawnLogic source, String name) {
            HandlerConfig.Request config = (HandlerConfig.Request)this._config;
            if (config.name.equals(name)) {
                this.execute(timestamp, source);
            }
        }
    }

    public static class ThresholdIntersectionCount
    extends BaseIntersectionCount {
        protected ActionLogic _underAction;

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            if (this._underAction != null) {
                this._underAction.transfer(((ThresholdIntersectionCount)source)._underAction, refs);
            }
        }

        @Override
        protected void didInit() {
            super.didInit();
            HandlerConfig.ThresholdIntersectionCount config = (HandlerConfig.ThresholdIntersectionCount)this._config;
            if (config.underAction != null) {
                this._underAction = this.createAction(config.underAction, this._source);
            }
        }

        @Override
        protected void countChanged(int timestamp, int newCount) {
            HandlerConfig.ThresholdIntersectionCount config = (HandlerConfig.ThresholdIntersectionCount)this._config;
            if (this._lastCount < config.threshold && newCount >= config.threshold) {
                this.execute(timestamp);
            } else if (this._underAction != null && this._lastCount >= config.threshold && newCount < config.threshold) {
                this._underAction.execute(timestamp, this._source);
            }
        }
    }

    public static abstract class BaseIntersectionCount
    extends BaseIntersection
    implements TudeySceneManager.IntersectionSensor {
        protected ConditionLogic _condition;
        protected int _lastCount = -1;

        public BaseIntersectionCount() {
            super(false, false);
        }

        @Override
        public int getMask() {
            return ((HandlerConfig.BaseIntersectionCount)this._config).mask;
        }

        @Override
        public void trigger(int timestamp, ActorLogic actor) {
            if (this._condition.isSatisfied(actor)) {
                this.activate(timestamp, actor);
            }
        }

        @Override
        public boolean tick(int timestamp) {
            super.tick(timestamp);
            int size = this._activated.size();
            if (this._lastCount != size) {
                this.countChanged(timestamp, size);
                this._lastCount = size;
            }
            return this._lastCount != 0;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            BaseIntersectionCount bsource = (BaseIntersectionCount)source;
            this._condition.transfer(bsource._condition, refs);
            this._lastCount = bsource._lastCount;
        }

        @Override
        protected void didInit() {
            super.didInit();
            this._condition = this.createCondition(((HandlerConfig.BaseIntersectionCount)this._config).condition, this._source);
        }

        protected abstract void countChanged(int var1, int var2);
    }

    public static class IntersectionStop
    extends BaseIntersection
    implements TudeySceneManager.IntersectionSensor {
        public IntersectionStop() {
            super(false, true);
        }

        @Override
        public int getMask() {
            return ((HandlerConfig.IntersectionStop)this._config).mask;
        }

        @Override
        public void trigger(int timestamp, ActorLogic actor) {
            this.activate(timestamp, actor);
        }
    }

    public static class IntersectionStart
    extends BaseIntersection
    implements TudeySceneManager.IntersectionSensor {
        public IntersectionStart() {
            super(true, false);
        }

        @Override
        public int getMask() {
            return ((HandlerConfig.IntersectionStart)this._config).mask;
        }

        @Override
        public void trigger(int timestamp, ActorLogic actor) {
            this.activate(timestamp, actor);
        }
    }

    public static class Intersection
    extends BaseIntersection
    implements TudeySceneManager.IntersectionSensor {
        protected int _minTimestamp;

        public Intersection() {
            super(false, false);
        }

        @Override
        public int getMask() {
            return ((HandlerConfig.Intersection)this._config).mask;
        }

        @Override
        public void trigger(int timestamp, ActorLogic actor) {
            if (timestamp >= this._minTimestamp) {
                this.execute(timestamp, actor);
                this._minTimestamp = Math.round((float)timestamp + ((HandlerConfig.Intersection)this._config).refractoryPeriod * 1000.0f);
            }
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._minTimestamp = ((Intersection)source)._minTimestamp;
        }
    }

    public static abstract class BaseIntersection
    extends Transition
    implements Logic.ShapeObserver {
        protected ShapeElement _shape;
        protected Transform2D _transform = new Transform2D();

        public BaseIntersection(boolean start, boolean stop) {
            super(start, stop);
        }

        @Override
        public void shapeWillChange(Logic source) {
        }

        @Override
        public void shapeDidChange(Logic source) {
            Shape shape = ((HandlerConfig.BaseIntersection)this._config).shape.getShape(this._source.getShape(), this._source.getTransform(this._transform), this._shape.getLocalShape());
            this._shape.setLocalShape(shape);
        }

        @Override
        public void startup(int timestamp) {
            Shape shape = ((HandlerConfig.BaseIntersection)this._config).shape.getShape(this._source.getShape(), this._source.getTransform(this._transform), null);
            if (shape == null) {
                return;
            }
            this._shape = new ShapeElement(shape);
            this._shape.setUserObject(this);
            this._scenemgr.getSensorSpace().add(this._shape);
            this._source.addShapeObserver(this);
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, (Map)refs);
            this.startup(0);
        }

        @Override
        public void shutdown(int timestamp, Logic activator) {
            if (this._shape != null) {
                this._scenemgr.getSensorSpace().remove(this._shape);
                this._source.removeShapeObserver(this);
            }
        }
    }

    public static class SignalStop
    extends Transition {
        public SignalStop() {
            super(false, true);
        }

        @Override
        public void signal(int timestamp, Logic source, String name) {
            if (((HandlerConfig.SignalStop)this._config).name.equals(name)) {
                this.activate(timestamp, source);
            }
        }
    }

    public static class SignalStart
    extends Transition {
        public SignalStart() {
            super(true, false);
        }

        @Override
        public void signal(int timestamp, Logic source, String name) {
            if (((HandlerConfig.SignalStart)this._config).name.equals(name)) {
                this.activate(timestamp, source);
            }
        }
    }

    public static abstract class Transition
    extends ActionHandlerLogic
    implements TudeySceneManager.TickParticipant {
        protected boolean _start;
        protected boolean _stop;
        protected boolean _added;
        protected Map<Logic, Boolean> _activated = Maps.newIdentityHashMap();

        public Transition(boolean start, boolean stop) {
            this._start = start;
            this._stop = stop;
        }

        @Override
        public boolean tick(int timestamp) {
            Iterator<Map.Entry<Logic, Boolean>> it = this._activated.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Logic, Boolean> entry = it.next();
                if (entry.getValue().booleanValue()) {
                    entry.setValue(false);
                    continue;
                }
                if (this._stop) {
                    this.execute(timestamp, entry.getKey());
                }
                it.remove();
            }
            this._added = !this._activated.isEmpty();
            return this._added;
        }

        @Override
        public void shutdown(int timestamp, Logic activator) {
            this._scenemgr.removeTickParticipant(this);
            this._added = false;
        }

        protected void activate(int timestamp, Logic source) {
            Boolean oldVal;
            if (!this._added) {
                this._scenemgr.addTickParticipant(this);
                this._added = true;
            }
            if ((oldVal = this._activated.put(source, true)) == null && this._start) {
                this.execute(timestamp, source);
            }
        }
    }

    public static class Signal
    extends ActionHandlerLogic {
        protected int _minTimestamp;

        @Override
        public void signal(int timestamp, Logic source, String name) {
            HandlerConfig.Signal config = (HandlerConfig.Signal)this._config;
            if (config.name.equals(name) && timestamp >= this._minTimestamp) {
                this.execute(timestamp, source);
                this._minTimestamp = Math.round((float)timestamp + config.refractoryPeriod * 1000.0f);
            }
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._minTimestamp = ((Signal)source)._minTimestamp;
        }
    }

    public static class WarnTimer
    extends Timer {
        protected ActionLogic _warnAction;
        protected Interval _warnInterval;

        @Override
        public void startup(int timestamp) {
            super.startup(timestamp);
            final HandlerConfig.WarnTimer config = (HandlerConfig.WarnTimer)this._config;
            if (config.warn == 0.0f || config.warn > config.interval) {
                return;
            }
            float initialDelay = config.interval - config.warn + config.offset;
            this._warnInterval = new Interval(this._scenemgr){

                public void expired() {
                    WarnTimer.this._warnAction.execute(WarnTimer.this._scenemgr.getTimestamp(), WarnTimer.this._source);
                    if (WarnTimer.this._limit > 1 && WarnTimer.this._warnInterval != null) {
                        this.schedule((long)(config.interval * 1000.0f));
                    }
                }
            };
            this._warnInterval.schedule((long)(initialDelay * 1000.0f));
        }

        @Override
        public void shutdown(int timestamp, Logic activator) {
            super.shutdown(timestamp, activator);
            if (this._warnInterval != null) {
                this._warnInterval.cancel();
                this._warnInterval = null;
            }
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            if (this._warnAction != null) {
                this._warnAction.transfer(((WarnTimer)source)._warnAction, refs);
            }
        }

        @Override
        protected void didInit() {
            super.didInit();
            HandlerConfig.WarnTimer config = (HandlerConfig.WarnTimer)this._config;
            if (config.warnAction != null) {
                this._warnAction = this.createAction(config.warnAction, this._source);
            }
        }
    }

    public static class Timer
    extends ActionHandlerLogic {
        protected int _limit;
        protected Interval _interval;

        @Override
        public void startup(int timestamp) {
            final HandlerConfig.Timer config = (HandlerConfig.Timer)this._config;
            this._limit = config.limit == 0 ? Integer.MAX_VALUE : config.limit;
            float initialDelay = Math.max(0.0f, config.interval + config.offset);
            this._interval = new Interval(this._scenemgr){

                public void expired() {
                    Timer.this.execute(Timer.this._scenemgr.getTimestamp());
                    if (--Timer.this._limit > 0 && Timer.this._interval != null) {
                        this.schedule((long)(config.interval * 1000.0f));
                    }
                }
            };
            if (config.onStart) {
                this._interval.schedule((long)(config.offset * 1000.0f));
            } else {
                this._interval.schedule((long)(initialDelay * 1000.0f));
            }
        }

        @Override
        public void shutdown(int timestamp, Logic activator) {
            if (this._interval != null) {
                this._interval.cancel();
                this._interval = null;
            }
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this.startup(0);
            this._limit = ((Timer)source)._limit;
        }
    }

    public static class Tick
    extends ActionHandlerLogic
    implements TudeySceneManager.TickParticipant {
        @Override
        public boolean tick(int timestamp) {
            this.execute(timestamp);
            return true;
        }

        @Override
        public void startup(int timestamp) {
            this._scenemgr.addTickParticipant(this);
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._scenemgr.addTickParticipant(this);
        }

        @Override
        public void shutdown(int timestamp, Logic activator) {
            this._scenemgr.removeTickParticipant(this);
        }
    }

    public static class Reference
    extends HandlerLogic {
        protected HandlerLogic _handler;

        @Override
        public void startup(int timestamp) {
            if (this._handler != null) {
                this._handler.startup(timestamp);
            }
        }

        @Override
        public void shutdown(int timestamp, Logic activator) {
            if (this._handler != null) {
                this._handler.shutdown(timestamp, activator);
            }
        }

        @Override
        public void variableChanged(int timestamp, Logic activator, String name) {
            if (this._handler != null) {
                this._handler.variableChanged(timestamp, activator, name);
            }
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            if (this._handler != null) {
                this._handler.transfer(((Reference)source)._handler, refs);
            }
        }

        @Override
        protected void didInit() {
            ConfigManager cfgmgr = this._scenemgr.getConfigManager();
            ParameterizedHandlerConfig config = cfgmgr.getConfig(ParameterizedHandlerConfig.class, ((HandlerConfig.Reference)this._config).handler);
            ParameterizedHandlerConfig.Original original = config == null ? null : config.getOriginal(cfgmgr);
            this._handler = original == null ? null : this.createHandler(original.handler, this._source);
        }

        @Override
        protected void wasRemoved() {
            if (this._handler != null) {
                this._handler.wasRemoved();
            }
        }
    }

    public static class Shutdown
    extends ActionHandlerLogic {
        @Override
        public void shutdown(int timestamp, Logic activator) {
            this.execute(timestamp, activator);
        }
    }

    public static class Startup
    extends ActionHandlerLogic {
        @Override
        public void startup(int timestamp) {
            this.execute(timestamp);
        }
    }
}

