/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.threerings.config.ConfigManager;
import com.threerings.crowd.client.PlaceView;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.math.FloatMath;
import com.threerings.math.Rect;
import com.threerings.math.Vector2f;
import com.threerings.opengl.gui.Image;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.Texture2D;
import com.threerings.opengl.renderer.TextureUnit;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.config.PlaceableConfig;
import com.threerings.tudey.config.TileConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.shape.Polygon;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.space.SpaceElement;
import com.threerings.tudey.util.Coord;
import com.threerings.tudey.util.CoordIntMap;
import com.threerings.tudey.util.TudeyContext;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.GL11;

public class SceneMap
implements PlaceView,
TudeySceneModel.Observer {
    protected TudeyContext _ctx;
    protected TudeySceneView _view;
    protected TudeySceneModel _sceneModel;
    protected CoordIntMap _types = new CoordIntMap();
    protected Map<Coord, Texture2D> _textures = Maps.newHashMap();
    protected byte[] _floorColor;
    protected byte[] _wallColor;
    protected int _flagMask = -1;
    protected TextureUnit[] _unmasked = new TextureUnit[]{new TextureUnit()};
    protected TextureUnit[] _masked = new TextureUnit[]{new TextureUnit(), new TextureUnit()};
    protected Coord _coord = new Coord();
    protected Rectangle _region = new Rectangle();
    protected Polygon _quad = new Polygon(4);
    protected SoftReference<ByteBuffer> _buf;
    protected List<SpaceElement> _elements = Lists.newArrayList();
    protected static final int TEXTURE_POT = 8;
    protected static final int TEXTURE_SIZE = 256;
    protected static final int TEXTURE_MASK = 255;
    protected static final byte[] EMPTY_COLOR = new byte[]{0, 0, 0, 0};

    public SceneMap(TudeyContext ctx, TudeySceneView view) {
        this._ctx = ctx;
        this._view = view;
        this.setColors(Color4f.GRAY, Color4f.WHITE);
    }

    public void setColors(Color4f floor, Color4f wall) {
        this._floorColor = SceneMap.getBytes(floor);
        this._wallColor = SceneMap.getBytes(wall);
    }

    public void setCollisionFlagMask(int flagMask) {
        this._flagMask = flagMask;
    }

    public void render(float sx, float sy, float swidth, float sheight, int tx, int ty, int twidth, int theight, float alpha, Image mask) {
        Renderer renderer = this._ctx.getRenderer();
        renderer.setColorState(alpha, alpha, alpha, alpha);
        float mwidth = 1.0f;
        float mheight = 1.0f;
        if (mask != null) {
            Texture2D mtex = mask.getTexture(renderer);
            this._masked[1].setTexture(mtex);
            mwidth = (float)mask.getWidth() / (float)mtex.getWidth();
            mheight = (float)mask.getHeight() / (float)mtex.getHeight();
        }
        int xmin = FloatMath.ifloor(sx / 256.0f);
        int ymin = FloatMath.ifloor(sy / 256.0f);
        int xmax = FloatMath.ifloor((sx + swidth - 1.0f) / 256.0f);
        int ymax = FloatMath.ifloor((sy + sheight - 1.0f) / 256.0f);
        for (int yy = ymin; yy <= ymax; ++yy) {
            for (int xx = xmin; xx <= xmax; ++xx) {
                Texture2D texture = this._textures.get(this._coord.set(xx, yy));
                if (texture == null) continue;
                float bx1 = xx << 8;
                float bx2 = xx + 1 << 8;
                float by1 = yy << 8;
                float by2 = yy + 1 << 8;
                float ix1 = Math.max(sx, bx1);
                float ix2 = Math.min(sx + swidth, bx2);
                float iy1 = Math.max(sy, by1);
                float iy2 = Math.min(sy + sheight, by2);
                float ls = (ix1 - bx1) / 256.0f;
                float us = (ix2 - bx1) / 256.0f;
                float lt = (iy1 - by1) / 256.0f;
                float ut = (iy2 - by1) / 256.0f;
                float lx = (ix1 - sx) / swidth;
                float ux = (ix2 - sx) / swidth;
                float ly = (iy1 - sy) / sheight;
                float uy = (iy2 - sy) / sheight;
                float mls = lx * mwidth;
                float mus = ux * mwidth;
                float mlt = ly * mheight;
                float mut = uy * mheight;
                lx = lx * (float)twidth + (float)tx;
                ux = ux * (float)twidth + (float)tx;
                ly = ly * (float)theight + (float)ty;
                uy = uy * (float)theight + (float)ty;
                TextureUnit[] units = mask == null ? this._unmasked : this._masked;
                units[0].setTexture(texture);
                renderer.setTextureState(units);
                GL11.glBegin((int)7);
                if (mask == null) {
                    GL11.glTexCoord2f((float)ls, (float)lt);
                    GL11.glVertex2f((float)lx, (float)ly);
                    GL11.glTexCoord2f((float)us, (float)lt);
                    GL11.glVertex2f((float)ux, (float)ly);
                    GL11.glTexCoord2f((float)us, (float)ut);
                    GL11.glVertex2f((float)ux, (float)uy);
                    GL11.glTexCoord2f((float)ls, (float)ut);
                    GL11.glVertex2f((float)lx, (float)uy);
                } else {
                    GL11.glTexCoord2f((float)ls, (float)lt);
                    ARBMultitexture.glMultiTexCoord2fARB((int)33985, (float)mls, (float)mlt);
                    GL11.glVertex2f((float)lx, (float)ly);
                    GL11.glTexCoord2f((float)us, (float)lt);
                    ARBMultitexture.glMultiTexCoord2fARB((int)33985, (float)mus, (float)mlt);
                    GL11.glVertex2f((float)ux, (float)ly);
                    GL11.glTexCoord2f((float)us, (float)ut);
                    ARBMultitexture.glMultiTexCoord2fARB((int)33985, (float)mus, (float)mut);
                    GL11.glVertex2f((float)ux, (float)uy);
                    GL11.glTexCoord2f((float)ls, (float)ut);
                    ARBMultitexture.glMultiTexCoord2fARB((int)33985, (float)mls, (float)mut);
                    GL11.glVertex2f((float)lx, (float)uy);
                }
                GL11.glEnd();
                renderer.setMatrixMode(5888);
            }
        }
    }

    public void willEnterPlace(PlaceObject plobj) {
        this._sceneModel = (TudeySceneModel)this._ctx.getSceneDirector().getScene().getSceneModel();
        this._sceneModel.addObserver(this);
        this.build();
    }

    public void didLeavePlace(PlaceObject plobj) {
        this._sceneModel.removeObserver(this);
    }

    @Override
    public void entryAdded(TudeySceneModel.Entry entry) {
        this.addEntry(entry, true);
    }

    @Override
    public void entryUpdated(TudeySceneModel.Entry oentry, TudeySceneModel.Entry nentry) {
        this.removeEntry(oentry, true);
        this.addEntry(nentry, true);
    }

    @Override
    public void entryRemoved(TudeySceneModel.Entry oentry) {
        this.removeEntry(oentry, true);
    }

    protected void build() {
        for (TudeySceneModel.Entry entry : this._sceneModel.getEntries()) {
            this.addEntry(entry, false);
        }
        for (Coord coord : this._types.keySet()) {
            this._coord.set(coord.x >> 8, coord.y >> 8);
            if (this._textures.containsKey(this._coord)) continue;
            this.buildTexture(this._coord.x, this._coord.y);
        }
    }

    protected void addEntry(TudeySceneModel.Entry entry, boolean retexture) {
        Shape shape;
        if (entry instanceof TudeySceneModel.TileEntry) {
            int yy;
            TudeySceneModel.TileEntry tentry = (TudeySceneModel.TileEntry)entry;
            TileConfig.Original config = tentry.getConfig(this._sceneModel.getConfigManager());
            tentry.getRegion(config, this._region);
            int yymax = yy + this._region.height;
            for (yy = this._region.y; yy < yymax; ++yy) {
                int xx;
                int xxmax = xx + this._region.width;
                for (xx = this._region.x; xx < xxmax; ++xx) {
                    int flags = this._flagMask & tentry.getCollisionFlags(config, xx, yy);
                    int type = Math.max(this._types.get(xx, yy), flags);
                    this._types.put(xx, yy, type);
                    if (!retexture) continue;
                    this.updateTexture(xx, yy, type);
                }
            }
            return;
        }
        int flags = this._flagMask & entry.getCollisionFlags(this._sceneModel.getConfigManager());
        if (entry instanceof TudeySceneModel.PlaceableEntry) {
            TudeySceneModel.PlaceableEntry pentry = (TudeySceneModel.PlaceableEntry)entry;
            PlaceableConfig.Original config = pentry.getConfig(this._sceneModel.getConfigManager());
            if (flags == 0 && !config.floorTile) {
                return;
            }
        } else if (flags == 0) {
            return;
        }
        if ((shape = entry.createShape(this._sceneModel.getConfigManager())) == null) {
            return;
        }
        Rect bounds = shape.getBounds();
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        int minx = FloatMath.ifloor(min.x);
        int maxx = FloatMath.ifloor(max.x);
        int miny = FloatMath.ifloor(min.y);
        int maxy = FloatMath.ifloor(max.y);
        for (int yy = miny; yy <= maxy; ++yy) {
            for (int xx = minx; xx <= maxx; ++xx) {
                this.updateQuad(xx, yy);
                if (!shape.intersects(this._quad)) continue;
                int type = Math.max(this._types.get(xx, yy), flags);
                this._types.put(xx, yy, type);
                if (!retexture) continue;
                this.updateTexture(xx, yy, type);
            }
        }
    }

    protected void removeEntry(TudeySceneModel.Entry entry, boolean retexture) {
        if (entry instanceof TudeySceneModel.TileEntry) {
            int yy;
            TudeySceneModel.TileEntry tentry = (TudeySceneModel.TileEntry)entry;
            TileConfig.Original config = tentry.getConfig(this._sceneModel.getConfigManager());
            tentry.getRegion(config, this._region);
            int yymax = yy + this._region.height;
            for (yy = this._region.y; yy < yymax; ++yy) {
                int xx;
                int xxmax = xx + this._region.width;
                for (xx = this._region.x; xx < xxmax; ++xx) {
                    this.updateQuad(xx, yy);
                    this.update(xx, yy, retexture);
                }
            }
            return;
        }
        int flags = this._flagMask & entry.getCollisionFlags(this._sceneModel.getConfigManager());
        if (flags == 0) {
            return;
        }
        Shape shape = entry.createShape(this._sceneModel.getConfigManager());
        if (shape == null) {
            return;
        }
        Rect bounds = shape.getBounds();
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        int minx = FloatMath.ifloor(min.x);
        int maxx = FloatMath.ifloor(max.x);
        int miny = FloatMath.ifloor(min.y);
        int maxy = FloatMath.ifloor(max.y);
        for (int yy = miny; yy <= maxy; ++yy) {
            for (int xx = minx; xx <= maxx; ++xx) {
                this.updateQuad(xx, yy);
                if (!shape.intersects(this._quad)) continue;
                this.update(xx, yy, retexture);
            }
        }
    }

    protected void update(int x, int y, boolean retexture) {
        int type = -1;
        TudeySceneModel.TileEntry tentry = this._sceneModel.getTileEntry(x, y);
        ConfigManager cfgmgr = this._sceneModel.getConfigManager();
        if (tentry != null) {
            type = tentry.getCollisionFlags(tentry.getConfig(cfgmgr), x, y);
        }
        this._sceneModel.getSpace().getIntersecting(this._quad, this._elements);
        int nn = this._elements.size();
        for (int ii = 0; ii < nn; ++ii) {
            SpaceElement element = this._elements.get(ii);
            int flags = this._flagMask & ((TudeySceneModel.Entry)element.getUserObject()).getCollisionFlags(cfgmgr);
            if (flags == 0) continue;
            type = Math.max(type, flags);
        }
        this._elements.clear();
        this._types.put(x, y, type);
        if (retexture) {
            this.updateTexture(x, y, type);
        }
    }

    protected void updateQuad(int x, int y) {
        float lx = x;
        float ly = y;
        float ux = lx + 1.0f;
        float uy = ly + 1.0f;
        this._quad.getVertex(0).set(lx, ly);
        this._quad.getVertex(1).set(ux, ly);
        this._quad.getVertex(2).set(ux, uy);
        this._quad.getVertex(3).set(lx, uy);
        this._quad.getBounds().getMinimumExtent().set(lx, ly);
        this._quad.getBounds().getMaximumExtent().set(ux, uy);
    }

    protected void updateTexture(int x, int y, int type) {
        int tx = x >> 8;
        int ty = y >> 8;
        Texture2D texture = this._textures.get(this._coord.set(tx, ty));
        if (texture == null) {
            this.buildTexture(tx, ty);
            return;
        }
        ByteBuffer buf = this.getBuffer(4);
        this.putColor(buf, type);
        buf.rewind();
        texture.setSubimage(0, x & 0xFF, y & 0xFF, 1, 1, 6408, 5121, buf);
    }

    protected void buildTexture(int tx, int ty) {
        int yy;
        ByteBuffer buf = this.getBuffer(262144);
        int yymax = yy + 256;
        for (yy = ty << 8; yy < yymax; ++yy) {
            int xx;
            int xxmax = xx + 256;
            for (xx = tx << 8; xx < xxmax; ++xx) {
                this.putColor(buf, this._types.get(xx, yy));
            }
        }
        buf.rewind();
        Texture2D texture = new Texture2D(this._ctx.getRenderer());
        texture.setFilters(9728, 9728);
        texture.setWrap(10496, 10496);
        texture.setImage(0, 6408, 256, 256, false, 6408, 5121, buf);
        this._textures.put(new Coord(tx, ty), texture);
    }

    protected void putColor(ByteBuffer buf, int type) {
        if (type == -1) {
            buf.put(EMPTY_COLOR);
        } else if (type == 0) {
            buf.put(this._floorColor);
        } else {
            buf.put(this._wallColor);
        }
    }

    protected ByteBuffer getBuffer(int size) {
        ByteBuffer buf;
        ByteBuffer byteBuffer = buf = this._buf == null ? null : this._buf.get();
        if (buf == null || buf.capacity() < size) {
            buf = BufferUtils.createByteBuffer((int)size);
            this._buf = new SoftReference<ByteBuffer>(buf);
        }
        return buf;
    }

    protected static byte[] getBytes(Color4f color) {
        return new byte[]{(byte)Math.round(color.r * 255.0f), (byte)Math.round(color.g * 255.0f), (byte)Math.round(color.b * 255.0f), (byte)Math.round(color.a * 255.0f)};
    }
}

