/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer.util;

import com.threerings.opengl.renderer.BufferObject;
import com.threerings.opengl.renderer.ClientArray;
import com.threerings.opengl.renderer.DisplayList;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.SimpleBatch;
import com.threerings.opengl.renderer.state.ArrayState;
import com.threerings.opengl.renderer.state.RenderState;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class BatchFactory {
    public static SimpleBatch createLineBatch(Renderer renderer, FloatBuffer vbuf) {
        SimpleBatch.DrawCommand command;
        RenderState[] states = RenderState.createEmptySet();
        int vcount = vbuf.remaining() / 3;
        if (GLContext.getCapabilities().GL_ARB_vertex_buffer_object) {
            BufferObject buffer = new BufferObject(renderer);
            buffer.setData(vbuf);
            states[1] = new ArrayState(0, null, null, null, null, new ClientArray(3, 5126, buffer), null);
            command = new SimpleBatch.DrawArrays(1, 0, vcount);
        } else {
            DisplayList list = new DisplayList(renderer);
            renderer.setArrayState(0, null, null, null, null, new ClientArray(3, vbuf), null);
            GL11.glNewList((int)list.getId(), (int)4864);
            GL11.glDrawArrays((int)1, (int)0, (int)vcount);
            GL11.glEndList();
            states[1] = ArrayState.DISABLED;
            command = new SimpleBatch.CallList(list, false, vcount / 2);
        }
        return new SimpleBatch(states, command);
    }

    public static SimpleBatch createTriangleBatchT2N3V3(Renderer renderer, FloatBuffer vbuf, ShortBuffer ibuf) {
        SimpleBatch.DrawCommand command;
        RenderState[] states = RenderState.createEmptySet();
        int vcount = vbuf.remaining() / 8;
        int icount = ibuf.remaining();
        if (GLContext.getCapabilities().GL_ARB_vertex_buffer_object) {
            BufferObject vbobj = new BufferObject(renderer);
            BufferObject ibobj = new BufferObject(renderer);
            vbobj.setData(vbuf);
            ibobj.setData(ibuf);
            states[1] = new ArrayState(0, null, new ClientArray[]{new ClientArray(2, 5126, 32, 0L, vbobj)}, null, new ClientArray(3, 5126, 32, 8L, vbobj), new ClientArray(3, 5126, 32, 20L, vbobj), ibobj);
            command = SimpleBatch.createDrawBufferElements(4, 0, vcount - 1, icount, 5123, 0L);
        } else {
            DisplayList list = new DisplayList(renderer);
            renderer.setArrayState(0, null, new ClientArray[]{new ClientArray(2, 32, 0L, vbuf)}, null, new ClientArray(3, 32, 8L, vbuf), new ClientArray(3, 32, 20L, vbuf), null);
            GL11.glNewList((int)list.getId(), (int)4864);
            GL11.glDrawElements((int)4, (ShortBuffer)ibuf);
            GL11.glEndList();
            states[1] = ArrayState.DISABLED;
            command = new SimpleBatch.CallList(list, false, icount / 3);
        }
        return new SimpleBatch(states, command);
    }
}

