/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer.config;

import com.google.common.collect.Lists;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.expr.Updater;
import com.threerings.opengl.geometry.config.PassDescriptor;
import com.threerings.opengl.renderer.Program;
import com.threerings.opengl.renderer.Shader;
import com.threerings.opengl.renderer.config.CoordSpace;
import com.threerings.opengl.renderer.config.ShaderConfig;
import com.threerings.opengl.renderer.state.RenderState;
import com.threerings.opengl.renderer.state.ShaderState;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GLContext;

@EditorTypes(value={Disabled.class, Enabled.class})
public abstract class ShaderStateConfig
extends DeepObject
implements Exportable {
    public void getUpdateReferences(ConfigReferenceSet refs) {
    }

    public abstract boolean isSupported(GlContext var1, boolean var2);

    public void populateDescriptor(GlContext ctx, PassDescriptor desc) {
        desc.coordSpace = CoordSpace.OBJECT;
        desc.hints = new String[0];
        desc.vertexAttribs = new String[0];
    }

    public abstract ShaderState getState(GlContext var1, Scope var2, RenderState[] var3, List<Updater> var4);

    public static class Enabled
    extends ShaderStateConfig {
        @Editable(nullable=true)
        public ConfigReference<ShaderConfig> vertex;
        @Editable(nullable=true)
        public ConfigReference<ShaderConfig> fragment;
        @Editable
        public boolean vertexProgramTwoSide;

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(ShaderConfig.class, this.vertex);
            refs.add(ShaderConfig.class, this.fragment);
        }

        @Override
        public boolean isSupported(GlContext ctx, boolean fallback) {
            return !(this.vertex != null && !GLContext.getCapabilities().GL_ARB_vertex_shader || this.fragment != null && !GLContext.getCapabilities().GL_ARB_fragment_shader || ctx.getApp().getCompatibilityMode());
        }

        @Override
        public void populateDescriptor(GlContext ctx, PassDescriptor desc) {
            ShaderConfig vconfig = this.getShaderConfig(ctx, this.vertex);
            if (vconfig != null) {
                vconfig.populateDescriptor(ctx, desc);
            } else {
                super.populateDescriptor(ctx, desc);
            }
        }

        @Override
        public ShaderState getState(GlContext ctx, Scope scope, RenderState[] states, List<Updater> updaters) {
            Shader fshader;
            ShaderConfig vconfig = this.getShaderConfig(ctx, this.vertex);
            ShaderConfig fconfig = this.getShaderConfig(ctx, this.fragment);
            Shader vshader = vconfig == null ? null : vconfig.getShader(ctx, scope, states, this.vertexProgramTwoSide);
            Shader shader = fshader = fconfig == null ? null : fconfig.getShader(ctx, scope, states, this.vertexProgramTwoSide);
            if (vshader == null && fshader == null) {
                return ShaderState.DISABLED;
            }
            Program program = ctx.getShaderCache().getProgram(vshader, fshader);
            if (program == null) {
                return ShaderState.DISABLED;
            }
            ArrayList uniforms = Lists.newArrayList();
            if (vshader != null) {
                PassDescriptor desc = new PassDescriptor();
                vconfig.populateDescriptor(ctx, desc);
                boolean relink = false;
                for (int ii = 0; ii < desc.vertexAttribs.length; ++ii) {
                    int nloc;
                    String attrib = desc.vertexAttribs[ii];
                    int oloc = program.getAttribLocation(attrib);
                    if (oloc == (nloc = desc.firstVertexAttribIndex + ii)) continue;
                    program.setAttribLocation(attrib, nloc);
                    relink = true;
                }
                if (relink) {
                    program.relink();
                }
                for (ShaderConfig.UniformConfig config : vconfig.getUniforms(ctx)) {
                    config.createUniforms(scope, program, uniforms, updaters);
                }
            }
            if (fshader != null) {
                for (ShaderConfig.UniformConfig config : fconfig.getUniforms(ctx)) {
                    config.createUniforms(scope, program, uniforms, updaters);
                }
            }
            return new ShaderState(program, uniforms.toArray(new Program.Uniform[uniforms.size()]), this.vertexProgramTwoSide);
        }

        protected ShaderConfig getShaderConfig(GlContext ctx, ConfigReference<ShaderConfig> ref) {
            return ref == null ? null : ctx.getConfigManager().getConfig(ShaderConfig.class, ref);
        }
    }

    public static class Disabled
    extends ShaderStateConfig {
        @Override
        public boolean isSupported(GlContext ctx, boolean fallback) {
            return true;
        }

        @Override
        public ShaderState getState(GlContext ctx, Scope scope, RenderState[] states, List<Updater> updaters) {
            return ShaderState.DISABLED;
        }
    }
}

