/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model.tools;

import com.threerings.math.Transform3D;
import com.threerings.opengl.model.config.AnimationConfig;
import com.threerings.opengl.model.tools.ModelDef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class AnimationDef {
    public float frameRate;
    public ArrayList<FrameDef> frames = new ArrayList();

    public void addFrame(FrameDef frame) {
        this.frames.add(frame);
    }

    public void update(AnimationConfig.Imported config) {
        config.rate = this.frameRate;
        config.targets = this.getTargets();
        config.transforms = this.getTransforms(config.targets, config.scale, config.loop && config.skipLastFrame);
    }

    public String[] getTargets() {
        HashSet<String> tset = new HashSet<String>();
        for (FrameDef frame : this.frames) {
            for (String target : frame.transforms.keySet()) {
                tset.add(target);
            }
        }
        return tset.toArray(new String[tset.size()]);
    }

    public Transform3D[][] getTransforms(String[] targets, float scale, boolean omitLastFrame) {
        int nframes = this.frames.size() - (omitLastFrame ? 1 : 0);
        Transform3D[][] transforms = new Transform3D[nframes][];
        for (int ii = 0; ii < nframes; ++ii) {
            transforms[ii] = this.frames.get(ii).getTransforms(targets, scale);
        }
        return transforms;
    }

    public static class TransformDef {
        public String name;
        public float[] translation;
        public float[] rotation;
        public float[] scale;

        public Transform3D createTransform(float gscale) {
            return ModelDef.createTransform(this.translation, this.rotation, this.scale, gscale);
        }
    }

    public static class FrameDef {
        public HashMap<String, TransformDef> transforms = new HashMap();

        public void addTransform(TransformDef transform) {
            this.transforms.put(transform.name, transform);
        }

        public Transform3D[] getTransforms(String[] targets, float scale) {
            Transform3D[] xforms = new Transform3D[targets.length];
            for (int ii = 0; ii < targets.length; ++ii) {
                TransformDef tdef = this.transforms.get(targets[ii]);
                xforms[ii] = tdef == null ? new Transform3D() : tdef.createTransform(scale);
            }
            return xforms;
        }
    }
}

