/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.cursor;

import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.expr.Scope;
import com.threerings.expr.SimpleScope;
import com.threerings.opengl.compositor.Compositable;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Tickable;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.client.cursor.EntryCursor;
import com.threerings.tudey.client.cursor.PathCursor;
import com.threerings.tudey.client.sprite.PathSprite;
import com.threerings.tudey.client.util.AreaElement;
import com.threerings.tudey.client.util.ShapeSceneElement;
import com.threerings.tudey.config.AreaConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.util.TudeyContext;

public class AreaCursor
extends EntryCursor
implements ConfigUpdateListener<AreaConfig> {
    protected TudeySceneModel.AreaEntry _entry;
    protected AreaConfig _config;
    protected Implementation _impl = NULL_IMPLEMENTATION;
    protected static final Implementation NULL_IMPLEMENTATION = new Implementation(null){};

    public AreaCursor(TudeyContext ctx, TudeySceneView view, TudeySceneModel.AreaEntry entry) {
        super(ctx, view);
        this.update(entry);
    }

    @Override
    public void configUpdated(ConfigEvent<AreaConfig> event) {
        this.updateFromConfig();
        this._impl.update(this._entry);
    }

    @Override
    public TudeySceneModel.Entry getEntry() {
        return this._entry;
    }

    public final void setVisible(boolean paramBoolean) {
        this._impl.setVisible(paramBoolean);
    }

    @Override
    public Shape getShape() {
        return this._impl.getShape();
    }

    @Override
    public void update(TudeySceneModel.Entry entry) {
        this._entry = (TudeySceneModel.AreaEntry)entry;
        this.setConfig(this._entry.area);
        this._impl.update(this._entry);
    }

    @Override
    public void tick(float elapsed) {
        this._impl.tick(elapsed);
    }

    @Override
    public void composite() {
        this._impl.composite();
    }

    @Override
    public void dispose() {
        super.dispose();
        this._impl.dispose();
        if (this._config != null) {
            this._config.removeListener(this);
        }
    }

    protected void setConfig(ConfigReference<AreaConfig> ref) {
        this.setConfig(this._ctx.getConfigManager().getConfig(AreaConfig.class, ref));
    }

    protected void setConfig(AreaConfig config) {
        if (this._config == config) {
            return;
        }
        if (this._config != null) {
            this._config.removeListener(this);
        }
        if ((this._config = config) != null) {
            this._config.addListener(this);
        }
        this.updateFromConfig();
    }

    protected void updateFromConfig() {
        Implementation nimpl = this._config == null ? null : this._config.getCursorImplementation(this._ctx, this, this._impl);
        Implementation implementation = nimpl = nimpl == null ? NULL_IMPLEMENTATION : nimpl;
        if (this._impl != nimpl) {
            this._impl.dispose();
            this._impl = nimpl;
        }
    }

    public static class Original
    extends Implementation {
        protected TudeyContext _ctx;
        protected Model[] _vertices = new Model[0];
        protected Model[] _edges = new Model[0];
        protected AreaElement _area;
        protected ShapeSceneElement _footprint;
        protected ColorState _colorState = new ColorState();

        public Original(TudeyContext ctx, Scope parentScope, AreaConfig.Original config) {
            super(parentScope);
            this._ctx = ctx;
            this._area = new AreaElement(ctx);
            this._footprint = new ShapeSceneElement((GlContext)ctx, true);
            this._footprint.getColor().set(EntryCursor.FOOTPRINT_COLOR);
            this.setConfig(config);
        }

        public void setConfig(AreaConfig.Original config) {
            this._colorState.getColor().set(config.color).multLocal(0.5f);
            this._area.getColor().set(config.color).multLocal(0.25f);
        }

        @Override
        public Shape getShape() {
            return this._footprint.getShape();
        }

        @Override
        public void setVisible(boolean visible) {
            int j;
            for (j = 0; j < this._vertices.length; ++j) {
                this._vertices[j].setVisible(visible);
            }
            for (j = 0; j < this._edges.length; ++j) {
                this._edges[j].setVisible(visible);
            }
            this._area.setVisible(visible);
        }

        @Override
        public void update(TudeySceneModel.AreaEntry entry) {
            this._vertices = PathCursor.maybeResize(this._vertices, entry.vertices.length, this._ctx, this, "editor/marker/vertex/model.dat", this._colorState);
            float minz = PathSprite.updateVertices(entry.vertices, this._vertices);
            this._edges = PathCursor.maybeResize(this._edges, entry.vertices.length - 1, this._ctx, this, "editor/marker/edge/model.dat", this._colorState);
            PathSprite.updateEdges(entry.vertices, this._edges);
            this._area.setVertices(entry.vertices);
            this._footprint.getTransform().getTranslation().z = minz;
            this._footprint.setShape(entry.createShape(this._ctx.getConfigManager()));
        }

        @Override
        public void tick(float elapsed) {
            for (Model model : this._vertices) {
                model.tick(elapsed);
            }
            for (Model model : this._edges) {
                model.tick(elapsed);
            }
        }

        @Override
        public void composite() {
            for (Model model : this._vertices) {
                model.composite();
            }
            for (Model model : this._edges) {
                model.composite();
            }
            this._footprint.composite();
            this._area.composite();
        }
    }

    public static abstract class Implementation
    extends SimpleScope
    implements Tickable,
    Compositable {
        public Implementation(Scope parentScope) {
            super(parentScope);
        }

        public Shape getShape() {
            return null;
        }

        public void update(TudeySceneModel.AreaEntry entry) {
        }

        @Override
        public void tick(float elapsed) {
        }

        @Override
        public void composite() {
        }

        @Override
        public String getScopeName() {
            return "impl";
        }

        public void setVisible(boolean paramBoolean) {
        }
    }
}

