/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.swing;

import com.google.common.collect.Lists;
import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.HGroupLayout;
import com.samskivert.util.OneLineLogFormatter;
import com.threerings.util.MessageBundle;
import com.threerings.util.MessageManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;

public class LogPanel
extends JPanel
implements ActionListener {
    protected MessageBundle _msgs;
    protected JLabel _warning;
    protected JButton _show;
    protected JButton _clear;
    protected Handler _handler;
    protected List<LogRecord> _records = Lists.newArrayList();
    protected LogDialog _dialog;
    protected static List<LogPanel> _panels = Lists.newArrayList();

    public LogPanel(MessageManager msgmgr, boolean addHandler) {
        super((LayoutManager)new HGroupLayout(GroupLayout.STRETCH));
        this._msgs = msgmgr.getBundle("swing");
        this._warning = new JLabel();
        this.add(this._warning);
        this._show = new JButton(this._msgs.get("m.show"));
        this.add((Component)this._show, GroupLayout.FIXED);
        this._show.addActionListener(this);
        this._show.setVisible(false);
        this._clear = new JButton(this._msgs.get("m.clear"));
        this.add((Component)this._clear, GroupLayout.FIXED);
        this._clear.addActionListener(this);
        this._clear.setVisible(false);
        this._handler = new Handler(){

            @Override
            public void publish(LogRecord record) {
                if (!this.isLoggable(record)) {
                    return;
                }
                LogPanel.this._warning.setText(record.getMessage());
                LogPanel.this._show.setVisible(true);
                LogPanel.this._clear.setVisible(true);
                LogPanel.this._records.add(record);
            }

            @Override
            public boolean isLoggable(LogRecord record) {
                return super.isLoggable(record) && !record.getMessage().startsWith("Long dobj");
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
        this._handler.setLevel(Level.WARNING);
        if (addHandler) {
            this.maybeAddHandler();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this._show) {
            if (this._dialog == null) {
                Window win = SwingUtilities.getWindowAncestor(this);
                this._dialog = win instanceof Frame ? new LogDialog((Frame)win) : new LogDialog((Dialog)win);
            }
            this._dialog.setVisible(true);
        }
        int nn = _panels.size();
        for (int ii = 0; ii < nn; ++ii) {
            _panels.get(ii).clear();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.maybeAddHandler();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        LogManager.getLogManager().getLogger("").removeHandler(this._handler);
        _panels.remove(this);
        this.clear();
    }

    protected void maybeAddHandler() {
        if (!Boolean.getBoolean("no_log_redir") && !_panels.contains(this)) {
            LogManager.getLogManager().getLogger("").addHandler(this._handler);
            _panels.add(this);
        }
    }

    protected void clear() {
        this._warning.setText("");
        this._show.setVisible(false);
        this._clear.setVisible(false);
        this._records.clear();
    }

    protected class LogDialog
    extends JDialog
    implements ActionListener {
        protected JTextArea _text;
        protected JScrollPane _pane;
        protected OneLineLogFormatter _formatter;

        public LogDialog(Dialog owner) {
            super(owner, LogPanel.this._msgs.get("m.error_log"));
            this._formatter = new OneLineLogFormatter();
            this.init();
        }

        public LogDialog(Frame owner) {
            super(owner, LogPanel.this._msgs.get("m.error_log"));
            this._formatter = new OneLineLogFormatter();
            this.init();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.setVisible(false);
        }

        @Override
        public void setVisible(boolean visible) {
            if (!visible) {
                super.setVisible(false);
                return;
            }
            this._text.setText("");
            int lines = 0;
            int nn = LogPanel.this._records.size();
            for (int ii = 0; ii < nn; ++ii) {
                lines = this._text.getLineCount();
                this._text.append(this._formatter.format(LogPanel.this._records.get(ii)));
            }
            super.setVisible(true);
            final int line = lines - 1;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Rectangle view = LogDialog.this._text.modelToView(LogDialog.this._text.getLineStartOffset(line));
                        LogDialog.this._pane.getVerticalScrollBar().setValue(view.y);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }

        protected void init() {
            this._text = new JTextArea();
            this._pane = new JScrollPane(this._text, 20, 31);
            this.add((Component)this._pane, "Center");
            this._text.setTabSize(4);
            this._text.setLineWrap(true);
            JPanel bpanel = new JPanel();
            this.add((Component)bpanel, "South");
            JButton close = new JButton(LogPanel.this._msgs.get("m.close"));
            bpanel.add(close);
            close.addActionListener(this);
            this.setSize(800, 500);
            this.setLocationRelativeTo(LogPanel.this);
        }
    }
}

