/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.prefs;

import com.threerings.prefs.FilePreferencesFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;

public class FilePreferences
extends AbstractPreferences {
    private Map<String, String> root;
    private Map<String, FilePreferences> children;
    private boolean isRemoved = false;
    Method enqueuePreferenceChangeEvent = null;

    public FilePreferences(AbstractPreferences parent, String name) {
        super(parent, name);
        this.reset();
        try {
            this.enqueuePreferenceChangeEvent = AbstractPreferences.class.getDeclaredMethod("enqueuePreferenceChangeEvent", String.class, String.class);
            this.enqueuePreferenceChangeEvent.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reset() {
        Map<String, String> old = this.root;
        this.root = new TreeMap<String, String>();
        this.children = new TreeMap<String, FilePreferences>();
        try {
            this.sync();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void putSpi(String key, String value) {
        this.root.put(key, value);
        try {
            this.flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getSpi(String key) {
        return this.root.get(key);
    }

    @Override
    protected void removeSpi(String key) {
        this.root.remove(key);
        try {
            this.flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        this.isRemoved = true;
        this.flush();
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        return this.root.keySet().toArray(new String[this.root.keySet().size()]);
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        return this.children.keySet().toArray(new String[this.children.keySet().size()]);
    }

    @Override
    protected FilePreferences childSpi(String name) {
        FilePreferences child = this.children.get(name);
        if (child == null || child.isRemoved()) {
            child = new FilePreferences(this, name);
            this.children.put(name, child);
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void syncSpi() throws BackingStoreException {
        File file;
        if (this.isRemoved()) {
            return;
        }
        File file2 = file = FilePreferencesFactory.getPreferencesFile();
        synchronized (file2) {
            Properties properties = new Properties();
            this.load(properties, file);
            StringBuilder sb = new StringBuilder();
            this.getPath(sb);
            String path = sb.toString();
            Enumeration<?> pnen = properties.propertyNames();
            while (pnen.hasMoreElements()) {
                String propKey = (String)pnen.nextElement();
                if (!propKey.startsWith(path)) continue;
                String subKey = propKey.substring(path.length());
                this.root.put(subKey, properties.getProperty(propKey));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(Properties properties, File file) throws BackingStoreException {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            return;
        }
        try {
            FileInputStream inputStream = new FileInputStream(file);
            try {
                properties.load(inputStream);
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }
        catch (IOException e) {
            throw new BackingStoreException(e);
        }
    }

    private void getPath(StringBuilder sb) {
        if (!(this.parent() instanceof FilePreferences)) {
            return;
        }
        FilePreferences parent = (FilePreferences)this.parent();
        if (parent == null) {
            return;
        }
        parent.getPath(sb);
        sb.append(this.name()).append('.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushSpi() throws BackingStoreException {
        File file;
        File file2 = file = FilePreferencesFactory.getPreferencesFile();
        synchronized (file2) {
            Properties properties = new Properties();
            this.load(properties, file);
            StringBuilder sb = new StringBuilder();
            this.getPath(sb);
            String path = sb.toString();
            ArrayList<String> toRemove = new ArrayList<String>();
            Enumeration<?> pnen = properties.propertyNames();
            while (pnen.hasMoreElements()) {
                String propKey = (String)pnen.nextElement();
                if (!propKey.startsWith(path)) continue;
                String subKey = propKey.substring(path.length());
                toRemove.add(propKey);
            }
            if (!this.isRemoved) {
                for (String s : this.root.keySet()) {
                    properties.setProperty(path + s, this.root.get(s));
                }
            }
            this.save(properties, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(Properties properties, File file) throws BackingStoreException {
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            try {
                properties.store(outputStream, "FilePreferences");
            }
            finally {
                ((OutputStream)outputStream).close();
            }
        }
        catch (IOException e) {
            throw new BackingStoreException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, String value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        if (key.length() > 80) {
            throw new IllegalArgumentException("Key too long: " + key);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node has been removed.");
            }
            this.putSpi(key, value);
            try {
                this.enqueuePreferenceChangeEvent.invoke((Object)this, key, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

