/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model.config;

import com.samskivert.util.ArrayUtil;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.FileConstraints;
import com.threerings.editor.util.EditorContext;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.expr.Transform3DExpression;
import com.threerings.io.Streamable;
import com.threerings.math.Transform3D;
import com.threerings.opengl.Log;
import com.threerings.opengl.model.Animation;
import com.threerings.opengl.model.config.ActionConfig;
import com.threerings.opengl.model.tools.AnimationDef;
import com.threerings.opengl.model.tools.xml.AnimationParser;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Preloadable;
import com.threerings.probs.FloatVariable;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import com.threerings.util.Shallow;

public class AnimationConfig
extends ParameterizedConfig
implements Preloadable.LoadableConfig {
    @Editable
    public Implementation implementation = new Imported();
    protected static AnimationParser _parser;

    public Animation.Implementation getAnimationImplementation(GlContext ctx, Scope scope, Animation.Implementation impl) {
        return this.implementation.getAnimationImplementation(ctx, scope, impl);
    }

    @Override
    public void preload(GlContext ctx) {
        this.implementation.preload(ctx);
    }

    @Override
    public void updateFromSource(EditorContext ctx, boolean force) {
        this.implementation.updateFromSource(ctx, force);
    }

    @Override
    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    public static class TargetModifier
    extends DeepObject
    implements Exportable,
    Streamable {
        @Editable
        public String target = "";
        @Editable
        public boolean ignoreTranslation = false;
        @Editable
        public boolean ignoreRotation = false;
        @Editable
        public boolean ignoreScale = false;
        @Editable(step=0.01)
        public Transform3D transform = new Transform3D(2);
        protected static Transform3D _transform = new Transform3D();

        public Transform3D modifyTransform(Transform3D anim, Transform3D def) {
            _transform.set((this.ignoreTranslation ? def : anim).getTranslation(), (this.ignoreRotation ? def : anim).getRotation(), (this.ignoreScale ? def : anim).getScale());
            Transform3D result = this.transform.compose(_transform);
            return result;
        }
    }

    public static class ComponentAnimation
    extends DeepObject
    implements Exportable,
    Streamable {
        @Editable(min=0.0, step=0.01)
        public float speed = 1.0f;
        @Editable(nullable=true)
        public ConfigReference<AnimationConfig> animation;
    }

    public static class TargetTransform
    extends DeepObject
    implements Exportable,
    Streamable {
        @Editable
        public String[] targets = ArrayUtil.EMPTY_STRING;
        @Editable
        public Transform3DExpression expression = new Transform3DExpression.Constant();
    }

    public static class FrameAction
    extends DeepObject
    implements Exportable {
        @Editable(min=0.0, step=0.01)
        public float frame;
        @Editable
        public ActionConfig action = new ActionConfig.CallFunction();
    }

    public static class Derived
    extends Implementation
    implements Streamable {
        @Editable(nullable=true)
        public ConfigReference<AnimationConfig> animation;

        @Override
        public Animation.Implementation getAnimationImplementation(GlContext ctx, Scope scope, Animation.Implementation impl) {
            AnimationConfig config = ctx.getConfigManager().getConfig(AnimationConfig.class, this.animation);
            return config == null ? null : config.getAnimationImplementation(ctx, scope, impl);
        }

        @Override
        public void preload(GlContext ctx) {
            new Preloadable.Animation(this.animation).preload(ctx);
        }
    }

    public static class Sequential
    extends Original
    implements Streamable {
        @Editable
        public boolean loop;
        @Editable
        public ComponentAnimation[] animations = new ComponentAnimation[0];

        @Override
        public Animation.Implementation getAnimationImplementation(GlContext ctx, Scope scope, Animation.Implementation impl) {
            if (this.animations.length == 0) {
                impl = null;
            } else if (impl instanceof Animation.Sequential) {
                ((Animation.Sequential)impl).setConfig(this);
            } else {
                impl = new Animation.Sequential(ctx, scope, this);
            }
            return impl;
        }

        @Override
        public void preload(GlContext ctx) {
            for (ComponentAnimation animation : this.animations) {
                new Preloadable.Animation(animation.animation).preload(ctx);
            }
        }
    }

    public static class Procedural
    extends Original
    implements Streamable {
        @Editable(min=0.0, step=0.01)
        public float duration;
        @Editable(min=0.0, step=0.01)
        public FloatVariable offset = new FloatVariable.Constant(0.0f);
        @Editable
        public TargetTransform[] transforms = new TargetTransform[0];

        @Override
        public void preload(GlContext ctx) {
        }

        @Override
        public Animation.Implementation getAnimationImplementation(GlContext ctx, Scope scope, Animation.Implementation impl) {
            if (impl instanceof Animation.Procedural) {
                ((Animation.Procedural)impl).setConfig(this);
            } else {
                impl = new Animation.Procedural(ctx, scope, this);
            }
            return impl;
        }

        @Override
        public void invalidate() {
            for (TargetTransform transform : this.transforms) {
                transform.expression.invalidate();
            }
        }
    }

    public static class Imported
    extends Original {
        @Editable(min=0.0, step=0.01, hgroup="t")
        public float transition;
        @Editable(min=0.0, step=0.01, hgroup="t")
        public float speed = 1.0f;
        @Editable(min=0.0, step=0.01, hgroup="t")
        public float scale = 0.01f;
        @Editable(hgroup="l")
        public boolean loop;
        @Editable(hgroup="l")
        public boolean skipLastFrame = true;
        @Editable(min=0.0, step=0.01, weight=2.0)
        public FloatVariable offset = new FloatVariable.Constant(0.0f);
        @Editable(weight=2.0)
        public FrameAction[] actions = new FrameAction[0];
        @Editable
        public TargetModifier[] modifiers = new TargetModifier[0];
        public float rate;
        @Shallow
        public String[] targets;
        @Shallow
        public Transform3D[][] transforms;
        protected String _source;
        @DeepOmit
        protected transient boolean _reload;

        @Editable(editor="resource", weight=-1.0, nullable=true)
        @FileConstraints(description="m.exported_anims", extensions={".mxml"}, directory="exported_anim_dir")
        public void setSource(String source) {
            this._source = source;
            this._reload = true;
        }

        @Editable
        public String getSource() {
            return this._source;
        }

        @Editable(step=0.01, hgroup="l", weight=1.0, depends={"transition", "source", "speed", "duration"})
        public void setDuration(float duration) {
        }

        @Editable
        public float getDuration() {
            return this.transition + (this.transforms == null ? 0.0f : (float)(this.transforms.length - 1) / this.getScaledRate());
        }

        public float getScaledRate() {
            return this.speed * this.rate;
        }

        @Override
        public void updateFromSource(EditorContext ctx, boolean force) {
            if (!this._reload && !force) {
                return;
            }
            this._reload = false;
            if (this._source == null) {
                this.updateFromSource(null);
                return;
            }
            if (_parser == null) {
                _parser = new AnimationParser();
            }
            try {
                this.updateFromSource(_parser.parseAnimation(ctx.getResourceManager().getResource(this._source)));
            }
            catch (Exception e) {
                Log.log.warning((Object)("Error parsing animation [source=" + this._source + "]."), new Object[]{e});
                return;
            }
        }

        @Override
        public Animation.Implementation getAnimationImplementation(GlContext ctx, Scope scope, Animation.Implementation impl) {
            if (this.targets == null) {
                return null;
            }
            if (impl instanceof Animation.Imported) {
                ((Animation.Imported)impl).setConfig(this);
            } else {
                impl = new Animation.Imported(ctx, scope, this);
            }
            return impl;
        }

        @Override
        public void preload(GlContext ctx) {
            for (FrameAction action : this.actions) {
                action.action.preload(ctx);
            }
        }

        public Transform3D[][] getModifiedTransforms(Transform3D[] defaults) {
            if (this.modifiers.length == 0) {
                return this.transforms;
            }
            Transform3D[][] result = new Transform3D[this.transforms.length][];
            for (int ii = 0; ii < result.length; ++ii) {
                result[ii] = (Transform3D[])this.transforms[ii].clone();
            }
            for (TargetModifier modifier : this.modifiers) {
                int idx = ArrayUtil.indexOf((Object[])this.targets, (Object)modifier.target);
                if (idx == -1) continue;
                for (int ii = 0; ii < result.length; ++ii) {
                    result[ii][idx] = modifier.modifyTransform(result[ii][idx].promote(2), defaults[idx]);
                }
            }
            return result;
        }

        protected void updateFromSource(AnimationDef def) {
            if (def == null) {
                this.targets = null;
                this.transforms = null;
            } else {
                def.update(this);
            }
        }
    }

    public static abstract class Original
    extends Implementation {
        @Editable(hgroup="p")
        public int priority;
        @Editable(hgroup="p")
        public boolean override = true;
        @Editable(min=0.0, max=1.0, step=0.01, hgroup="w")
        public float weight = 1.0f;
        @Editable(min=0.0, step=0.01, hgroup="w")
        public float blendIn;
        @Editable(min=0.0, step=0.01, hgroup="w")
        public float blendOut;
    }

    @EditorTypes(value={Imported.class, Procedural.class, Sequential.class, Derived.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable,
    Preloadable.LoadableConfig {
        public void updateFromSource(EditorContext ctx, boolean force) {
        }

        @Deprecated
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public abstract Animation.Implementation getAnimationImplementation(GlContext var1, Scope var2, Animation.Implementation var3);

        public void invalidate() {
        }
    }
}

