/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.layout;

import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.layout.DimenInfo;
import com.threerings.opengl.gui.layout.HGroupLayout;
import com.threerings.opengl.gui.layout.LayoutManager;
import com.threerings.opengl.gui.layout.VGroupLayout;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.util.GlContext;
import java.util.HashMap;

public abstract class GroupLayout
extends LayoutManager {
    public static final int DEFAULT_GAP = 5;
    public static final Constraints FIXED = new Constraints(true);
    public static final Policy NONE = new Policy(0);
    public static final Policy STRETCH = new Policy(1);
    public static final Policy EQUALIZE = new Policy(2);
    public static final Policy CONSTRAIN = new Policy(3);
    public static final Justification CENTER = new Justification(0);
    public static final Justification LEFT = new Justification(1);
    public static final Justification RIGHT = new Justification(2);
    public static final Justification TOP = new Justification(3);
    public static final Justification BOTTOM = new Justification(4);
    protected Policy _policy = NONE;
    protected Policy _offpolicy = CONSTRAIN;
    protected int _gap = 5;
    protected Justification _justification = CENTER;
    protected Justification _offjust = CENTER;
    protected HashMap<Component, Object> _constraints;

    public GroupLayout setPolicy(Policy policy) {
        this._policy = policy;
        return this;
    }

    public Policy getPolicy() {
        return this._policy;
    }

    public GroupLayout setOffAxisPolicy(Policy offpolicy) {
        this._offpolicy = offpolicy;
        return this;
    }

    public Policy getOffAxisPolicy() {
        return this._offpolicy;
    }

    public GroupLayout setGap(int gap) {
        this._gap = gap;
        return this;
    }

    public int getGap() {
        return this._gap;
    }

    public GroupLayout setJustification(Justification justification) {
        this._justification = justification;
        return this;
    }

    public Justification getJustification() {
        return this._justification;
    }

    public GroupLayout setOffAxisJustification(Justification justification) {
        this._offjust = justification;
        return this;
    }

    public Justification getOffAxisJustification() {
        return this._offjust;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints != null) {
            if (constraints instanceof Constraints) {
                if (this._constraints == null) {
                    this._constraints = new HashMap();
                }
                this._constraints.put(comp, constraints);
            } else {
                throw new RuntimeException("GroupLayout constraints object must be of type GroupLayout.Constraints");
            }
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (this._constraints != null) {
            this._constraints.remove(comp);
        }
    }

    @Override
    public Object getConstraints(Component comp) {
        return this._constraints == null ? null : this._constraints.get(comp);
    }

    protected boolean isFixed(Component child) {
        if (this._constraints == null) {
            return false;
        }
        Constraints c = (Constraints)this._constraints.get(child);
        if (c != null) {
            return c.fixed;
        }
        return false;
    }

    protected int getWeight(Component child) {
        if (this._constraints == null) {
            return 1;
        }
        Constraints c = (Constraints)this._constraints.get(child);
        if (c != null) {
            return c.weight;
        }
        return 1;
    }

    protected DimenInfo computeDimens(Container parent, boolean horiz, int whint, int hhint) {
        Dimension csize;
        Component child;
        int ii;
        int count = parent.getComponentCount();
        DimenInfo info = new DimenInfo();
        info.dimens = new Dimension[count];
        for (ii = 0; ii < count; ++ii) {
            child = parent.getComponent(ii);
            if (!child.isVisible()) continue;
            ++info.count;
            if (!this.isFixed(child)) continue;
            csize = this.computeChildDimens(info, ii, child, whint, hhint);
            info.fixwid += csize.width;
            info.fixhei += csize.height;
            ++info.numfix;
            info.dimens[ii] = csize;
        }
        if (info.numfix == info.count) {
            return info;
        }
        if (this._policy == STRETCH) {
            if (horiz) {
                if (whint > 0) {
                    whint -= info.fixwid + this._gap * (info.count - 1);
                    whint /= info.count - info.numfix;
                }
            } else if (hhint > 0) {
                hhint -= info.fixhei + this._gap * (info.count - 1);
                hhint /= info.count - info.numfix;
            }
        }
        for (ii = 0; ii < count; ++ii) {
            child = parent.getComponent(ii);
            if (!child.isVisible() || this.isFixed(child)) continue;
            csize = this.computeChildDimens(info, ii, child, whint, hhint);
            info.totweight += this.getWeight(child);
            if (csize.width > info.maxfreewid) {
                info.maxfreewid = csize.width;
            }
            if (csize.height > info.maxfreehei) {
                info.maxfreehei = csize.height;
            }
            info.dimens[ii] = csize;
        }
        return info;
    }

    protected Dimension computeChildDimens(DimenInfo info, int ii, Component child, int whint, int hhint) {
        Dimension csize = child.getPreferredSize(whint, hhint);
        info.totwid += csize.width;
        info.tothei += csize.height;
        if (csize.width > info.maxwid) {
            info.maxwid = csize.width;
        }
        if (csize.height > info.maxhei) {
            info.maxhei = csize.height;
        }
        return csize;
    }

    public static GroupLayout makeHoriz(Policy policy, Justification justification, Policy offpolicy) {
        HGroupLayout lay = new HGroupLayout();
        lay.setPolicy(policy);
        lay.setJustification(justification);
        lay.setOffAxisPolicy(offpolicy);
        return lay;
    }

    public static GroupLayout makeVert(Policy policy, Justification justification, Policy offpolicy) {
        VGroupLayout lay = new VGroupLayout();
        lay.setPolicy(policy);
        lay.setJustification(justification);
        lay.setOffAxisPolicy(offpolicy);
        return lay;
    }

    public static GroupLayout makeHoriz(Justification justification) {
        HGroupLayout lay = new HGroupLayout();
        lay.setJustification(justification);
        return lay;
    }

    public static GroupLayout makeVert(Justification justification) {
        VGroupLayout lay = new VGroupLayout();
        lay.setJustification(justification);
        return lay;
    }

    public static GroupLayout makeHStretch() {
        HGroupLayout lay = new HGroupLayout();
        lay.setPolicy(STRETCH);
        lay.setOffAxisPolicy(STRETCH);
        return lay;
    }

    public static GroupLayout makeVStretch() {
        VGroupLayout lay = new VGroupLayout();
        lay.setPolicy(STRETCH);
        lay.setOffAxisPolicy(STRETCH);
        return lay;
    }

    public static Container makeHBox(GlContext ctx, Justification justification) {
        HGroupLayout lay = new HGroupLayout();
        lay.setJustification(justification);
        return new Container(ctx, lay);
    }

    public static Container makeHBox(GlContext ctx, Justification justification, Component ... comps) {
        Container cont = GroupLayout.makeHBox(ctx, justification);
        for (Component comp : comps) {
            cont.add(comp);
        }
        return cont;
    }

    public static Container makeVBox(GlContext ctx, Justification justification) {
        VGroupLayout lay = new VGroupLayout();
        lay.setJustification(justification);
        return new Container(ctx, lay);
    }

    public static Container makeVBox(GlContext ctx, Justification justification, Component ... comps) {
        Container cont = GroupLayout.makeVBox(ctx, justification);
        for (Component comp : comps) {
            cont.add(comp);
        }
        return cont;
    }

    public static class Justification {
        int code;

        public Justification(int code) {
            this.code = code;
        }
    }

    public static class Policy {
        int code;

        public Policy(int code) {
            this.code = code;
        }
    }

    public static class Constraints {
        public boolean fixed = false;
        public int weight = 1;

        public Constraints(boolean fixed) {
            this.fixed = fixed;
        }

        public Constraints(int weight) {
            this.weight = weight;
        }
    }
}

