/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Log;
import com.threerings.opengl.gui.layout.LayoutManager;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.util.GlContext;
import java.util.ArrayList;

public class Container
extends Component {
    protected ArrayList<Component> _children = new ArrayList();
    protected LayoutManager _layout;

    public Container(GlContext ctx) {
        super(ctx);
    }

    public Container(GlContext ctx, LayoutManager layout) {
        super(ctx);
        this.setLayoutManager(layout);
    }

    public void setLayoutManager(LayoutManager layout) {
        this._layout = layout;
    }

    public LayoutManager getLayoutManager() {
        return this._layout;
    }

    public void add(Component child) {
        this.add(child, null);
    }

    public void add(int index, Component child) {
        this.add(index, child, null);
    }

    public void add(Component child, Object constraints) {
        this.add(this._children.size(), child, constraints);
    }

    public void add(int index, Component child, Object constraints) {
        if (this._layout != null) {
            this._layout.addLayoutComponent(child, constraints);
        }
        this._children.add(index, child);
        child.setParent(this);
        if (this.isAdded()) {
            child.wasAdded();
        }
        this.invalidate();
    }

    public void remove(int index) {
        Component child = this.getComponent(index);
        this._children.remove(index);
        if (this._layout != null) {
            this._layout.removeLayoutComponent(child);
        }
        child.setParent(null);
        if (this.isAdded()) {
            child.wasRemoved();
        }
        this.invalidate();
    }

    public boolean replace(Component oldc, Component newc) {
        int idx = this._children.indexOf(oldc);
        if (idx >= 0) {
            Object constraints = this._layout == null ? null : this._layout.getConstraints(oldc);
            this.remove(idx);
            this.add(idx, newc, constraints);
            return true;
        }
        return false;
    }

    public void remove(Component child) {
        if (!this._children.remove(child)) {
            return;
        }
        if (this._layout != null) {
            this._layout.removeLayoutComponent(child);
        }
        child.setParent(null);
        if (this.isAdded()) {
            child.wasRemoved();
        }
        this.invalidate();
    }

    public int getComponentCount() {
        return this._children.size();
    }

    public Component getComponent(int index) {
        return this._children.get(index);
    }

    public int getComponentIndex(Component component) {
        return this._children.indexOf(component);
    }

    public void removeAll() {
        for (int ii = this.getComponentCount() - 1; ii >= 0; --ii) {
            this.remove(this.getComponent(ii));
        }
    }

    @Override
    public void setAlpha(float alpha) {
        super.setAlpha(alpha);
        for (int ii = this.getComponentCount() - 1; ii >= 0; --ii) {
            this.getComponent(ii).setAlpha(alpha);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int ii = this.getComponentCount() - 1; ii >= 0; --ii) {
            this.getComponent(ii).setEnabled(enabled);
        }
    }

    @Override
    public void setHoverable(boolean hoverable) {
        super.setHoverable(hoverable);
        for (int ii = this.getComponentCount() - 1; ii >= 0; --ii) {
            this.getComponent(ii).setHoverable(hoverable);
        }
    }

    @Override
    public Component getHitComponent(int mx, int my) {
        if (!this.isVisible() || !this.contains(mx, my)) {
            return null;
        }
        mx -= this._x;
        my -= this._y;
        Component hit = null;
        for (int ii = this.getComponentCount() - 1; ii >= 0; --ii) {
            Component child = this.getComponent(ii);
            hit = child.getHitComponent(mx, my);
            if (hit == null) continue;
            return hit;
        }
        return this._hoverable ? this : null;
    }

    @Override
    public void validate() {
        if (!this._valid) {
            if (this.isVisible()) {
                this.layout();
                this.applyOperation(new ChildOp(){

                    @Override
                    public void apply(Component child) {
                        child.validate();
                    }
                });
            }
            this._valid = true;
        }
    }

    @Override
    protected String getDefaultStyleConfig() {
        return "Default/Container";
    }

    @Override
    protected void layout() {
        if (this._layout != null) {
            this._layout.layoutContainer(this);
        }
    }

    @Override
    protected void renderComponent(Renderer renderer) {
        super.renderComponent(renderer);
        int ll = this.getComponentCount();
        for (int ii = 0; ii < ll; ++ii) {
            this.getComponent(ii).render(renderer);
        }
    }

    @Override
    protected Dimension computePreferredSize(int whint, int hhint) {
        if (this._layout != null) {
            return this._layout.computePreferredSize(this, whint, hhint);
        }
        return super.computePreferredSize(whint, hhint);
    }

    @Override
    protected void wasAdded() {
        super.wasAdded();
        this.applyOperation(new ChildOp(){

            @Override
            public void apply(Component child) {
                child.wasAdded();
            }
        });
    }

    @Override
    protected void wasRemoved() {
        super.wasRemoved();
        this.applyOperation(new ChildOp(){

            @Override
            public void apply(Component child) {
                child.wasRemoved();
            }
        });
    }

    protected Component getNextFocus(Component current) {
        int idx = this.getComponentIndex(current);
        int nn = this.getComponentCount();
        for (int ii = idx + 1; ii < nn; ++ii) {
            Component focus = this.getComponent(ii).getFirstDescendantFocus();
            if (focus == null) continue;
            return focus;
        }
        return this.getNextFocus();
    }

    protected Component getPreviousFocus(Component current) {
        int idx = current == null ? this.getComponentCount() : this.getComponentIndex(current);
        for (int ii = idx - 1; ii >= 0; --ii) {
            Component focus = this.getComponent(ii).getLastDescendantFocus();
            if (focus == null) continue;
            return focus;
        }
        return this.getPreviousFocus();
    }

    @Override
    protected Component getFirstDescendantFocus() {
        if (this.acceptsFocus()) {
            return this;
        }
        int nn = this.getComponentCount();
        for (int ii = 0; ii < nn; ++ii) {
            Component desc = this.getComponent(ii).getFirstDescendantFocus();
            if (desc == null) continue;
            return desc;
        }
        return null;
    }

    @Override
    protected Component getLastDescendantFocus() {
        for (int ii = this.getComponentCount() - 1; ii >= 0; --ii) {
            Component desc = this.getComponent(ii).getLastDescendantFocus();
            if (desc == null) continue;
            return desc;
        }
        return super.getLastDescendantFocus();
    }

    protected void applyOperation(ChildOp op) {
        for (Component child : this._children) {
            try {
                op.apply(child);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Child operation choked.", new Object[]{"op", op, "child", child, e});
            }
        }
    }

    protected static interface ChildOp {
        public void apply(Component var1);
    }
}

