/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer.state;

import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.state.RenderState;

public class MaterialState
extends RenderState {
    public static final MaterialState DEFAULT = new MaterialState(Color4f.DARK_GRAY, Color4f.GRAY, Color4f.BLACK, Color4f.BLACK, 0.0f, Color4f.DARK_GRAY, Color4f.GRAY, Color4f.BLACK, Color4f.BLACK, 0.0f, -1, 1028, false, false, false, false);
    public static final MaterialState WHITE = new MaterialState(Color4f.WHITE, Color4f.WHITE, Color4f.BLACK, Color4f.BLACK, 0.0f, Color4f.WHITE, Color4f.WHITE, Color4f.BLACK, Color4f.BLACK, 0.0f, -1, 1028, false, false, false, false);
    protected Color4f _frontAmbient = new Color4f();
    protected Color4f _frontDiffuse = new Color4f();
    protected Color4f _frontSpecular = new Color4f(Color4f.BLACK);
    protected Color4f _frontEmission = new Color4f(Color4f.BLACK);
    protected float _frontShininess;
    protected Color4f _backAmbient = new Color4f();
    protected Color4f _backDiffuse = new Color4f();
    protected Color4f _backSpecular = new Color4f(Color4f.BLACK);
    protected Color4f _backEmission = new Color4f(Color4f.BLACK);
    protected float _backShininess;
    protected int _colorMaterialMode = -1;
    protected int _colorMaterialFace = 1028;
    protected boolean _twoSide;
    protected boolean _localViewer;
    protected boolean _separateSpecular;
    protected boolean _flatShading;

    public static MaterialState getInstance(Color4f ambient, Color4f diffuse, Color4f specular, Color4f emission, float shininess, int colorMaterialMode, boolean localViewer, boolean separateSpecular, boolean flatShading) {
        return MaterialState.getInstance(ambient, diffuse, specular, emission, shininess, ambient, diffuse, specular, emission, shininess, colorMaterialMode, 1028, false, localViewer, separateSpecular, flatShading);
    }

    public static MaterialState getInstance(Color4f frontAmbient, Color4f frontDiffuse, Color4f frontSpecular, Color4f frontEmission, float frontShininess, Color4f backAmbient, Color4f backDiffuse, Color4f backSpecular, Color4f backEmission, float backShininess, int colorMaterialMode, int colorMaterialFace, boolean localViewer, boolean separateSpecular, boolean flatShading) {
        return MaterialState.getInstance(frontAmbient, frontDiffuse, frontSpecular, frontEmission, frontShininess, backAmbient, backDiffuse, backSpecular, backEmission, backShininess, colorMaterialMode, colorMaterialFace, true, localViewer, separateSpecular, flatShading);
    }

    public static MaterialState getInstance(Color4f frontAmbient, Color4f frontDiffuse, Color4f frontSpecular, Color4f frontEmission, float frontShininess, Color4f backAmbient, Color4f backDiffuse, Color4f backSpecular, Color4f backEmission, float backShininess, int colorMaterialMode, int colorMaterialFace, boolean twoSide, boolean localViewer, boolean separateSpecular, boolean flatShading) {
        return MaterialState.getInstance(new MaterialState(frontAmbient, frontDiffuse, frontSpecular, frontEmission, frontShininess, backAmbient, backDiffuse, backSpecular, backEmission, backShininess, colorMaterialMode, colorMaterialFace, twoSide, localViewer, separateSpecular, flatShading));
    }

    public static MaterialState getInstance(MaterialState state) {
        if (state.equals(DEFAULT)) {
            return DEFAULT;
        }
        if (state.equals(WHITE)) {
            return WHITE;
        }
        return state;
    }

    public MaterialState(Color4f ambient, Color4f diffuse, Color4f specular, Color4f emission, float shininess, int colorMaterialMode, boolean localViewer, boolean separateSpecular, boolean flatShading) {
        this(ambient, diffuse, specular, emission, shininess, ambient, diffuse, specular, emission, shininess, colorMaterialMode, 1028, false, localViewer, separateSpecular, flatShading);
    }

    public MaterialState(Color4f frontAmbient, Color4f frontDiffuse, Color4f frontSpecular, Color4f frontEmission, float frontShininess, Color4f backAmbient, Color4f backDiffuse, Color4f backSpecular, Color4f backEmission, float backShininess, int colorMaterialMode, int colorMaterialFace, boolean localViewer, boolean separateSpecular, boolean flatShading) {
        this(frontAmbient, frontDiffuse, frontSpecular, frontEmission, frontShininess, backAmbient, backDiffuse, backSpecular, backEmission, backShininess, colorMaterialMode, colorMaterialFace, true, localViewer, separateSpecular, flatShading);
    }

    public MaterialState(Color4f frontAmbient, Color4f frontDiffuse, Color4f frontSpecular, Color4f frontEmission, float frontShininess, Color4f backAmbient, Color4f backDiffuse, Color4f backSpecular, Color4f backEmission, float backShininess, int colorMaterialMode, int colorMaterialFace, boolean twoSide, boolean localViewer, boolean separateSpecular, boolean flatShading) {
        this._frontAmbient.set(frontAmbient);
        this._frontDiffuse.set(frontDiffuse);
        this._frontSpecular.set(frontSpecular);
        this._frontEmission.set(frontEmission);
        this._frontShininess = frontShininess;
        this._backAmbient.set(backAmbient);
        this._backDiffuse.set(backDiffuse);
        this._backSpecular.set(backSpecular);
        this._backEmission.set(backEmission);
        this._backShininess = backShininess;
        this._colorMaterialMode = colorMaterialMode;
        this._colorMaterialFace = colorMaterialFace;
        this._twoSide = twoSide;
        this._localViewer = localViewer;
        this._separateSpecular = separateSpecular;
        this._flatShading = flatShading;
    }

    public MaterialState() {
    }

    public Color4f getFrontAmbient() {
        return this._frontAmbient;
    }

    public Color4f getFrontDiffuse() {
        return this._frontDiffuse;
    }

    public Color4f getFrontSpecular() {
        return this._frontSpecular;
    }

    public Color4f getFrontEmission() {
        return this._frontEmission;
    }

    public float getFrontShininess() {
        return this._frontShininess;
    }

    public Color4f getBackAmbient() {
        return this._backAmbient;
    }

    public Color4f getBackDiffuse() {
        return this._backDiffuse;
    }

    public Color4f getBackSpecular() {
        return this._backSpecular;
    }

    public Color4f getBackEmission() {
        return this._backEmission;
    }

    public float getBackShininess() {
        return this._backShininess;
    }

    public int getColorMaterialMode() {
        return this._colorMaterialMode;
    }

    public int getColorMaterialFace() {
        return this._colorMaterialFace;
    }

    public boolean getTwoSide() {
        return this._twoSide;
    }

    public boolean getLocalViewer() {
        return this._localViewer;
    }

    public boolean getSeparateSpecular() {
        return this._separateSpecular;
    }

    public boolean getFlatShading() {
        return this._flatShading;
    }

    @Override
    public int getType() {
        return 9;
    }

    @Override
    public void apply(Renderer renderer) {
        renderer.setMaterialState(this._frontAmbient, this._frontDiffuse, this._frontSpecular, this._frontEmission, this._frontShininess, this._backAmbient, this._backDiffuse, this._backSpecular, this._backEmission, this._backShininess, this._colorMaterialMode, this._colorMaterialFace, this._twoSide, this._localViewer, this._separateSpecular, this._flatShading);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof MaterialState)) return false;
        MaterialState ostate = (MaterialState)other;
        if (!this._frontAmbient.equals(ostate._frontAmbient)) return false;
        if (!this._frontDiffuse.equals(ostate._frontDiffuse)) return false;
        if (!this._frontSpecular.equals(ostate._frontSpecular)) return false;
        if (!this._frontEmission.equals(ostate._frontEmission)) return false;
        if (this._frontShininess != ostate._frontShininess) return false;
        if (!this._backAmbient.equals(ostate._backAmbient)) return false;
        if (!this._backDiffuse.equals(ostate._backDiffuse)) return false;
        if (!this._backSpecular.equals(ostate._backSpecular)) return false;
        if (!this._backEmission.equals(ostate._backEmission)) return false;
        if (this._backShininess != ostate._backShininess) return false;
        if (this._colorMaterialMode != ostate._colorMaterialMode) return false;
        if (this._colorMaterialFace != ostate._colorMaterialFace) return false;
        if (this._twoSide != ostate._twoSide) return false;
        if (this._localViewer != ostate._localViewer) return false;
        if (this._separateSpecular != ostate._separateSpecular) return false;
        if (this._flatShading != ostate._flatShading) return false;
        return true;
    }
}

