/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer;

import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.Texture;
import com.threerings.opengl.util.GlUtil;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.ARBTextureCompression;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class TextureCubeMap
extends Texture {
    public static final int[] FACE_TARGETS = new int[]{34069, 34070, 34071, 34072, 34073, 34074};
    protected int _size;

    public TextureCubeMap(Renderer renderer) {
        super(renderer, 34067);
    }

    public void setImages(int format, int size, boolean border, boolean mipmap) {
        this.setImages(0, format, size, border);
        if (mipmap) {
            int ll = 1;
            for (int ss = this._size / 2; ss > 0; ss /= 2) {
                this.setImages(ll, format, ss, border);
                ++ll;
            }
        }
    }

    public void setImages(int level, int format, int size, boolean border) {
        for (int target : FACE_TARGETS) {
            this.setImage(target, level, format, size, border, TextureCubeMap.getTransferFormat(format), 5121, null);
        }
    }

    public void setImage(int target, int level, int format, int size, boolean border, int dformat, int dtype, ByteBuffer data) {
        if (!GLContext.getCapabilities().GL_ARB_texture_non_power_of_two) {
            size = GlUtil.nextPowerOfTwo(size);
        }
        if (level == 0) {
            this._format = format;
            this._size = size;
        }
        this._renderer.setTexture(this);
        int ib = border ? 1 : 0;
        int ib2 = ib * 2;
        int bsize = size + ib2;
        GL11.glTexImage2D((int)target, (int)level, (int)format, (int)bsize, (int)bsize, (int)ib, (int)dformat, (int)dtype, (ByteBuffer)data);
    }

    public void setCompressedImage(int target, int level, int format, int size, boolean border, ByteBuffer data) {
        if (level == 0) {
            this._format = format;
            this._size = size;
        }
        this._renderer.setTexture(this);
        int ib = border ? 1 : 0;
        int ib2 = ib * 2;
        int bsize = size + ib2;
        ARBTextureCompression.glCompressedTexImage2DARB((int)target, (int)level, (int)format, (int)bsize, (int)bsize, (int)ib, (ByteBuffer)data);
    }

    public void setImages(int format, boolean border, BufferedImage[] images, boolean premultiply, boolean rescale, boolean mipmap) {
        this.setImages(0, format, border, images, premultiply, rescale);
        if (mipmap) {
            int ll = 1;
            for (int ss = this._size / 2; ss > 0; ss /= 2) {
                for (int ii = 0; ii < images.length; ++ii) {
                    if (images[ii] == null) continue;
                    images[ii] = TextureCubeMap.halveImage(images[ii]);
                }
                this.setImages(ll, format, border, images, premultiply, rescale);
                ++ll;
            }
        }
    }

    public void setImages(int level, int format, boolean border, BufferedImage[] images, boolean premultiply, boolean rescale) {
        int size = 1;
        for (BufferedImage image : images) {
            if (image == null) continue;
            size = Math.max(size, Math.max(image.getWidth(), image.getHeight()));
        }
        if (!GLContext.getCapabilities().GL_ARB_texture_non_power_of_two) {
            size = GlUtil.nextPowerOfTwo(size);
        }
        if (level == 0) {
            this._format = format;
            this._size = size;
        }
        this._renderer.setTexture(this);
        int ib = border ? 1 : 0;
        int ib2 = ib * 2;
        int bsize = size + ib2;
        for (int ii = 0; ii < FACE_TARGETS.length; ++ii) {
            BufferedImage image = images[ii];
            if (image == null) continue;
            GL11.glTexImage2D((int)FACE_TARGETS[ii], (int)level, (int)format, (int)bsize, (int)bsize, (int)ib, (int)TextureCubeMap.getFormat(image), (int)5121, (ByteBuffer)TextureCubeMap.getData(image, premultiply, size, size, rescale));
        }
    }

    public void setImages(int format, boolean border, BufferedImage image, int sdivs, int tdivs, boolean premultiply, boolean rescale, boolean mipmap) {
        this.setImages(0, format, border, image, sdivs, tdivs, premultiply, rescale);
        if (mipmap) {
            int ll = 1;
            for (int ss = this._size / 2; ss > 0; ss /= 2) {
                this.setImages(ll, format, border, image, sdivs, tdivs, premultiply, rescale);
                ++ll;
            }
        }
    }

    public void setImages(int level, int format, boolean border, BufferedImage image, int sdivs, int tdivs, boolean premultiply, boolean rescale) {
        int size = Math.max(image.getWidth() / sdivs, image.getHeight() / tdivs);
        if (!GLContext.getCapabilities().GL_ARB_texture_non_power_of_two) {
            size = GlUtil.nextPowerOfTwo(size);
        }
        if (level == 0) {
            this._format = format;
            this._size = size;
        }
        this._renderer.setTexture(this);
    }

    @Override
    public int getWidth() {
        return this._size;
    }

    @Override
    public int getHeight() {
        return this._size;
    }
}

