/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer;

import com.threerings.opengl.renderer.Renderbuffer;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.Texture;
import com.threerings.opengl.renderer.TextureCubeMap;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.EXTFramebufferObject;

public class Framebuffer {
    protected Renderer _renderer;
    protected int _id;
    protected Object _colorAttachment;
    protected int _colorLevel;
    protected int _colorParam;
    protected Object _depthAttachment;
    protected int _depthLevel;
    protected int _depthParam;
    protected Object _stencilAttachment;
    protected int _stencilLevel;
    protected int _stencilParam;

    public Framebuffer(Renderer renderer) {
        this._renderer = renderer;
        IntBuffer idbuf = BufferUtils.createIntBuffer((int)1);
        EXTFramebufferObject.glGenFramebuffersEXT((IntBuffer)idbuf);
        this._id = idbuf.get(0);
    }

    public final int getId() {
        return this._id;
    }

    public void setColorAttachment(Texture texture) {
        this.setColorAttachment(texture, 0, 0);
    }

    public void setColorAttachment(Texture texture, int level, int param) {
        if (this._colorAttachment != texture || this._colorLevel != level || this._colorParam != param) {
            this._colorLevel = level;
            this._colorParam = param;
            this.setAttachment(36064, texture, this._colorLevel, this._colorParam);
            this._colorAttachment = texture;
        }
    }

    public void setColorAttachment(Renderbuffer renderbuffer) {
        if (this._colorAttachment != renderbuffer) {
            this.setAttachment(36064, renderbuffer);
            this._colorAttachment = renderbuffer;
        }
    }

    public Object getColorAttachment() {
        return this._colorAttachment;
    }

    public void setDepthAttachment(Texture texture) {
        this.setDepthAttachment(texture, 0, 0);
    }

    public void setDepthAttachment(Texture texture, int level, int param) {
        if (this._depthAttachment != texture || this._depthLevel != level || this._depthParam != param) {
            this._depthLevel = level;
            this._depthParam = param;
            this.setAttachment(36096, texture, this._depthLevel, this._depthParam);
            this._depthAttachment = texture;
        }
    }

    public void setDepthAttachment(Renderbuffer renderbuffer) {
        if (this._depthAttachment != renderbuffer) {
            this.setAttachment(36096, renderbuffer);
            this._depthAttachment = renderbuffer;
        }
    }

    public Object getDepthAttachment() {
        return this._depthAttachment;
    }

    public void setStencilAttachment(Texture texture) {
        this.setStencilAttachment(texture, 0, 0);
    }

    public void setStencilAttachment(Texture texture, int level, int param) {
        if (this._stencilAttachment != texture || this._stencilLevel != level || this._stencilParam != param) {
            this._stencilLevel = level;
            this._stencilParam = param;
            this.setAttachment(36128, texture, this._stencilLevel, this._stencilParam);
            this._stencilAttachment = texture;
        }
    }

    public void setStencilAttachment(Renderbuffer renderbuffer) {
        if (this._stencilAttachment != renderbuffer) {
            this.setAttachment(36128, renderbuffer);
            this._stencilAttachment = renderbuffer;
        }
    }

    public Object getStencilAttachment() {
        return this._stencilAttachment;
    }

    public boolean isComplete() {
        return this.checkStatus() == 36053;
    }

    public int checkStatus() {
        Framebuffer obuffer = this._renderer.getFramebuffer();
        this._renderer.setFramebuffer(this);
        int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        this._renderer.setFramebuffer(obuffer);
        return status;
    }

    public void delete() {
        IntBuffer idbuf = BufferUtils.createIntBuffer((int)1);
        idbuf.put(this._id).rewind();
        EXTFramebufferObject.glDeleteFramebuffersEXT((IntBuffer)idbuf);
        this._id = 0;
    }

    protected void setAttachment(int attachment, Texture texture, int level, int param) {
        Framebuffer obuffer = this._renderer.getFramebuffer();
        this._renderer.setFramebuffer(this);
        int target = texture.getTarget();
        if (target == 3552) {
            EXTFramebufferObject.glFramebufferTexture1DEXT((int)36160, (int)attachment, (int)3552, (int)texture.getId(), (int)level);
        } else if (target == 32879) {
            EXTFramebufferObject.glFramebufferTexture3DEXT((int)36160, (int)attachment, (int)32879, (int)texture.getId(), (int)level, (int)param);
        } else {
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)attachment, (int)(target == 34067 ? TextureCubeMap.FACE_TARGETS[param] : target), (int)texture.getId(), (int)level);
        }
        this._renderer.setFramebuffer(obuffer);
    }

    protected void setAttachment(int attachment, Renderbuffer renderbuffer) {
        Framebuffer obuffer = this._renderer.getFramebuffer();
        this._renderer.setFramebuffer(this);
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)attachment, (int)36161, (int)renderbuffer.getId());
        this._renderer.setFramebuffer(obuffer);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this._id > 0) {
            this._renderer.framebufferFinalized(this._id);
        }
    }
}

