/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer;

import com.threerings.opengl.renderer.Renderer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBBufferObject;

public class BufferObject {
    protected Renderer _renderer;
    protected int _id;
    protected int _bytes;

    public BufferObject(Renderer renderer) {
        this._renderer = renderer;
        IntBuffer idbuf = BufferUtils.createIntBuffer((int)1);
        ARBBufferObject.glGenBuffersARB((IntBuffer)idbuf);
        this._id = idbuf.get(0);
        this._renderer.bufferObjectCreated();
    }

    public final int getId() {
        return this._id;
    }

    public void setData(long size) {
        this.setData(size, 35044);
    }

    public void setData(long size, int usage) {
        this._renderer.setArrayBuffer(this);
        ARBBufferObject.glBufferDataARB((int)34962, (long)size, (int)usage);
        this.setBytes((int)size);
    }

    public void setData(FloatBuffer data) {
        this.setData(data, 35044);
    }

    public void setData(FloatBuffer data, int usage) {
        this._renderer.setArrayBuffer(this);
        ARBBufferObject.glBufferDataARB((int)34962, (FloatBuffer)data, (int)usage);
        this.setBytes(data.remaining() * 4);
    }

    public void setData(ShortBuffer data) {
        this.setData(data, 35044);
    }

    public void setData(ShortBuffer data, int usage) {
        this._renderer.setArrayBuffer(this);
        ARBBufferObject.glBufferDataARB((int)34962, (ShortBuffer)data, (int)usage);
        this.setBytes(data.remaining() * 2);
    }

    public void setSubData(long offset, FloatBuffer data) {
        this._renderer.setArrayBuffer(this);
        ARBBufferObject.glBufferSubDataARB((int)34962, (long)offset, (FloatBuffer)data);
    }

    public void setSubData(long offset, ShortBuffer data) {
        this._renderer.setArrayBuffer(this);
        ARBBufferObject.glBufferSubDataARB((int)34962, (long)offset, (ShortBuffer)data);
    }

    public void delete() {
        IntBuffer idbuf = BufferUtils.createIntBuffer((int)1);
        idbuf.put(this._id).rewind();
        ARBBufferObject.glDeleteBuffersARB((IntBuffer)idbuf);
        this._id = 0;
        this._renderer.bufferObjectDeleted(this._bytes);
    }

    protected BufferObject() {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this._id > 0) {
            this._renderer.bufferObjectFinalized(this._id, this._bytes);
        }
    }

    protected void setBytes(int bytes) {
        this._renderer.bufferObjectResized(bytes - this._bytes);
        this._bytes = bytes;
    }
}

