/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.sprite;

import com.samskivert.util.ListUtil;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.expr.Bound;
import com.threerings.expr.Scope;
import com.threerings.expr.ScopeEvent;
import com.threerings.expr.SimpleScope;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.util.GlContext;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.client.sprite.EntrySprite;
import com.threerings.tudey.client.sprite.PathSprite;
import com.threerings.tudey.client.util.AreaElement;
import com.threerings.tudey.client.util.ShapeSceneElement;
import com.threerings.tudey.config.AreaConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.util.TudeyContext;

public class AreaSprite
extends EntrySprite
implements ConfigUpdateListener<AreaConfig> {
    protected TudeySceneModel.AreaEntry _entry;
    protected AreaConfig _config = INVALID_CONFIG;
    protected Implementation _impl = NULL_IMPLEMENTATION;
    protected static AreaConfig INVALID_CONFIG = new AreaConfig();
    protected static final Implementation NULL_IMPLEMENTATION = new Implementation(null){};

    public AreaSprite(TudeyContext ctx, TudeySceneView view, TudeySceneModel.AreaEntry entry) {
        super(ctx, view);
        this.update(entry);
    }

    public int getVertexIndex(Model model) {
        return this._impl.getVertexIndex(model);
    }

    public int getEdgeIndex(Model model) {
        return this._impl.getEdgeIndex(model);
    }

    @Override
    public void configUpdated(ConfigEvent<AreaConfig> event) {
        this.updateFromConfig();
        this._impl.update(this._entry);
    }

    @Override
    public void scopeUpdated(ScopeEvent event) {
        super.scopeUpdated(event);
        this.updateFromConfig();
        this._impl.update(this._entry);
    }

    @Override
    public TudeySceneModel.Entry getEntry() {
        return this._entry;
    }

    @Override
    public void setVisible(boolean visible) {
        this._impl.setVisible(visible);
    }

    @Override
    public void update(TudeySceneModel.Entry entry) {
        this._entry = (TudeySceneModel.AreaEntry)entry;
        this.setConfig(this._entry.area);
        this._impl.update(this._entry);
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.updateFromConfig();
        this._impl.update(this._entry);
    }

    @Override
    public void dispose() {
        super.dispose();
        this._impl.dispose();
        if (this._config != null) {
            this._config.removeListener(this);
        }
    }

    protected void setConfig(ConfigReference<AreaConfig> ref) {
        this.setConfig(this._ctx.getConfigManager().getConfig(AreaConfig.class, ref));
    }

    protected void setConfig(AreaConfig config) {
        if (this._config == config) {
            return;
        }
        if (this._config != null) {
            this._config.removeListener(this);
        }
        if ((this._config = config) != null) {
            this._config.addListener(this);
        }
        this.updateFromConfig();
    }

    protected void updateFromConfig() {
        AreaConfig.Original original = this._config == null ? null : this._config.getOriginal(this._ctx.getConfigManager());
        original = original == null ? AreaConfig.NULL_ORIGINAL : original;
        Implementation nimpl = original.getSpriteImplementation(this._ctx, this, this._impl);
        Implementation implementation = nimpl = nimpl == null ? NULL_IMPLEMENTATION : nimpl;
        if (this._impl != nimpl) {
            this._impl.dispose();
            this._impl = nimpl;
        }
    }

    public static class Original
    extends Implementation {
        protected TudeyContext _ctx;
        protected Model[] _vertices = new Model[0];
        protected Model[] _edges = new Model[0];
        protected AreaElement _area;
        protected ColorState _colorState = new ColorState();
        protected ShapeSceneElement _footprint;
        @Bound
        protected Scene _scene;

        public Original(TudeyContext ctx, Scope parentScope, AreaConfig.Original config) {
            super(parentScope);
            this._ctx = ctx;
            this._area = new AreaElement(ctx);
            this._scene.add(this._area);
            this._area.setUserObject(this._parentScope);
            this.setConfig(config);
        }

        public void setConfig(AreaConfig.Original config) {
            this._colorState.getColor().set(config.color);
            this._area.getColor().set(config.color).multLocal(0.5f);
            boolean selected = ((AreaSprite)this._parentScope).isSelected();
            if (selected && this._footprint == null) {
                this._footprint = new ShapeSceneElement((GlContext)this._ctx, true);
                this._footprint.getColor().set(EntrySprite.SELECTED_COLOR);
                this._scene.add(this._footprint);
            } else if (!selected && this._footprint != null) {
                this._scene.remove(this._footprint);
                this._footprint = null;
            }
        }

        @Override
        public int getVertexIndex(Model model) {
            return ListUtil.indexOfRef((Object[])this._vertices, (Object)model);
        }

        @Override
        public int getEdgeIndex(Model model) {
            return ListUtil.indexOfRef((Object[])this._edges, (Object)model);
        }

        @Override
        public void update(TudeySceneModel.AreaEntry entry) {
            this._vertices = PathSprite.maybeResize(this._vertices, entry.vertices.length, this._ctx, this._scene, "editor/marker/vertex/model.dat", this._colorState, this._parentScope);
            float minz = PathSprite.updateVertices(entry.vertices, this._vertices);
            this._edges = PathSprite.maybeResize(this._edges, entry.vertices.length, this._ctx, this._scene, "editor/marker/edge/model.dat", this._colorState, this._parentScope);
            PathSprite.updateEdges(entry.vertices, this._edges);
            this._area.setVertices(entry.vertices);
            if (this._edges.length > 0) {
                float size = this._area.getBounds().getDiagonalLength();
                float offset = this._edges[0].getBounds().getMaximumExtent().z - this._edges[0].getBounds().getMinimumExtent().z;
                this._area.getTransform().getTranslation().z = offset + (size > 0.0f ? (offset *= 0.5f) / size : 0.0f);
            }
            if (this._footprint != null) {
                this._footprint.getTransform().getTranslation().z = minz;
                this._footprint.setShape(entry.createShape(this._ctx.getConfigManager()));
            }
        }

        @Override
        public void setVisible(boolean visible) {
            for (Model vertex : this._vertices) {
                vertex.setVisible(visible);
            }
            for (Model edge : this._edges) {
                edge.setVisible(visible);
            }
            this._area.setVisible(visible);
        }

        @Override
        public void dispose() {
            super.dispose();
            this._scene.removeAll(this._vertices);
            this._scene.removeAll(this._edges);
            this._scene.remove(this._area);
            if (this._footprint != null) {
                this._scene.remove(this._footprint);
            }
        }
    }

    public static abstract class Implementation
    extends SimpleScope {
        public Implementation(Scope parentScope) {
            super(parentScope);
        }

        public int getVertexIndex(Model model) {
            return -1;
        }

        public int getEdgeIndex(Model model) {
            return -1;
        }

        public void update(TudeySceneModel.AreaEntry entry) {
        }

        public void setVisible(boolean visible) {
        }

        @Override
        public String getScopeName() {
            return "impl";
        }
    }
}

