/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.threerings.export.Exportable;
import com.threerings.export.Exporter;
import com.threerings.export.Streamer;
import com.threerings.export.Streams;
import com.threerings.util.ReflectionUtil;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;

public class BinaryExporter
extends Exporter {
    public static final int MAGIC_NUMBER = -87118066;
    public static final short VERSION = 4098;
    public static final short COMPRESSED_FORMAT_FLAG = 4096;
    public static final byte FINAL_CLASS_FLAG = 1;
    public static final byte INNER_CLASS_FLAG = 2;
    public static final byte COLLECTION_CLASS_FLAG = 4;
    public static final byte MAP_CLASS_FLAG = 8;
    public static final byte MULTI_FLAG = 16;
    public static final Class<?>[] BOOTSTRAP_CLASSES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE};
    protected OutputStream _base;
    protected DataOutputStream _out;
    protected boolean _compress;
    protected DeflaterOutputStream _defout;
    protected IdentityHashMap<Object, Integer> _objectIds;
    protected int _lastObjectId;
    protected Map<Class<?>, Integer> _classIds = new HashMap();
    protected int _lastClassId;
    protected Map<String, FieldValue> _fields;
    protected Map<Class<?>, ClassData> _classData = new HashMap();
    protected static final Set<Object> TYPE_ERASED_SINGLETONS = Sets.newIdentityHashSet();

    public BinaryExporter(OutputStream out) {
        this(out, true);
    }

    public BinaryExporter(OutputStream out, boolean compress) {
        this._base = out;
        this._out = new DataOutputStream(this._base);
        this._compress = compress;
        for (Class<?> clazz : BOOTSTRAP_CLASSES) {
            this._classIds.put(clazz, ++this._lastClassId);
        }
    }

    @Override
    public BinaryExporter setReplacer(Exporter.Replacer replacer) {
        super.setReplacer(replacer);
        return this;
    }

    @Override
    public void writeObject(Object object) throws IOException {
        if (this._objectIds == null) {
            this._out.writeInt(-87118066);
            this._out.writeShort(4098);
            this._out.writeShort(this._compress ? 4096 : 0);
            if (this._compress) {
                this._defout = new DeflaterOutputStream(this._base);
                this._out = new DataOutputStream(this._defout);
            }
            this._objectIds = new IdentityHashMap();
            this._objectIds.put(null, 0);
        }
        this.write(object, Object.class);
    }

    @Override
    public void write(String name, boolean value) throws IOException {
        this._fields.put(name, new FieldValue(value, Boolean.TYPE));
    }

    @Override
    public void write(String name, byte value) throws IOException {
        this._fields.put(name, new FieldValue(value, Byte.TYPE));
    }

    @Override
    public void write(String name, char value) throws IOException {
        this._fields.put(name, new FieldValue(Character.valueOf(value), Character.TYPE));
    }

    @Override
    public void write(String name, double value) throws IOException {
        this._fields.put(name, new FieldValue(value, Double.TYPE));
    }

    @Override
    public void write(String name, float value) throws IOException {
        this._fields.put(name, new FieldValue(Float.valueOf(value), Float.TYPE));
    }

    @Override
    public void write(String name, int value) throws IOException {
        this._fields.put(name, new FieldValue(value, Integer.TYPE));
    }

    @Override
    public void write(String name, long value) throws IOException {
        this._fields.put(name, new FieldValue(value, Long.TYPE));
    }

    @Override
    public void write(String name, short value) throws IOException {
        this._fields.put(name, new FieldValue(value, Short.TYPE));
    }

    @Override
    public <T> void write(String name, T value, Class<T> clazz) throws IOException {
        Exporter.Replacement repl;
        Object tVal = value;
        Class<Object> tClazz = clazz;
        if (this._replacer != null && (repl = this._replacer.getReplacement(value, clazz)) != null) {
            tVal = repl.value;
            tClazz = repl.clazz;
        }
        this._fields.put(name, new FieldValue(tVal, tClazz));
    }

    @Override
    public void close() throws IOException {
        this._out.close();
    }

    @Override
    public void finish() throws IOException {
        if (this._defout != null) {
            this._defout.finish();
        }
    }

    protected void write(Object value, Class<?> clazz) throws IOException {
        Exporter.Replacement repl;
        if (this._replacer != null && (repl = this._replacer.getReplacement(value, clazz)) != null) {
            value = repl.value;
            clazz = repl.clazz;
        }
        this.writeNoReplace(value, clazz);
    }

    protected void writeNoReplace(Object value, Class<?> clazz) throws IOException {
        Integer objectId;
        boolean track;
        if (clazz.isPrimitive()) {
            this.writeValue(value, clazz);
            return;
        }
        if (value instanceof String) {
            value = ((String)value).intern();
            track = true;
        } else {
            track = this.shouldTrackInstance(value);
        }
        if (track && (objectId = this._objectIds.get(value)) != null) {
            Streams.writeVarInt(this._out, objectId);
            return;
        }
        Streams.writeVarInt(this._out, ++this._lastObjectId);
        if (track) {
            this._objectIds.put(value, this._lastObjectId);
        }
        this.writeValue(value, clazz);
    }

    protected boolean shouldTrackInstance(Object value) {
        return !TYPE_ERASED_SINGLETONS.contains(value);
    }

    protected void writeValue(Object value, Class<?> clazz) throws IOException {
        Object outer;
        Streamer<?> streamer;
        Class<?> cclazz = BinaryExporter.getClass(value);
        if (!Modifier.isFinal(clazz.getModifiers())) {
            this.writeClass(cclazz);
        }
        if ((streamer = Streamer.getStreamer(cclazz)) != null) {
            streamer.write(value, this._out);
            return;
        }
        if (cclazz.isArray()) {
            Streams.writeVarInt(this._out, Array.getLength(value));
        }
        if (!(value instanceof Collection) && !(value instanceof Map) && (outer = ReflectionUtil.getOuter(value)) != null) {
            this.write(outer, Object.class);
        }
        if (value instanceof Exportable) {
            this.writeFields((Exportable)value);
        } else if (value instanceof Object[]) {
            Class<?> ctype = cclazz.getComponentType();
            this.writeEntries((Object[])value, ctype);
        } else if (value instanceof Collection) {
            if (value instanceof EnumSet) {
                this.writeEntries((EnumSet)value);
            } else if (value instanceof Multiset) {
                this.writeEntries((Multiset)value);
            } else {
                this.writeEntries((Collection)value);
            }
        } else if (value instanceof Map) {
            this.writeEntries((Map)value);
        } else {
            if (value instanceof Multimap) {
                throw new IOException("TODO: Multimap support");
            }
            throw new IOException("Value is not exportable [class=" + cclazz + "].");
        }
    }

    protected void writeClass(Class<?> clazz) throws IOException {
        Integer classId = this._classIds.get(clazz);
        if (classId != null) {
            Streams.writeVarInt(this._out, classId);
            return;
        }
        Streams.writeVarInt(this._out, ++this._lastClassId);
        this._classIds.put(clazz, this._lastClassId);
        Streamer.writeUTF(this._out, clazz.getName());
        this._out.writeByte(BinaryExporter.getFlags(BinaryExporter.getInmostComponentType(clazz)));
    }

    @Override
    protected void writeFields(Exportable object) throws IOException {
        HashMap<String, FieldValue> fields = new HashMap<String, FieldValue>();
        this._fields = fields;
        super.writeFields(object);
        this._fields = null;
        Class<?> clazz = object.getClass();
        ClassData cdata = this._classData.get(clazz);
        if (cdata == null) {
            cdata = new ClassData();
            this._classData.put(clazz, cdata);
        }
        cdata.writeFields(fields);
    }

    protected <T> void writeEntries(T[] array, Class<T> ctype) throws IOException {
        for (T entry : array) {
            this.write(entry, ctype);
        }
    }

    protected void writeEntries(EnumSet<?> set) throws IOException {
        EnumSet<?> typer = set.isEmpty() ? EnumSet.complementOf(set) : set;
        Class ctype = ((Enum)typer.iterator().next()).getDeclaringClass();
        this.writeClass(ctype);
        this.writeEntries((Collection<?>)set);
    }

    protected void writeEntries(Collection<?> collection) throws IOException {
        Streams.writeVarInt(this._out, collection.size());
        for (Object entry : collection) {
            this.write(entry, Object.class);
        }
    }

    protected void writeEntries(Multiset<?> multiset) throws IOException {
        Multiset<?> mset = multiset;
        Set entrySet = mset.entrySet();
        Streams.writeVarInt(this._out, entrySet.size());
        for (Multiset.Entry entry : entrySet) {
            this.write(entry.getElement(), Object.class);
            Streams.writeVarInt(this._out, entry.getCount());
        }
    }

    protected void writeEntries(Map<?, ?> map) throws IOException {
        Streams.writeVarInt(this._out, map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.write(entry.getKey(), Object.class);
            this.write(entry.getValue(), Object.class);
        }
    }

    protected static Class<?> getInmostComponentType(Class<?> clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    protected static byte getFlags(Class<?> clazz) {
        byte flags = 0;
        int mods = clazz.getModifiers();
        if (Modifier.isFinal(mods)) {
            flags = (byte)(flags | 1);
        }
        if (ReflectionUtil.isInner(clazz)) {
            flags = (byte)(flags | 2);
        }
        if (!Exportable.class.isAssignableFrom(clazz)) {
            if (Collection.class.isAssignableFrom(clazz)) {
                flags = (byte)(flags | 4);
                if (Multiset.class.isAssignableFrom(clazz)) {
                    flags = (byte)(flags | 0x10);
                }
            } else if (Map.class.isAssignableFrom(clazz)) {
                flags = (byte)(flags | 8);
            }
        }
        return flags;
    }

    static {
        TYPE_ERASED_SINGLETONS.addAll(Arrays.asList(ImmutableList.of(), ImmutableSet.of(), ImmutableSortedSet.of(), ImmutableMap.of(), ImmutableMultiset.of(), Collections.emptyList(), Collections.emptySet(), Collections.emptyMap()));
    }

    protected static class FieldData {
        public final String name;
        public final Class<?> clazz;

        public FieldData(String name, Class<?> clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FieldData)) {
                return false;
            }
            FieldData that = (FieldData)o;
            return this.name.equals(that.name) && this.clazz.equals(that.clazz);
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.clazz.hashCode();
        }
    }

    protected static class FieldValue {
        public final Object value;
        public final Class<?> clazz;

        public FieldValue(Object value, Class<?> clazz) {
            this.value = value;
            this.clazz = clazz;
        }
    }

    protected class ClassData {
        protected Map<FieldData, Integer> _fieldIds = Maps.newHashMap();
        protected int _nextFieldId;

        protected ClassData() {
        }

        public void writeFields(Map<String, FieldValue> fields) throws IOException {
            Streams.writeVarInt(BinaryExporter.this._out, fields.size());
            for (Map.Entry<String, FieldValue> entry : fields.entrySet()) {
                FieldValue value = entry.getValue();
                this.writeField(entry.getKey(), value.value, value.clazz);
            }
        }

        protected void writeField(String name, Object value, Class<?> clazz) throws IOException {
            FieldData field = new FieldData(name, clazz);
            Integer fieldId = this._fieldIds.get(field);
            if (fieldId == null) {
                int newFieldId = this._nextFieldId++;
                Streams.writeVarInt(BinaryExporter.this._out, newFieldId);
                this._fieldIds.put(field, newFieldId);
                BinaryExporter.this.writeNoReplace(name, String.class);
                BinaryExporter.this.writeClass(clazz);
            } else {
                Streams.writeVarInt(BinaryExporter.this._out, fieldId);
            }
            BinaryExporter.this.writeNoReplace(value, clazz);
        }
    }
}

