/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.data.actor;

import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.delta.DeltaFinal;
import com.threerings.delta.Deltable;
import com.threerings.io.Streamable;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector2f;
import com.threerings.opengl.util.Preloadable;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.config.ActorConfig;
import com.threerings.tudey.util.ActorAdvancer;
import com.threerings.tudey.util.TudeyContext;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;

public class Actor
extends DeepObject
implements Streamable,
Deltable {
    public static final int WARP = 1;
    public static final int LAST_FLAG = 1;
    @DeepOmit
    protected ConfigReference<ActorConfig> _config;
    @DeepOmit
    @DeltaFinal
    protected int _id;
    @DeepOmit
    @DeltaFinal
    protected int _created;
    @DeepOmit
    protected int _destroyed = Integer.MAX_VALUE;
    @DeepOmit
    protected Vector2f _translation = new Vector2f();
    @DeepOmit
    protected float _rotation;
    @DeepOmit
    protected int _flags;
    @DeepOmit
    protected transient ActorConfig.Original _original;
    @DeepOmit
    protected transient boolean _dirty = true;
    protected static final ActorConfig.Original NULL_ORIGINAL = new ActorConfig.Original();

    public Actor(ConfigReference<ActorConfig> config, int id, int created, Vector2f translation, float rotation) {
        this._config = config;
        this._id = id;
        this._created = created;
        this._translation.set(translation);
        this._rotation = rotation;
    }

    public Actor() {
        this._id = 0;
        this._created = 0;
    }

    public void init(ConfigManager cfgmgr) {
        ActorConfig config = cfgmgr.getConfig(ActorConfig.class, this._config);
        this._original = config == null ? null : config.getOriginal(cfgmgr);
        this._original = this._original == null ? NULL_ORIGINAL : this._original;
    }

    public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
        if (preloads.add(new Preloadable.Config(ActorConfig.class, this._config))) {
            this._original.getPreloads(cfgmgr, preloads);
        }
    }

    public void setConfig(ConfigReference<ActorConfig> config) {
        this._config = config;
        this.setDirty(true);
    }

    public ConfigReference<ActorConfig> getConfig() {
        return this._config;
    }

    public ActorConfig.Original getOriginal() {
        return this._original;
    }

    public int getId() {
        return this._id;
    }

    public int getCreated() {
        return this._created;
    }

    public void setDestroyed(int destroyed) {
        this._destroyed = destroyed;
        this.setDirty(true);
    }

    public int getDestroyed() {
        return this._destroyed;
    }

    public void setTranslation(float x, float y) {
        if (this._translation.x != x || this._translation.y != y) {
            this._translation.set(x, y);
            this.setDirty(true);
        }
    }

    public Vector2f getTranslation() {
        return this._translation;
    }

    public void setRotation(float rotation) {
        if (this._rotation != rotation) {
            this._rotation = rotation;
            this.setDirty(true);
        }
    }

    public float getRotation() {
        return this._rotation;
    }

    public void setFlags(int flags) {
        this._flags = flags;
        this.setDirty(true);
    }

    public int getFlags() {
        return this._flags;
    }

    public void set(int flag, boolean value) {
        this._flags = value ? this._flags | flag : this._flags & ~flag;
        this.setDirty(true);
    }

    public void set(int flag) {
        this._flags |= flag;
        this.setDirty(true);
    }

    public void clear(int flag) {
        this._flags &= ~flag;
        this.setDirty(true);
    }

    public boolean isSet(int flag) {
        return (this._flags & flag) != 0;
    }

    public Actor interpolate(Actor other, int start, int end, int timestamp, Actor result) {
        this.copy(result);
        if (!other.isSet(1)) {
            float t = (float)(timestamp - start) / (float)(end - start);
            this._translation.lerp(other.getTranslation(), t, result.getTranslation());
            result.setRotation(FloatMath.lerpa(this._rotation, other.getRotation(), t));
        }
        return result;
    }

    public Actor extrapolate(float elapsed, int timestamp, Actor result) {
        return (Actor)this.copy(result);
    }

    public ActorAdvancer maybeCreateAdvancer(TudeyContext ctx, TudeySceneView view, int timestamp) {
        if (view.getController() == null) {
            return null;
        }
        return this.isClientControlled(ctx, view) ? this.createAdvancer(view, timestamp) : null;
    }

    public boolean isClientControlled(TudeyContext ctx, TudeySceneView view) {
        return this._id < 0;
    }

    public ActorAdvancer createAdvancer(ActorAdvancer.Environment environment, int timestamp) {
        return new ActorAdvancer(environment, this, timestamp);
    }

    public boolean canCollide(Actor oactor) {
        return this._id != oactor.getId() && this.canCollide(oactor.getCollisionFlags());
    }

    public boolean canCollide(int flags) {
        return (this.getCollisionMask() & flags) != 0;
    }

    public int getCollisionFlags() {
        return this._original.collisionFlags;
    }

    public int getCollisionMask() {
        return this.isSet(1) ? this._original.spawnAdjustMask : this._original.collisionMask;
    }

    public boolean directionAffected() {
        return false;
    }

    public void setDirty(boolean dirty) {
        this._dirty = dirty;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    @Override
    public Object copy(Object dest) {
        ConfigReference config;
        Actor result = (Actor)super.copy(dest);
        result._config = config = (ConfigReference)this._config.copy(result._config);
        result._id = this._id;
        result._created = this._created;
        result._destroyed = this._destroyed;
        result._translation.set(this._translation);
        result._rotation = this._rotation;
        result._flags = this._flags;
        result._original = this._original;
        result.setDirty(true);
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        Actor oactor = (Actor)other;
        return this._config.equals(oactor._config) && this._id == oactor._id && this._created == oactor._created && this._destroyed == oactor._destroyed && this._translation.equals(oactor._translation) && this._rotation == oactor._rotation && this._flags == oactor._flags && this._original == oactor._original;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this._config.hashCode();
        hash = 31 * hash + this._id;
        hash = 31 * hash + this._created;
        hash = 31 * hash + this._destroyed;
        hash = 31 * hash + this._translation.hashCode();
        hash = 31 * hash + Float.floatToIntBits(this._rotation);
        hash = 31 * hash + this._flags;
        hash = 31 * hash + System.identityHashCode(this._original);
        return hash;
    }

    @Override
    public String toString() {
        return "[config=" + this._config + ", id=" + this._id + "]";
    }
}

