/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.sprite;

import com.threerings.expr.Bound;
import com.threerings.expr.Scope;
import com.threerings.expr.SimpleScope;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector2f;
import com.threerings.opengl.model.Animation;
import com.threerings.opengl.model.Model;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.client.sprite.ActorSprite;
import com.threerings.tudey.client.sprite.Sprite;
import com.threerings.tudey.config.EffectConfig;
import com.threerings.tudey.config.EffectSpriteConfig;
import com.threerings.tudey.data.effect.Effect;
import com.threerings.tudey.util.TudeyContext;

public class EffectSprite
extends Sprite
implements TudeySceneView.TickParticipant {
    protected Effect _effect;
    protected Implementation _impl;
    protected static final Implementation NULL_IMPLEMENTATION = new Implementation(null){};

    public EffectSprite(TudeyContext ctx, TudeySceneView view, Effect effect) {
        super(ctx, view);
        this._effect = effect;
        view.addTickParticipant(this);
    }

    public Effect getEffect() {
        return this._effect;
    }

    @Override
    public boolean tick(int delayedTime) {
        int timestamp = this._effect.getTimestamp();
        if (delayedTime < timestamp) {
            return true;
        }
        if (this._impl == null) {
            EffectConfig config = this._ctx.getConfigManager().getConfig(EffectConfig.class, this._effect.getConfig());
            this._impl = config == null ? null : config.createSpriteImplementation(this._ctx, this, this._effect);
            this._impl = this._impl == null ? NULL_IMPLEMENTATION : this._impl;
        }
        return this._impl.tick((float)(delayedTime - timestamp) / 1000.0f);
    }

    public static class Animator
    extends Original {
        public Animator(TudeyContext ctx, Scope parentScope, EffectSpriteConfig.Animator config, Effect effect) {
            super(ctx, parentScope, config, effect);
            Animation anim;
            if (this._targetModel != null && config.animation != null && (anim = this._targetModel.createAnimation(config.animation)) != null) {
                anim.start();
            }
        }
    }

    public static abstract class Implementation
    extends SimpleScope {
        public Implementation(Scope parentScope) {
            super(parentScope);
        }

        public boolean tick(float elapsed) {
            return false;
        }

        @Override
        public String getScopeName() {
            return "impl";
        }
    }

    public static class Original
    extends Implementation {
        protected Model _targetModel;
        @Bound
        protected TudeySceneView _view;

        public Original(TudeyContext ctx, Scope parentScope, EffectSpriteConfig config, Effect effect) {
            super(parentScope);
            Transform3D transform;
            Sprite sprite = this._view.getSprite(effect.getTarget());
            Model model = this._targetModel = sprite == null ? null : sprite.getModel();
            if (config.model == null) {
                return;
            }
            if (sprite instanceof ActorSprite && config.attachToTarget) {
                ((ActorSprite)sprite).spawnAttachedTransientModel(config.model, config.rotateWithTarget);
                return;
            }
            if (this._targetModel != null) {
                transform = this._targetModel.getLocalTransform();
            } else {
                Vector2f translation = effect.getTranslation();
                transform = this._view.getFloorTransform(translation.x, translation.y, effect.getRotation(), config.floorMask);
            }
            this._view.getScene().spawnTransient(config.model, transform);
        }
    }
}

