/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.effect;

import com.samskivert.util.HashIntMap;
import com.threerings.expr.Bound;
import com.threerings.expr.MutableInteger;
import com.threerings.expr.Scope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.FloatMath;
import com.threerings.math.Matrix4f;
import com.threerings.math.Quaternion;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.effect.Particle;
import com.threerings.opengl.effect.config.ParticleSystemConfig;
import com.threerings.opengl.geometry.DynamicGeometry;
import com.threerings.opengl.geometry.config.GeometryConfig;
import com.threerings.opengl.geometry.config.PassDescriptor;
import com.threerings.opengl.geometry.util.GeometryUtil;
import com.threerings.opengl.renderer.BufferObject;
import com.threerings.opengl.renderer.ClientArray;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.SimpleBatch;
import com.threerings.opengl.renderer.config.ClientArrayConfig;
import com.threerings.opengl.renderer.state.ArrayState;
import com.threerings.opengl.renderer.state.TransformState;
import com.threerings.opengl.util.GlContext;
import java.lang.ref.SoftReference;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GLContext;

public abstract class ParticleGeometry
extends DynamicGeometry {
    @Bound
    protected ParticleSystemConfig.Layer _config;
    @Bound
    protected Particle[] _particles;
    @Bound
    protected MutableInteger _living;
    @Bound
    protected TransformState _transformState;
    @Bound
    protected Vector3f _center;
    protected int _stride;
    protected int _texCoordOffset;
    protected int _colorOffset;
    protected int _normalOffset;
    protected int _vertexOffset;
    protected ArrayState[] _arrayStates;
    protected SimpleBatch.DrawElements _drawCommand;
    protected Transform3D _xform = new Transform3D();
    protected Vector3f _position = new Vector3f();
    protected Vector3f _last = new Vector3f();
    protected Vector3f _next = new Vector3f();
    protected Vector3f _view = new Vector3f();
    protected Quaternion _rotation = new Quaternion();
    protected Quaternion _vrot = new Quaternion();
    protected Vector3f _s = new Vector3f();
    protected Vector3f _t = new Vector3f();
    protected Vector3f _r = new Vector3f();
    protected Vector3f _n = new Vector3f();

    public ParticleGeometry(Scope scope) {
        ScopeUtil.updateBound(this, scope);
    }

    @Override
    public Vector3f getCenter() {
        return this._center;
    }

    @Override
    public ArrayState getArrayState(int pass) {
        return this._arrayStates[pass];
    }

    @Override
    public SimpleBatch.DrawCommand getDrawCommand(int pass) {
        return this._drawCommand;
    }

    @Override
    public void update() {
        super.update();
        this._drawCommand.setLimits(0, this._living.value * this.getParticleIndexCount());
        this._drawCommand.setRange(0, this._living.value * this.getParticleVertexCount() - 1);
    }

    protected void init(GlContext ctx, PassDescriptor[] passes) {
        boolean normals = false;
        PassDescriptor[] passDescriptorArray = passes;
        int n = passes.length;
        int n2 = 0;
        while (n2 < n) {
            PassDescriptor pass = passDescriptorArray[n2];
            normals |= pass.normals;
            ++n2;
        }
        HashMap<String, ClientArray> vertexAttribArrays = new HashMap<String, ClientArray>(0);
        HashIntMap texCoordArrays = new HashIntMap();
        ClientArray texCoordArray = new ClientArray(2, null);
        texCoordArrays.put(0, (Object)texCoordArray);
        ClientArray colorArray = new ClientArray(4, null);
        ClientArray normalArray = normals ? new ClientArray(3, null) : null;
        ClientArray vertexArray = new ClientArray(3, null);
        ArrayList<ClientArray> arrays = GeometryUtil.createList(vertexAttribArrays, (HashIntMap<ClientArray>)texCoordArrays, colorArray, normalArray, vertexArray);
        this._stride = GeometryUtil.updateOffsetsAndStride(arrays) / 4;
        this._texCoordOffset = (int)(texCoordArray.offset / 4L);
        this._colorOffset = (int)(colorArray.offset / 4L);
        this._normalOffset = normals ? (int)(normalArray.offset / 4L) : -1;
        this._vertexOffset = (int)(vertexArray.offset / 4L);
        float[] fArray = this._data = this._config.data == null ? null : this._config.data.get();
        if (this._data == null) {
            int size = this._particles.length * this.getParticleVertexCount() * this._stride;
            this._data = new float[size];
            this._config.data = new SoftReference<float[]>(this._data);
        }
        BufferObject elementArrayBuffer = null;
        if (GLContext.getCapabilities().GL_ARB_vertex_buffer_object) {
            this._arrayBuffer = new BufferObject(ctx.getRenderer());
            this._floatArray = ParticleGeometry.getScratchBuffer(this._data.length);
            BufferObject bufferObject = elementArrayBuffer = this._config.elementArrayBuffer == null ? null : this._config.elementArrayBuffer.get();
            if (elementArrayBuffer == null) {
                elementArrayBuffer = new BufferObject(ctx.getRenderer());
                this._config.elementArrayBuffer = new SoftReference<BufferObject>(elementArrayBuffer);
                elementArrayBuffer.setData(this.createIndices());
            }
            this._drawCommand = SimpleBatch.createDrawBufferElements(this.getMode(), 0, 0, 0, 5123, 0L);
        } else {
            ShortBuffer indices;
            this._floatArray = BufferUtils.createFloatBuffer((int)this._data.length);
            ShortBuffer shortBuffer = indices = this._config.indices == null ? null : this._config.indices.get();
            if (indices == null) {
                indices = this.createIndices();
                this._config.indices = new SoftReference<ShortBuffer>(indices);
            }
            this._drawCommand = SimpleBatch.createDrawShortElements(this.getMode(), 0, 0, indices);
        }
        for (ClientArray array : arrays) {
            array.arrayBuffer = this._arrayBuffer;
            FloatBuffer floatBuffer = array.floatArray = this._arrayBuffer == null ? this._floatArray : null;
        }
        this._arrayStates = GeometryUtil.createArrayStates(vertexAttribArrays, (HashIntMap<ClientArray>)texCoordArrays, colorArray, normalArray, vertexArray, elementArrayBuffer, passes);
    }

    protected ShortBuffer createIndices() {
        int[] prototype = this.getPrototypeIndices();
        ShortBuffer indices = BufferUtils.createShortBuffer((int)(this._particles.length * prototype.length));
        int vpp = this.getParticleVertexCount();
        int ii = 0;
        int offset = 0;
        while (ii < this._particles.length) {
            int[] nArray = prototype;
            int n = prototype.length;
            int n2 = 0;
            while (n2 < n) {
                int index = nArray[n2];
                indices.put((short)(offset + index));
                ++n2;
            }
            ++ii;
            offset += vpp;
        }
        indices.rewind();
        return indices;
    }

    protected abstract int getMode();

    protected abstract int getParticleVertexCount();

    protected abstract int getParticleIndexCount();

    protected abstract int[] getPrototypeIndices();

    protected static void computeOffset(Vector3f v1, Vector3f v2, float size, Vector3f result) {
        v1.cross(v2, result);
        float length = result.length();
        if (length > 1.0E-6f) {
            result.multLocal(size / length);
        } else {
            result.set(Vector3f.ZERO);
        }
    }

    protected static int write(float[] data, int idx, int stride, float v0, float v1) {
        data[idx] = v0;
        data[idx + 1] = v1;
        return idx + stride;
    }

    protected static int write(float[] data, int idx, int stride, float v0, float v1, float v2) {
        data[idx] = v0;
        data[idx + 1] = v1;
        data[idx + 2] = v2;
        return idx + stride;
    }

    protected static int write(float[] data, int idx, int stride, float v0, float v1, float v2, float v3) {
        data[idx] = v0;
        data[idx + 1] = v1;
        data[idx + 2] = v2;
        data[idx + 3] = v3;
        return idx + stride;
    }

    protected static int write(float[] data, int idx, int stride, Vector3f value) {
        data[idx] = value.x;
        data[idx + 1] = value.y;
        data[idx + 2] = value.z;
        return idx + stride;
    }

    protected static int write(float[] data, int idx, int stride, Color4f value) {
        data[idx] = value.r;
        data[idx + 1] = value.g;
        data[idx + 2] = value.b;
        data[idx + 3] = value.a;
        return idx + stride;
    }

    public static class LineTrails
    extends ParticleGeometry {
        protected int _segments;

        public LineTrails(GlContext ctx, Scope scope, PassDescriptor[] passes, int segments) {
            super(scope);
            this._segments = segments;
            this.init(ctx, passes);
        }

        @Override
        protected int getMode() {
            return 1;
        }

        @Override
        protected int getParticleVertexCount() {
            return this._segments + 1;
        }

        @Override
        protected int getParticleIndexCount() {
            return this._segments * 2;
        }

        @Override
        protected int[] getPrototypeIndices() {
            int[] prototype = new int[this._segments * 2];
            int ii = 0;
            int idx = 0;
            while (ii < this._segments) {
                prototype[idx++] = ii;
                prototype[idx++] = ii + 1;
                ++ii;
            }
            return prototype;
        }

        @Override
        protected void updateData() {
            Particle[] particles = this._particles;
            float[] data = this._data;
            int stride = this._stride;
            int segments = this._segments;
            Vector3f position = this._position;
            Vector3f n = this._n;
            boolean normals = this._normalOffset >= 0;
            int udivs = this._config.textureDivisionsS;
            float uscale = 1.0f / (float)udivs;
            float vscale = 1.0f / (float)this._config.textureDivisionsT;
            float tscale = 1.0f / (float)segments;
            int texCoordIdx = this._texCoordOffset;
            int colorIdx = this._colorOffset;
            int normalIdx = this._normalOffset;
            int vertexIdx = this._vertexOffset;
            int ii = 0;
            int nn = this._living.value;
            while (ii < nn) {
                Particle particle = particles[ii];
                int frame = FloatMath.round(particle.getFrame());
                float uoff = (float)(frame % udivs) * uscale;
                float voff = (float)(frame / udivs) * vscale;
                Color4f color = particle.getColor();
                float cr = color.r;
                float cg = color.g;
                float cb = color.b;
                float ca = color.a;
                if (normals) {
                    particle.getOrientation().transformUnitZ(n);
                    float nx = n.x;
                    float ny = n.y;
                    float nz = n.z;
                    int jj = 0;
                    while (jj <= segments) {
                        float frac = (float)jj * tscale;
                        particle.getPosition(frac, position);
                        texCoordIdx = LineTrails.write(data, texCoordIdx, stride, uoff + frac * uscale, voff);
                        colorIdx = LineTrails.write(data, colorIdx, stride, cr, cg, cb, ca);
                        normalIdx = LineTrails.write(data, normalIdx, stride, nx, ny, nz);
                        vertexIdx = LineTrails.write(data, vertexIdx, stride, position);
                        ++jj;
                    }
                } else {
                    int jj = 0;
                    while (jj <= segments) {
                        float frac = (float)jj * tscale;
                        particle.getPosition(frac, position);
                        texCoordIdx = LineTrails.write(data, texCoordIdx, stride, uoff + frac * uscale, voff);
                        colorIdx = LineTrails.write(data, colorIdx, stride, cr, cg, cb, ca);
                        vertexIdx = LineTrails.write(data, vertexIdx, stride, position);
                        ++jj;
                    }
                }
                ++ii;
            }
        }
    }

    public static class Lines
    extends ParticleGeometry {
        public Lines(GlContext ctx, Scope scope, PassDescriptor[] passes) {
            super(scope);
            this.init(ctx, passes);
        }

        @Override
        protected int getMode() {
            return 1;
        }

        @Override
        protected int getParticleVertexCount() {
            return 2;
        }

        @Override
        protected int getParticleIndexCount() {
            return 2;
        }

        @Override
        protected int[] getPrototypeIndices() {
            int[] nArray = new int[2];
            nArray[1] = 1;
            return nArray;
        }

        @Override
        protected void updateData() {
            Particle[] particles = this._particles;
            float[] data = this._data;
            int stride = this._stride;
            Vector3f s = this._s;
            Vector3f n = this._n;
            Quaternion rotation = this._rotation;
            Quaternion vrot = this._vrot;
            boolean normals = this._normalOffset >= 0;
            int udivs = this._config.textureDivisionsS;
            float uscale = 1.0f / (float)udivs;
            float vscale = 1.0f / (float)this._config.textureDivisionsT;
            ParticleSystemConfig.Alignment alignment = this._config.alignment;
            if (alignment == ParticleSystemConfig.Alignment.BILLBOARD) {
                this._transformState.getModelview().extractRotation(vrot).invertLocal();
            }
            int texCoordIdx = this._texCoordOffset;
            int colorIdx = this._colorOffset;
            int normalIdx = this._normalOffset;
            int vertexIdx = this._vertexOffset;
            int ii = 0;
            int nn = this._living.value;
            while (ii < nn) {
                Particle particle = particles[ii];
                int frame = FloatMath.round(particle.getFrame());
                float uoff = (float)(frame % udivs) * uscale;
                float voff = (float)(frame / udivs) * vscale;
                Color4f color = particle.getColor();
                float cr = color.r;
                float cg = color.g;
                float cb = color.b;
                float ca = color.a;
                Vector3f position = particle.getPosition();
                float px = position.x;
                float py = position.y;
                float pz = position.z;
                if (alignment == ParticleSystemConfig.Alignment.VELOCITY) {
                    Vector3f velocity = particle.getVelocity();
                    float length = velocity.length();
                    if (length < 1.0E-6f) {
                        s.set(Vector3f.ZERO);
                    } else {
                        velocity.mult(particle.getSize() / length, s);
                    }
                    if (normals) {
                        particle.getOrientation().transformUnitZ(n);
                    }
                } else {
                    Quaternion rot = alignment == ParticleSystemConfig.Alignment.BILLBOARD ? vrot.mult(particle.getOrientation(), rotation) : particle.getOrientation();
                    rot.transformUnitX(s).multLocal(particle.getSize());
                    if (normals) {
                        rot.transformUnitZ(n);
                    }
                }
                float sx = s.x;
                float sy = s.y;
                float sz = s.z;
                if (normals) {
                    float nx = n.x;
                    float ny = n.y;
                    float nz = n.z;
                    texCoordIdx = Lines.write(data, texCoordIdx, stride, uoff, voff);
                    colorIdx = Lines.write(data, colorIdx, stride, cr, cg, cb, ca);
                    normalIdx = Lines.write(data, normalIdx, stride, nx, ny, nz);
                    vertexIdx = Lines.write(data, vertexIdx, stride, px - sx, py - sy, pz - sz);
                    texCoordIdx = Lines.write(data, texCoordIdx, stride, uoff + uscale, voff);
                    colorIdx = Lines.write(data, colorIdx, stride, cr, cg, cb, ca);
                    normalIdx = Lines.write(data, normalIdx, stride, nx, ny, nz);
                    vertexIdx = Lines.write(data, vertexIdx, stride, px + sx, py + sy, pz + sz);
                } else {
                    texCoordIdx = Lines.write(data, texCoordIdx, stride, uoff, voff);
                    colorIdx = Lines.write(data, colorIdx, stride, cr, cg, cb, ca);
                    vertexIdx = Lines.write(data, vertexIdx, stride, px - sx, py - sy, pz - sz);
                    texCoordIdx = Lines.write(data, texCoordIdx, stride, uoff + uscale, voff);
                    colorIdx = Lines.write(data, colorIdx, stride, cr, cg, cb, ca);
                    vertexIdx = Lines.write(data, vertexIdx, stride, px + sx, py + sy, pz + sz);
                }
                ++ii;
            }
        }
    }

    public static class Meshes
    extends ParticleGeometry {
        protected GeometryConfig.IndexedStored _geom;
        protected float[] _source;
        protected int _sourceStride;
        protected int _sourceTexCoordOffset;
        protected int _sourceNormalOffset;
        protected int _sourceVertexOffset;

        public static ParticleGeometry create(GlContext ctx, Scope scope, PassDescriptor[] passes, GeometryConfig geom) {
            GeometryConfig.IndexedStored stored;
            if (geom instanceof GeometryConfig.IndexedStored && (stored = (GeometryConfig.IndexedStored)geom).getTexCoordArray(0) != null) {
                return new Meshes(ctx, scope, passes, stored);
            }
            return new Points(ctx, scope, passes);
        }

        public Meshes(GlContext ctx, Scope scope, PassDescriptor[] passes, GeometryConfig.IndexedStored geom) {
            super(scope);
            this._geom = geom;
            this.init(ctx, passes);
            ClientArrayConfig texCoordArray = geom.texCoordArrays[0];
            ClientArrayConfig vertexArray = geom.vertexArray;
            ClientArrayConfig normalArray = geom.normalArray;
            if (this._normalOffset >= 0) {
                this._source = this._geom.getFloatArray(false, texCoordArray, normalArray, vertexArray);
                this._sourceStride = texCoordArray.size + normalArray.size + vertexArray.size;
                this._sourceNormalOffset = texCoordArray.size;
                this._sourceVertexOffset = texCoordArray.size + normalArray.size;
            } else {
                this._source = this._geom.getFloatArray(false, texCoordArray, vertexArray);
                this._sourceStride = texCoordArray.size + vertexArray.size;
                this._sourceVertexOffset = texCoordArray.size;
            }
            this._sourceTexCoordOffset = 0;
        }

        @Override
        protected int getMode() {
            return this._geom.mode.getConstant();
        }

        @Override
        protected int getParticleVertexCount() {
            return this._geom.getVertexCount();
        }

        @Override
        protected int getParticleIndexCount() {
            return this._geom.indices.capacity();
        }

        @Override
        protected int[] getPrototypeIndices() {
            int[] prototype = new int[this._geom.indices.capacity()];
            int ii = 0;
            while (ii < prototype.length) {
                prototype[ii] = this._geom.indices.get(ii);
                ++ii;
            }
            return prototype;
        }

        @Override
        protected void updateData() {
            Particle[] particles = this._particles;
            float[] data = this._data;
            float[] source = this._source;
            int stride = this._stride;
            int sourceStride = this._sourceStride;
            Transform3D xform = this._xform;
            Quaternion vrot = this._vrot;
            Quaternion rotation = this._rotation;
            Vector3f s = this._s;
            Vector3f t = this._t;
            Vector3f r = this._r;
            Vector3f view = this._view;
            boolean normals = this._normalOffset >= 0;
            int udivs = this._config.textureDivisionsS;
            float uscale = 1.0f / (float)udivs;
            float vscale = 1.0f / (float)this._config.textureDivisionsT;
            ParticleSystemConfig.Alignment alignment = this._config.alignment;
            if (alignment == ParticleSystemConfig.Alignment.VELOCITY) {
                this._transformState.getModelview().invert(this._xform).transformVector(Vector3f.UNIT_Z, view);
            } else if (alignment == ParticleSystemConfig.Alignment.BILLBOARD) {
                this._transformState.getModelview().extractRotation(vrot).invertLocal();
            }
            int vpp = this._geom.getVertexCount();
            int texCoordIdx = this._texCoordOffset;
            int colorIdx = this._colorOffset;
            int normalIdx = this._normalOffset;
            int vertexIdx = this._vertexOffset;
            int ii = 0;
            int nn = this._living.value;
            while (ii < nn) {
                float m32;
                float m22;
                float m12;
                float m02;
                float m31;
                float m21;
                float m11;
                float m01;
                float m30;
                float m20;
                float m10;
                float m00;
                Particle particle = particles[ii];
                int frame = FloatMath.round(particle.getFrame());
                float uoff = (float)(frame % udivs) * uscale;
                float voff = (float)(frame / udivs) * vscale;
                Color4f color = particle.getColor();
                float cr = color.r;
                float cg = color.g;
                float cb = color.b;
                float ca = color.a;
                float size = particle.getSize();
                if (alignment == ParticleSystemConfig.Alignment.VELOCITY) {
                    Vector3f velocity = particle.getVelocity();
                    view.cross(velocity, t);
                    float length = t.length();
                    if (length > 1.0E-6f) {
                        t.multLocal(1.0f / length);
                        velocity.normalize(s);
                        s.cross(t, r);
                    } else {
                        s.set(Vector3f.ZERO);
                        t.set(Vector3f.ZERO);
                        r.set(Vector3f.ZERO);
                    }
                    Vector3f position = particle.getPosition();
                    m00 = s.x * size;
                    m10 = t.x * size;
                    m20 = r.x * size;
                    m30 = position.x;
                    m01 = s.y * size;
                    m11 = t.y * size;
                    m21 = r.y * size;
                    m31 = position.y;
                    m02 = s.z * size;
                    m12 = t.z * size;
                    m22 = r.z * size;
                    m32 = position.z;
                } else {
                    xform.set(particle.getPosition(), alignment == ParticleSystemConfig.Alignment.BILLBOARD ? vrot.mult(particle.getOrientation(), rotation) : particle.getOrientation(), size);
                    xform.update(3);
                    Matrix4f m = xform.getMatrix();
                    m00 = m.m00;
                    m10 = m.m10;
                    m20 = m.m20;
                    m30 = m.m30;
                    m01 = m.m01;
                    m11 = m.m11;
                    m21 = m.m21;
                    m31 = m.m31;
                    m02 = m.m02;
                    m12 = m.m12;
                    m22 = m.m22;
                    m32 = m.m32;
                }
                int sourceTexCoordIdx = this._sourceTexCoordOffset;
                int sourceVertexIdx = this._sourceVertexOffset;
                if (normals) {
                    int sourceNormalIdx = this._sourceNormalOffset;
                    float rsize = 1.0f / particle.getSize();
                    float n00 = m00 * rsize;
                    float n10 = m10 * rsize;
                    float n20 = m20 * rsize;
                    float n01 = m01 * rsize;
                    float n11 = m11 * rsize;
                    float n21 = m21 * rsize;
                    float n02 = m02 * rsize;
                    float n12 = m12 * rsize;
                    float n22 = m22 * rsize;
                    int jj = 0;
                    while (jj < vpp) {
                        texCoordIdx = Meshes.write(data, texCoordIdx, stride, uoff + source[sourceTexCoordIdx] * uscale, voff + source[sourceTexCoordIdx + 1] * vscale);
                        sourceTexCoordIdx += sourceStride;
                        colorIdx = Meshes.write(data, colorIdx, stride, cr, cg, cb, ca);
                        float nx = source[sourceNormalIdx];
                        float ny = source[sourceNormalIdx + 1];
                        float nz = source[sourceNormalIdx + 2];
                        normalIdx = Meshes.write(data, normalIdx, stride, n00 * nx + n10 * ny + n20 * nz, n01 * nx + n11 * ny + n21 * nz, n02 * nx + n12 * ny + n22 * nz);
                        sourceNormalIdx += sourceStride;
                        float vx = source[sourceVertexIdx];
                        float vy = source[sourceVertexIdx + 1];
                        float vz = source[sourceVertexIdx + 2];
                        vertexIdx = Meshes.write(data, vertexIdx, stride, m00 * vx + m10 * vy + m20 * vz + m30, m01 * vx + m11 * vy + m21 * vz + m31, m02 * vx + m12 * vy + m22 * vz + m32);
                        sourceVertexIdx += sourceStride;
                        ++jj;
                    }
                } else {
                    int jj = 0;
                    while (jj < vpp) {
                        texCoordIdx = Meshes.write(data, texCoordIdx, stride, uoff + source[sourceTexCoordIdx] * uscale, voff + source[sourceTexCoordIdx + 1] * vscale);
                        sourceTexCoordIdx += sourceStride;
                        colorIdx = Meshes.write(data, colorIdx, stride, cr, cg, cb, ca);
                        float vx = source[sourceVertexIdx];
                        float vy = source[sourceVertexIdx + 1];
                        float vz = source[sourceVertexIdx + 2];
                        vertexIdx = Meshes.write(data, vertexIdx, stride, m00 * vx + m10 * vy + m20 * vz + m30, m01 * vx + m11 * vy + m21 * vz + m31, m02 * vx + m12 * vy + m22 * vz + m32);
                        sourceVertexIdx += sourceStride;
                        ++jj;
                    }
                }
                ++ii;
            }
        }
    }

    public static class Points
    extends ParticleGeometry {
        public Points(GlContext ctx, Scope scope, PassDescriptor[] passes) {
            super(scope);
            this.init(ctx, passes);
        }

        @Override
        protected int getMode() {
            return 0;
        }

        @Override
        protected int getParticleVertexCount() {
            return 1;
        }

        @Override
        protected int getParticleIndexCount() {
            return 1;
        }

        @Override
        protected int[] getPrototypeIndices() {
            return new int[1];
        }

        @Override
        protected void updateData() {
            Particle[] particles = this._particles;
            float[] data = this._data;
            int stride = this._stride;
            Vector3f n = this._n;
            boolean normals = this._normalOffset >= 0;
            int udivs = this._config.textureDivisionsS;
            float uscale = 1.0f / (float)udivs;
            float vscale = 1.0f / (float)this._config.textureDivisionsT;
            int texCoordIdx = this._texCoordOffset;
            int colorIdx = this._colorOffset;
            int normalIdx = this._normalOffset;
            int vertexIdx = this._vertexOffset;
            int ii = 0;
            int nn = this._living.value;
            while (ii < nn) {
                Particle particle = particles[ii];
                int frame = FloatMath.round(particle.getFrame());
                float uoff = (float)(frame % udivs) * uscale;
                float voff = (float)(frame / udivs) * vscale;
                texCoordIdx = Points.write(data, texCoordIdx, stride, uoff, voff);
                colorIdx = Points.write(data, colorIdx, stride, particle.getColor());
                if (normals) {
                    normalIdx = Points.write(data, normalIdx, stride, particle.getOrientation().transformUnitZ(n));
                }
                vertexIdx = Points.write(data, vertexIdx, stride, particle.getPosition());
                ++ii;
            }
        }
    }

    public static class QuadTrails
    extends ParticleGeometry {
        protected int _segments;

        public QuadTrails(GlContext ctx, Scope scope, PassDescriptor[] passes, int segments) {
            super(scope);
            this._segments = segments;
            this.init(ctx, passes);
        }

        @Override
        protected int getMode() {
            return 4;
        }

        @Override
        protected int getParticleVertexCount() {
            return (this._segments + 1) * 2;
        }

        @Override
        protected int getParticleIndexCount() {
            return this._segments * 6;
        }

        @Override
        protected int[] getPrototypeIndices() {
            int[] prototype = new int[this._segments * 6];
            int ii = 0;
            int idx = 0;
            while (ii < this._segments) {
                int offset = ii * 2;
                prototype[idx++] = offset;
                prototype[idx++] = offset + 1;
                prototype[idx++] = offset + 2;
                prototype[idx++] = offset + 2;
                prototype[idx++] = offset + 1;
                prototype[idx++] = offset + 3;
                ++ii;
            }
            return prototype;
        }

        @Override
        protected void updateData() {
            Particle[] particles = this._particles;
            float[] data = this._data;
            int stride = this._stride;
            int segments = this._segments;
            Vector3f position = this._position;
            Vector3f last = this._last;
            Vector3f next = this._next;
            Vector3f s = this._s;
            Vector3f t = this._t;
            Vector3f n = this._n;
            boolean normals = this._normalOffset >= 0;
            int udivs = this._config.textureDivisionsS;
            float uscale = 1.0f / (float)udivs;
            float vscale = 1.0f / (float)this._config.textureDivisionsT;
            Vector3f view = this._transformState.getModelview().invert(this._xform).transformVector(Vector3f.UNIT_Z, this._view);
            float tscale = 1.0f / (float)segments;
            int texCoordIdx = this._texCoordOffset;
            int colorIdx = this._colorOffset;
            int normalIdx = this._normalOffset;
            int vertexIdx = this._vertexOffset;
            int ii = 0;
            int nn = this._living.value;
            while (ii < nn) {
                Particle particle = particles[ii];
                Color4f color = particle.getColor();
                float cr = color.r;
                float cg = color.g;
                float cb = color.b;
                float ca = color.a;
                float size = particle.getSize();
                particle.getPosition(0.0f, position);
                float px = position.x;
                float py = position.y;
                float pz = position.z;
                particle.getPosition(tscale, next);
                QuadTrails.computeOffset(view, next.subtract(position, s), size, t);
                float tx = t.x;
                float ty = t.y;
                float tz = t.z;
                int frame = FloatMath.round(particle.getFrame());
                float uoff = (float)(frame % udivs) * uscale;
                float voff = (float)(frame / udivs) * vscale;
                float vtop = voff + vscale;
                if (normals) {
                    QuadTrails.computeOffset(s, t, 1.0f, n);
                    float nx = n.x;
                    float ny = n.y;
                    float nz = n.z;
                    texCoordIdx = QuadTrails.write(data, texCoordIdx, stride, uoff, vtop);
                    colorIdx = QuadTrails.write(data, colorIdx, stride, cr, cg, cb, ca);
                    normalIdx = QuadTrails.write(data, normalIdx, stride, nx, ny, nz);
                    vertexIdx = QuadTrails.write(data, vertexIdx, stride, px + tx, py + ty, pz + tz);
                    texCoordIdx = QuadTrails.write(data, texCoordIdx, stride, uoff, voff);
                    colorIdx = QuadTrails.write(data, colorIdx, stride, cr, cg, cb, ca);
                    normalIdx = QuadTrails.write(data, normalIdx, stride, nx, ny, nz);
                    vertexIdx = QuadTrails.write(data, vertexIdx, stride, px - tx, py - ty, pz - tz);
                } else {
                    texCoordIdx = QuadTrails.write(data, texCoordIdx, stride, uoff, vtop);
                    colorIdx = QuadTrails.write(data, colorIdx, stride, cr, cg, cb, ca);
                    vertexIdx = QuadTrails.write(data, vertexIdx, stride, px + tx, py + ty, pz + tz);
                    texCoordIdx = QuadTrails.write(data, texCoordIdx, stride, uoff, voff);
                    colorIdx = QuadTrails.write(data, colorIdx, stride, cr, cg, cb, ca);
                    vertexIdx = QuadTrails.write(data, vertexIdx, stride, px - tx, py - ty, pz - tz);
                }
                int jj = 1;
                while (jj < segments) {
                    this._last.set(px, py, pz);
                    px = next.x;
                    py = next.y;
                    pz = next.z;
                    float frac = (float)jj * tscale;
                    particle.getPosition(frac + tscale, next);
                    QuadTrails.computeOffset(view, next.subtract(last, s), size, t);
                    tx = t.x;
                    ty = t.y;
                    tz = t.z;
                    float u = uoff + frac * uscale;
                    if (normals) {
                        QuadTrails.computeOffset(s, t, 1.0f, n);
                        float nx = n.x;
                        float ny = n.y;
                        float nz = n.z;
                        texCoordIdx = QuadTrails.write(data, texCoordIdx, stride, u, vtop);
                        colorIdx = QuadTrails.write(data, colorIdx, stride, cr, cg, cb, ca);
                        normalIdx = QuadTrails.write(data, normalIdx, stride, nx, ny, nz);
                        vertexIdx = QuadTrails.write(data, vertexIdx, stride, px + tx, py + ty, pz + tz);
                        texCoordIdx = QuadTrails.write(data, texCoordIdx, stride, u, voff);
                        colorIdx = QuadTrails.write(data, colorIdx, stride, cr, cg, cb, ca);
                        normalIdx = QuadTrails.write(data, normalIdx, stride, nx, ny, nz);
                        vertexIdx = QuadTrails.write(data, vertexIdx, stride, px - tx, py - ty, pz - tz);
                    } else {
                        texCoordIdx = QuadTrails.write(data, texCoordIdx, stride, u, vtop);
                        colorIdx = QuadTrails.write(data, colorIdx, stride, cr, cg, cb, ca);
                        vertexIdx = QuadTrails.write(data, vertexIdx, stride, px + tx, py + ty, pz + tz);
                        texCoordIdx = QuadTrails.write(data, texCoordIdx, stride, u, voff);
                        colorIdx = QuadTrails.write(data, colorIdx, stride, cr, cg, cb, ca);
                        vertexIdx = QuadTrails.write(data, vertexIdx, stride, px - tx, py - ty, pz - tz);
                    }
                    ++jj;
                }
                last.set(px, py, pz);
                px = next.x;
                py = next.y;
                pz = next.z;
                position.set(px, py, pz);
                QuadTrails.computeOffset(view, position.subtract(last, s), size, t);
                tx = t.x;
                ty = t.y;
                tz = t.z;
                float uright = uoff + uscale;
                if (normals) {
                    QuadTrails.computeOffset(s, t, 1.0f, n);
                    float nx = n.x;
                    float ny = n.y;
                    float nz = n.z;
                    texCoordIdx = QuadTrails.write(data, texCoordIdx, stride, uright, vtop);
                    colorIdx = QuadTrails.write(data, colorIdx, stride, cr, cg, cb, ca);
                    normalIdx = QuadTrails.write(data, normalIdx, stride, nx, ny, nz);
                    vertexIdx = QuadTrails.write(data, vertexIdx, stride, px + tx, py + ty, pz + tz);
                    texCoordIdx = QuadTrails.write(data, texCoordIdx, stride, uright, voff);
                    colorIdx = QuadTrails.write(data, colorIdx, stride, cr, cg, cb, ca);
                    normalIdx = QuadTrails.write(data, normalIdx, stride, nx, ny, nz);
                    vertexIdx = QuadTrails.write(data, vertexIdx, stride, px - tx, py - ty, pz - tz);
                } else {
                    texCoordIdx = QuadTrails.write(data, texCoordIdx, stride, uright, vtop);
                    colorIdx = QuadTrails.write(data, colorIdx, stride, cr, cg, cb, ca);
                    vertexIdx = QuadTrails.write(data, vertexIdx, stride, px + tx, py + ty, pz + tz);
                    texCoordIdx = QuadTrails.write(data, texCoordIdx, stride, uright, voff);
                    colorIdx = QuadTrails.write(data, colorIdx, stride, cr, cg, cb, ca);
                    vertexIdx = QuadTrails.write(data, vertexIdx, stride, px - tx, py - ty, pz - tz);
                }
                ++ii;
            }
        }
    }

    public static class Quads
    extends ParticleGeometry {
        public Quads(GlContext ctx, Scope scope, PassDescriptor[] passes) {
            super(scope);
            this.init(ctx, passes);
        }

        @Override
        protected int getMode() {
            return 4;
        }

        @Override
        protected int getParticleVertexCount() {
            return 4;
        }

        @Override
        protected int getParticleIndexCount() {
            return 6;
        }

        @Override
        protected int[] getPrototypeIndices() {
            int[] nArray = new int[6];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 2;
            nArray[4] = 1;
            nArray[5] = 3;
            return nArray;
        }

        @Override
        protected void updateData() {
            Particle[] particles = this._particles;
            float[] data = this._data;
            int stride = this._stride;
            Vector3f s = this._s;
            Vector3f t = this._t;
            Vector3f n = this._n;
            Vector3f view = this._view;
            Quaternion rotation = this._rotation;
            Quaternion vrot = this._vrot;
            boolean normals = this._normalOffset >= 0;
            int udivs = this._config.textureDivisionsS;
            float uscale = 1.0f / (float)udivs;
            float vscale = 1.0f / (float)this._config.textureDivisionsT;
            ParticleSystemConfig.Alignment alignment = this._config.alignment;
            if (alignment == ParticleSystemConfig.Alignment.VELOCITY) {
                this._transformState.getModelview().invert(this._xform).transformVector(Vector3f.UNIT_Z, view);
            } else if (alignment == ParticleSystemConfig.Alignment.BILLBOARD) {
                this._transformState.getModelview().extractRotation(vrot).invertLocal();
            }
            int texCoordIdx = this._texCoordOffset;
            int colorIdx = this._colorOffset;
            int normalIdx = this._normalOffset;
            int vertexIdx = this._vertexOffset;
            int ii = 0;
            int nn = this._living.value;
            while (ii < nn) {
                Particle particle = particles[ii];
                int frame = FloatMath.round(particle.getFrame());
                float uoff = (float)(frame % udivs) * uscale;
                float voff = (float)(frame / udivs) * vscale;
                Color4f color = particle.getColor();
                float cr = color.r;
                float cg = color.g;
                float cb = color.b;
                float ca = color.a;
                Vector3f position = particle.getPosition();
                float px = position.x;
                float py = position.y;
                float pz = position.z;
                float size = particle.getSize();
                if (alignment == ParticleSystemConfig.Alignment.VELOCITY) {
                    Vector3f velocity = particle.getVelocity();
                    view.cross(velocity, t);
                    float length = t.length();
                    if (length > 1.0E-6f) {
                        t.multLocal(size / length);
                        velocity.normalize(s).multLocal(size);
                    } else {
                        s.set(Vector3f.ZERO);
                        t.set(Vector3f.ZERO);
                    }
                    if (normals) {
                        Quads.computeOffset(s, t, 1.0f, n);
                    }
                } else {
                    Quaternion rot = alignment == ParticleSystemConfig.Alignment.BILLBOARD ? vrot.mult(particle.getOrientation(), rotation) : particle.getOrientation();
                    rot.transformUnitX(s).multLocal(size);
                    rot.transformUnitY(t).multLocal(size);
                    if (normals) {
                        rot.transformUnitZ(n);
                    }
                }
                float sx = s.x;
                float sy = s.y;
                float sz = s.z;
                float tx = t.x;
                float ty = t.y;
                float tz = t.z;
                float vtop = voff + vscale;
                float uright = uoff + uscale;
                if (normals) {
                    float nx = n.x;
                    float ny = n.y;
                    float nz = n.z;
                    texCoordIdx = Quads.write(data, texCoordIdx, stride, uoff, vtop);
                    colorIdx = Quads.write(data, colorIdx, stride, cr, cg, cb, ca);
                    normalIdx = Quads.write(data, normalIdx, stride, nx, ny, nz);
                    vertexIdx = Quads.write(data, vertexIdx, stride, px + tx - sx, py + ty - sy, pz + tz - sz);
                    texCoordIdx = Quads.write(data, texCoordIdx, stride, uoff, voff);
                    colorIdx = Quads.write(data, colorIdx, stride, cr, cg, cb, ca);
                    normalIdx = Quads.write(data, normalIdx, stride, nx, ny, nz);
                    vertexIdx = Quads.write(data, vertexIdx, stride, px - sx - tx, py - sy - ty, pz - sz - tz);
                    texCoordIdx = Quads.write(data, texCoordIdx, stride, uright, vtop);
                    colorIdx = Quads.write(data, colorIdx, stride, cr, cg, cb, ca);
                    normalIdx = Quads.write(data, normalIdx, stride, nx, ny, nz);
                    vertexIdx = Quads.write(data, vertexIdx, stride, px + sx + tx, py + sy + ty, pz + sz + tz);
                    texCoordIdx = Quads.write(data, texCoordIdx, stride, uright, voff);
                    colorIdx = Quads.write(data, colorIdx, stride, cr, cg, cb, ca);
                    normalIdx = Quads.write(data, normalIdx, stride, nx, ny, nz);
                    vertexIdx = Quads.write(data, vertexIdx, stride, px + sx - tx, py + sy - ty, pz + sz - tz);
                } else {
                    texCoordIdx = Quads.write(data, texCoordIdx, stride, uoff, vtop);
                    colorIdx = Quads.write(data, colorIdx, stride, cr, cg, cb, ca);
                    vertexIdx = Quads.write(data, vertexIdx, stride, px + tx - sx, py + ty - sy, pz + tz - sz);
                    texCoordIdx = Quads.write(data, texCoordIdx, stride, uoff, voff);
                    colorIdx = Quads.write(data, colorIdx, stride, cr, cg, cb, ca);
                    vertexIdx = Quads.write(data, vertexIdx, stride, px - sx - tx, py - sy - ty, pz - sz - tz);
                    texCoordIdx = Quads.write(data, texCoordIdx, stride, uright, vtop);
                    colorIdx = Quads.write(data, colorIdx, stride, cr, cg, cb, ca);
                    vertexIdx = Quads.write(data, vertexIdx, stride, px + sx + tx, py + sy + ty, pz + sz + tz);
                    texCoordIdx = Quads.write(data, texCoordIdx, stride, uright, voff);
                    colorIdx = Quads.write(data, colorIdx, stride, cr, cg, cb, ca);
                    vertexIdx = Quads.write(data, vertexIdx, stride, px + sx - tx, py + sy - ty, pz + sz - tz);
                }
                ++ii;
            }
        }
    }
}

